; Iconbar Addition 1.2 masterpatch
; x65 M65v50 (c) benj9


number_of_monitor_icon_engines	EQU	2

						AREA ARMex, CODE, READONLY  

						EXPORT	iconbar_addition				
						IMPORT	mp_Bufferizer
						IMPORT	v01_RamLS
						IMPORT	f039_AddIconToIconbar
						
						CODE16
						
						DCB		"IconbrAdd2,benj9"
					
; -----------------------------------------------------------------------------------	
						ENTRY
iconbar_addition		PUSH	{R3, R4, R6, LR}
						LDR		R0,_id
						BL		mp_Bufferizer
						BEQ		exit
						
						BL		charging_icons
					
; -----------------------------------------------------------------------------------	
					

monitor_icons_init		MOV		R0, #number_of_monitor_icon_engines
						SUB		R0, #1
						
						MOV		R3, #0x30 ; record length
						MUL		R0, R3
						
						MOV		R3, #12 ; offset for start of first monitor icons engine ram			
						ADD		R3, R0
						
monitor_icons_init_loop	BL		monitor_icons
						SUB		R3, #0x30					
						CMP		R3, #12 ; offset for start of first monitor icons engine ram			
						BGE		monitor_icons_init_loop
						
; -----------------------------------------------------------------------------------	
					
exit					LDR		R7, repatch_1 ; repatch
						BLX		R7
						LDR		R7, repatch_2 ; repatch
						BLX		R7
						POP		{R3, R4, R6, R7}
						ADD		R7, #4
						CMP		R0, #0 ; repatch
						BX		R7
		
; ========================================================================================	
			
						
monitor_icons			PUSH	{R3, LR}
						ADD		R3, R6
						MOV		R2, #45 ; {(R3 + 45).0 cb engage}, {(R3 + 45).1 cb `use as pointer`} 
						LDRB	R4, [R3, R2]
						MOV		R2, #1 ; test bit 0: {(R3 + 45).0 cb engage}
						AND		R2, R4
						BEQ		monitor_icons_exit

						LDR		R7, [R3] ; R3 + 0: a focus v=A8752560
						MOV		R2, #2 ; test bit 1: {(R3 + 45).1 cb `use as pointer`}
						AND		R2, R4
						BNE		monitor_icons_focus_ptr ; address is indirect, by pointer
						
						LDRB	R7, [R7] ; direct addressing
						B		monitor_icons_preloop		

monitor_icons_focus_ptr	LDR		R7, [R7]
						MOV		R2, #47 ; {(R3+47) b offset}
						LDRB	R4, [R3, R2]	
						LDRB	R7, [R7, R4]
						
monitor_icons_preloop	MOV		R2, #44 ; R3 + 44 : permits for values {R3+44.? cb v?}
						LDRB	R0, [R3, R2]
						MOV		R4, #0
		
monitor_icons_loop		CMP		R4, #7 
						BEQ		monitor_icons_else
						
						BL		monitor_value_permit
						BEQ		monitor_icons_loop_x
						
						MOV		R2, #46 ; condition direction. 0=eq, 1=le, 2=ge
						LDRB	R1, [R3, R2]
						BL		monitor_value
						BEQ		monitor_icons_snapped 

monitor_icons_loop_x	LSR		R0, #1
						ADD		R4, #1
						B		monitor_icons_loop
						
monitor_icons_else		BL		monitor_value_permit
						BEQ		monitor_icons_exit
						
						MOV		R1,#0 ; condition direction. 0=eq, 1=le, 2=ge
						BL		monitor_value
						BEQ		monitor_icons_exit ; NOT this value
						
monitor_icons_snapped	LSL		R4, #2 ; *4
						MOV		R2, #4 ; R3 + 4: first icon
						ADD		R2, R4
						LDR		R1, [R3, R2]
						BL		icon2bar

monitor_icons_exit		POP		{R3, PC}


; -----------------------------------------------------------------------------------	

monitor_value_permit	MOV		R1, #1
						AND		R1, R0
						BX		LR

; -----------------------------------------------------------------------------------	

monitor_value			PUSH	{LR} ; input R1:  condition direction. 0=eq, 1=le, 2=ge
						MOV		R2, #36 ; 36 first byte value
						ADD		R2, R4 
						LDRB	R2, [R3, R2] 
						CMP		R1, #1 ; input R1:  condition direction. 0=eq, 1=le, 2=ge
						BEQ		monitor_value_le
						BGT		monitor_value_ge

monitor_value_equal		CMP		R7, R2 ; focus byte snapped?
						POP		{PC} ; BX		LR

monitor_value_le		CMP		R7, R2 ; focus byte snapped?
						BLE		monitor_value_true
						B		monitor_value_false
						
monitor_value_ge		CMP		R7, R2 ; focus byte snapped?
						BGE		monitor_value_true

monitor_value_false		MOV		R2, #0
						B		monitor_value_test

monitor_value_true		MOV		R2, #1				

monitor_value_test		CMP		R2,#1
						POP		{PC} ; outputs condition bits
						
						
; ========================================================================================				
					
charging_icons			PUSH	{R4, LR}
						LDRB	R4, [R6,#2] ; {2 o ChargingIcons `off`=0 `only full`=1 `both`=2}
						CMP		R4, #0
						BEQ		charging_icons_x
						
						BL		v01_RamLS
						LDRB	R0, [R7]
						CMP		R0 ,#0
						BEQ		charging_icons_x
						
						LDR		R1, [R6,#8] ; {8 i iconFull}
						CMP		R0, #3
						BGE		charging_icons_do

						CMP		R4, #1
						BEQ		charging_icons_x

						LDR		R1 , [R6,#4] ; {4 i iconCharge}

charging_icons_do		BL		icon2bar

charging_icons_x		POP		{R4, PC}
					
; ========================================================================================	

icon2bar				PUSH	{LR}
						ADD		R2, SP, #0x18 + 7 * 4 ; MainscreenIcon context
						MOV		R0, R5 ; MainscreenIcon context
						BL		f039_AddIconToIconbar
						POP		{PC}

; ========================================================================================	

;FunctionLibrary				DCD	0xA0FC0000
;MpBufferizer				DCD 0xA0FC0C01

;DrawIcon2Iconbar			DCD	0xA1633B99
repatch_1					DCD 0xA164FDF8
repatch_2					DCD 0xA165033C ; CheckHomezoneStatus1

							DCD	0,0,0xB1C2D3E4
_id							DCD	0x00001c00

       				
        END  
        
{sm UniversalIcons}","\
{57 o `off`=0 `on`=1}","\
{12 a focus v=A8752560}","\                00
{sm v1}{56.0 cb 1 v=1}","\   44
{48 b b v=2}","\                36
{16 i icon v=326}{endsm}","\           4
{sm v2}{56.1 cb 2 v=1}","\   44
{49 b b v=1}","\                37
{20 i icon v=335}{endsm}","\           8
{sm v3}{56.2 cb 3 v=1}","\   44
{50 b b v=0}","\                38
{24 i icon v=329}{endsm}","\          12
{sm v4}{56.3 cb 4 v=1}","\    44
{51 b b v=3}","\                39
{28 i icon v=1139}{endsm}","\        16
{sm v5}{56.4 cb 5 v=1}","\   44
{52 b b v=8}","\                40
{32 i icon v=1199}{endsm}","\         20
{sm v6}{56.5 cb 6 v=0}","\   44
{53 b b v=27}","\               41
{36 i icon v=1072}{endsm}","\         24
{sm v7}{56.6 cb 7 v=0}","\   44
{54 b b v=0}","\                42
{40 i icon v=1067}{endsm}","\         28
{sm vElse}{56.7 cb Else v=0}","\44
{44 i icon v=333}","\                 32
{55 b `NOT b` v=0}{endsm}{endsm}","\43
{endsm}",00