TARGET("elf32-littlearm");
OUTPUT_FORMAT("elf32-littlearm")
OUTPUT_ARCH(ARM)
ENTRY(main)

PHDRS
{
 text PT_LOAD;
 bss  PT_LOAD;
 dyn  PT_DYNAMIC;
}

DT_NULL    = 0;
DT_REL     = 17;
DT_RELSZ   = 18;
DT_RELENT  = 19;

SECTIONS
{
 . = 0x0;
 PROVIDE (__executable_start = .);

 .text   : AT(0) ALIGN(4) SUBALIGN(4) { *(.text) *(.rodata*) *(.data) *(COMMON) } :text
 .bss  : AT(LOADADDR(.text)+SIZEOF(.text)) { *(.bss) } :bss
 .dynamic  0 (NOLOAD) /*VMA*/ : AT(0) /*LMA*/
  {
   LONG(DT_REL); LONG(rs);
   LONG(DT_RELSZ); LONG(re - rs);
   LONG(DT_RELENT); LONG(4+4);

   LONG(DT_NULL); LONG(0);
   rs = .;
   *(.rel.text)
   re = .;
  } :dyn

/DISCARD/ :
 {
  *(*);
 }
}
