// Pic/Sound-Demo

// (c) benj9

// use picsounddemo_mainscr to display values



#define CX65v50

#include "..\shared\x65.h"

#define _Var_  0xA8000200	

#ifdef M65v50
	#define _DrawImg_ (0xA16341BC+1) 
	#define _GetSelectedProfile_ (0xA08C9FE4+1)
	#define _PlaySoundLoop_ 0xA0935CF8   
	#define _GetImageWidth_ (0xA114E024+1)
#endif

#ifdef CX65v50
	#define _DrawImg_ (0xA11634770+1)  
	#define _GetSelectedProfile_ (0xA08C9FE4+1)
	#define _PlaySoundLoop_ 0xA0935CF4 
	#define _GetImageWidth_ (0xA114E024+1)
#endif

#ifdef S65v50
	#define _DrawImg_ 
	#define _GetSelectedProfile_
	#define _PlaySoundLoop_ (0x) 

	#define _GetImageWidth_ (0xA114D38C+1) 
#endif

struct Var{
	byte b0, b1, b2; 
};

typedef int (*g_GetSelectedProfile)(void);
g_GetSelectedProfile GetSelectedProfile = (g_GetSelectedProfile) _GetSelectedProfile_;

DrawImg DrawImage = (DrawImg) _DrawImg_;

GetImageWidth getimagewidth = (GetImageWidth) _GetImageWidth_;

typedef void (*g_PlaySoundLoop)(unsigned int iSoundID, unsigned int unknown1, unsigned int LoopCount);
g_PlaySoundLoop PlaySoundLoop = (g_PlaySoundLoop) _PlaySoundLoop_;

	

void Net_Display(int x, int y, int PictureIndex) 
{
	// const struct NetData* net = (struct NetData *) _NetData_;
	struct Var* var = (struct Var *)_Var_;
	const FirstPic = 0xCC33 ; //1123
	const NumOfPics = 0xDD44;
	
	int img;

	/* mode:
	0  NetNormal
	1  ProfileLogo
	2  NetNormal & ProfileLogo
	3  NetImproved
	4  NetNormal & NetImproved
	5  NetImproved & ProfileLogo
	6  NetNormal & NetImproved & ProfileLogo
	*/
	 
	DrawImage(x, y, PictureIndex); //normal Netlogo

	if ((GetSelectedProfile()>=5)&&(GetSelectedProfile()<=6)){
      	var->b0 += 1;
      	if (var->b0 >= NumOfPics) var->b0=0;
      	img = var->b0 + FirstPic;
      	DrawImage((132-getimagewidth(img))/2,65,img);
     }
	 if (GetSelectedProfile()==6){
     if (var->b1 > 0) { 
     	if (var->b1 > 1) { 
     		var->b2 +=1; var->b1=0;
     		if (var->b2 > 0xff) var->b2=0;
     		PlaySoundLoop(var->b2, 1, 5);
     	} else var->b1+=1;
     } else var->b1+=1;	
     }
     	
     	//PlaySoundLoop(3, 2, 10);
	    //PlaySound(0, 0, 0, 2); // Battery empty sound
     	// PlaySoundLoop(var->b1, 1, 7);
     	/* PlaySoundLoop(
     	  1 fiep
     	  3 akku
     	  4 piep, leer
     	  7 freizeichen
     	  11 besetzt
     	  12 kein Anschluss
     	  12 tut tuut
     	  18 hoher schneller sinus
     	  25 dtmf
     	  29 dtmf
     	  33 d
     	  
     	  */
      	
      	//m=var->b0;
      	
      	//var->b0=PictureIndex;
      	
      /*	if ((PictureIndex==808)&&(net->RX<50)){
      		PlaySoundLoop(3, 2, 10); 
      		PlaySoundLoop(0x2F, 1, 5);
      		PlaySound(0, 0, 0, 2); // Battery empty sound
      	} */
      	
}