; Key Sequencer @entry CalledBy__IllByKey_On_5mX_5_GX__KeyPress_Off
; prototype
; m65v50 (c) benj9 

; keylock double check funze
; sounds berdenken
; key sequencer module berdenken (lt. mentaler skizze)
; optimieren
;A114D0A6             Keypad_IsUnlocked                       ; CODE XREF: ROM:A0800184j
;A114D0A6                                                     ; IlluminationByKeyEventOn_3m+12p ...
;A114D0A6 DB 48                       LDR     R0, =ram_KeypadIsLocked_plus8



; entry m65v50
; 114C9D4: 041C251C B3F694FB ; -> A1000100
; repatch: ADD R4, R0, #0. ADD R5, R4, #0


		AREA benj9, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for SL65v50

TYPE	SETA	1 						

 IF  TYPE = 1

;free_ram_dword			EQU 0xA8000204
;ram_basement			EQU	0xA8752F00
; ram usage: 
; [ram_basement+0] hotkey-mode
; [ram_basement+1] keypress-after-hotkey-counter
; [ram_basement+2]... sequence record buffers 

; _ram_keypress_buffer	EQU 0xA114CCF0

; internally functions addresses downstairs



; constants
number_of_sequence_records	EQU	0x24 ; !!!!!
profile_key					EQU 63 ; 0n00111111 

hotkey						EQU	"*" ; 
sp_param					EQU	0x18 ; 5 additional parameters needed. 4x4=0x10
sp_sub_1					EQU	0x1C ; 7 pushes
sp_sub_2					EQU 0x14 ; PUSH {R0-R3,R7}: 5 regs pushed, 5*4=0x14
sp_ActionPerformed			EQU 0    ; [SP,#0] ; SequAccepted&ActionPerformed(FF=False)
sp_Keylock_State			EQU 4    ; [SP,#4] ; KeyUnlock_State
sp_SequenceRecords 			EQU 8    ; [SP,#8] ; number of sequence records
sp_ScanKeySequencesMode		EQU 0xC  ; [SP,#0xC] ; scan_key_sequences - mode. 0=direct mode. 1=after hotkey mode.
sp_AnySequenceTouched		EQU 0x10 ; [SP,#0x10] ; is in ScanKeySequences the key in at least one sequence?
sp_direct_or_hotkey_seq		EQU	0x14
;[_ram_mainscreen_menu_state_,#2] ; Mainscreen_Menu_State. 0 on boot, FF on everything else then mainscreen 

FF					EQU 0xFF

 ENDIF
 
 
; ram_basemen+2: count_key_in_sequence[0], ..., count_key_in_sequence[n-1]
; count_key_in_sequence=0: not entered. =n: n keys accepted.

; -----------------------------------------------------------------------------

 CODE16			
 
 IMPORT	sequences
 IMPORT midlet_fnames
 				
	 				NOP 
	 				B		m_start
					DCB		"KeySeq1benj9" 
				
m_start				PUSH	{R0-R7,LR}
					SUB		SP,#sp_param ; need more stack slots
					MOV		R5,R0
					BL		_mainscreen_state	
					CMP		R6,#0 ; phone boots up?
					BEQ		m_start_nopatch
					
					;MOV		R5,R0
					
					;PUSH	{R3} ; cause GetProfile zeroes R3
					;LDR		R6,GetProfile_
					;BLX		R6
					MOV		R6,#2 ; GetProfile
					BL		_FuncLib
					;POP		{R3}
					LDR 	R6,=profile_key
					LSR		R6, R0
					MOV		R0 ,#1
					AND		R6, R0
					CMP		R6, #1
					BEQ		m_init
					
m_start_nopatch		MOV		R0,R5
					LSL     R1,R0,#0x18 ; key_off=key_on+0x80
					BMI     m_off_exec ; is negative?	
					B		m_on_exec

m_init				BL		_keylock
					STR		R0,[SP,#sp_Keylock_State] ; store Keylock_State
					
					MOV		R7,#number_of_sequence_records
					STR		R7,[SP,#sp_SequenceRecords] ; [SP,#8]=number of records
					
m_init_ram			LDR		R0,free_ram_dword_
					LDR		R4,[R0]
					CMP		R4,#0
					BNE		m_init_1
					;PUSH	{R0}
					ADD		R0,R7,#1
					MOV		R6,#20 ; Malloc
					BL		_FuncLib
					MOV		R4,R0
					;POP		{R0}
					CMP		R4,#0
					BNE		m_init_ram_1
m_init_ram_no		MOV		R0,R5
					B 		m_exit
m_init_ram_1		LDR		R0,free_ram_dword_
					STR		R4,[R0]
								
m_init_ram_reset	; reset all sequence ram buffers to zero here
					MOV		R0,#0
					MOV		R1,#0
					STR		R0,[R4]
					ADD		R4,#2
m_init_ram_reset_l	CMP		R0,R7 ; last sequence
					BEQ		m_init_ram_x
					STRB	R1,[R4,R0] ; store zero to ram
					ADD		R0,#1 ; reset next ram sequence buffer
					B		m_init_ram_reset_l

m_init_ram_x		SUB		R4,#2
m_init_1			MOV		R0,R5
					
					LDRB	R2,[R4] ; hotkey enabled flag

m_on_off	 		LSL     R1,R0,#0x18 ; key_off=key_on+0x80

					BMI     m_off ; is negative?

m_on				CMP		R0,#hotkey
					BNE		m_on_hotk_no
					
m_on_hotk_yes		CMP		R2,#1 ; is hotkey already enabled?
					BGE		m_on_hotk_escape ; hotkey already enabled
					
m_on_hotk_activate	MOV		R2,#2 ; lock hotkey flag
					STRB	R2,[R4] ; enable hotkey flag
					MOV		R2,#0 ; zero keypresses-after-hotkey-counter
					STRB	R2,[R4,#1] ; NEW
					
					; B		m_exit ; ########## skip hotkey activation sound
					MOV		R0,#0x22
					MOV		R2,#1
					BL		_playsoundloop
					B		m_exit
					
m_on_hotk_no		CMP		R0,#0xC ; red button
					BEQ		m_on_hotk_escape ; kill hotkey on red button
			
					CMP		R2,#0 ; isnt hotkey already enabled?
					BNE		m_on_hotk_snapped
					
					MOV		R1,#0 
					STR		R1,[SP,#sp_ScanKeySequencesMode]  ; without hotkey, direct mode.
					BL 		scan_key_sequences
					B		m_on_exec 	
					
m_on_hotk_snapped	MOV		R1,#1
					STR		R1,[SP,#sp_ScanKeySequencesMode]  ; after hotkey .
					BL 		scan_key_sequences
					
					; NEW
					LDRB	R2,[R4,#1] ; [ram_basement+1] keypress-after-hotkey-counter
					ADD		R2,#1
					STRB	R2,[R4,#1] ; increase the counter 

					LDR		R2,[SP,#sp_AnySequenceTouched]
					CMP		R2,#1
					BEQ		m_on_hotk_touched_y

					BL		m_snap_fail_sound
					B		m_on_hotk_touched_n
					
m_on_hotk_touched_y	CMP		R1,#FF ; SequAccepted&ActionPerformed(FF=False)
					BEQ		m_exit 
					
m_on_hotk_touched_n	MOV		R2,#1 ; hotkeyflag: skip key_off, but be 0 on next key.
					STRB	R2,[R4] ; enable hotkey flag
					
					B		m_exit

					
					
m_on_hotk_escape	CMP		R2,#0
					BEQ		m_on_hotk_escape_1
					BL		m_snap_fail_sound

m_on_hotk_escape_1	MOV		R2,#0 ; disable hotkey flag
					STRB	R2,[R4] ; 
			
m_on_exec			LDR		R1,Keypress_On_Store2Ram_
					B		m_exec
				
m_off				CMP		R2,#0 ; 0: no hotkey flag. 
					BEQ		m_off_exec
					CMP		R2,#1 ; 1: hotkeyflag for key_off locked, after clear. 2: hotkey flag locked, leave
					BNE		m_exit
					
					MOV		R2,#0 ; disable hotkey flag
					STRB	R2,[R4] ;  hotkey flag
					
					B		m_exit

m_off_exec			LDR		R1,Keypress_Off_Store2Ram_

m_exec				BLX		R1

m_exit				ADD		SP,#sp_param ; release my stack slot
					;LSL     R1,R0,#0x18 ; key_off=key_on+0x80
					;BMI     m_exit_x ; keypress_off?
					;STRB	R0,[R4,#1] ; ###
					POP		{R0-R7,PC}
					
m_snap_fail_sound	PUSH	{R0-R3,LR}
					MOV		R0,#3
					MOV		R2,#1
					BL		_playsoundloop
					POP		{R0-R3,PC}
				

; ============================================================================= 
_keylock		LDR		R6,_ram_KeypadIsLocked8_ ; returns in R0 the content of R6
				LDR		R6,[R6]
				SUB		R6,#8 ; R6=KeypadIsLocked_RAM_Address
				LDRB	R0,[R6]
				BX		LR
				
_playsoundloop	PUSH	{R1,R6,LR}
				MOV		R1,#2
				MOV		R6,#52 ; PlaySoundloop
				BL		_FuncLib
				POP		{R1,R6,PC}			
				
; -----------------------------------------------------------------------------	

scan_key_sequences
				PUSH	{R2-R7,LR}
				MOV		R5,R0 ; put pressed key to R5. there come key_on_events and key_off_events(key=key_on+0x80)

s_init			LDR		R7,[SP,#sp_sub_1 + sp_SequenceRecords] ; [SP,#8]=number of sequence records
				;LDR		R3,=sequences
				;SUB		R3,#1 ; compiler mismatch
				
				LDR		R4,free_ram_dword_ ; 
				LDR		R4,[R4]
				;LDR			R4,=ram_basement
				ADD		R4,#2 ; goto base address for sequence record table
				MOV		R7,#0 ; counter of sequences
				STR		R7,[SP,#sp_sub_1 + sp_AnySequenceTouched] ; reset
				
s_loop			LDR		R3,=sequences
				;SUB		R3,#1 ; compiler mismatch
				
				LDR		R0,[SP,#sp_sub_1 + sp_SequenceRecords] ; R0=# of sequence records
				CMP		R0,R7
				BLE		s_exit ; if last sequence+1, its so nice, but i must leave

				LDRB	R1,[R4,R7] ; ram status byte of current sequence
				LSL		R6,R7,#4 ; *16
				ADD		R2,R3,R6 ; address of very first byte of current sequence record
				
				MOV		R0,#FF
				STR		R0,[SP,#sp_sub_1 + sp_ActionPerformed] ; SequAccepted&ActionPerformed(FF=False) [SP] reset with FF
				
				; filter

				; process sequence record depending SequenceMode_Snap _AfterHotkey or _Directly?
				LDRB	R3,[R2,#0xD] ; mode byte of sequence record
				MOV		R0,#1 ; bit 0
				AND		R0,R3 ; sequence mode byte, bit zero: SequenceMode_Snap
				LDR		R6,[SP,#sp_sub_1 + sp_ScanKeySequencesMode]
				
				
				
				STR		R0,[SP,#sp_sub_1 + sp_direct_or_hotkey_seq]
				
				CMP		R0,#1 ; is sequence hotkey mode?
				BEQ		s_loop_seq_hotk
				
s_loop_seq_dire	CMP		R6,#1 ; is current run of func hotkey mode?
				BEQ		s_key_not_snapped
				B		s_loop_filter_keylock ; NEW
				
s_loop_seq_hotk	CMP		R6,#0 ; is current run of func direct mode?
				BEQ		s_key_not_snapped

				SUB		R0,R4,#1  
				LDRB	R0,[R0] ; ; [ram_basement+1] keypress-after-hotkey-counter
				CMP		R0,#0
				BEQ		s_loop_filter_keylock ; if 1st run process all sequences
				CMP		R1,#0 ; if status byte of curr. sequence unused
				BEQ		s_key_not_snapped 
				
				
					
					
s_loop_filter_keylock	; process sequence record depending SequenceMode_Keylock
				MOV		R0,#0x20 ; bit 5
				AND		R0,R3 ; R0=0 do always. R0=1 do conditional depending on bit4
				CMP		R0,#0
				BEQ		s_loop_filter_scrsav ; skip this check
				BL		_keylock
				MOV		R6,#0x10 ; bit 4
				AND		R6,R3 ; if bit5=1: R0=0: do only if no keylock. R0=1: do only if key locked
				LSL		R0,#4 ; make it up to bit 4
				CMP		R0,R6
				BNE		s_key_not_snapped
				
s_loop_filter_scrsav	; process sequence record depending SequenceMode_Screensaver
				MOV		R0,#0x80 ; bit 7
				AND		R0,R3 ; R0=0 do always. R0=1 do conditional depending on bit6
				CMP		R0,#0
				BEQ		s_loop_filter_mainscr ; skip this check
				PUSH 	{R1}
				MOV		R6,#66 ; IsScreensaver
				BL		_FuncLib
				POP		{R1}
				; LSL		R0,#6 ; make it to bit 6
				MOV		R6,#0x40 ; bit 6
				AND		R6,R3 ; if bit5=1: R0=0: do only if no scrsav. R0=1: do only if srsav
				
				CMP		R6,#0x40
				BNE 	s_loop_filter_scrsav_0
				
s_loop_filter_scrsav_1	; statusbit1
				CMP		R0,#1 ; is now screensaver?
				BEQ		s_loop_9
				B		s_loop_filter_mainscr
				
s_loop_filter_scrsav_0	; status bit=0
				CMP		R0,#0 ; is not srcsaver?
				BEQ		s_loop_filter_mainscr
				B		s_key_not_snapped
	
s_loop_filter_mainscr	; process sequence record depending SequenceMode_Mainscreen _yes or _no?
				MOV		R0,#8 ; bit 3
				AND		R0,R3 ; R0=0 do always. R0=1 do conditional depending on bit2
				CMP		R0,#0
				BEQ		s_loop_8 ; skip this check
				BL		_mainscreen_state
				CMP		R6,#FF
				BNE		s_loop_filter_mainscr1
				MOV		R6,#0
				B		s_loop_filter_mainscr2 
s_loop_filter_mainscr1	
				MOV		R6,#4 ; set to power of bit2
s_loop_filter_mainscr2	
				MOV		R0,#4 ; bit 2
				AND		R0,R3 ; if bit3=1: R0=0: do only if at mainscreen. R0=1: do always but not at mainscreen
				CMP		R6,R0
				BNE		s_key_not_snapped

s_loop_8		LDR		R0,[SP,#sp_sub_1 + sp_direct_or_hotkey_seq]
				CMP		R0,#1 ; is sequence direct or hotkey mode?
				BEQ		s_loop_8_hotk ; NEW

s_loop_8_direct	ADD		R0,R2,R1 ; R0=Very1stByteOfCurrSeqRec + seq rec ram counter
				B		s_loop_9
				
s_loop_8_hotk	SUB		R0,R4,#1  
				LDRB	R0,[R0] ; ; [ram_basement+1] keypress-after-hotkey-counter
				ADD		R0,R2,R0 ; R0=Very1stByteOfCurrSeqRec + keypress-after-hotkey-counter

s_loop_9		ADD		R0,#8 ; position of first key sequence byte
				LDRB	R6,[R0] ; R0=key sequence byte of current sequence record
				
				CMP		R5,R6 ; is currently pressed key = the current key in the current sequence?
				BEQ		s_key_snapped
				
s_key_not_snapped					
				MOV		R1,#0 ; reset_sequence
				STRB	R1,[R4,R7] ; reset ram-buf for seq
				B		s_loop_return
							
s_key_snapped	MOV		R6,#1 ; counter of sequences
				STR		R6,[SP,#sp_sub_1 + sp_AnySequenceTouched] ; set to true
				

s_key_snapped_1	LDRB	R6,[R0,#1]
				CMP		R6,#0 ; sequence end reached, cause next key sequence element 0?
				BEQ		s_action
				
				
				
				
				LDR		R3,[SP,#sp_sub_1 + sp_direct_or_hotkey_seq]
				CMP		R3,#1 ; is sequence direct or hotkey mode?
				BEQ		s_key_snapped_1_hotk ; NEW

s_key_snapped_1_direct
				CMP		R1,#4 ; sequence end reached, cause maximum number of elements reached? (max=5. max-1=4)
				BGE		s_action
				B		s_key_in_sequence

s_key_snapped_1_hotk
				SUB		R3,R4,#1  
				LDRB	R3,[R3] ; [ram_basement+1] keypress-after-hotkey-counter
				CMP		R3,#4 ; sequence end reached, cause maximum number of elements reached? (max=5. max-1=4)
				BGE		s_action
		
s_key_in_sequence
				ADD		R1,#1
				STRB	R1,[R4,R7]
				B		s_loop_return
								
; -----------------------------------------------------------------------------	
		
s_exit			;SUB		R1,R4,#2
				;STRB	R0,[R4,#1] ; ###

				LDR		R1,[SP,#sp_sub_1 + sp_ActionPerformed] ; SequAccepted&ActionPerformed(FF=False) 
				
				
				; returns:SequAccepted&ActionPerformed(FF=False)

				
				MOV		R0,R5 ; repatch
				
 				POP		{R2-R7}

				;CMP		R1,FF ; Skip KeypressOn_Func? (FF=False) 
				;BNE		exit_x
				;LDR		R4,Keypress_On_Store2Ram_
				;BLX		R4
				
				POP		{PC}

; -----------------------------------------------------------------------------


s_action		PUSH	{R0-R3,R7}
				MOV		R7,R2
				LDR		R0,_ram_mainscreen_menu_state_
				LDR		R0,[R0]
				MOV		R2,#FF
				STRB	R2,[R0,#2] ; set to dirty
				STR		R4,[SP,#sp_sub_1 + sp_sub_2 + sp_ActionPerformed] ; store anything else than FF in SequAccepted&ActionPerformed(FF=False) to dirty it. SP: ({R0-R3,R7}: 5 regs x 4 = 20 = 0x14.

s_action_reset	; reset all sequence ram buffers to zero here
				LDR		R0,[SP,#sp_sub_1 + sp_sub_2 + sp_SequenceRecords] ; number of sequence records
				MOV		R2,#0
				MOV		R1,R2
				
s_action_reset_l
				CMP		R2,R0 ; last sequence
				BEQ		s_action_sound
				STRB	R1,[R4,R2] ; store zero to ram
				ADD		R2,#1 ; reset next ram sequence buffer
				B		s_action_reset_l
				
s_action_sound	; B		s_action_illu_on ; ########## skip action sound 
				LDRB	R0,[R7,#0x0E] ; R0=sound for PlaySound
				LDRB	R2,[R7,#0x0F] ; R2=loops for PlaySound
				ADD		R6,R0,R2
				CMP		R6,#0
				BEQ		s_action_illu_on
				MOV		R1,#2
				BL		_playsoundloop
				
s_action_illu_on
 				MOV		R0,#3 ; turn all lights on
				MOV		R6,#68 ; IlluminationEvent_
				BL		_FuncLib

s_action_what	LDR		R6,[R7] ; R6=ExecAddress or Action
				ADD		R6,#4 ; shift for comparing
				BMI		s_action_blx
				
				CMP		R6,#0 ; device unlock ?
				BEQ		s_action_device_unlock
				
				CMP		R6,#1 ; device lock ?
				BEQ		s_action_device_lock
				
				CMP		R6,#2 ; keylock?
				BEQ		s_action_keylock
				
				CMP		R6,#3 ; midlet?
				BEQ		s_action_midlet

				
s_action_flib	BL		s_action_loadr
				BL		_FuncLib
				B		s_action_x
				
s_action_keylock
				BL		_keylock ; returns in r0 content of r6.
				MOV		R1,#1
				SUB		R0,R1,R0
				STRB	R0,[R6] ; toggle keylock
				B		s_action_x
				
s_action_device_lock
				MOV		R0,#0xFF
				BL		_set_scrsaver ; unlock device
				B		s_action_x
				
s_action_device_unlock
				MOV		R0,#0x10
 				BL		_set_scrsaver ; unlock device
				LDR		R0,DrawMainscreen_
				BLX		R0
				; BL		_send_redkey
				B		s_action_x
				
s_action_midlet	LDRB	R0,[R7,#0x04] ; R0=number of midlet string
				MOV		R1,#0x30 ; length of string record
				MUL		R0,R1
				LDR		R1,midlet_fnames_
				ADD		R0,R1
				MOV		R1,#1
				MOV		R6,#75 ; StartMidlet
				BL		_FuncLib
				B		s_action_x

s_action_blx	BL		s_action_loadr
				BLX		R6

s_action_x	  	; send red key after action? 
				LDRB	R6,[R7,#0xD] ; mode byte of sequence record
				MOV		R3,#2
				AND		R6,R3 ; sequence mode byte, bit 1: SequenceMode_SendKey
				CMP		R6,R3
				BNE		s_action_xx
				BL		_send_redkey
				
s_action_xx		POP		{R0-R3,R7}
				; B		s_loop_return

; -----------------------------------------------------------------------------
		
s_loop_return	LDR		R0,[SP,#sp_sub_1 + sp_ActionPerformed]
				CMP		R0,#FF ; SequAccepted&ActionPerformed(FF=False) 
				BNE		s_exit ; leave patch when one sequence accepted and the action performed.
			
				ADD		R7,#1 ; read next key sequence record
				B		s_loop
				
s_action_loadr	SUB		R6,#4 ; shift back
				LDRB	R0,[R7,#4] ; R0 for exec_address
				LDRB	R1,[R7,#5] ; R1 for exec_address
				LDRB	R2,[R7,#6] ; R2 for exec_address
				LDRB	R3,[R7,#7] ; R3 for exec_address
				BX		LR
				
_send_redkey	PUSH	{R6,LR}
				MOV		R0,#0xC ; red button on
				LDR		R6,Keypress_On_Store2Ram_
				BLX		R6
				MOV		R0,#0x8C ; red button off
				LDR		R6,Keypress_Off_Store2Ram_
				BLX		R6
				POP		{R6,PC}
				
; -----------------------------------------------------------------------------

_FuncLib		; input: r6=func-no from func lib
				PUSH	{R7,LR}
				LDR		R7,FunctionLibrary_
				LSL		R6,#3
				ADD		R7,R6
				BLX		R7
				BLX		R7
				POP		{R7,PC}
				
_set_scrsaver	PUSH	{R5,LR} ; input R0=state.
				MOV		R5,R0
				LDR		R0,Screensaver_GetAddress
				BLX		R0
				CMP		R0,#0
				BEQ		_set_scrsaver_x
				STRB	R5,[R0]
_set_scrsaver_x	POP		{R5,PC}
			
_mainscreen_state ; returns in R0: 00 on boot, FF not mainscreen. everything else: mainscreen.
				LDR		R6,_ram_mainscreen_menu_state_
				LDR		R6,[R6]
				LDRB	R6,[R6,#2]
				BX		LR
							
; -----------------------------------------------------------------------------
; m65v50 function addresses needed by patch core 
Keypress_On_Store2Ram_		DCD 0xA114C9D3
Keypress_Off_Store2Ram_		DCD 0xA114CA91
;GetProfile_				DCD	0xA08C9FE5 ; 2
;Malloc_					DCD	0xA0820F98 ; 20
;MidletExec_				DCD	0xA0C349A8 ; 75
;PlaySoundLoop_				DCD	0xA0935CF8 ; 52
;IlluminationEvent_			DCD	0xA0B69779 ; 68
;IsScreensaver				DCD	0xA163E2D1 ; 66
DrawMainscreen_			DCD 0xA163B09D ; 31
_ram_KeypadIsLocked8_		DCD 0xA114D414 
_ram_mainscreen_menu_state_ DCD 0xA1633D0C
Screensaver_GetAddress		DCD 0xA16310B3
free_ram_dword_				DCD 0xA8000204

FunctionLibrary_ 			DCD	0xA0FC0001

midlet_fnames_				DCD	midlet_fnames
 END
 				
