; net blink
; x65 M65v50 (c) benj9 

		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for CX6C

TYPE	SETA	1 						

 IF  TYPE = 1


netblinker_ram	EQU	0xA824FFF0 ; each set of netblinker_rom data consumes 4 bytes 
Illumination	EQU	0xA0BC78B8
IsKeyUnlocked	EQU	0xA114D0A7
GetProfile		EQU	0xA08C9FE5 

repatch			EQU	0xA13103D8
_ram_netacess_	EQU	0xA1310858 ; DCD 0xA8717D4C (+4=A8717D50)
_ram_netaccess_netmode EQU 0xA132D7D0


netbli	EQU	5
output			EQU	1
brightness		EQU 72
smoothness		EQU	7

 ENDIF


		
		CODE16

		
netblinker		; 

			PUSH	{R0-R7}
			MOV		R7,LR
			PUSH {R7}
			
			MOV		R7,#0 ; output device
			
		;LDR		R4,=IsKeyUnlocked
		;BLX		R4
		;CMP		R0,#0
		;BEQ		exit
		
netblinker_Is_NetAccess	
		;flight2-1
		LDR		R4,=_ram_netaccess_netmode 
		LDR		R4,[R4]
		LDRB	R5,[R4] 
		; 05=pre-phon, 06=pho+sms, 09 gprs, 13=idle. 14=post-sms !
		CMP		R5,#0x13 ; ruhiges netz
		BEQ		exit
		
netblinker_Which_NetAccessMode
		SUB		R4,#0x68 ; netaccess_base+2b  (netaccess_mode-68): 03, 02 meistens phone
		LDRB	R6,[R4] ; R4=A8752560 
		
		CMP		R6,#2
		BLE		netblinker_Which_NetAccessMode_x
		
		CMP		R6,#3
		BEQ		netblinker_Which_NetAccessMode_3
		
		MOV		R6,#3 ; choose set 3 - idle/default
		B		netblinker_Which_NetAccessMode_x
		
netblinker_Which_NetAccessMode_3
		MOV		R6,#2 ; choose set 2	
		; B		netblinker_Which_NetAccessMode_x
		
netblinker_Which_NetAccessMode_x
		ADD		R4,R6,R6
		ADD		R6,R4 ; R6*3=Ram-Offset
	
		;LDR		R6,=0xA8250000
		;LDRB	R6,[R6]
		;BL		netbli_run
		;B		exit



netbli_run	;PUSH	{R0-R6,LR} ; input: R6=0: netblinkerset0.  R6=3: netblinkerset1 ...
			LDR		R4,=netblinker_ram
			ADD		R4,R6
			LDR		R5,=netblinker_rom
			SUB		R5,#1	; porter's delight!
			ADD		R5,R6
			
netbli_togg	LDRB	R2,[R4,#2] ; toggle-funcnow1
			;MOV	R3,#loop_trigger_max
			LDRB	R3,[R5] ; <loop_trigger_max>
			CMP		R2,R3 ; signal ausdnnen
			BEQ 	netbli_step	
		
			ADD		R2,#1
			STRB	R2,[R4,#2]  ; reset funcnow
			B 		netbli_exit
	
netbli_step	
			MOV 	R2,#1
			STRB	R2,[R4,#2]	; set toggle_funcnow

       		LDRB	R2,[R4] ; toggle_on/off
			;MOV 	R1,#brightness 
			LDRB	R1,[R5,#2] ; <brightness>
			SUB		R2,R1,R2
			STRB	R2,[R4]
		
netbli_illu	MOV		R0,R7 ; <output>
			;LDRB	R0,[R5,#1]
        	MOV     R1, #1
      	  	;MOV		R3,#smoothness ; <smoothness>
        	LDRB	R3,[R5,#3]  ; <smoothness>
    	    LDR		R4,=Illumination
   	    	BLX     R4
   	    	
netbli_exit	; POP		{R0-R6,PC}

		
exit		POP		{R7}
			MOV		LR,R7
			POP		{R0-R7}
			LDR 	R7,=repatch
	 		MOV		PC,R7
	 		
	 		
		; LDR	R0,= GetProfile
		; BLX	R0
		; CMP	R0,#5 ; profile sfx



netblinker_rom ; <loop_trigger_max>,<brightness>,<smoothness>
; <loop_trigger_max>: min 3!,<output>0=Scr,1=KPL,2=DL,<brightness>0-0x64,<smoothness>0=off
			DCB	4,40,2 ; ;R6=0 beim Rufaufbau kurz
			DCB	3,55,2 ;  R6=1 beim Rufaufbau sehr kurz
			DCB	7,50,6 ;  R6=2 + 3  Verbindung
			DCB 1,25,32 ; R6=1B, blink for idle and default
			

 END

       	
;toggle-miss-loop-max, <output>, brightness, smoothness
;Langsamer guter Wert: 0c 01 42 09
;Schneller guter Wert:  07 01 35 09



Port-Info


RAM_NetAccessTable= netaccess_ram		

;A (10B5041C2820FFF7B7FD002141626060217010BD)+0x44
;B (99B5027A8478011C01261223002C9948994D0BD01523841C201C4968)+0x5A

M65 v50
A:A1310858 -> A8717D4C (+4 = A8717D50) -> A8752534
B->A135F208 -> A8752534 net_access_ram_table

SL65v50
A->A131A308 -> A8711A0C (+4 = A8711A10)
B->A136C03A+0x5a=->A136C094->A87490C8 net_access_ram_table

CX70v56
A->A127DCAC -> A87760EC (+4 = A87760F0)
B->A12CE93A+0x5a=A12CE994->A87B0D34 net_access_ram_table 

S65 v50
A->A13485F8 -> A872215C (+4 = A8722160)

net_access_ram_table:
+2C:  1B meistens Idle, 02 Phone, 01, 00 .
+4C:  bis SIM 0
+7C:  01 at phoning. kurz 1 bei sms. sonst 0
+94:  05=pre-phon, 06=pho+sms, 09 gprs, 13=idle. 14=post-sms !
+101: Reagiert auf Net-Acess, Idle: 2B



RAM_NetAccessTable_Netmode = RAM_NetAccessTable +94
05=pre-phon, 06=pho+sms, 09 gprs, 13=idle. 14=post-sms !
Write access to A87525C9, PC=A132D81C ; net idle
Write access to A87525C8, PC=A132D668 ; net traffic

M65v50
A132D7D0 C8 25 75 A8 _RAM_NetAccessTable_NetMode_Traffic DCD RAM_NetAccessTable_Netmode
(0022002100209999999999999999999999990C489999999900220092131C0A490B4899999999E6E7)+0x2E
A132D7D0->A87525C8

CX70v56
19539428->A87B0DC8 

SL65v50
A133907A->A874915C 


M65v50:
A12265F8 00 F0 66 A8 _RAM_Illumination_Data DCD RAM_Illumination_Data