#include "..\inc\swilib.h"
#include "..\inc\cfg_items.h"
#include "conf_loader.h"
#include "language.h"

#ifdef NEWSGOLD
#define SHORTCUT "DEVICE_INBOX"
#else
#define SHORTCUT "MESG_UNIFIEDBOX"
#endif

//ReadMissedMes v1.4
//by tick

//CSM_DESC icsmd;
//int (*old_icsm_onMessage)(CSM_RAM*,GBS_MSG*);
//void (*old_icsm_onClose)(CSM_RAM*);

extern void kill_data(void *p, void (*func_p)(void *));

const int minus11=-11;
extern const unsigned int HELLO_MESSAGE;
extern const unsigned int CALL_BUTTON;
extern const unsigned int ACTIVE_KEY_STYLE;
//extern const unsigned int UNLOCK_KBD;
extern const unsigned int ILLU_POWER;
short int READY=1;

typedef struct
{
  CSM_RAM csm;
}MAIN_CSM;

int IDLECSM_ID=-1;

int IsIDLE(void)
{
  CSM_RAM *icsm=FindCSMbyID(CSM_root()->idle_id);
  if (IsGuiOnTop(((int *)icsm)[DISPLACE_OF_IDLEGUI_ID/4])) return(1);
                                                           else return(0);
}

#pragma inline=forced
int toupper(int c)
{
  if ((c>='a')&&(c<='z')) c+='A'-'a';
  return(c);
}
#pragma inline
int strcmp_nocase(const char *s1,const char *s2)
{
  int i;
  int c;
  while(!(i=(c=toupper(*s1++))-toupper(*s2++))) if (!c) break;
  return(i);
}

int maincsm_onmessage(CSM_RAM* data,GBS_MSG* msg)
{
  //int csm_result;
  //csm_result=old_icsm_onMessage(data, msg);  
  
  if(msg->msg == MSG_RECONFIGURE_REQ) 
  {
    extern const char *successed_config_filename;
    if (strcmp_nocase(successed_config_filename,(char *)msg->data0)==0)
    {
      InitConfig();
      ShowMSG(1,(int)LGP_CFG_UPDATE);
    }
  }
   
 if (!READY) {
 if (IsIDLE()) {
   READY=1;
   RefreshGUI();
   if ((ILLU_POWER)&&(!IsUnlocked())) {
     SetIllumination(0, 1, 0, 20);
     SetIllumination(1, 1, 0, 20);
   }
 } }
  
  return(1);
}

int my_keyhook(int submsg, int msg)
{
  if ((READY)&&(submsg==CALL_BUTTON)&&(msg==ACTIVE_KEY_STYLE+404))
    {
      if (!IsUnlocked())
      {
        #ifdef NEWSGOLD 
        if (GetMissedEventCount(0))
        #else 
        if (*RamMissedMessage())
        #endif
          { 
           LockSched();
//           if (UNLOCK_KBD) KbdUnlock();
           unsigned int* addr = (unsigned int*)GetFunctionPointer(SHORTCUT);
           if (addr)
           {
           typedef void (*voidfunc)();
           #ifdef NEWSGOLD
           voidfunc pp=(voidfunc)*(addr+4);
           #else
           voidfunc pp=(voidfunc)addr;
           #endif           
           pp();
           }                       
           if (ILLU_POWER) {
             SetIllumination(0, 1, ILLU_POWER, 0);
             SetIllumination(1, 1, ILLU_POWER, 0);   
           }
           READY=0;
           UnlockSched(); 
          }       
       } 
     }
 
#ifdef FORME  
  if ((msg==LONG_PRESS)&&(submsg==INTERNET_BUTTON)) SpellTime();
#endif    
 return 0;
}

static void maincsm_oncreate(CSM_RAM *data)
{
}

static void Killer(void)
{
  extern void *ELF_BEGIN;
  RemoveKeybMsgHook((void *)my_keyhook);  
  kill_data(&ELF_BEGIN,(void (*)(void *))mfree_adr());
}

static void maincsm_onclose(CSM_RAM *csm)
{
  SUBPROC((void *)Killer);
}

static unsigned short maincsm_name_body[140];

static const struct
{
  CSM_DESC maincsm;
  WSHDR maincsm_name;
}MAINCSM =
{
  {
  maincsm_onmessage,
  maincsm_oncreate,
#ifdef NEWSGOLD
  0,
  0,
  0,
  0,
#endif
  maincsm_onclose,
  sizeof(MAIN_CSM),
  1,
  &minus11
  },
  {
    maincsm_name_body,
    NAMECSM_MAGIC1,
    NAMECSM_MAGIC2,
    0x0,
    139
  }
};

static void UpdateCSMname(void)
{
  wsprintf((WSHDR *)(&MAINCSM.maincsm_name),"ReadMissedMes");
}

int main(void)
{
  CSM_RAM *save_cmpc;
  char dummy[sizeof(MAIN_CSM)];
  InitConfig();
  UpdateCSMname();
  
  
  
  LockSched();
  save_cmpc=CSM_root()->csm_q->current_msg_processing_csm;
  CSM_root()->csm_q->current_msg_processing_csm=CSM_root()->csm_q->csm.first;
  CreateCSM(&MAINCSM.maincsm,dummy,0);
  CSM_root()->csm_q->current_msg_processing_csm=save_cmpc;
  AddKeybMsgHook((void *)my_keyhook);
  if (HELLO_MESSAGE) ShowMSG(1,(int)LGP_HELLO_MESSAGE);
  UnlockSched(); 
  return 0;
}
