public class Tag {

	public static byte[] ALNUM;

	public String tag;
	public String name;
	public int index;
	public int offset;
	public int bitshift, bitmask;
	public int maxlen;

	public int npars;
	public String[] par_names;
	public String[] par_values;

	public String body;
	public int start, data, end;
	public int items;

	private boolean parsed;

	static {

		ALNUM = new byte[256];
		for (int i=0x2a; i<=0x39; i++) ALNUM[i] = 1;
		for (int i=0x41; i<=0x5a; i++) ALNUM[i] = 1;
		for (int i=0x61; i<=0x7a; i++) ALNUM[i] = 1;
		for (int i=0xc0; i<=0xff; i++) ALNUM[i] = 1;
		ALNUM[0x5f] = 1;


	}

	protected Tag() { }

	public static Tag copy(Tag t, int i, int offs) {

		if (i == 0) return t;

		Tag tt = new Tag();
		tt.index = i;
		tt.tag = t.tag;
		tt.name = t.name;
		tt.offset = t.offset + offs;
		tt.bitshift = t.bitshift;
		tt.bitmask = t.bitmask;
		tt.npars = t.npars;
		tt.par_names = t.par_names;
		tt.par_values = t.par_values;
		tt.body = t.body;
		tt.start = t.start;
		tt.data = t.data;
		tt.end = t.end;
		tt.items = t.items;
		tt.parsed = t.parsed;

		return tt;

	}

	public static int nexttoken(String s, int pos) {

		int l = s.length();
		while (pos < l && s.charAt(pos) <= 0x20) pos++;
		return pos;

	}

	public static boolean isdigit(char c) {

		return (c >= 0x30 && c <= 0x39);

	}

	public static boolean isalnum(char c) {

		return (c > 0xff || ALNUM[c] == 1);

	}

	public static String parseword(String s, int pos) {

		int e;

		if (s.charAt(pos) == '`') {
			e = s.indexOf('`', pos+1);
			if (e == -1) return null;
			return s.substring(pos, e+1);
		} else {
			e = pos;
			while (isalnum(s.charAt(e))) e++;
			if (e == pos) return null;
			return s.substring(pos, e);
		}

	}

	public static String unquote(String s) {

		return (s.charAt(0) != '`') ? s : s.substring(1, s.length()-1);

	}

	public static long parsenumber(String s) throws Exception {

		long sign = 1;
		int c = s.indexOf(','); if (c != -1) s = s.substring(0, c);
		if (s.charAt(0) == '+') s = s.substring(1);
		if (s.charAt(0) == '-') { s = s.substring(1); sign = -1; }
		if (s.length() >= 2 && s.substring(0, 2).toLowerCase().equals("0x")) {
			return sign * Long.parseLong(s.substring(2), 16);
		} else {
			return sign * Long.parseLong(s);
		}

	}

	public static Tag next(String cfg, int pos) {

		int bithigh, bitlow;

		Tag t = new Tag();
		t.tag = "";
		t.name = null;
		t.index = -1;
		t.npars = 0;
		t.par_names = new String[4];
		t.par_values = new String[4];
		t.parsed = false;
		t.items = 1;

		if (pos >= cfg.length()) return null;
		t.start = cfg.indexOf('{', pos);
		if (t.start == -1) return null;
		t.end = cfg.indexOf('}', t.start);
		if (t.end == -1) return null;

		t.body = cfg;
		int i = nexttoken(cfg, t.start+1);

		char c = cfg.charAt(i);
		if (isdigit(c)) {
			int ii = i;
			while (isalnum(cfg.charAt(ii)) && cfg.charAt(ii) != '.') ii++;
			try {
				t.offset = (int)parsenumber(cfg.substring(i, ii));
			} catch (Exception e) {
				t.offset = -1;
			}
			if (cfg.charAt(ii) == '.') {
				bithigh = bitlow = cfg.charAt(ii+1) - 0x30;
				ii += 2;
				if (cfg.charAt(ii) == '-') {
					bithigh = cfg.charAt(ii+1) - 0x30;
					if (bithigh < bitlow) {
						int btmp = bithigh;
						bithigh = bitlow;
						bitlow = btmp;
					}
					ii += 2;
				}
			} else {
				bithigh = 7;
				bitlow = 0;
			}
			t.bitshift = bitlow;
			t.bitmask = 0xff >> (7 - (bithigh - bitlow));

			i = nexttoken(cfg, ii);
		} else {
			t.offset = -1;
			t.bitshift = 0;
			t.bitmask = 0;
		}

		String s = parseword(cfg, i);
		if (s != null) {
			t.tag = unquote(s);
			i += s.length();
			if (cfg.charAt(i) == '(') {
				int j = cfg.indexOf(')', i);
				if (j != -1 && j-i <= 5) {
					try {
						t.items = (int)parsenumber(cfg.substring(i+1, j));
					}
					catch (Exception e) { }
					i = j + 1;
				}
			}
		}

		t.data = i;

		return t;

	}		

	public void parse() {

		if (this.parsed) return;

		String cfg = this.body;
		int i = this.data;

		while (i < this.end) {

			i = nexttoken(cfg, i);
			if (cfg.charAt(i) == '}') return;

			String s = parseword(cfg, i);
			if (s == null) {
				i++;
				continue;
			}
			i += s.length();

			if (cfg.charAt(i) == '=') {
				i++;
				String ss = parseword(cfg, i);
				if (ss == null) ss = "";
				i += ss.length();
				if (s.startsWith("`")) {
					s = unquote(s);
				} else {
					s = s.toLowerCase();
				}
				if (par_names.length <= npars+2) {
					String[] old_pn = par_names;
					String[] old_pv = par_values;
					par_names = new String[npars+8];
					par_values = new String[npars+8];
					System.arraycopy(old_pn, 0, par_names, 0, npars);
					System.arraycopy(old_pv, 0, par_values, 0, npars);
				}
				if (s.equals("v")) s = "value";
				par_names[npars] = s;
				par_values[npars] = unquote(ss);
				npars++;
			} else {
				if (npars == 0) {
					name = unquote(s);
				}
			}

		}

		parsed = true;

	}

	public String getString(String par) {

		par = par.toLowerCase();
		for (int i=0; i<this.npars; i++) {
			if (this.par_names[i].equals(par)) {
				return this.par_values[i];
			}
		}

		return null;

	}

	public int getInt(String par) {

		String s = this.getString(par);
		long n = 0;
		try {
			n = (int)parsenumber(s);
		}
		catch (Exception e) { }

		return (int)n;

	}

	public int getInt(String par, int idx) {

		String s = this.getString(par);
		long n = 0;
		try {
			int p1 = 0;
			int p2 = -1;
			for (int j=0; j<=idx; j++) {
				int p = s.indexOf(',', p2+1);
				if (p == -1) p = s.length();
				p1 = p2+1;
				p2 = p;
			}
			s = (p2 == -1) ? s.substring(p1) : s.substring(p1, p2);
			n = (int)parsenumber(s);
		}
		catch (Exception e) { }

		return (int)n;

	}

	public long[] getRange() {

		String s = this.getString("range");
		if (s == null) s = this.getString("r");
		long n1 = 0L;
		long n2 = 0xffffffffL;
		try {
			int d = s.indexOf("..");
			if (d == -1) throw new Exception();
			String s1 = s.substring(0, d);
			String s2 = s.substring(d+2);
			n2 = parsenumber(s2);
			n1 = parsenumber(s1);
		}
		catch (Exception e) { }

		long[] r = new long[2];
		r[0] = n1;
		r[1] = n2;

		return r;

	}

}
