import javax.microedition.lcdui.*;

public class PlaceField extends Canvas implements Runnable {

	static Font mfont = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_PLAIN, Font.SIZE_SMALL);
	static Image imgGRID;
	static int w, h;

	Displayable DS;
	Image I;
	Graphics G;
	Widget CW;
	boolean is2;
	int dx, dy;
	int timer;
	boolean exit;

	static {
		imgGRID = getImage("screen.png");
		if (imgGRID == null) imgGRID = getImage("screen.jpg");
		if (imgGRID == null) imgGRID = getImage("screen.bmp");
		if (imgGRID == null) {
			try {
				imgGRID = Image.createImage("/images/grid.png");
			}
			catch (Exception e) { }
		}
	}

	public PlaceField(Patch p, Widget cw) {

		super();
		DS = Master.D.getCurrent();
		CW = cw;
		w = getWidth();
		h = getHeight();
		is2 = (cw.type == Widget.XY2);

		I = Image.createImage(w, h);
		G = I.getGraphics();
		G.setColor(0xffffff);
		G.fillRect(0, 0, w, h);

		G.setColor(0xa5d3de);
		Widget[] ws = p.widgets;
		for (int i=0; i<p.nwidgets; i++) {
			if (ws[i].type != Widget.XY) continue;
			if (ws[i] == cw) continue;
			if (ws[i].w > 0 && ws[i].h > 0) {
				G.fillRect(ws[i].x, ws[i].y, ws[i].w, ws[i].h);
			} else {
				G.drawLine(ws[i].x, ws[i].y-3, ws[i].x, ws[i].y+3);
				G.drawLine(ws[i].x-3, ws[i].y, ws[i].x+3, ws[i].y);
			}

		}

		int ww = imgGRID.getWidth();
		int hh = imgGRID.getHeight();

		for (int y=0; y<h; y+=hh) {
			for (int x=0; x<w; x+=ww) {
				G.drawImage(imgGRID, x, y, G.TOP|G.LEFT);
			}
		}

		if (is2) {
			cw.x &= 0x7fff;
		} else {
			if (cw.x == 255) cw.x = cw.savex;
			if (cw.y == 255) cw.y = cw.savey;
			if (cw.x == 255) cw.x = w/2;
			if (cw.y == 255) cw.y = h/2;
		}
		dx = dy = 0;
		exit = false;
		(new Thread(this)).start();

		Master.D.setCurrent(this);

	}

	protected void paint(Graphics g) {

		g.drawImage(I, 0, 0, g.TOP|g.LEFT);
		g.setColor(0);
		if (CW.w > 0 && CW.h > 0) {
			g.setStrokeStyle(g.DOTTED);
			g.drawRect(CW.x, CW.y, CW.w, CW.h);
		} else {
			g.setStrokeStyle(g.SOLID);
			g.drawLine(CW.x, CW.y-3, CW.x, CW.y+3);
			g.drawLine(CW.x-3, CW.y, CW.x+3, CW.y);
		}
		g.setColor(0x800000);
		g.setFont(mfont);
		String s = ""+CW.x+","+CW.y;
		g.drawString(s, w-1, h-1, g.BOTTOM|g.RIGHT);

	}

	protected void keyPressed(int key) {

		switch (key) {

			case -59:
			case '2':
				timer = 7;
				dx = 0;
				dy = -1;
				movePoint();
				break;

			case -60:
			case '8':
				timer = 7;
				dx = 0;
				dy = 1;
				movePoint();
				break;

			case -61:
			case '4':
				timer = 7;
				dx = -1;
				dy = 0;
				movePoint();
				break;

			case -62:
			case '6':
				timer = 7;
				dx = 1;
				dy = 0;
				movePoint();
				break;

			case -26:
			case -4:
			case '5':
				exit = true;
				CW.savex = CW.x;
				CW.savey = CW.y;
				Master.D.setCurrent(DS);
				break;

			case -12:
			case '0':
				exit = true;
				Master.D.setCurrent(DS);
				if (is2) {
					CW.x |= 0x8000;
				} else {
					CW.x = CW.y = 255;
				}
				ChoiceGroup cg = (ChoiceGroup)(CW.item);
				cg.setSelectedIndex(0, false);
				break;

		}

	}

	protected void keyReleased(int key) {

		dx = dy = 0;

	}

	public void run() {

		while (! exit) {

			try { Thread.sleep(75); } catch (Exception e) { }
			if (--timer > 0) continue;
			movePoint();

		}

	}

	private void movePoint() {

		if (dx == 0 && dy == 0) return;
		CW.x += dx;
		if (CW.x+CW.w < 0) CW.x = -CW.w;
		if (CW.x >= w) CW.x = w-1;
		CW.y += dy;
		if (CW.y+CW.h < 0) CW.y = -CW.h;
		if (CW.y >= h) CW.y = h-1;
		repaint();

	}

	public static Image getImage(String name) {

		try {
			String s = Master.PATCHDIR + "\\" + name;
			if (! AFile.exists(s)) return null;
			AFile F = AFile.open(s);
			int len = F.length();
			byte[] b = new byte[len];
			F.read(b, 0, len);
			F.close();
			Image ii = Image.createImage(b, 0, len);
			return ii;
		}
		catch (Exception e) {
			return null;
		}

	}

}
