import javax.microedition.lcdui.*;

public class Patch implements CommandListener, ItemCommandListener,
							ItemStateListener {

	static Command CMD_OK = new Command(Msg.OK, Command.OK, 1);
	static Command CMD_BACK = new Command(Msg.CANCEL, Command.BACK, 2);
	static Command CMD_INFO = new Command(Msg.INFO, Command.HELP, 3);
	static Command CMD_OPEN = new Command(Msg.OPEN, Command.ITEM, 0);
	static Command CMD_CHOOSE = new Command(Msg.SELECT, Command.ITEM, 0);
	static Command CMD_VARIANTS = new Command(Msg.VARIANTS, Command.ITEM, 0);

	static Font fBold = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_BOLD, Font.SIZE_MEDIUM);

	static String PROFILES = null;
	static String NONE = Msg.NONE;

	public int id;
	public String name;
	public String version;
	public String cpy;
	public int memory;
	public String body;
	public String info;
	public byte pmask;

	public OptChoice[] choices;
	public int nchoices;

	public String[] tempnames;
	public int[] temppos;
	public int ntemps;

	public Widget[] widgets;
	public int nwidgets;
	public Widget currentwidget;

	public Form F;
	public Form[] smstack;
	public int smitems;

	public int[] tplstack_i;
	public int[] tplstack_o;
	public int tplitems;

	public int index;
	public boolean enabled;

	public Ptc ptc;

	public void cleanup() {

		choices = new OptChoice[32];
		nchoices = 0;

		tempnames = new String[32];
		temppos = new int[32];
		ntemps = 0;

		widgets = new Widget[16];
		nwidgets = 0;
		currentwidget = null;

		F = null;
		smstack = new Form[10];
		smitems = 0;

		tplstack_i = new int[10];
		tplstack_o = new int[10];
		tplitems = 0;

		ptc = null;

		System.gc();

	}

	public Patch(String pname, String pversion, String pcpy, int pmemory, boolean pprof, String pbody, int ppos) {

		if (PROFILES == null) PROFILES = "{sm `" + Msg.PROFILES + "`}{0.0 cb `" + Msg.NORMAL + 
			"` v=1}{0.1 cb `" + Msg.QUIET + "` v=1}{0.2 cb `" + Msg.NOISY +
			"` v=1}{0.3 cb `" + Msg.CARKIT + "` v=1}{0.4 cb `" + Msg.HEADSET +
			"` v=1}{0.5 cb `" + Msg.PROFILE6 + "` v=1}{0.6 cb `" + Msg.PROFILE7 + "`}{endsm}";

		name = pname;
		version = pversion;
		cpy = pcpy;
		memory = pmemory;
		info = "";

		int last = findNextPatch(pbody, ppos);

		if (pprof) {
			body = PROFILES + pbody.substring(ppos, last);
			pmask = (byte)0x80;
		} else {
			body = pbody.substring(ppos, last);
			pmask = (byte)0xff;
		}

		cleanup();

	}

	public String getInfo() {

		String s = Msg.NAME + " " + name + "\n" + Msg.VERSION + " " + version;
		if (cpy != null) s = s + "\n(c) " + cpy;
		s = s + "\nID: " + Integer.toHexString(id) + "\n\n" + info;
		return s;

	}

	public Ptc getPtc() {

		return ptc;

	}

	public void setEnabled(boolean en) {

		byte b = ptc.buffer[0];
		if (en) {
			ptc.buffer[0] = (byte)(b | pmask);
		} else {
			ptc.buffer[0] = (byte)(b & ~pmask);
		}
		enabled = en;		

	}

	public Form buildMenu() {

		Widget w;
		long n;
		String s;
		TextField tf;
		ChoiceGroup cg;
		StringItem si;
		Gauge gg;
		OptChoice oc;
		int maxl;
		long[] ai;
		int offset;

		F = new Form(name);
		F.addCommand(CMD_OK);
		F.addCommand(CMD_BACK);
		F.addCommand(CMD_INFO);
		F.setCommandListener(this);
		F.setItemStateListener(this);
		Form cf = F;
		nchoices = 0;
		nwidgets = 0;
		offset = 0;

		ptc = Ptc.read(id, memory);

		int i = 0;
		while (true) {

			if (widgets.length <= nwidgets+1) {
				Widget[] oldwidgets = widgets;
				widgets = new Widget[nwidgets+16];
				System.arraycopy(oldwidgets, 0, widgets, 0, nwidgets);
				oldwidgets = null;
			}

			Tag t = Tag.next(body, i);
			s = (t == null) ? body.substring(i) : body.substring(i, t.start);
			s = s.trim();
			if (s.length() != 0) cf.append(s);
			if (t == null) break;
			t.parse();
			String ctag = t.tag;
			String cname = t.name;
			t.offset += offset;

			i = t.end + 1;

			if (ctag.equals("patch")) break;

			if (ctag.equals("info")) {

				info = cname;

			} else if (ctag.equals("offset") || ctag.equals("of")) {

				try {
					offset = (int)Tag.parsenumber(cname);
				}
				catch (Exception e) {
					offset = 0;
				}

			} else if (ctag.equals("choice") || ctag.equals("c")) {

				oc = new OptChoice(cname, t.npars);

				for (int x=0; x<t.npars; x++) {
					try {
						oc.opt_names[oc.count] = t.par_names[x];
						String ov = t.unquote(t.par_values[x]);
						oc.opt_values[oc.count] = (int)t.parsenumber(ov);
						oc.count++;
					} catch (Exception e) { }
				}
				choices[nchoices++] = oc;

			} else if (ctag.equals("byte") || ctag.equals("b")) {

				for (int j=0; j<t.items; j++) {
					Tag tt = Tag.copy(t, j, j);
					w = widgets[nwidgets++] = new Widget(Widget.BYTE, tt);
					n = ptc.getBits(tt);
					ai = tt.getRange();
					if (ai[0] >= 0L) {
						if (n < 0L) n = 0L;
						if (n > 255L) n = 255L;
					} else {
						if (n > 127L) n -= 256L;
						if (n < -128L) n = -128L;
						if (n > 127L) n = 127L;
					}
					tf = new TextField((j==0) ? cname : null, Long.toString(n), 4, TextField.NUMERIC);
					cf.append(w.item = tf);
				}

			} else if (ctag.equals("int") || ctag.equals("i")) {

				for (int j=0; j<t.items; j++) {
					Tag tt = Tag.copy(t, j, j*4);
					w = widgets[nwidgets++] = new Widget(Widget.INT, tt);
					n = ptc.getInt(tt);
					ai = tt.getRange();
					if (ai[0] >= 0L) {
						if (n < 0L) n = 0L;
						if (n > 0xffffffffL) n = 0xffffffffL;
					} else {
						if (n >= 0x80000000L) n -= 0x100000000L;
						if (n < -0x80000000L) n = -0x80000000L;
						if (n > 0x7fffffffL) n = 0x7fffffffL;
					}
					tf = new TextField((j==0) ? cname : null, Long.toString(n), 11, TextField.NUMERIC);
					cf.append(w.item = tf);
				}

			} else if (ctag.equals("timeinms") || ctag.equals("ms")) {

				w = widgets[nwidgets++] = new Widget(Widget.TIMEINMS, t);
				n = ptc.getInt(t);
				n = (n * 60L) / 13L;
				if (n < 0) n = 0;
				if (n > 0xffffffffL) n = 0xffffffffL;
				tf = new TextField(cname, Long.toString(n), 10, TextField.NUMERIC);
				cf.append(w.item = tf);

			} else if (ctag.equals("string") || ctag.equals("s")) {

				w = widgets[nwidgets++] = new Widget(Widget.STRING, t);
				maxl = t.getInt("maxlen");
				if (maxl == 0) maxl = t.getInt("ml");
				if (maxl == 0) maxl = 15;
				t.maxlen = maxl;
				s = ptc.getString(t);
				tf = new TextField(cname, s, maxl, TextField.ANY);
				cf.append(w.item = tf);

			} else if (ctag.equals("ustring") || ctag.equals("u")) {

				w = widgets[nwidgets++] = new Widget(Widget.USTRING, t);
				maxl = t.getInt("maxlen");
				if (maxl == 0) maxl = t.getInt("ml");
				if (maxl == 0) maxl = 15;
				t.maxlen = maxl;
				s = ptc.getUstring(t);
				tf = new TextField(cname, s, maxl, TextField.ANY);
				cf.append(w.item = tf);

			} else if (ctag.equals("hex") || ctag.equals("h")) {

				w = widgets[nwidgets++] = new Widget(Widget.HEX, t);
				maxl = t.getInt("maxlen") * 2;
				if (maxl == 0) maxl = t.getInt("ml") * 2;
				if (maxl == 0) maxl = 2;
				t.maxlen = maxl;
				s = ptc.getHex(t);
				tf = new TextField(cname, s, maxl, TextField.ANY);
				tf.setInitialInputMode("MIDP_UPPERCASE_LATIN");
				cf.append(w.item = tf);

			} else if (ctag.equals("address") || ctag.equals("a")) {

				w = widgets[nwidgets++] = new Widget(Widget.ADDR, t);
				s = ptc.getAddr(t);
				tf = new TextField(cname, s, 8, TextField.ANY);
				tf.setInitialInputMode("MIDP_UPPERCASE_LATIN");
				cf.append(w.item = tf);

			} else if (ctag.equals("checkbox") || ctag.equals("cb")) {

				w = widgets[nwidgets++] = new Widget(Widget.CHECKBOX, t);
				n = ptc.getBits(t);
				cg = new ChoiceGroup(null, Choice.MULTIPLE);
				cg.append(cname, null);
				cg.setSelectedIndex(0, (n != 0));
				cf.append(w.item = cg);

			} else if (ctag.equals("selectfile") || ctag.equals("sf")) {

				w = widgets[nwidgets++] = new Widget(Widget.SELECTFILE, t);
				maxl = t.getInt("maxlen");
				if (maxl == 0) maxl = t.getInt("ml");
				if (maxl == 0) maxl = 63;
				t.maxlen = maxl;
				s = ptc.getString(t);
				if (s.length() == 0) s = NONE;
				s.replace('/', '\\');
				si = new StringItem(cname, s);
				si.setFont(fBold);
				cf.append(w.item = si);
				si.addCommand(w.command = CMD_CHOOSE);
				si.setItemCommandListener(this);

			} else if (ctag.equals("selectdir") || ctag.equals("sd")) {

				w = widgets[nwidgets++] = new Widget(Widget.SELECTDIR, t);
				maxl = t.getInt("maxlen");
				if (maxl == 0) maxl = t.getInt("ml");
				if (maxl == 0) maxl = 63;
				t.maxlen = maxl;
				s = ptc.getString(t);
				if (s.length() == 0) s = NONE;
				s.replace('/', '\\');
				si = new StringItem(cname, s);
				si.setFont(fBold);
				cf.append(w.item = si);
				si.addCommand(w.command = CMD_CHOOSE);
				si.setItemCommandListener(this);

			} else if (ctag.equals("phone") || ctag.equals("ph")) {

				w = widgets[nwidgets++] = new Widget(Widget.PHONE, t);
				t.maxlen = maxl = 31;
				s = ptc.getString(t);
				tf = new TextField(cname, s, maxl, TextField.PHONENUMBER);
				cf.append(w.item = tf);

			} else if (ctag.equals("slider") || ctag.equals("sl")) {

				w = widgets[nwidgets++] = new Widget(Widget.SLIDER, t);
				n = ptc.getBits(t);
				ai = t.getRange();
				if (ai[0] < 0) {
					if (ai[0] < -128L) ai[0] = -128L;
					if (ai[1] > 127L) ai[1] = 127L;
				} else {
					if (ai[1] > 255L) ai[1] = 255L;
				}
				w.minvalue = (int)ai[0];
				if (n < ai[0]) n = ai[0];
				if (n > ai[1]) n = ai[1];
				gg = new Gauge(t.name+": "+n, true, (int)(ai[1]-ai[0]), (int)(n-w.minvalue));
				cf.append(w.item = gg);

			} else if (ctag.equals("option") || ctag.equals("o")) {

				w = widgets[nwidgets++] = new Widget(Widget.OPTION, t);
				n = ptc.getBits(t);
				oc = null;
				s = t.getString("choice");
				if (s == null) s = t.getString("c");
				if (s != null) {
					for (int j=0; j<nchoices; j++) {
						if (choices[j].name.equals(s)) {
							oc = choices[j];
							break;
						}
					}
				}
				if (oc == null) {
					oc = new OptChoice(cname, t.npars);
					for (int j=0; j<t.npars; j++) {
						if (t.par_names[j].equals("choice")) continue;
						if (t.par_names[j].equals("value")) continue;
						try {
							oc.opt_names[oc.count] = t.par_names[j];
							oc.opt_values[oc.count] = (int)Long.parseLong(t.par_values[j]);
							oc.count++;
						} catch (Exception e) { }
					}
				}
				w.optchoice = oc;
				cg = new ChoiceGroup(cname, Choice.POPUP);
				cg.addCommand(w.command = CMD_VARIANTS);
				cg.setDefaultCommand(CMD_VARIANTS);
				cg.setItemCommandListener(this);
				for (int j=0; j<oc.count; j++) {
					int idx = cg.append(oc.opt_names[j], null);
					if (oc.opt_values[j] == n) {
						cg.setSelectedIndex(idx, true);
					}
				}
				cf.append(w.item = cg);

			} else if (ctag.equals("submenu") || ctag.equals("sm")) {

				w = widgets[nwidgets++] = new Widget(Widget.SUBMENU, t);
				si = subitem(cname, w);
				cf.append(w.item = si);
				smstack[smitems++] = cf;
				w.form = cf = new Form(cname);
				cf.addCommand(new Command("Back", Command.BACK, 1));
				cf.setCommandListener(this);
				cf.setItemStateListener(this);

			} else if (ctag.equals("endsubmenu") || ctag.equals("endsm")) {

				if (smitems > 0) {
					cf = smstack[--smitems];
				}

			} else if (ctag.equals("const")) {

				w = widgets[nwidgets++] = new Widget(Widget.CONSTANT, t);
				w.size = t.getInt("size");
				if (w.size < 1) w.size = 1;
				if (w.size > 4) w.size = 4;
				w.value = t.getInt("value");

			} else if (ctag.equals("xy") || ctag.equals("xy2")) {

				boolean is2 = ctag.equals("xy2");
				w = widgets[nwidgets++] = new Widget(is2 ? Widget.XY2 : Widget.XY, t);
				int[] xy = is2 ? ptc.getXY2(t) : ptc.getXY(t);
				w.x = w.savex = xy[0];
				w.y = w.savey = xy[1];
				w.w = t.getInt("w");
				w.h = t.getInt("h");
				cg = new ChoiceGroup(null, Choice.MULTIPLE);
				cg.append(cname, null);
				if (is2) {
					cg.setSelectedIndex(0, (w.x & 0x8000) == 0);
				} else {
					cg.setSelectedIndex(0, (w.x != 255 && w.y != 255));
				}
				cf.append(w.item = cg);

			} else if (ctag.equals("color") || ctag.equals("co")) {

				w = widgets[nwidgets++] = new Widget(Widget.COLOR, t);
				w.value = ptc.getInt(t);
				t.maxlen = 4;
				si = subitem(cname, w);
				cf.append(w.item = si);

			} else if (ctag.equals("template") || ctag.equals("tp")) {

				tempnames[ntemps] = t.name;
				temppos[ntemps] = i = t.end + 1;
				ntemps++;

				while (true) {
					t = Tag.next(body, i);
					if (t == null) break;
					i = t.end + 1;
					if (t.tag.equals("endtemplate") || t.tag.equals("endtp")) break;
				}				

			} else if (ctag.equals("usetemplate") || ctag.equals("usetp")) {

				for (int j=0; j<ntemps; j++) {
					if (tempnames[j].equals(t.name)) {
						tplstack_i[tplitems] = t.end + 1;
						tplstack_o[tplitems] = offset;
						tplitems++;
						offset = t.offset;
						i = temppos[j];
						break;
					}
				}

			} else if (ctag.equals("endtemplate") || ctag.equals("endtp")) {

				if (tplitems > 0) {
					tplitems--;
					i = tplstack_i[tplitems];
					offset = tplstack_o[tplitems];
				}

			} else {

				cf.append("\n {" + Msg.UNKOPT + " '" + ctag + "'}");

			}

			// i = t.end + 1;

		}

		smitems = 0;
		return F;

	}

	public void commandAction(Command c, Item item) {

		Master.timeout = 0;
		for (int i=0; i<nwidgets; i++) {

			Widget w = widgets[i];

			if (w.item == item) {

				switch (w.type) {

					case Widget.SELECTFILE:
					case Widget.SELECTDIR:
						Form cf = (Form)(Master.D.getCurrent());
						SelectFile sf = new SelectFile(cf, w);
						break;

					case Widget.SUBMENU:
						cf = widgets[i].form;
						smstack[smitems++] = (Form)Master.D.getCurrent();
						Master.D.setCurrent(cf);
						break;

					case Widget.COLOR:
						new ColorSelector(this, w);
						break;

					case Widget.OPTION:
						currentwidget = w;
						List cl = new List(w.name, List.IMPLICIT);
						OptChoice oc = w.optchoice;
						ChoiceGroup cg = (ChoiceGroup)w.item;
						String s = cg.getString(cg.getSelectedIndex());
						for (int j=0; j<oc.count; j++) {
							String ss = oc.opt_names[j];
							int idx = cl.append(ss, null);
							if (ss.equals(s)) {
								cl.setSelectedIndex(idx, true);
							}
						}
						cl.addCommand(CMD_BACK);
						cl.setCommandListener(this);
						smstack[smitems++] = (Form)Master.D.getCurrent();
						Master.D.setCurrent(cl);
						break;

/*
					case Widget.XY:
						new PlaceField(this, w);
						break;
*/
						
				}

			}

		}

	}

	public void commandAction(Command c, Displayable d) {

		Master.timeout = 0;
		switch (c.getCommandType()) {

			case Command.BACK:

				if (smitems == 0) {
					Master.D.setCurrent((Displayable)Master.GL);
					cleanup();
				} else {
					Master.D.setCurrent((Displayable)smstack[--smitems]);
				}
				break;

			case Command.HELP:

				Master.D.setCurrent(new Msg(getInfo(), F));
				break;

			case Command.OK:

				if (buildPtc()) {

					setEnabled(true);
					ptc.save();
					String txt = Master.GL.getString(index);
					Master.GL.set(index, txt, Master.imgEN);
					Master.D.setCurrent(Master.GL);
					cleanup();

				}
				break;

			case Command.SCREEN:

				// option list

				Widget w = currentwidget;
				ChoiceGroup cg = (ChoiceGroup)(w.item);
				List l = (List)d;
				String s = l.getString(l.getSelectedIndex());
				int n = cg.size();
				for (int i=0; i<n; i++) {
					if (cg.getString(i).equals(s)) {
						cg.setSelectedIndex(i, true);
						break;
					}
				}
				Master.D.setCurrent(smstack[--smitems]);
				break;

		}

	}

	public void itemStateChanged(Item item) {

		TextField tf = null;

		Master.timeout = 0;
		if (item instanceof TextField) {
			tf = (TextField)item;
			if (tf.getConstraints() != TextField.DECIMAL) return;
		} else if (! (item instanceof Gauge || item instanceof ChoiceGroup)) return;

		for (int i=0; i<nwidgets; i++) {

			Widget w = widgets[i];
			if (w.item == item) {
				if (item instanceof Gauge) {
					Gauge gg = (Gauge)item;
					gg.setLabel(w.name + ": " + (gg.getValue() + w.minvalue));
					break;
				} else if (item instanceof TextField) {
					String s = tf.getString();
					int p = s.indexOf('.');
					if (p != -1) tf.setString(s.substring(0, p));
				} else if (w.type == Widget.XY || w.type == Widget.XY2) {
					ChoiceGroup cg = (ChoiceGroup)item;
					boolean q = cg.isSelected(0);
					if (q) {
						new PlaceField(this, w);
					} else {
						if (w.type == Widget.XY2) {
							w.x |= 0x8000;
						} else {
							w.x = w.y = 255;
						}
					}
				}
			}

		}

	}

	public boolean buildPtc() {

		String wname = name;

		try {

			for (int i=0; i<nwidgets; i++) {

				Widget w = widgets[i];
				wname = w.name;
				handleWidget(w);

			}
			return true;

		} catch (Exception e) {

			Master.D.setCurrent(new Msg(wname + ": " + e.getMessage(), F));
			return false;

		}

	}

	private void handleWidget(Widget w) throws Exception {

		Tag t = w.tag;
		int x;
		long xl;
		String s;
		boolean q;

		switch (w.type) {

			case Widget.BYTE:

				try {
					x = Integer.parseInt(((TextField)w.item).getString());
				}
				catch (Exception e) {
					throw new Exception(Msg.INVINT);
				}
				ptc.setBits(t, x);
				break;

			case Widget.INT:

				try {
					xl = Long.parseLong(((TextField)w.item).getString());
				}
				catch (Exception e) {
					throw new Exception(Msg.INVINT);
				}
				ptc.setInt(t, xl);
				break;

			case Widget.TIMEINMS:

				try {
					xl = Long.parseLong(((TextField)w.item).getString());
					xl = (((xl * 13L) / 6L) + 5L) / 10L;
				}
				catch (Exception e) {
					throw new Exception(Msg.INVTIME);
				}
				ptc.setInt(t, xl);
				break;

			case Widget.STRING:
			case Widget.PHONE:

				s = ((TextField)w.item).getString();
				ptc.setString(t, s);
				break;

			case Widget.USTRING:

				s = ((TextField)w.item).getString();
				ptc.setUstring(t, s);
				break;

			case Widget.HEX:

				s = ((TextField)w.item).getString();
				ptc.setHex(t, s);
				break;

			case Widget.ADDR:

				s = ((TextField)w.item).getString();
				ptc.setAddr(t, s);
				break;

			case Widget.CHECKBOX:

				q = ((ChoiceGroup)w.item).isSelected(0);
				ptc.setBits(t, q ? 1 : 0);
				break;

			case Widget.SELECTFILE:
			case Widget.SELECTDIR:

				s = ((StringItem)w.item).getText();
				if (s.equals(NONE)) s = "";
				ptc.setString(t, s);
				break;

			case Widget.SLIDER:

				x = ((Gauge)w.item).getValue();
				ptc.setBits(t, x + w.minvalue);
				break;

			case Widget.OPTION:

				ChoiceGroup cg = (ChoiceGroup)w.item;
				s = cg.getString(cg.getSelectedIndex());
				OptChoice oc = w.optchoice;
				x = 0;
				for (int i=0; i<oc.count; i++) {
					if (oc.opt_names[i].equals(s)) {
						x = oc.opt_values[i];
						break;
					}
				}
				ptc.setBits(t, x);
				break;

			case Widget.CONSTANT:

				int v = w.value;
				byte[] b = new byte[4];
				b[0] = (byte)(v & 0xff);
				b[1] = (byte)((v >> 8) & 0xff);
				b[2] = (byte)((v >> 16) & 0xff);
				b[3] = (byte)((v >> 24) & 0xff);
				int n = w.size;
				ptc.setData(t.offset, b, n);
				break;

			case Widget.XY:

				int[] xy = new int[2];
				xy[0] = w.x;
				xy[1] = w.y;
				ptc.setXY(t, xy);
				break;

			case Widget.XY2:

				int[] xy2 = new int[2];
				xy2[0] = w.x;
				xy2[1] = w.y;
				ptc.setXY2(t, xy2);
				break;

			case Widget.COLOR:

				ptc.setInt(t, w.value);
				break;

		}

	}

	private int findNextPatch(String s, int i) {

		int l = s.length();
		while (i < l) {

			Tag t = Tag.next(s, i);
			if (t == null) break;
			if (t.tag.equals("patch") || t.tag.equals("p")) return i+1;
			i = t.end;

		}
		return l;

	}

	private boolean isHexChar(char c) {

		return ((c >= '0' && c <= '9') || (c >= 'A' && c <= 'F') || (c >= 'a' && c <= 'f'));

	}

	private StringItem subitem(String name, Widget w) {

		StringItem si = new StringItem(null, name, Item.HYPERLINK);
		si.setLayout(Item.LAYOUT_NEWLINE_AFTER);
		si.addCommand(w.command = CMD_OPEN);
		si.setDefaultCommand(CMD_OPEN);
		si.setItemCommandListener(this);
		return si;

	}

}
