WSHDR *ws_info;
#include "main.h"
//#include "debug.c"
const char percent_t[]="%t";
const char percent_d[]="%d";
const char percent_s[]="%s";
const char percent_ss[]="%s%s";
const char percent_td[]="%t%d";
const char percent_x[]="%x";
const char percent_dd[]="%05d";

int type1 = 0;

int EditcontrolOnKey(GUI *data, GUI_MSG *msg)
{
  WSHDR *ws;
  ws = AllocWS(32);
  EDITCONTROL ec;
  char *tmpstr;
  if (msg->keys==0xFFF || msg->keys == 0x18)
  {
    switch (type1)
    {
      case 2:
        {
          ExtractEditControl(data,1,&ec);
          tmpstr = malloc(32);
          wstrcpy(ws,ec.pWS);
          ws_2str(ws, tmpstr, 32);
          int unit = 0;
          sscanf(tmpstr, percent_d, &unit);
          writeinit(unit, 1);
          if(tmpstr) mfree(tmpstr);
          break;
        }
      case 3:
        {
          ExtractEditControl(data,1,&ec);
          tmpstr = malloc(32);
          wstrcpy(ws,ec.pWS);
          ws_2str(ws, tmpstr, 32);
          int unit = 0;
          sscanf(tmpstr, percent_d, &unit);
          writeinit(unit, 2);
          if(tmpstr) mfree(tmpstr);
          break;
        }
        case 4:
        {
          char *xmap = malloc(32);
          char *ymap = malloc(32);
          int x1 = 0, y1 = 0;
          ExtractEditControl(data,2,&ec);
          wstrcpy(ws,ec.pWS);
          ws_2str(ws, xmap, 32);
          sscanf(xmap, percent_d, &x1);
          CutWSTR(ws, 0);
          ExtractEditControl(data,4,&ec);
          wstrcpy(ws,ec.pWS);
          ws_2str(ws, ymap, 32);
          sscanf(ymap, percent_d, &y1);
          if(x1 > 128) x1 = 128;
          if(y1 > 128) y1 = 128;
          changeSize(x1, y1);
          if(xmap) mfree(xmap);
          if(ymap) mfree(ymap);
          break;
        }        
      case 1:
      default:
        {
          ExtractEditControl(data,1,&ec);
          tmpstr = malloc(32);
          wstrcpy(ws,ec.pWS);
          ws_2str(ws, tmpstr, 32);
          writemap(tmpstr);
          if(tmpstr) mfree(tmpstr);
          break;
        }
    }
    if(ws) FreeWS(ws);
    return 1;
  }
  return(0); //   
}

void EditcontrolGHook(GUI *data, int cmd)
{
  //EDITCONTROL ec;
  static SOFTKEY_DESC sk={0x0FFF,0x0000,(int)"OK"};
  if(cmd==0xA)
  {
    DisableIDLETMR();   //     
  }
  if(cmd==0x03)     //   
  {
    FreeWS(ws_info);
    ws_info = NULL;
  }
  if (cmd==7)
  {
    SetSoftKey(data,&sk,SET_SOFT_KEY_N);
  }
}

void edchat_locret(void){}

SOFTKEY_DESC fmenu_sk[]=
{
  {0x0018,0x0000,(int)""},
  {0x0001,0x0000,(int)""},
  {0x003D,0x0000,(int)LGP_DOIT_PIC}
};

SOFTKEYSTAB fmenu_skt=
{
  fmenu_sk,0
};

INPUTDIA_DESC EditcontrolStruct=
{
  1,
  EditcontrolOnKey,
  EditcontrolGHook,
  (void *)edchat_locret,
  0,
  &fmenu_skt,
  {0,22,131,153},
  4, 100, 101, 0, 0,
  0x40000000//  -
};

HEADER_DESC FilenameHeader={0,0,0,0,NULL,(int)" ",LGP_NULL};
HEADER_DESC GoldHeader={0,0,0,0,NULL,(int)"",LGP_NULL};
HEADER_DESC WoodHeader={0,0,0,0,NULL,(int)"",LGP_NULL};
HEADER_DESC SizeHeader={0,0,0,0,NULL,(int)" ",LGP_NULL};

void DoEditcontrol(int type, char *deftext, char *def2)
{
  type1 = type;
  char *text = malloc(256);
  ws_info = AllocWS(256);
  EDITCONTROL ec;
  void *ma=malloc_adr();
  void *eq;
  PrepareEditControl(&ec);
  eq=AllocEQueue(ma,mfree_adr());
  switch (type)
  {
    case 2:
      {
        // 
        wsprintf(ws_info, percent_s,deftext);
        ConstructEditControl(&ec,2,0x40,ws_info,6); // 1
        AddEditControlToEditQend(eq,&ec,ma);
        patch_header(&GoldHeader);
        patch_input(&EditcontrolStruct);
        CreateInputTextDialog(&EditcontrolStruct,&GoldHeader,eq,1,0);
        break;
      }
    case 3:
      {
        // 
        wsprintf(ws_info, percent_s,deftext);
        ConstructEditControl(&ec,2,0x40,ws_info,6); // 1
        AddEditControlToEditQend(eq,&ec,ma);
        patch_header(&WoodHeader);
        patch_input(&EditcontrolStruct);
        CreateInputTextDialog(&EditcontrolStruct,&WoodHeader,eq,1,0);
        break;
      }
    case 4:
      {
        //  
        wsprintf(ws_info, percent_t,": ");
        ConstructEditControl(&ec,1,0x00,ws_info,256); // 1 
        AddEditControlToEditQend(eq,&ec,ma); 

        CutWSTR(ws_info,0);
        wsprintf(ws_info, percent_s,deftext);
        ConstructEditControl(&ec,2,0x40,ws_info,3); // 2
        AddEditControlToEditQend(eq,&ec,ma);
        
        wsprintf(ws_info, percent_t,": ");
        ConstructEditControl(&ec,1,0x00,ws_info,256); // 3 
        AddEditControlToEditQend(eq,&ec,ma); 

        CutWSTR(ws_info,0);
        wsprintf(ws_info, percent_s,def2);
        ConstructEditControl(&ec,2,0x40,ws_info,3); // 4
        AddEditControlToEditQend(eq,&ec,ma);
        
        patch_header(&SizeHeader);
        patch_input(&EditcontrolStruct);
        CreateInputTextDialog(&EditcontrolStruct,&SizeHeader,eq,1,0);
        break;
      }
    case 1:
    default:
      {
        //  
        wsprintf(ws_info, percent_s,deftext);
        ConstructEditControl(&ec,3,0x40,ws_info,256); // 1
        AddEditControlToEditQend(eq,&ec,ma);
        patch_header(&FilenameHeader);
        patch_input(&EditcontrolStruct);
        CreateInputTextDialog(&EditcontrolStruct,&FilenameHeader,eq,1,0);
        break;
      }
  }
}
