__attribute__((noreturn))
static void kill_data(void *start, void *free_addr)
{
 register void* p0 asm("r0")=start;
 register void* p1 asm("r1")=free_addr;
 asm volatile("bx	%1\n\t"::"r"(p0),"r"(p1));
}

inline static void loopback0(void)
{
 swi_call0(0);
}

inline static void loopback1(void)
{
 swi_call0(1);
}

inline static void loopback2(void)
{
 swi_call0(2);
}

inline static void loopback3(void)
{
 swi_call0(3);
}

inline static void loopback4(void)
{
 swi_call0(4);
}

inline static int GetAkku(int param1,int param2)
{
 return (int)swi_call2(6, param1, param2);
}

inline static long SetIllumination(unsigned char dev,unsigned long param1,unsigned short bright,unsigned long delay)
{
 return swi_call4(8, dev, param1, bright, delay);
}

inline static void SwitchPhoneOff(void)
{
 swi_call0(0x9);
}

inline static int fopen(const char * cFileName, unsigned int iFileFlags, unsigned int iFileMode, unsigned int *ErrorNumber)
{
 return (int)swi_call4(10, (long)cFileName, iFileFlags, iFileMode, (long)ErrorNumber);
}

inline static int fread(int FileHandler, void *cBuffer, int iByteCount, unsigned int *ErrorNumber)
{
 return (int)swi_call4(11, FileHandler, (long)cBuffer, iByteCount, (long)ErrorNumber);
}

inline static unsigned int fwrite(int FileHandler, void const * cBuffer, int iByteCount, unsigned int *ErrorNumber)
{
 return (unsigned int)swi_call4(12, FileHandler, (long)cBuffer, iByteCount, (long)ErrorNumber);
}

inline static void fclose(int FileHandler, unsigned int *ErrorNumber)
{
 swi_call2(13, FileHandler, (long)ErrorNumber);
}

inline static unsigned int lseek(int FileHandler, unsigned int offset, unsigned int origin, unsigned int *ErrorNumber, unsigned int *ErrorNumber2)
{
 return (unsigned int)swi_call5(15, FileHandler, offset, origin, (long)ErrorNumber, (long)ErrorNumber2);
}

inline static int mkdir(const char * cFileName, unsigned int *ErrorNumber)
{
 return (int)swi_call2(16, (long)cFileName, (long)ErrorNumber);
}

inline static int GetFileAttrib(const char *cFileName, unsigned char *cAttribute, unsigned int *ErrorNumber)
{
 return (int)swi_call3(18, (long)cFileName, (long)cAttribute, (long)ErrorNumber);
}

inline static int SetFileAttrib(const char *cFileName, unsigned char cAttribute, unsigned int *ErrorNumber)
{
 return swi_call3(19, (long)cFileName, (long)cAttribute, (long)ErrorNumber);
}


inline static void *malloc(unsigned int size){
 return (void *)swi_call1r(20, size);
}

inline static void *malloc_adr(void)
{
 return (void *)swi_call0r(0x8014);
}

inline static void mfree(void *ptr)
{
 swi_call1(21, (long)ptr);
}

inline static void * mfree_adr(void)
{
 return (void *)swi_call0r(0x8015);
}

inline static int sprintf(char *buf, const char *str, ...)
{
 return (int)swi_call2(22, (long)buf, (long)str);
}

inline static char * strcat (char *str1, const char *str2)
{
 return (char *)swi_call2(23, (long)str1, (long)str2);
}

inline static char * strchr (const char *str, int pos)
{
 return (char *)swi_call2(24, (long)str, (long)pos);
}

inline static int strcmp (const char *str1, const char *str2)
{
 return (int)swi_call2(25, (long)str1, (long)str2);
}

inline static char * strcpy (char *dest, const char *source)
{
 return (char *)swi_call2(26, (long)dest, (long)source);
}

inline static unsigned int strlen(const char *str)
{
 return (unsigned int)swi_call1r(27, (long)str);
}

inline static void wsAppendChar(WSHDR *ws, int wchar)
{
 swi_call2(28, (long)ws, wchar);
}

inline static int wsInsertChar(WSHDR *ws,int wchar,int pos)
{
 return swi_call3(29, (long)ws, wchar, pos);
}

inline static IMGHDR *GetPITaddr(int num)
{
 return (IMGHDR *)swi_call1r(30, num);
}

inline static int GetImgHeight(int picture)
{
 return swi_call1r(33, picture);
}

inline static int GetImgWidth(int picture)
{
 return swi_call1r(34, picture);
}

inline static void DrawImg(unsigned int x, unsigned int y, unsigned int picture)
{
 swi_call3(35, x, y, picture);
}

inline static void DrawCanvas(void *data, int x1, int y1, int x2, int y2, int flag_one)
{
 swi_call6(37, (long)data, x1, y1, x2, y2, flag_one);
}

inline static void DrawImgBW(unsigned int x, unsigned int y, unsigned int picture, char *pen, char *brush)
{
 swi_call5(38, x, y, picture, (long)pen, (long)brush);
}

inline static int EEFullGetBlockInfo(unsigned int block, int *size, char *version)
{
 return swi_call3(0x2C, block, (long)size, (long)version);
} // res : 0 -OK, 2 - block not found

inline static void PlaySound(long param1, long param2, long param3, long tone, long param5)
{
 swi_call5(50, param1, param2, param3, tone, param5);
}

inline static void PlaySoundLoop(int _0x2F, int param2, int duration)
{
 swi_call3(0x34, _0x2F, param2, duration);
}

inline static void AlarmClockRing(void)
{
 swi_call0(0x35);
}

inline static int *GetEELiteBlockAddress(short blocknum)
{
 return (int *)swi_call1r(42, blocknum);
}

inline static int setfilesize(int FileHandler, unsigned int iNewFileSize, unsigned int *ErrorNumber)
{
 return swi_call3(60, FileHandler, iNewFileSize, (long)ErrorNumber);
}

inline static int IsScreenSaver(void)
{
 return swi_call0r(0x42);
}

inline static int IsUnlocked(void)
{
 return swi_call0r(67);
}

#ifdef NEWSGOLD 
inline static int GetWavLen(char *filename)
{
 return swi_call1r(0x45, (long)filename);
} 
#else 
inline static int GetWavLen(TWavLen *wl)
{
 return swi_call1r(0x45, (long)wl);
} 
#endif

inline static int HasNewSMS(void)
{
 return swi_call0r(0x46);
}

inline static int HasFlashSMS(void)
{
 return swi_call0r(0x47);
}

#ifdef X75
inline static short PlayFile(int flags, WSHDR *foldername, WSHDR *filename, int zero, int CepId, int Msg, const PLAYFILE_OPT *sfo)
{
 return swi_call7(0x4A, flags, (long)foldername, (long)filename, zero, CepId, Msg, (long)sfo);
}
#else
inline static short PlayFile(int flags, WSHDR *foldername, WSHDR *filename, int CepId, int Msg, const PLAYFILE_OPT *sfo)
{
 return swi_call6(0x4A, flags, (long)foldername, (long)filename, CepId, Msg, (long)sfo);
}
#endif

inline static int GetMissedCallsCount(void)
{
 return swi_call0r(0x4C);
}

inline static void GBS_StartTimerProc(void *htimer, long ms, void ptr())
{
 swi_call3(77, (long)htimer, ms, (long)ptr);
}

inline static int MsgBoxError(int flag, int LgpId)
{
 return swi_call2(0x4E, flag, LgpId);
}

inline static int MsgBoxYesNo(int flag, int LgpID, void CallBackProc(int))
{
 return swi_call3(0x4F, flag, LgpID, (long)CallBackProc);
}

inline static int MsgBoxOkCancel(int flag, int LgpID, void CallBackProc(int))
{
 return swi_call3(0x50, flag, LgpID, (long)CallBackProc);
}

#ifdef NEWSGOLD
#else
#endif
inline static char *GetIlluminationDataTable(void){
 return (char *)swi_call0r(0x52);
}

inline static int StrToInt(char *s, char **endp)
{
 return swi_call2(0x54, (long)s, (long)endp);
}

inline static unsigned char GetCPUClock(void)
{
 return swi_call0r(92);
}

inline static unsigned char GetCPULoad(void)
{
 return swi_call0r(93);
}

inline static int GetFreeRamAvail(void)
{
 return swi_call0r(95);
}

inline static int FindFirstFile (DIR_ENTRY *DIRENTRY,char *mask,unsigned int *ErrorNumber)
{
 return swi_call3(107, (long)DIRENTRY, (long)mask, (long)ErrorNumber);
}

inline static int  FindNextFile (DIR_ENTRY *DIRENTRY, unsigned int *ErrorNumber)
{
 return swi_call2(108, (long)DIRENTRY, (long)ErrorNumber);
}

inline static int FindClose (DIR_ENTRY *DIRENTRY, unsigned int *ErrorNumber)
{
 return swi_call2(109, (long)DIRENTRY, (long)ErrorNumber);
}

inline static int IsCalling(void)
{
 return swi_call0r(0x6E);
}

inline static void RefreshGPRSTraffic(void)
{
 swi_call0(111);
}

inline static int *GetGPRSTrafficPointer(void)
{
 return (int *)swi_call0r(112);
}

inline static int GetTypeOfCall()
{
 return swi_call0r(0x73);
}

inline static void* GetFunctionPointer(char * _shortcut)
{
 return (void *)swi_call1r(116, (long)_shortcut);
}

inline static unsigned int SetVibration(unsigned int power)
{
 return (unsigned int)swi_call1r(124, power);
}

inline static int ShowCallList(int list, int zero)
{
 return swi_call2(128, list, zero);
}

inline static int GetFileStats(const char *cFileName, FSTATS * StatBuffer, unsigned int *errornumber)
{
 return swi_call3(132, (long)cFileName, (long)StatBuffer, (long)errornumber);
}

inline static int strcmpi(const char *s1, const char *s2)
{
 return swi_call2(0x85, (long)s1, (long)s2);
}

inline static void EEFullReadBlock(int block, void *buf, int offset, int size, int cepid, int msg)
{
 swi_call6(0x86, block, (long)buf, offset, size, cepid, msg);
} //cepid=msg=0

inline static void EEFullWriteBlock(int block, void *buf, int offset, int size, int cepid, int msg)
{
 swi_call6(0x87, block, (long)buf, offset, size, cepid, msg);
}

inline static int GetFreeFlexSpace(int DriveNum, unsigned int *ErrorNumber)
{
 return swi_call2(138, DriveNum, (long)ErrorNumber);
}

inline static int GetTotalFlexSpace(int DriveNum, unsigned int *ErrorNumber)
{
 return swi_call2(139, DriveNum, (long)ErrorNumber);
}

inline static void RegExplorerExt(REGEXPLEXT const *ptr)
{
 swi_call1(140, (long)ptr);
}

inline static int fmove(const char * SourceFileName, const char * DestFileName, unsigned int *ErrorNumber)
{
 return swi_call3(142, (long)SourceFileName, (long)DestFileName, (long)ErrorNumber);
}

inline static int rmdir(const char * cDirectory, unsigned int *ErrorNumber)
{
 return swi_call2(143, (long)cDirectory, (long)ErrorNumber);
}

inline static int truncate(int FileHandler, int length, int *errornumber)
{
 return swi_call3(144, FileHandler, length, (long)errornumber);
}

inline static int isdir(const char * cDirectory, unsigned int *ErrorNumber)
{
 return swi_call2(145, (long)cDirectory, (long)ErrorNumber);
}

inline static void *calloc(size_t nelem, size_t elsize)
{
 return (void *)swi_call2(146, (long)nelem, (long)elsize);
}

inline static int ExecuteFile (WSHDR *filepath, WSHDR *mimetype, void *param)
{
 return swi_call3(148, (long)filepath, (long)mimetype, (long)param);
}

inline static int UnRegExplorerExt(REGEXPLEXT const *ptr)
{
 return swi_call1r(149, (long)ptr);
}

inline static int PlayMelodyInMem(char Unk_0x11, void * MelAddr, int MelSize, int CepId, int Msg, int Unk_0)
{
 return swi_call6(0x99, (long)Unk_0x11, (long)MelAddr, MelSize, CepId, Msg, Unk_0);
} // CepId = MMI_CEPID, Msg = MSG_PLAYFILE_REPORT

inline static int ChangeVolume(unsigned char Volume)
{
 return swi_call1r(154, Volume);
}

inline static void ws_2str(WSHDR *ws, char *str, unsigned int size)
{
 swi_call3(163, (long)ws, (long)str, size);
}

inline static void ResetGPRSTraffic(void)
{
 swi_call0(166);
}

inline static char *GetCurrentLocale(void)
{
 return (char *)swi_call0r(170);
}

inline static void loopback171(void)
{
 swi_call0(171);
}

inline static void GetDateTime(TDate *date, TTime *time)
{
 swi_call2(180, (long)date, (long)time);
}

inline static char GetWeek(TDate *date)
{
 return swi_call1r(181, (long)date);
}

inline static char GetProfile(void)
{
 return swi_call0r(182);
}

inline static char SetProfile(char profile)
{
 return swi_call1r(183, profile);
}

inline static int sdiv(int denom, int number)
{
 return swi_call2(184, denom, number);
}

inline static char IsGPRSEnabled(void)
{
 return swi_call0r(167);
}

inline static char IsGPRSConnected(void)
{
 return swi_call0r(168);
}

inline static void KbdLock(void)
{
 swi_call0(169);
}

inline static void KbdUnlock(void)
{
 swi_call0(185);
}

inline static void *realloc(void *ptr, int size)
{
 return (void *)swi_call2(186, (long)ptr, size);
}

inline static void *memset(void *s, int c, int n)
{
 return (void *)swi_call3(187, (long)s, c, n);
}

inline static int udiv(unsigned int denom, unsigned int number)
{
 return swi_call2(188, denom, number);
}

inline static int DivBy10(int divident)
{
 return swi_call1r(189, divident);
}

inline static void SpellTime(void)
{
 swi_call0(0xBF);
}

inline static void *GetBuffer(int patch_id)
{
 return (void *)swi_call1r(0xC4, patch_id);
}

inline static char GetAkkuCapacity(void)
{
 return swi_call0r(198);
}


inline static char GetAccessoryType(void)
{
 return swi_call0r(0x88);
}

inline static void RebootPhone(void)
{
 swi_call0(0x93);
}

inline static unsigned short *RamCap(void)
{
 return (unsigned short *)swi_call0r(0x80C8);
}

inline static unsigned short *RamLS(void)
{
 return (unsigned short *)swi_call0r(0x80C9);
}

inline static RAMNET * RamNet(void)
{
 return (RAMNET *)swi_call0r(0x80CA);
}

inline static char * RamMissedCalls(void)
{
 return (char *)swi_call0r(0x80CC);
}

inline static char * RamMissedSMS(void)
{
 return (char *)swi_call0r(0x80CD);
}

inline static char * RamMissedMessage(void)
{
 return (char *)swi_call0r(0x80D4);
}

inline static char * RamMenuAnywhere(void)
{
 return (char *)swi_call0r(0x80D8);
}

inline static char *RamPressedKey(void)
{
 return (char *)swi_call0r(0x80DF);
}

inline static void * RamScreenBuffer(void)
{
 return (void *)swi_call0r(0x80E0);
}

inline static unsigned int *RamMPlayer_CtrlCode(void)
{
 return (unsigned int *)swi_call0r(0x80E1);
}

inline static void *FreeRAM(void)
{
 return (void *)swi_call0r(0x80E4);
}

inline static void *BuildCanvas(void)
{
 return (void *)swi_call0r(0x80F1);
}

inline static unsigned int AddrLibrary(void)
{
 return (unsigned int)swi_call0r(0x80FF);
}

inline static void GBS_SendMessage(int cepid_to, int msg, ...)
{
 swi_call2(0x100, cepid_to, msg);
} //int submess, void *data1, void *data2

inline static int GBS_ReciveMessage(GBS_MSG *msg)
{
 return swi_call1r(0x101, (long)msg);
}

inline static void GBS_AcceptMessage(void)
{
 swi_call0(0x102);
}

inline static void GBS_ClearMessage(void)
{
 swi_call0(0x103);
}

inline static void GBS_PendMessage(GBS_MSG *msg)
{
 swi_call1(0x104, (long)msg);
}

inline static void CreateGBSproc(int cepid, const char *name, void (*onMsg)(void), int prio, int unk_zero)
{
 swi_call5(0x105, cepid, (long)name, (long)onMsg, prio, unk_zero);
}

inline static CSMROOT *CSM_root(void)
{
 return (CSMROOT *)swi_call0r(0x8106);
}

inline static int CreateCSM(const CSM_DESC *desc, void *mem, int id)
{
 return swi_call3(0x107, (long)desc, (long)mem, id);
}

inline static CSM_RAM * FindCSMbyID (int id)
{
 return (CSM_RAM *)swi_call1r(0x108, id);
}

inline static void DoIDLE(void)
{
 swi_call0(0x109);
}

inline static void *GetConfig(unsigned int id)
{
 return (void *)swi_call1r(0x10A, id);
} //BoBaPack

inline static void *GetMinAdrScan(void)
{
 return (void *)swi_call0r(0x810B);
} //BoBaPack

inline static void *GetMaxAdrScan(void)
{
 return (void *)swi_call0r(0x810C);
} //BoBaPack

inline static unsigned short *GetCI(void)
{
 return (unsigned short *)swi_call0r(0x810D);
}

inline static void Vibration(unsigned int power, unsigned int duration)
{
 swi_call2(0x10E, power, duration);
} //BoBaPack

inline static void freeUSSD(void)
{
 swi_call0(0x10F);
}

inline static char *wstrcopy(unsigned short *dst, const unsigned short *src)
{
 return (char *)swi_call2(0x110, (long)dst, (long)src);
}

inline static char GetTypeUSSD(void)
{
 return swi_call0r(0x111);
}

inline static unsigned int SetUSSD(StructUSSDStr *str)
{
 return swi_call1r(0x112, (long)str);
}

inline static char * strpbrk (const char *s1,const char *s2)
{
 return (char *)swi_call2(0x113, (long)s1, (long)s2);
}

inline static int strcspn(const char *s1, const char *s2)
{
 return swi_call2(0x113, (long)s1, (long)s2);
}

inline static char * strncat (char *dest, const char *substr, int maxSubLen)
{
 return (char *)swi_call3(0x114, (long)dest, (long)substr, maxSubLen);
}

inline static int strncmp (const char *s1, const char *s2, int n)
{
 return swi_call3(0x115, (long)s1, (long)s2, n);
}

inline static int strncpy (char *dest, const char *source, int maxlen)
{
 return swi_call3(0x116, (long)dest, (long)source, maxlen);
}

inline static char * strrchr (const char *s, int c)
{
 return (char *)swi_call2(0x117, (long)s, c);
}

inline static char * strstr (const char *s1, const char *s2)
{
 return (char *)swi_call2(0x118, (long)s1, (long)s2);
}

inline static int snprintf (char *str, int n, const char *format,...)
{
 return swi_call3(0x11B, (long)str, n, (long)format);
}

inline static int  memcmp (const void *m1, const void *m2, int n)
{
 return swi_call3(0x011C, (long)m1, (long)m2, n);
}

inline static void zeromem (void *dest, int n)
{
 swi_call2(0x11D, (long)dest, n);
}

inline static void * memcpy (void *dest, const void *source, int cnt)
{
 return (void *)swi_call3(0x11E, (long)dest, (long)source, cnt);
}

inline static WSHDR * wstrcpy (WSHDR *wshdr_d, WSHDR *wshdr_s)
{
 return (WSHDR *)swi_call2(0x11F, (long)wshdr_d, (long)wshdr_s);
}

inline static WSHDR * wstrncpy (WSHDR *str1, WSHDR *str2, int n)
{
 return (WSHDR *)swi_call3(0x120, (long)str1, (long)str2, n);
}

inline static WSHDR * wstrcat (WSHDR *wshdr_d, WSHDR *wshdr_s)
{
 return (WSHDR *)swi_call2(0x121, (long)wshdr_d, (long)wshdr_s);
}

inline static WSHDR * wstrncat (WSHDR *wshdr_d, WSHDR *wshdr_s, int n)
{
 return (WSHDR *)swi_call3(0x122, (long)wshdr_d, (long)wshdr_s, n);
}

inline static int  wstrlen (WSHDR *wshdr)
{
 return swi_call1r(0x123, (long)wshdr);
}

inline static int wsprintf (WSHDR *ws, const char *format, ...)
{
 return swi_call2(0x124, (long)ws, (long)format);
}

inline static WSHDR * AllocWS (int len)
{
 return (WSHDR *)swi_call1r(0x125, len);
}

inline static void CutWSTR (void *WSHDR, int len)
{
 swi_call2(0x126, (long)WSHDR, len);
}

inline static WSHDR * CreateLocalWS (WSHDR *wshdr, unsigned __int16 *wsbody, int len)
{
 return (WSHDR *)swi_call3(0x127, (long)wshdr, (long)wsbody, len);
}

inline static int CreateWS (void *malloc, void *mfree, int len)
{
 return swi_call3(0x128, (long)malloc, (long)mfree, len);
}

inline static void FreeWS (WSHDR *wshdr)
{
 swi_call1(0x129, (long)wshdr);
}

inline static void DrawObject (DRWOBJ *obj)
{
 swi_call1(0x12A, (long)obj);
}

inline static void AddKeybMsgHook (void *proc)
{
 swi_call1(0x12B, (long)proc);
}

inline static int AddKeybMsgHook_end (void *proc)
{
 swi_call1(0x12C, (long)proc);
}

inline static void RemoveKeybMsgHook (void *proc)
{
 swi_call1(0x12D, (long)proc);
}

inline static char *GetPaletteAdrByColorIndex (int ColorIndex)
{
 return (char *)swi_call1r(0x12E, ColorIndex);
}

inline static void getRGBcolor (int ColorIndex, void *dest)
{
 swi_call2(0x12F, ColorIndex, (long)dest);
}

inline static void getRGBbyPaletteAdr (int *paletteAdr, void *dest)
{
 swi_call2(0x130, (long)paletteAdr, (long)dest);
}

inline static void setColor (int a, int r, int g, int b, void *dest)
{
 swi_call5(0x131, a, r, g, b, (long)dest);
}

inline static void *memmove(void *dest, const void *source, int cnt)
{
 return (void *)swi_call3(0x132, (long)dest, (long)source, cnt);
}


inline static void StoreXYWHtoRECT (void *RECT, int x, int y, int w, int h)
{
 swi_call5(0x133, (long)RECT, x, y, w, h);
}

inline static void StoreXYXYtoRECT (void *RECT, int x, int y, int x2, int y2)
{
 swi_call5(0x134, (long)RECT, x, y, x2, y2);
}

inline static int IsGuiOnTop (int id)
{
 return swi_call1r(0x135, id);
}

inline static int CreateGUI_ID (void *gui, int id)
{
 return swi_call2(0x136, (long)gui, id);
}

inline static int CreateGUI (void *gui)
{
 return swi_call1r(0x137, (long)gui);
}

inline static int CreateGUI_30or2 (void *gui)
{
 return swi_call1r(0x138, (long)gui);
}

inline static int CreateGUIWithDummyCSM (void *gui, int flag)
{
 return swi_call2(0x139, (long)gui, flag);
}

inline static int CreateGUIWithDummyCSM_30or2 (void *gui, int flag)
{
 return swi_call2(0x13A, (long)gui, flag);
}

inline static void GeneralFuncF1 (int cmd)
{
 swi_call1r(0x13B, cmd);
}

inline static void GeneralFuncF0 (int cmd)
{
 swi_call1r(0x13C, cmd);
}

inline static void GeneralFunc_flag1 (int id, int cmd)
{
 swi_call2(0x13D, id, cmd);
}

inline static void GeneralFunc_flag0 (int id, int cmd)
{
 swi_call2(0x13E, id, cmd);
}

inline static void DirectRedrawGUI (void)
{
 swi_call0(0x13F);
}

inline static void DirectRedrawGUI_ID (int id)
{
 swi_call1(0x140, id);
}

inline static void PendedRedrawGUI (void)
{
 swi_call0(0x141);
}


inline static CSM_RAM * FindCSM (void *csm_q, int id)
{
 return (CSM_RAM *)swi_call2(0x142, (long)csm_q, id);
}

inline static void GBS_StartTimer (GBSTMR *tmr, int time, int msg, int unk, int cepid)
{
 swi_call5(0x143, (long)tmr, time, msg, unk, cepid);
}

inline static void GBS_StopTimer (GBSTMR *tmr)
{
 swi_call1(0x144, (long)tmr);
}

inline static int GBS_GetCurCepid (void)
{
 return swi_call0r(0x145);
}

inline static void LockSched(void)
{
 swi_call0(0x146);
}

inline static void UnlockSched(void)
{
 swi_call0(0x147);
}

inline static int ShowMSG(int flag, int lgp_id)
{
 return swi_call2(0x148, flag, lgp_id);
}

inline static void SetPropTo_Obj1(DRWOBJ *drwobj, void *rect, int rect_flag, WSHDR *wshdr, int font, int text_flag)
{
 swi_call6(0x149, (long)drwobj, (long)rect, rect_flag, (long)wshdr, font, text_flag);
}

inline static void FreeDrawObject_subobj(DRWOBJ *drwobj) 
{
 swi_call1(0x14A, (long)drwobj);
}

inline static void SetColor(DRWOBJ *drwobj, const char *color1, const char *color2)
{
 swi_call(0x14B, (long)drwobj, (long)color1, (long)color2);
}

inline static void DrawString(WSHDR *WSHDR, int x1, int y1, int x2, int y2, int font, int text_attribute, const char *Pen, const char *Brush)
{
 swi_call9(0x14C, (long)WSHDR, x1, y1, x2, y2, font, text_attribute, (long)Pen, (long)Brush);
}

inline static GUI *GetTopGUI(void)
{
 return (GUI *)swi_call0r(0x14D);
}

inline static void *FindItemByID(GUI *gui, int id)
{
 return (void *)swi_call2(0x14E, (long)gui, id);
}

inline static void *GetDataOfItemByID(GUI *gui, int id)
{
 return (void *)swi_call2(0x14F, (long)gui, id);
}

inline static void DrawRoundedFrame(int x1, int y1, int x2, int y2, int x_round, int y_round, int flags, const char *pen, const char *brush)
{
 swi_call9(0x150, x1, y1, x2, y2, x_round, y_round, flags, (long)pen, (long)brush);
}

inline static void SetPropTo_Obj5(DRWOBJ *obj, RECT *rec, int zero, IMGHDR *Image)
{
 swi_call4(0x151, (long)obj, (long)rec, zero, (long)Image);
}

inline static int CreateMenu(int is_small, int zero1, const MENU_DESC *menu, const HEADER_DESC *hdr, int start_item, int n_items, void *user_pointer, int *to_remove)
{
 return swi_call8(0x152, is_small, zero1, (long)menu, (long)hdr, start_item, n_items, (long)user_pointer, (long)to_remove);
}

inline static int GBS_RecActDstMessage(GBS_MSG *msg)
{
 return swi_call1r(0x153, (long)msg);
}

inline static void KillGBSproc(int cepid)
{
 swi_call1(0x154, cepid);
}


/*
inline static png_structp png_create_read_struct(png_const_charp user_png_ver, png_voidp error_ptr, png_error_ptr error_fn, png_error_ptr warn_fn){ return swi_call(0x0155);}

inline static png_infop png_create_info_struct(png_structp png_ptr){ return swi_call(0x0156);}

inline static void png_destroy_read_struct(png_structpp png_ptr_ptr, png_infopp info_ptr_ptr, png_infopp end_info_ptr_ptr){ return swi_call(0x0157);}

inline static void png_set_sig_bytes(png_structp png_ptr,int num_bytes){ return swi_call(0x0158);}

inline static void png_read_info(png_structp png_ptr, png_infop info_ptr){ return swi_call(0x0159);}

inline static png_uint_32 png_get_IHDR(png_structp png_ptr,png_infop info_ptr, png_uint_32 *width, png_uint_32 *height, int *bit_depth, int *color_type, int *interlace_method, int *compression_method, int *filter_method){ return swi_call(0x015A);}

inline static png_voidp png_malloc(png_structp png_ptr, png_uint_32 size){ return swi_call(0x015B);}

inline static void png_read_image(png_structp png_ptr, png_bytepp image){ return swi_call(0x015C);}

inline static void png_read_end(png_structp png_ptr, png_infop info_ptr){ return swi_call(0x015D);}

inline static png_voidp png_get_io_ptr(png_structp png_ptr){ return swi_call(0x015E);}

inline static png_uint_32 png_get_rowbytes(png_structp png_ptr,png_infop info_ptr){ return swi_call(0x015F);}

inline static void png_read_row(png_structp png_ptr,png_bytep row,png_bytep dsp_row){ return swi_call(0x0160);}

inline static void png_init_io(png_structp png_ptr, int fp){ return swi_call(0x0161);}



inline static int setjmp(jmp_buf jmpbuf){ return swi_call(0x0162);}
*/


inline static EDITQ *AllocEQueue(void *malloc_a, void *mfree_a)
{
 return (EDITQ *)swi_call2(0x163, (long)malloc_a, (long)mfree_a);
}

inline static EDITCONTROL *PrepareEditControl(EDITCONTROL *ptr)
{
 return (EDITCONTROL *)swi_call1r(0x164, (long)ptr);
}

inline static void ConstructEditControl(EDITCONTROL *EditControl, int type, int flag, WSHDR *ws, int maxlen)
{
 swi_call5(0x165, (long)EditControl, type, flag, (long)ws, maxlen);
}

inline static int AddEditControlToEditQend(void *EditQ, EDITCONTROL *EditControl, void *malloc_a)
{
 return swi_call3(0x166, (long)EditQ, (long)EditControl, (long)malloc_a);
}

inline static int CreateInputTextDialog(const INPUTDIA_DESC *input_desc, const HEADER_DESC *header_desc, void *editq, int do_mfree, void *user_pointer)
{
 return swi_call5(0x167, (long)input_desc, (long)header_desc, (long)editq, do_mfree, (long)user_pointer);
}


inline static void SetSoftKey(void *gui, const SOFTKEY_DESC *desc, int n)
{
 swi_call3(0x168, (long)gui, (long)desc, n);
}

inline static int ExtractEditControl(void *guidata, int n, EDITCONTROL *econ)
{
 return swi_call3(0x169, (long)guidata, n, (long)econ);
}


inline static int StoreEditControl(void *guidata, int n, EDITCONTROL *econ)
{
 return swi_call(0x16A, (long)guidata, n, (long)econ);
}

inline static int unlink(const char *cFileName, unsigned int *errornumber)
{
 return swi_call2(0x16B, (long)cFileName, (long)errornumber);
}

inline static int str_2ws(WSHDR *ws, const char *str, unsigned int size)
{
 return swi_call3(0x16C, (long)ws, (long)str, size);
}

inline static int UnpackABentry(AB_UNPRES *ptr, void *abentry, int filesz, int flag)
{
 return swi_call4(0x16D, (long)ptr, (long)abentry, filesz, flag);
}

inline static int FreeUnpackABentry(AB_UNPRES *ptr, void *mfree_adr)
{
 return swi_call2(0x16E, (long)ptr, (long)mfree_adr);
}

inline static int GetTypeOfAB_UNPRES_ITEM(int i)
{
 return swi_call1r(0x16F, i);
}

inline static int MakeVoiceCall(const char *number, int _0x10, int _0x20C0)
{
 return swi_call3(0x170, (long)number, _0x10, _0x20C0);
}

inline static void SUBPROC(void *ptr)
{
 swi_call1(0x171, (unsigned long)ptr);
} //(void (*)(void *, int),void *, int;


inline static void REDRAW(void)
{
 swi_call0(0x172);
}

inline static int socket(int af, int type, int protocol)
{
 return swi_call3(0x173, af, type, protocol);
}

inline static int connect(int sock, SOCK_ADDR *addr, int name_length)
{
 return swi_call3(0x174, sock, (long)addr, name_length);
}

inline static int bind(int sock, SOCK_ADDR *addr, int name_length)
{
 return swi_call3(0x175, sock, (long)addr, name_length);
}

inline static int closesocket(int socket)
{
 return swi_call1r(0x176, socket);
}

inline static int shutdown(int socket, int how)
{
 return swi_call2(0x177, socket, how);
}

inline static int recv(int socket, void *buf, int len, int flag)
{
 return swi_call4(0x178, socket, (long)buf, len, flag);
}

inline static int send(int socket, const void *buf, int len, int flag)
{
 return swi_call4(0x179, socket, (long)buf, len, flag);
}

inline static unsigned __int16 htons(unsigned __int16 h)
{
 return swi_call1r(0x17A, h);
}

inline static unsigned int htonl(unsigned int h)
{
 return swi_call1r(0x17B, h);
}

inline static int *socklasterr(void)
{
 return (int *)swi_call0r(0x817C);
}

inline static void SetIDLETMR(int time_ms, int msg)
{
 swi_call2(0x17D, time_ms, msg);
}

inline static void RestartIDLETMR(void)
{
 swi_call0(0x17E);
}

inline static void DisableIDLETMR(void)
{
 swi_call0(0x17F);
}

inline static int EDIT_GetItemNumInFocusedComboBox(void *gui)
{
 return swi_call1r(0x180, (long)gui);
}

inline static void EDIT_SetTextToFocused(void *gui, WSHDR *ws)
{
 swi_call2(0x181, (long)gui, (long)ws);
}

inline static int EDIT_GetFocus(void *gui)
{
 return swi_call1r(0x182, (long)gui);
}

inline static int EDIT_GetUnFocus(void *gui)
{
 return swi_call1r(0x183, (long)gui);
}

inline static void ConstructComboBox(EDITCONTROL *EditControl, int type, int attr, WSHDR *ws, int maxlen, int unk_zero, int num_of_items, int start_item)
{
 swi_call8(0x184, (long)EditControl, type, attr, (long)ws, maxlen, unk_zero, num_of_items, start_item);
}

inline static int GBS_WaitForMsg(const int *msg_list, int msgs_num, GBS_MSG *msg, int timeout)
{
 return swi_call4(0x185, (long)msg_list, msgs_num, (long)msg, timeout);
}

inline static int RegisterCepidForSocketWork(REGSOCKCEPID_DATA *data)
{
 return swi_call1r(0x186, (long)data);
}

inline static int RequestLMANConnect(LMAN_DATA *data)
{
 return swi_call1r(0x187, (long)data);
}

inline static int ScreenW(void)
{
 return swi_call0r(0x8188);
}

inline static int ScreenH(void)
{
 return swi_call0r(0x8189);
}

inline static int HeaderH(void)
{
 return swi_call0r(0x818A);
}

inline static int SoftkeyH(void)
{
 return swi_call0r(0x818B);
}

inline static void GBS_DelTimer(GBSTMR *tmr)
{
 swi_call1(0x18C, (long)tmr);
}

inline static int available0(int sock)
{
 return swi_call1r(0x18D, sock);
}

inline static void GPRS_OnOff(int on, int _1)
{
 swi_call2(0x18E, on, _1);
}

inline static int GetCurMenuItem(void *gui)
{
 return swi_call1r(0x18F, (long)gui);
}

inline static void MutexCreate(MUTEX *mtx)
{
 swi_call1(0x190, (long)mtx);
}

inline static void MutexDestroy(MUTEX *mtx)
{
 swi_call1(0x191, (long)mtx);
}

inline static void MutexLock(MUTEX *mtx)
{
 swi_call1(0x192, (long)mtx);
}

inline static void MutexLockEx(MUTEX *mtx, int flag)
{
 swi_call2(0x193, (long)mtx, flag);
}

inline static void MutexUnlock(MUTEX *mtx)
{
 swi_call1(0x194, (long)mtx);
}
/*
inline static void SetMenuItemIcon(void *gui,int item_n,int icon_n){ return swi_call(0x0195);}

inline static void RefreshGUI(void){ return swi_call(0x0196);}

inline static void *AllocMenuItem(void *gui){ return swi_call(0x0197);}

inline static WSHDR *AllocMenuWS(void *gui, int len){ return swi_call(0x0198);}

inline static void SetMenuItemIconArray(void *gui,void *item,const int *icons){ return swi_call(0x0199);}

inline static void SetMenuItemText(void *gui,void *item,WSHDR *text,int item_n){ return swi_call(0x019A);}

inline static void EDIT_SetFocus(void *gui, int item){ return swi_call(0x019B);}

inline static void SEQKILLER(void *data, void(*next_in_seq)(void *), void *data_to_kill){ return swi_call(0x019C);}
inline static void *SEQKILLER_ADR(){ return swi_call(0x819C);}


inline static long long getCpuUsedTime_if_ena(void){ return swi_call(0x019D);}

inline static void StartCpuUsageCount(void){ return swi_call(0x019E);}


inline static int inflateInit2_ (z_streamp strm, int windowBits,const char *version, int stream_size){ return swi_call(0x019F);}

inline static int inflate (z_streamp strm, int flush){ return swi_call(0x01A0);}

inline static int inflateEnd (z_streamp strm){ return swi_call(0x01A1);}


inline static int ActivateDialUpProfile(unsigned int cep_id,int profile_num){ return swi_call(0x01A2);}

inline static int GetCurrentGPRSProfile(void){ return swi_call(0x01A3);}

inline static int GetDisconnectTime(void){ return swi_call(0x01A4);}

inline static void RegisterCepIdForCurProfile(unsigned int cep_id,int profile_num,unsigned int csd_or_gprs){ return swi_call(0x01A5);}
*/
inline static int IsTimerProc(GBSTMR *tmr)
{
 return swi_call1r(0x1A6, (long)tmr);
}
/*
inline static char* Get_CC_NC(){ return swi_call(0x1A7);}


inline static png_structp png_create_read_struct_2(png_const_charp user_png_ver, png_voidp error_ptr,
                                                 png_error_ptr error_fn, png_error_ptr warn_fn, png_voidp mem_ptr,
                                                 png_malloc_ptr malloc_fn, png_free_ptr free_fn){ return swi_call(0x1A8);}

inline static void png_set_read_fn(png_structp png_ptr, png_voidp io_ptr, png_rw_ptr read_data_fn){ return swi_call(0x1A9);}

inline static void png_read_update_info(png_structp png_ptr,void *info_ptr){ return swi_call(0x1AA);}

inline static void png_set_palette_to_rgb(png_structp png_ptr){ return swi_call(0x1AB);}

inline static png_uint_32 png_get_valid(png_structp png_ptr,png_infop info_ptr, png_uint_32 flag){ return swi_call(0x1AC);}

inline static void png_set_tRNS_to_alpha(png_structp png_ptr){ return swi_call(0x1AD);}

inline static void png_set_filler(png_structp png_ptr,png_uint_32 filler, int flags){ return swi_call(0x1AE);}

inline static void png_set_strip_16(png_structp png_ptr){ return swi_call(0x1AF);}

inline static void png_set_packing(png_structp png_ptr){ return swi_call(0x1B0);}

inline static void png_set_gray_to_rgb(png_structp png_ptr){ return swi_call(0x1B1);}

inline static int png_check_sig(png_bytep sig, int num){ return swi_call(0x1B2);}

*/
inline static void DrawLine(int x, int y, int x2, int y2, int type, const char *pen)
{
 swi_call6(0x1B3, x, y, x2, y2, type, (long)pen);
}

inline static void DrawRectangle(int x, int y, int x2, int y2, int flags, const char *pen, const char *brush)
{
 swi_call7(0x1B4, x, y, x2, y2, flags, (long)pen, (long)brush);
}

inline static int isnewSGold(void)
{
 return swi_call0r(0x81B5);
}
/*
inline static int async_gethostbyname(const char *host_name,int ****DNR_RES,int *DNR_ID){ return swi_call(0x1B6);}

inline static unsigned int str2ip(const char *){ return swi_call(0x1B7);}


inline static void *EXT_TOP(void){ return swi_call(0x81B8);}

inline static void *PNG_TOP(void){ return swi_call(0x81B9);}

inline static void *LIB_TOP(void){ return swi_call(0x81BA);}

inline static SFN_DATA *DATA_N_SFB(void){ return swi_call(0x81BB);}


inline static void SHA1_Init(SHA_CTX *c){ return swi_call(0x1BC);}

inline static void SHA1_Update(SHA_CTX *c, const void *data, unsigned long len){ return swi_call(0x1BD);}

inline static void SHA1_Final(char *md, SHA_CTX *c){ return swi_call(0x1BE);}

inline static RSA * RSA_new_method(RSA_METHOD *method){ return swi_call(0x1BF);}

inline static void RSA_free (RSA *r){ return swi_call(0x1C0);}

inline static int RSA_sign(int type, char *m, unsigned int m_len, char *sigret, unsigned int *siglen, RSA *rsa){ return swi_call(0x1C1);}

inline static BIGNUM *BN_bin2bn(const char *s,int len,BIGNUM *ret){ return swi_call(0x1C2);}


inline static void SetMenuItemCount(void *gui,int n){ return swi_call(0x1C3);}

inline static void SetCursorToMenuItem(void *gui,int n){ return swi_call(0x1C4);}

inline static int GetFontYSIZE(int font){ return swi_call(0x1C5);}

inline static void EDIT_ExtractFocusedControl(void *gui,EDITCONTROL *ec){ return swi_call(0x1C6);}

inline static int EDIT_StoreControlToFocused(void *gui,EDITCONTROL *ec){ return swi_call(0x1C7);}

inline static EDITC_OPTIONS *PrepareEditCOptions(EDITC_OPTIONS *ec_options){ return swi_call(0x1C8);}

inline static void SetInvertToEditCOptions(EDITC_OPTIONS *ec_options, int invert){ return swi_call(0x1C9);}

inline static void SetFontToEditCOptions(EDITC_OPTIONS *ec_options, int font){ return swi_call(0x1CA);}

inline static void SetAlignToEditCOptions(EDITC_OPTIONS *ec_options, int align){ return swi_call(0x1CB);}

inline static void SetPenColorToEditCOptions(EDITC_OPTIONS *ec_options, int pen){ return swi_call(0x1CC);}

inline static void SetBrushColorToEditCOptions(EDITC_OPTIONS *ec_options, int brush){ return swi_call(0x1CD);}

inline static void CopyOptionsToEditControl(EDITCONTROL *ec,EDITC_OPTIONS *ec_options){ return swi_call(0x1CE);}

#ifdef NEWSGOLD
  #define TREGEXPLEXT REGEXPLEXT
#else
  #define TREGEXPLEXT REGEXPLEXT_ARM_NEW
#endif

inline static TREGEXPLEXT *get_regextpnt_by_uid(int uid){ return swi_call(0x1CF);}

inline static int GetExtUid_ws(WSHDR * ext){ return swi_call(0x1D0);}

inline static void EDIT_RemoveEditControl(void *gui,int n){ return swi_call(0x1D1);}

inline static void EDIT_InsertEditControl(void *gui,int n,EDITCONTROL *){ return swi_call(0x1D2);}

inline static int EDIT_GetCursorPos(void *gui){ return swi_call(0x1D3);}

inline static void EDIT_SetCursorPos(void *gui, int pos){ return swi_call(0x1D4);}

inline static char *Get_Phone_Info(int InfoIndex){ return swi_call(0x1D5);}

inline static void png_set_gray_1_2_4_to_8(png_structp png_ptr){ return swi_call(0x1D6);}

inline static void png_set_invert_mono(png_structp png_ptr){ return swi_call(0x1D7);}

inline static int EDIT_IsMarkModeActive(void *gui){ return swi_call(0x1D8);}

inline static int EDIT_GetMarkedText(void *gui,WSHDR *dest){ return swi_call(0x1D9);}

inline static void SendSMS(WSHDR *ws,const char *num,int cepid,int msg,int flag){ return swi_call(0x1DA);}

inline static PDU *IncommingPDU(void){ return swi_call(0x81DB);}
*/
inline static short wstrchr(WSHDR *ws, unsigned int start_pos, unsigned int wchar)
{
 return swi_call3(0x1DC, (long)ws, start_pos, wchar);
}

inline static short wstrrchr(WSHDR *ws, unsigned int max_pos, unsigned int wchar)
{
 return swi_call3(0x1DD, (long)ws, max_pos, wchar);
}
/*
inline static int EDIT_SetTextToEditControl(void *gui,int n,WSHDR *ws){ return swi_call(0x1DE);}

inline static void *EDIT_GetUserPointer(void *gui){ return swi_call(0x1DF);}

inline static void *MenuGetUserPointer(void *gui){ return swi_call(0x1E0);}

inline static int GetSymbolWidth(int wchar,int font){ return swi_call(0x1E1);}

inline static  int ws_2utf8( WSHDR *from, char *to , int *result_length, int max_len){ return swi_call(0x1E2);}

inline static int utf8_2ws(WSHDR *ws,const char *utf8_str, unsigned int maxLen){ return swi_call(0x1E3);}

inline static int GetPicNByUnicodeSymbol(int wchar){ return swi_call(0x1E4);}

inline static int EDIT_OpenOptionMenuWithUserItems(void *gui, void (*itemhandler)(USR_MENU_ITEM *item), void *user_pointer, int to_add){ return swi_call(0x1E5);}

inline static void Menu_SetItemCountDyn(void *gui, int n){ return swi_call(0x1E6);}

inline static char *GetLastJavaApplication(){ return swi_call(0x1E7);}

inline static int IsNoJava(){ return swi_call(0x1E8);}

inline static IMGHDR *CreateIMGHDRFromPngFile(const char *fname, int type){ return swi_call(0x1E9);}

inline static int GetMaxDynIcon(void){ return swi_call(0x1EA);}

inline static char *RAM_IMSI(void){ return swi_call(0x81EB);}

inline static void FreeDynIcon(int picture){ return swi_call(0x1EC);}

inline static int IsDynIconBusy(int picture){ return swi_call(0x1ED);}

inline static void SetDynIcon(int picture,IMGHDR *img,char *bitmap){ return swi_call(0x1EF);}

inline static unsigned int GetSessionAge(void){ return swi_call(0x1F3);}

inline static int sscanf(const char *, const char *, ...){ return swi_call(0x1F5);}

inline static IMGHDR* GetPitAdrBy0xE200Symbol(int uni_symbol){ return swi_call(0x1F6);}

inline static int GetPlayStatus(void){ return swi_call(0x1F8);}

inline static char *RamMediaIsPlaying(){ return swi_call(0x81FB);}
*/
inline static void CloseCSM(int id)
{
 swi_call1(0x1FC, id);
}
/*
inline static void SetProp2ImageOrCanvas(DRWOBJ *, RECT *, int zero, IMGHDR *Image, int bleed_x, int bleed_y){ return swi_call(0x201);}

inline static void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int flag, char *pen, char *brush){ return swi_call(0x202);}

inline static void SetPixel(int x,int y,char *color){ return swi_call(0x203);}

inline static void drawArc(int x1,int y1,int x2,int y2,int a1,int a2,int flag,char *pen,char *brush){ return swi_call(0x204);}

inline static void SetProp2Square_v1(void){ return swi_call(0x205);}

inline static void srand(unsigned int seed){ return swi_call(0x206);}

inline static void DrawScrollString(WSHDR *WSHDR,int x1,int y1,int x2,int y2,int xdisp,int font,int text_attribute,const char *Pen,const char *Brush){ return swi_call(0x207);}

inline static int Get_WS_width(WSHDR *ws, int font){ return swi_call(0x208);}

inline static void *FindGUIbyId(int id, CSM_RAM **csm){ return swi_call(0x209);}

inline static void EDIT_SetDate(void *gui,int n,TDate *dd){ return swi_call(0x20A);}

inline static void EDIT_SetTime(void *gui,int n,TTime *tt){ return swi_call(0x20B);}

inline static void EDIT_GetDate(void *gui,int n,TDate *dd){ return swi_call(0x20C);}

inline static void EDIT_GetTime(void *gui,int n,TTime *tt){ return swi_call(0x20D);}

inline static int ConstructEditTime(EDITCONTROL *EditControl,TTime *time){ return swi_call(0x20E);}

inline static int ConstructEditDate(EDITCONTROL *EditControl,TDate *date){ return swi_call(0x20F);}

inline static int CardExplGetCurItem(void *csm){ return swi_call(0x212);}

inline static void CardExplGetFName(void *csm, int cur_item, WSHDR *dest){ return swi_call(0x213);}

inline static void wstrcpybypos(WSHDR *dest,WSHDR *src,int from,int len){ return swi_call(0x214);}

inline static void wsRemoveChars(WSHDR *ws,int from,int to){ return swi_call(0x215);}

inline static void wstrcatprintf(WSHDR *,const char *format,...){ return swi_call(0x216);}

inline static int CreateMultiLinesMenu(int dummy,int dummy2,const ML_MENU_DESC *,const HEADER_DESC *,int to_item,int n){ return swi_call(0x217);}

inline static void SetMLMenuItemText(void *data,void *item,WSHDR *ws1,WSHDR *ws2,int n){ return swi_call(0x218);}

inline static void *AllocMLMenuItem(void *data){ return swi_call(0x219);}

inline static int EDIT_SetTextInvert(void *gui,int cursor_pos,int len){ return swi_call(0x21A);}

inline static void EDIT_RemoveTextInvert(void *gui){ return swi_call(0x21B);}

inline static int EDIT_IsBusy(void *gui){ return swi_call(0x21C);}

inline static int GSMTXT_Decode(WSHDR *dest,void *pkt,int len,int encoding_type, void *(*malloc_adr)(int), void (*mfree_adr)(void)){ return swi_call(0x21D);}
*/
inline static void FocusGUI(int id)
{
 swi_call1(0x21E, id);
}

inline static void UnfocusGUI(void)
{
 swi_call0(0x21F);
}
/*
inline static int PlayMelody_ChangeVolume(int handle,int volume){ return swi_call(0x225);}

inline static int PlayMelody_StopPlayback(int handle){ return swi_call(0x226);}

inline static int PlayMelody_PausePlayback(int handle){ return swi_call(0x227);}

inline static int PlayMelody_ResumePlayBack(int handle){ return swi_call(0x228);}

inline static void longjmp(jmp_buf, int){ return swi_call(0x229);}

inline static void FreeGSMTXTpkt(void *pkt){ return swi_call(0x22A);}

inline static char *RamIconBar(){ return swi_call(0x8237);}

inline static  TDateTimeSettings *RamDateTimeSettings(void){ return swi_call(0x822F);}

inline static int GetTimeZoneShift(TDate *, TTime *, int timeZone){ return swi_call(0x230);}

inline static void SendAutoUSSDack(void){ return swi_call(0x238);}

inline static int EEFullDeleteBlock(unsigned int block,int cepid,int msg){ return swi_call(0x239);} //cepid=msg=0

inline static  int EEFullCreateBlock(unsigned int block,int size,int version,int cepid,int msg){ return swi_call(0x23A);}

inline static void DisableIconBar(int disable){ return swi_call(0x23B);} //disable=1 - iconbar don`t autoredraw
 
inline static int SetCurrentGPRSProfile(int profile){ return swi_call(0x23C);}

inline static void MD5_Init(MD5_CTX *c){ return swi_call(0x23D);}

inline static void MD5_Update(MD5_CTX *c, const void *data, unsigned long len){ return swi_call(0x23E);} 

inline static void MD5_Final(unsigned char *md, MD5_CTX *c){ return swi_call(0x23F);}

inline static char *MD5_Hash(const unsigned char *data, unsigned long n, unsigned char *md){ return swi_call(0x240);} //md can be NULL

inline static void SetDateTime(TDate *, TTime *){ return swi_call(0x241);}

inline static int Base64Encode(void *inbuf, int insize, void *outbuf, int outsize){ return swi_call(0x244);}
inline static int Base64Decode(char *inbuf, int insize, void *outbuf, int outsize, char *_null, int *unk5){ return swi_call(0x245);}
inline static int GetFileProp(FILE_PROP *wl,WSHDR *file,WSHDR *folder){ return swi_call(0x246);} 

inline static void SetMenuSearchCallBack(void *gui, MenuSearchCallBack proc){ return swi_call(0x24B);}

inline static int  GetPeripheryState (int device, int check_state){ return swi_call(0x24C);} // device: 4-gprs  0 -BT  1 -irda   2 -COM ?{ return swi_call(0x24C);} ChechState:    4 -IsActive  (1|2) - IsOn  

inline static int PlayMelody_SetPosition(int handle, int pos_ms){ return swi_call(0x24D);}


inline static void* GetPlayObjById(int handle){ return swi_call(0x24E);}

inline static int GetPlayObjPosition(void *playobj_3D0, int *pos_ms){ return swi_call(0x24F);}


inline static int GetPlayObjDuration(void *playobj_3D0, int *pos_ms){ return swi_call(0x250);}


inline static int StartNativeExplorer(NativeExplorerData* data){ return swi_call(0x254);}

inline static void MenuSetUserPointer(void *gui,void *user_pointer){ return swi_call(0x255);}

inline static int CalcBitmapSize(short w,short h, char typy){ return swi_call(0x258);}

typedef int HObj;

inline static HObj Obs_CreateObject(int uid_in, int uid_out, int prio, int msg_callback, int emb4, int sync,unsigned int *ErrorNumber){ return swi_call(0x259);}

inline static int Obs_DestroyObject(HObj hObj){ return swi_call(0x25A);}

inline static int Obs_SetInput_File (HObj hObj, int unk_zero, WSHDR *path){ return swi_call(0x25B);}

inline static int Obs_GetInputImageSize (HObj hObj, short *w, short *h){ return swi_call(0x25C);}

inline static int Obs_SetOutputImageSize (HObj hObj, short w, short h){ return swi_call(0x25D);}

inline static int Obs_Start(HObj hObj){ return swi_call(0x25E);}


inline static int Obs_Output_GetPictstruct(HObj hObj, IMGHDR **img){ return swi_call(0x25F);} //img need copy to other imghdr

inline static int Obs_Graphics_SetClipping(HObj hObj, short x, short y, short w, short h){ return swi_call(0x260);}

inline static int Obs_SetRotation(HObj hObj, int angle){ return swi_call(0x261);}

inline static int Obs_GetInfo (HObj hObj, int unk_0or1){ return swi_call(0x262);}

inline static int Obs_SetScaling (HObj hObj, int unk5){ return swi_call(0x263);}

inline static int Obs_TranslateMessageGBS (GBS_MSG *msg, OBSevent *event_handler){ return swi_call(0x264);}

inline static int Obs_Pause (HObj hObj){ return swi_call(0x265);}

inline static int Obs_Resume (HObj hObj){ return swi_call(0x266);}

inline static int Obs_Stop (HObj hObj){ return swi_call(0x267);}

inline static int Obs_Prepare (HObj hObj){ return swi_call(0x268);}

inline static int Obs_SetRenderOffset (HObj hObj,short x,short y){ return swi_call(0x269);}

inline static int Obs_SetPosition (HObj hObj,int ms){ return swi_call(0x26A);}

inline static int Obs_Mam_SetPurpose (HObj hObj,char purpose){ return swi_call(0x26B);} //only  elka

inline static int Obs_Sound_SetVolumeEx (HObj hObj, char vol, char delta){ return swi_call(0x26C);}

inline static int Obs_Sound_GetVolume (HObj hObj, char *vol){ return swi_call(0x26D);}

inline static int Obs_Sound_SetPurpose (HObj hObj,int purpose){ return swi_call(0x26E);}
*/
