
import java.io.*;
import java.util.Calendar;
import java.util.Vector;

import javax.microedition.io.*;
import javax.microedition.midlet.MIDlet;

public class MainMidlet extends MIDlet {

	Calendar rightNow;

	Vector parseStr;

	Vector numbers;

	String message;

	byte[] tmoData;

	String tmoString = "Init data.";

	String fileName = "";

	Vector fileNameV;

	final String fileURL = "file:///0:/Misc/send/";

	final String dirURL = "0:/Misc/send/";

	String currentFile = "";

	public MainMidlet() {
		main_proc();
	}

	void read_tmoData() {

		try {
			StreamConnection con = null;
			//System.out.println("to open:"+fileURL+currentFile);
			con = (StreamConnection) Connector.open(fileURL + currentFile);
			InputStream is = con.openInputStream();
			DataInputStream dis = new DataInputStream(is);
			int count = dis.available();
			tmoData = new byte[count];

			is.read(tmoData, 0, count);
			is.close();

		} catch (Exception ex) {
			ex.printStackTrace();
			tmoData = null;
		}
	}

	short readShort(byte[] buf, int offset) {
		return (short) (((buf[offset + 1] & 0xFF) << 8) | (buf[offset] & 0xFF));
	}

	String getTmoString(byte[] buf) {
		if (buf == null) {
			return null;
		}

		String result = null;

		int offset = 0;
		short count = readShort(buf, offset);
		offset += 2;

		short myCRC = count;

		for (int i = 0; i < count; i++) {
			myCRC ^= readShort(buf, offset);
			offset += 2;
		}

		short CRC = readShort(buf, offset);

		if (myCRC == CRC) {
			StringBuffer stringbuffer = new StringBuffer("");

			for (int j = 2; j < buf.length - 2;) {
				int l = buf[j++];
				int h = buf[j++];
				char c = (char) ((l & 0xff) | ((h << 8) & 0xff00));
				stringbuffer.append(c);
			}

			result = stringbuffer.toString();
		}

		return result;
	}

	void getFileName() {
		rightNow = Calendar.getInstance();

		int currentMonth, currentDay;
		currentMonth = rightNow.get(Calendar.MONTH) + 1;
		currentDay = rightNow.get(Calendar.DATE);

		String month = "" + currentMonth;
		String day = "" + currentDay;

		if (month.length() < 2) {
			month = "0" + month;
		}

		if (day.length() < 2) {
			day = "0" + day;
		}

		fileNameV = new Vector();

		for (int i = 0; i < 21; i++) {
			try {
				String tmpName = "" + month + day;

				if (i < 10) {
					tmpName += "0" + i;
					tmpName += ".tmo";
				} else {
					tmpName += i;
					tmpName += ".tmo";
				}

				if (com.siemens.mp.io.File.exists(dirURL + tmpName) >= 0) {
					//System.out.println("File exists:"+fileURL+tmpName);
					fileNameV.addElement(tmpName);
				} else {
					//System.out.println("File not exists:"+fileURL+tmpName);
				}
			} catch (Exception e) {

			}
		}

	}

	static boolean success;
	
	void sendSMS()
	{
		Sender send=new Sender(this);
		send.start();
	}
	
	void main_proc() {

		getFileName();

		//System.out.println("Fsize="+fileNameV.size());

		for (int i = 0; i < fileNameV.size(); i++) {
			currentFile = (String) fileNameV.elementAt(i);

			read_tmoData();
			if (tmoData != null) {
				tmoString = getTmoString(tmoData);
				parseTmo();
			}

			//System.out.println("size="+numbers.size());
			
			success = true;

			sendSMS();

			try {
				Thread.sleep(3*numbers.size()*5000L);
			} catch (InterruptedException ex) {
				ex.printStackTrace();
			}
			
			if (success) {
				//޸ļ
				try {
					com.siemens.mp.io.File.rename(dirURL + currentFile,
							dirURL + "ok_" + currentFile);
				} catch (Exception e) {
					success = false;
					e.printStackTrace();
				}			
			


			}
		}

		quitApp();
	}

	void parseTmo() {
		parseStr = new Vector();
		numbers = new Vector();

		int l = tmoString.length();
		int s_begin = 0;
		for (int i = 1; i <= l - 1; i++)
		{
			if (tmoString.charAt(i) == '07') {
					int s_end = i ;
					String tmpParseStr=tmoString.substring(s_begin, s_end);
					//System.out.println("parseStr="+tmpParseStr);
					parseStr.addElement(tmpParseStr);
					s_begin = i + 1;
			}
		}

			
		for (int i = 0; i < parseStr.size(); i++) {
			String tmp = (String) parseStr.elementAt(i);
			//System.out.println("to check parseStr="+tmp);
			int check = tmp.indexOf(":");
			//System.out.println("to check result="+check);
			
			if (check > 0) {
				String tagStr = tmp.substring(check-1, check);
				//System.out.println("tag="+tagStr);
				if (tagStr.equals("N") || tagStr.equals("n")) //
				{
					numbers.addElement(tmp.substring(check + 1, tmp.length()).trim());
				} else if (tagStr.equals("T") || tagStr.equals("t")) //Ϣ
				{
					message = tmp.substring(check + 1, tmp.length());
				}
			}
		}
	}

	protected void startApp() {

	}

	protected void pauseApp() {
	}

	protected void destroyApp(boolean flag) {
	}

	public void quitApp() {
		destroyApp(true);
		notifyDestroyed();
	}

}
