// RAM-Monitor (c) benj9

#define SL65v50

#include "..\shared\x65.h"

#ifdef CX70v56
	#define _GetProfile_ (0xA08C9FE4+1)
	#define _Sprintf_ 0xA153E501
	
	#define _VarRAM_   0xA8000200 // any free RAM for the patch
	#define _CheckRAM_ 0xA80FFF00 // the RAM to analyze

//	#define _Dec2Hex_ (0xA082BE20+1)
//	#define _PlaySoundLoop_ 0xA0935CF8 
#endif

#ifdef SL65v50
	#define _GetProfile_ (0xA08CBB4C+1)
	#define _Sprintf_ (0xA1548DEC+1)
	
	#define _VarRAM_   0xA8000200 // any free RAM for the patch
	#define _CheckRAM_ 0xA80FFF00 // the RAM to analyze 
#endif


#ifdef CX70v56
	#define _GetProfile_ (0xA08D1999)
	#define _Sprintf_ 0xA1610211
	
	#define _VarRAM_   0xA8000200 // any free RAM for the patch
	#define _CheckRAM_ 0xA80FFF00 // the RAM to analyze 
#endif


struct VarRam{
	word w0; int profile, dist, offset;
};

struct CheckRam {
	byte b0, b1, b2, b3;
};

g_GetProfile GetProfile = (g_GetProfile)_GetProfile_;
//g_PlaySoundLoop PlaySoundLoop = (g_PlaySoundLoop) _PlaySoundLoop_;
f_sprintf sprintf = (f_sprintf) _Sprintf_;

void copystrtowstr(char *src, unsigned short *dest, unsigned int*count) {
	while(*src != 0) {
		*dest++ = *src++;
		*count += 1;
	}	
}


void Custom_Format(struct WString* pws) {

   struct VarRam* varRam = (struct VarRam *) _VarRAM_;
   struct CheckRam* checkRam = (struct CheckRam *) _CheckRAM_;

	unsigned int count = 1; int i=0; int j;
	unsigned short *p = pws->pstr; 
	char string[32];
	
	i=GetProfile();
	
	if (i==4) varRam->offset += varRam->dist -1 ;
	if (varRam->offset>0) {
		for (j=0;j<varRam->offset;j++) checkRam++;
	} else {
		if (varRam->offset<0) {
			for (j=0;j>varRam->offset;j--) checkRam--;
		}
	}
	
	
	if (i<4) varRam->profile=i; else
	    if (i==5) varRam->dist=2-varRam->dist; else
	      if (i==6) { 
		    switch(varRam->profile) { 
			  case (0): checkRam->b0 += varRam->dist-1; break;
			  case (1): checkRam->b1 += varRam->dist-1; 
			  			// PlaySoundLoop(checkRam->b1, 2, checkRam->b2); //play sound b2, b2 times
			 			break;
			  case (2): checkRam->b2 += varRam->dist-1; break;
			  case (3): checkRam->b3 += varRam->dist-1;
						// checkRam->b0=1-checkRam->b0; // toggle b0
						break;
		    }
	      }
	//if (varRam->w0==0)
	sprintf(string, "%x[%x,%x,%x,%x]%d", checkRam-0xA8000000, checkRam->b0,checkRam->b1,checkRam->b2,checkRam->b3, (varRam->dist)-1);
	//sprintf(string, "<%x, %x, %x, %x> <%d>", checkRam->b0,checkRam->b1,checkRam->b2,checkRam->b3, (varRam->dist)-1);

	copystrtowstr(string, &p[count], &count);
	
	*p = count-1;
	return;
}

void entryMainscreen(struct WString* pws) {
	Custom_Format(pws);
	return;
}