; OverlayInfoMux Alpha 0.3

; developing on Siemens m65v50
; (c) benj9

					AREA benj9, CODE, READONLY  

					IMPORT	mp_Bufferizer
					IMPORT	f092_GetCPUClock
					IMPORT	f093_GetCPULoad
					IMPORT	v03_RamNetRX
					IMPORT	f160_Uncicode_sprintf
					IMPORT	f161_Unicode_CopyStr2Str
					IMPORT	f162_Unicode_GetCharByPosition
					IMPORT	f077_CallAfterTimer
					IMPORT	f063_SelectColor
					
					IMPORT	f035_DrawImg
					IMPORT	f036_DrawImage2
					IMPORT	f037_DrawCanvas
					IMPORT	f038_DrawImageBW
					IMPORT	v19_ram_mainscreen_accu_icon
				
					EXPORT	e_refresh
					EXPORT	e_screen

mp_LoadPercent		EQU	3	;b
mp_RefreshTime		EQU	4	;w


					DCB		"OvlayMx03,benj9",0
					
					CODE16
					ENTRY	

; =============================================================

e_refresh			PUSH	{R6, LR}

					LDR		R0, mp_id
					BL		mp_Bufferizer							
					BEQ		refresh_nopatch
					
					LDR		R1, [R6,#mp_RefreshTime] 
					CMP		R1,#8 ; prevent overload
					BGE		refresh_do
								
refresh_nopatch		MOV		R1,#0x36 ; standard value

refresh_do			MOV		R0,R5 ; repatch
					LDR		R2, DevMenOverlayDisp
					BL		f077_CallAfterTimer
					
					POP		{R6, R7}
					ADD		R7, #4
					BX		R7


; =====================================================================

e_screen			LDR		R0, mp_id
					BL		mp_Bufferizer							
					BEQ		screen_x
					
					BL		v19_ram_mainscreen_accu_icon
					LDRH	R0,[R7]
					LDR		R7,=0xFFFF
					CMP		R0,R7
					BEQ		screen_x
					
					
					; r0=buf, r1=xl, r2=yl, r3=xr, [sp]=yr, [sp,4]=1
						

					
screen_start	    LDR		R2, [R4,#4]
					ADD     R0, SP, #0x2C
					STR     R2, [SP]
					MOV     R2, #0x73          ; y pos
					MOV     R1, #0          ; x pos
					LDR     R3, [R4]        ; window width
					LDR		R7, OverlayCanvasText_Metrics ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
					BLX		R7
										

screen_1			BL		_get_net_mode2
					STR		R0,[SP]
					
					BL		_get_net_rx
					MOV		R3, R0

					BL		_get_cpu_load
					MOV		R2, R0
					
					MOV		R1, R6 
					ADD		R1, #36
					
					MOV		R0, R5
					
					BL		f160_Uncicode_sprintf
					
					MOV     R2, #2          ;  alignement, 0=left 2=center, 4=right, 0x30=invertscreem
					STR     R2, [SP,#4]
					
					MOV     R1, #3          ;  font
					STR     R1, [SP]

					MOV     R3, R5
					MOV		R2,#0
					ADD     R1, SP, #0x2C
					ADD     R0, SP, #8
					LDR		R7, OverlayCanvasText_Text ;R0=buffer, R1=points2 general_metrics, R2=inversion?, r3=ptr2ws, SP=font, sp+4=alignement?
					BLX		R7
					
					;MOV     R0, #0
					;BL      f063_SelectColor
					
					;MOV     R5, R0
					;MOV     R0, #1
					;BL      f063_SelectColor
					
					ADD		R0, SP, #8
					ADR     R1, col_fg
					ADR     R2, col_bg
					LDR		R7, OverlayCanvasText_Color
					BLX		R7

screen_x			LDR		R7, OverlayDisplayScreen_return
					BX		R7

; ---------------------------------------------------------------------
	
	
_get_cpu_load		PUSH	{R1-R3, R7, LR}

					BL		f093_GetCPULoad

					POP		{R1-R3, R7, PC}

; ---------------------------------------------------------------------
					
_get_net_rx			PUSH	{R1-R3, R7, LR}

					BL		v03_RamNetRX
					LDRB	R0,[R7]

					POP		{R1-R3, R7, PC}
		
; ---------------------------------------------------------------------
					
_get_net_mode2		PUSH	{R1-R3, R7, LR}

					LDR		R7, ram_netmode_2
					LDRB	R0,[R7]

					POP		{R1-R3, R7, PC}
					
; =====================================================================
					

DevMenOverlayDisp			DCD		0xA08C8957

OverlayCanvasText_Metrics	DCD		0xA114A30C+1
OverlayCanvasText_Text		DCD		0xA116647C+1
OverlayCanvasText_Color		DCD		0xA1163C5A+1

OverlayDisplayScreen_return	DCD		0xA114640B

ram_netmode_2				DCD		0xA8752560

mp_id						DCD		0xCCCB	
col_fg						DCB		0,0,0xFF,0x55	
col_bg						DCB		0,0,0x2C,0x48	


					END

; =============================================================



MOV     R2, #0          ; y pos
MOV     R1, #0          ; x pos
LDR     R3, [R4]        ; window width
BL      OverlayCanvasText_Metrics ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
MOV     R1, #4          ;  font
MOV     R2, #0          ;  alignement, 0=left 2=center, 4=right, 0x30=invertscreem
STR     R1, [SP]
ADD     R1, SP, #0x2C
STR     R2, [SP,#4]
ADD     R3, R5, #0
ADD     R0, SP, #8
BL      OverlayCanvasText_Text ;R0=buffer, R1=points2 general_metrics,
;                               R2=inversion?, r3=ptr2ws, SP=font, sp+4=alignement?

MOV     R0, #0
BL      Select_Color
ADD     R5, R0, #0
MOV     R0, #1
BL      Select_Color
ADD     R1, R0, #0
ADD     R0, SP, #8
ADD     R2, R5, #0
BL      OverlayCanvasText_Color













	
start				PUSH	{R1-R3, R5, R6, LR}
					MOV		R4, R0
					
					LDR		R0, mp_id
					BL		mp_Bufferizer							
					BEQ		nopatch
					
					PUSH	{R4-R6}
					BL		f093_GetCPULoad
					POP		{R4-R6}
					
					LDRB	R7, [R6,#1] ; percent
					CMP		R0, R7
					BGE		mydisplay
					
					LDR		R1,[R4]
					MOV		R2,#0
					STRH	R2,[R1]
					B		out
					
mydisplay			;BL		v03_RamNetRX
					;MOV		R3, R5
					;LDRB	R2,[R7]
					
					
					MOV		R2, R0
					ADR		R1, format1
					MOV		R0, R4
					BL		f160_Uncicode_sprintf
											
					B		out
					
					
nopatch				MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_functions
					BLX		R7
					
out					MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_strings_graph
					BLX		R7
					
					POP		{R1-R3, R5, R6, R7}
					ADD		R7,#4
					BX		R7
						
	ALIGN
	
format1								DCB	"%03d benj9 ",0
		
; found at entrypoint
DevMenOverlayDisp_functions			DCD	0xA08C89B7
DevMenOverlayDisp_strings_graph		DCD	0xA1149673


mp_magic							DCD 0,0,0,0xB1C2D3E4
mp_id								DCD	0x0000CCCB,0,0

