; own strings in ShowMsgInR1_x
; there are some functions "ShowMsgInR1..:" that display a given language pack (LP) string.
; 
; normal usage ShowMsgInR1_x:
; R0=0 or 1. R1=string LB number

; extended usage:
; normal mode and
; R0=0 or 1. R1=address of string.

; this patch patches the call of GetLP within  ShowMsgInR1_x

; x65 M65v50 (c) benj9 

		AREA ARMex, CODE, READONLY  
            
		ENTRY						

FunctionLibrary	EQU	0xA0FC0001
		
			CODE16
		
start			PUSH	{R6-R7,LR}
				MOV		R7,R0
	
				CMP		R0,#0
				BMI		patch_string
				
				MOV		R6,#7 ; f07: GetLP
				BL		_func_lib
				B		exit
		
patch_string	MOV		R0,R1
				MOV		R1,R7
				MOV		R6,#26 ; f26: strcopy
				BL		_func_lib
				
				MOV		R1,R0
				MOV		R0,R7
		
exit			POP		{R6-R7,PC}

_func_lib		; input: R6  = func#
				PUSH	{R7,LR}
				LDR		R7,=FunctionLibrary
				LSL		R6,#3
				ADD		R7,R6
				BLX		R7
				BLX		R7	
				POP		{R7,PC}


 END      