; net blink
; x65 M65v50 (c) benj9 

		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for CX6C

TYPE	SETA	1 						

 IF  TYPE = 1


any_free_ram	EQU	0xA8250000 
Illumination	EQU	0xA0BC78B8
IsKeyUnlocked	EQU	0xA114D0A7
GetProfile		EQU	0xA08C9FE5 

repatch			EQU	0xA13103D8
_ram_netacess_	EQU	0xA1310858 ; DCD 0xA8717D4C (+4=A8717D50)
_ram_netaccess_netmode EQU 0xA132D7D0


loop_trigger_max	EQU	5
output			EQU	1
brightness		EQU 72
smoothness		EQU	7

 ENDIF


		
		CODE16

		
start		

		PUSH	{R0-R7}
		MOV		R7,LR
		
		;LDR		R4,=IsKeyUnlocked
		;BLX		R4
		;CMP		R0,#0
		;BEQ		exit
		
IsNet	
		;flight1
		;LDR		R4,=_net_ram ;Offset Net_Ram - 4 im Rom
		;LDR		R4,[R4] 
		;LDR		R4,[R4,#4] ; pointer-inhalt +4
		;MOV		R5,#1 ; R5=0x101
		;LSL		R5,#8 ; R5=0x101
		;ADD		R5,#1 ; R5=0x101
		;ADD		R4,R5 ; Inhalt von net_ram + 0x101
		;LDRB	R4,[R4]
		; +101: Reagiert auf Net-Acess, Idle: 2B
		;CMP		R4,#0x2B ; ruhiges netz
		;BEQ		exit
		
		;flight2
		;LDR		R4,=ram_netaccess ;Offset Net_Ram - 4 im Rom
		;LDR		R4,[R4] 
		;LDR		R4,[R4,#4] ; pointer-inhalt +4
		;MOV		R5,#0x94
		;ADD		R4,R5 ; Inhalt von ram_netaccess + 0x94
		;LDRB	R4,[R4]
		; +94:	05=pre-phon, 06=pho+sms, 09 gprs, 13=idle. 14=post-sms !
		;CMP		R4,#0x13 ; ruhiges netz
		;BEQ		exit
		
		;flight2-1
		LDR		R4,=_ram_netaccess_netmode 
		LDR		R4,[R4]
		LDRB	R4,[R4] 
		; 05=pre-phon, 06=pho+sms, 09 gprs, 13=idle. 14=post-sms !
		CMP		R4,#0x13 ; ruhiges netz
		BEQ		exit



		LDR		R4,=any_free_ram
		
tog12	LDR		R2,[R4,#4] ; toggle-funcnow1
		MOV		R3,#loop_trigger_max
		;LDR		R3,[R4,#0x0C] ; <loop_trigger_max>
		CMP		R2,R3 ; signal ausdnnen
		BEQ 	step	
		
		ADD		R2,R2,#1
		STR		R2,[R4,#4]  ; reset funcnow
		B 		exit
	
step	
		MOV 	R2,#1
		STR		R2,[R4,#4]	; set toggle_funcnow

       	LDR		R2,[R4] ; toggle_on/off
		MOV 	R1,#brightness 
		;LDR		R1,[R4,#0x2C] ; <brightness>
		SUB		R2,R1,R2
		STR		R2,[R4]

		
		;LDR		R0,= GetProfile
		;BLX		R0

		
light1	MOV		R0,#output ; <output>
		;LDR	R0,[R4,#0x1C]
        MOV     R1, #1
        MOV		R3,#smoothness ; <smoothness>
        ;LDR	R3,[R4,#0x3C]
        LDR		R4,=Illumination
       	BLX     R4
		B 		exit
		
exit	MOV		LR,R7
		POP		{R0-R7}
		LDR 	R7,=repatch
	 	MOV		PC,R7


        END
 
        
 sexit	POP {R0-R7}
		BL exit ; A1310560
		POP {PC}
		
		
		LDR		R2,[R4] ; toggle_on/off
		light0	MOV		R0,#1
        MOV     R1, #1
        MOV		R3,#6
        LDR		R4,=Illumination
       	BLX     R4
       	
;toggle-miss-loop-max, <output>, brightness, smoothness
;Langsamer guter Wert: 0c 01 42 09
;Schneller guter Wert:  07 01 35 09



Port-Info


RAM_NetAccessTable= netaccess_ram		

;A (10B5041C2820FFF7B7FD002141626060217010BD)+0x44
;B (99B5027A8478011C01261223002C9948994D0BD01523841C201C4968)+0x5A

M65 v50
A:A1310858 -> A8717D4C (+4 = A8717D50) -> A8752534
B->A135F208 -> A8752534 net_access_ram_table

SL65v50
A->A131A308 -> A8711A0C (+4 = A8711A10)
B->A136C03A+0x5a=->A136C094->A87490C8 net_access_ram_table

CX70v56
A->A127DCAC -> A87760EC (+4 = A87760F0)
B->A12CE93A+0x5a=A12CE994->A87B0D34 net_access_ram_table 

S65 v50
A->A13485F8 -> A872215C (+4 = A8722160)

net_access_ram_table:
+2C:  1B meistens Idle, 02 Phone, 01, 00 .
+4C:  bis SIM 0
+7C:  01 at phoning. kurz 1 bei sms. sonst 0
+94:  05=pre-phon, 06=pho+sms, 09 gprs, 13=idle. 14=post-sms !
+101: Reagiert auf Net-Acess, Idle: 2B



RAM_NetAccessTable_Netmode = RAM_NetAccessTable +94
05=pre-phon, 06=pho+sms, 09 gprs, 13=idle. 14=post-sms !
Write access to A87525C9, PC=A132D81C ; net idle
Write access to A87525C8, PC=A132D668 ; net traffic

M65v50
A132D7D0 C8 25 75 A8 _RAM_NetAccessTable_NetMode_Traffic DCD RAM_NetAccessTable_Netmode
(0022002100209999999999999999999999990C489999999900220092131C0A490B4899999999E6E7)+0x2E
A132D7D0->A87525C8

CX70v56
19539428->A87B0DC8 

SL65v50
A133907A->A874915C 