; Blinker v3.2, (c) benj9, m65v50
; blink on events



				AREA Blinker, CODE, READONLY     
				
				EXPORT	illumi32
				IMPORT	f077_CallAfterTimer
				IMPORT	v12_RamMissedMes
				IMPORT	f008_SetIllumination
				IMPORT	f081_GetNetMode
				IMPORT	z00_FreeRAM
				IMPORT	mp_Bufferizer
				IMPORT	f002_GetProfile



boot_blink_type					EQU	0x01 ; 0x99 ; 1 ; boot sfx: 0=no, 1=dynamicblinker
; see boot-setting at: fake_profile


; -----------------------------------------------------------------------------

; simplified function: master_loop is running approx 1x/sec and checks for events.
; if events found, according blink engine is started. master_loop doest run meanwhile,
; last call of blink module restarts master_loop

; entry blinker_start starts dynamic_blink_module for boot effects, that starts after ending the master_loop.
			
; NOTE: cause the functions call each other by "CallAfterTimer", they cannot communicate by Registers, only by RAM
		
; -----------------------------------------------------------------------------
		
; patch_ram usage:
; 0-7:	timer data for blinker
; 8-9:	illumination toggler
; A:	DynamicBlinker polarity
; B:	SequenceBlinker internal position / DynamicBlinker Parameter: step-divide-by
; C:	SequenceBlinker Sequence-Pattern#. 0=netlost, 1-3 missed events 1-3
; D: 	MissedEventsResult (FF if not set)
; E: 	DynamicBlinker Parameter: lo value (time, 1sec=ca-225)
; F: 	DynamicBlinker Parameter: hi value (time, 1sec=ca-225)
; 11:	DynamicBlinker Parameter: blink type
; 12:	Lock after running entryp first time
; 13:	NetBlinker wait time for next blink call. 
; 14:	IlluTogglerFlag (0)=illu is allowed, (2)=illu forbidden, (1) only if fw thinks that illumi is off
; 15:	SetIllumination-Is-Called-By-Blinker message (0=false)
; 16:	Illumination State by Law (what the firmware thinks about illumination on or off)
; 17:	permit for _set_illumination which illumination output (0=off, 1=screen only, 2=kpl only, 3=both) is generatet
; 18-1b	profile_data_base_address = masterpatch_buffer + 2 + profile# * 8
; 1c-23 timer data for stoptimer
; 10    master loop copies general blinker smoothness (parameter 1) to here

; --> shared in 0xB now: 0x10:	DynamicBlinker Parameter: step-divide-by

; -----------------------------------------------------------------------------

; masterpatch buffer: 

; profile 1:
; 2 missed events & netlost bits
; 3 net traffic bits
; 4-7 net traffic kill time
; 8 blinker brightness
; 9 keep_screen_alive_brightness

; profile 2:
; 10 =2 + 8

; profile 2:
; 18 =10 + 8

; ......

; profile 7:
; 50 

;  60 ms `master loop cycle time (ms)` v=433}","\
;  1 allow external call of blinker

; -----------------------------------------------------------------------------


				DCB	"Blinker3.2,benj9"

; ========================================================================================	
; SetIllumination Patch Entry
; ========================================================================================	

; Called by SetIllumination Entrypoint
				ENTRY
				CODE32


illumi32		STMFD	SP!,{R1-R3,R5-R6,LR} ; return is at: "illumi16_x  POP {R3,R6,PC}"
				LDR		R7, _illumi16
				BX		R7 ; switch to thumb
		


; ========================================================================================	
; Blink Sequencer Entry
; ========================================================================================
				CODE16
								
sequence_blinker PUSH	{R0-R7,LR} ; input:
				; R0=SeqBlinker sequence number (0=netlost, 1-3=missed_events, 4=auxiliary blinker)

				BL		_get_mem
				STRB	R0,[R6,#0xC] ; SeqBlinker sequence number
				BL		sequence_blinker_start
				
				POP		{R0-R7,PC}
				
		
; ========================================================================================	
; SetIllumination Patch 
; ========================================================================================	

; R0 output					; R1 allowance	->R6
; R2 brightness	->R4		; R3 delay
; R4 = R2 brightness		; R5 used
; R6 = R1 allowance			; R7 addr	

illumi16		BL		_get_mem
				LDRB	R3,[R6,#0x12] 
				CMP		R3,#0 ; first time run resp. phone off?
				BNE		illumi16_reg1
							
; ----- first start of patch -----------------------------------------


illu16_first	MOV		R3,#0xFF ; 01: FF: patch runs
				STRB	R3,[R6,#0x12] ; first time run/phone off flag
				
				MOV		R3,#boot_blink_type ; boot sfx: 0=off, 1=dynamic
				; CMP		R3,#0 ; no entry start ; ####2
				BNE		illu16_first_1
				
illu16_first_0	LDR		R2,_master
				MOV		R1,#6
				LSL		R1,#8 ; 7 seconds, ,including netblinker
				
				BL		_call_after_timer
				B		illumi16_x
				
illu16_first_1	MOV		R3,#0x1A ; make the beginning a bit before fast climax. long: 0x20, short:0x10
				STRB	R3,[R6,#9] ; illumination toggle counter DynamicBlinker
				BL		dynamic_blinker ; starts after being finished booting master :)

; ----- called by regular SetIllumination-----------------------------------------

illumi16_reg1	MOV		R2,R0

				; CMP		R2,#0 ; illumination output device 0 = screen ####3
				BNE		illumi16_x ; SetIllumination-Call is "output not screen"

				CMP		R1,#0 ; SetIllumination-Call is "no allowance"
				BEQ		illumi16_x
				
				; set ram byte with brightness content of FW calls, not of Blinker calls.
				BL		_get_mem

				LDRB	R5,[R6,#0x16] ; Illumination State by Law (what the firmware thinks about illumination on or off)

				LDRB	R3,[R6,#0x15] ; SetIllumination-Is-Called-By-Blinker message (set by Blinker-internal SetIllumination calls)
				CMP		R3,#0 
				BNE		illumi16_reg2 ;  called by Blinker
				
				STRB	R4,[R6,#0x16] ; Illumination State by Law (what the firmware thinks about illumination on or off)
				
illumi16_reg2	BL		_get_profile_codes_prep
				BEQ		illumi16_x

				CMP		R4,#0 ; brightness. 0=off.
				BEQ		illumi16__KeepScreenIllumAlive

illumi16__BlinkByIlluOn	
				ADD		R5,R3

				; CMP		R5,#0 ; IlluStateByLaw before SetIllu-Call=off AND !(called by Blinker) ####3
				BNE		illumi16_x
				
				;CMP		R3,#0 
				;BNE		illumi16_x
				
				BL		_get_accu_icon
				BEQ		illumi16_x
				
				MOV		R3,#64 ; {64 cb `flash at illuni on (output is like boot sfx)`}
				LDRB	R3,[R7,R3] ; R0=offset
				CMP		R3,#0 ; off
				BEQ		illumi16_x	
				
illumi16__BlinkByIlluOn_1
				; R0=SeqBlinker sequence number (0=netlost, 1-3=missed_events, 4=auxiliary blinker)
				MOV		R0,#4
				BL		sequence_blinker	
				
				B		illumi16_x ; SetIllumination-Call is "screen illumi on"
				
illumi16__KeepScreenIllumAlive
				LDR		R3,[R6,#0x18] ; profile_data_base_address = masterpatch_buffer + 2 + profile# * 8
				LDRB	R3,[R3,#9] ; KeepScreenIllumAlive by current profile codes
				CMP		R3,#0 ; off 
				BEQ		illumi16_x	
				
				MOV		R4,R3

illumi16_x		MOV		R0,R2
				MOV		R7,R0 ; repatch
				POP		{R1-R3,R5-R6,PC} ; return to entry	& MOV		R7,R0 ; repatch


; ========================================================================================	
; master loop
; ========================================================================================	
;dcb "_master_"
master			PUSH	{R0-R7,LR} 
				BL		_reset_illutoggler_flag
				BL		_get_profile_codes_prep
				MOV		R5,R7
				CMP		R5,#0
				BEQ		master_patrol ; masterpatch profile off
				
ma_precheck		BL		_get_blink_events_number	

				MOV		R3,R0 ; R0=calculated_missed-events-result
				BL		_get_evaluated_netmode
				MOV		R1,R0 ; R1=net-access-traffic evaluated to timer-data. 0=idle, 1,2=other channels. >2=timer data
				
ma_precheck3	BL		_get_net_online
				MOV		R2,R0 ; R2=net online (1=true)
				
				BL		_get_accu_icon ; R0=boot state (0=true)
	
ma_check		BEQ		ma_bli_net_traf

ma_boot_no		CMP		R3,#0 ; no events
				BEQ		ma_event_no 

ma_event_y		CMP		R2,#1 ; netonline
				BNE		ma_bli_event	

ma_net_online_y	CMP		R1,#0 ; netaccess_idle
				BNE		ma_bli_net_traf
				B		ma_bli_event
				
ma_event_no		CMP		R2,#1 ; netonline
				BNE		ma_bli_net_lost
				
				CMP		R1,#0 ; netaccess_idle
				BEQ		master_patrol
				
				B		ma_bli_net_traf
				
; ----------------------------------------------
		
ma_bli_event	CMP		R3,#4 ; 1 & 2 & 3 events 
				BGE		ma_bli_event1
				
				MOV		R0,R3 ; mevent type for sequence_blinker=event_blinker (R3=number of events=1v2v3)
				B		ma_bli_net_lc1
				
ma_bli_event1	MOV		R1,#1
				STRB	R1,[R6,#0x11] ; blink type
				BL		dynamic_blinker 
				B		master_x				
								
ma_bli_net_traf	BL		net_blinker_start
				B		master_x

ma_bli_net_lost	MOV		R0,#0 ; ; R0=event type for sequence_blinker=netlost
			
ma_bli_net_lc1	BL		sequence_blinker 
				B		master_x		
	
master_patrol	LDR		R1,[R5,#60] ; master loop cycle time by masterpatchbuffer
				CMP		R1,#22
				BGE		master_patrol1
				MOV		R1,#22
				
master_patrol1	LDR		R2,_master
				BL		_call_after_timer		
					
master_x		POP		{R0-R7,PC}


; ========================================================================================	
; dynamic sweeping blinker module
; ========================================================================================	

; E: DynamicBlinker lo value (time, 1sec=ca-225)
; F: DynamicBlinker hi value (time, 1sec=ca-225)
; 10:DynamicBlinker step-divide-by
; 11:DynamicBlinker Parameter: blink type

dynamic_blinker ; input ram+0x11: blink type
				PUSH 	{R0-R7,LR} 
				BL		_reset_illutoggler_flag				
				LDRB	R0,[R6,#0x11] ; blink type
				CMP		R0,#0 
				BEQ		dyn_blinker_0

dyn_blinker_1	MOV		R0,#5
				MOV		R1,#0x48
				MOV		R2,#3
				B		dyn_blinker_exe

dyn_blinker_0	MOV		R0,#4
				MOV		R1,#0x60
				MOV		R2,#4
				
dyn_blinker_exe	STRB	R0,[R6,#0xE] ; lo value
				STRB	R1,[R6,#0xF] ; hi value
				STRB	R2,[R6,#0xB] ; B:	SequenceBlinker internal position / DynamicBlinker Parameter: step-divide-by  (formerly: 0x10)

				BL		dynamic_blinker_loop
				POP		{R0-R7,PC} ; POP		{PC}

; -----------------------------------------------------------------

;dcb "_DYN_"

dynamic_blinker_loop	PUSH	{R0-R7,LR}
						MOV		R5,#0 ; zero dynamic_loop_x flag
						BL		_get_profile_codes_prep
						BEQ		dyn_master
						
						MOV		R0,#0 ; input R0: info for 0=missed events, 1=netlost/weak, 2=netblinker
						BL		_get_profile_codes_set_illu
						BL		_illumination_toggler
 		
dyn_on					LDRB	R1,[R6,#9] ; gespeicherter nchster Zeitwert
						LDRB	R2,[R6,#0xE] ; low value
						CMP		R1,R2
						BGE		dyn_on1 ; wenn kleiner als 4, Richtung umpolen

dyn_pol_pos				MOV		R2,#1
 						B		dyn_pol_str

dyn_on1					LDRB	R2,[R6,#0xF] ; hi value
						CMP		R1,R2 
						BLE		dyn_on2 ; wenn grer als startvalue, Richtung umpolen
		
dyn_pol_neg				MOV		R2,#0
						MOV		R5,#1 ; set dynamix_loop_x flag
dyn_pol_str 			STRB	R2,[R6,#0xA] ; polarity speichern
			
dyn_on2					LDRB	R2,[R6,#0xB] ; LSR-Val  (formerly 0x10)
						MOV		R7,R1
						LSR		R7,R2  
						ADD		R7,#1
						LDRB	R2,[R6,#0xA] ; polaritaet
						CMP		R2,#0 
						BNE		dyn_on_pos
		
dyn_on_neg				SUB		R1,R7
						B		dyn_on3
		
dyn_on_pos				ADD		R1,R7

dyn_on3					STRB	R1,[R6,#9]	; store current timeval

dyn_start_what			CMP		R5,#1 ; loop finished?
						BEQ		dyn_master
				
dyn_inner_ret			LDR     R2,_dynamic_blinker_loop ; loop not finished, go on
						B		dyn_exec3	
				
dyn_master				LDRB	R0,[R6,#0x17] ;  output: 0=off, 1=screen only, 2=kpl only, 3=both
						CMP		R0,#0 ; off? 
						BEQ		dyn_law
						
						BL		_get_blink_events_number
						; CMP		R0,#0 ####1
						BNE		dyn_master_ret

dyn_law					BL		_set_illumination_state_to_law
			
dyn_master_ret			LDR     R2,_master
		
dyn_exec3				BL		_call_after_timer
			
dynamic_loop_x			POP		{R0-R7,PC}	


				
; ========================================================================================	
; net-blinker module
; ========================================================================================	

net_blinker_start	PUSH	{LR}
					BL		_get_mem
					; MOV		R0,#2
					LDR		R0,[R6,#0x18] ; profile_data_base_address = masterpatch_buffer + 2 + profile# * 8
					CMP		R0,#0 ; masterpatch not active or Stoptimer in current profile =0 (off)
					BEQ		net_blinker_start_x
				
					LDR		R1,[R0,#4] ; Blinker Timestop-Netblinker
					CMP		R1,#20 ; minimum
					BLE		net_blinker_start_x
							
					ADD		R6,#0x1c ;  1c-1f timer data for stoptimer
					LDR		R2,_stoptimer_netblinker
					BL		_call_after_timer
net_blinker_start_x	BL		net_blinker
					POP		{PC}
				
; -----------------------------------------------------------------

;dcb "__NETBLI___"
net_blinker		PUSH	{LR} 
				BL		_get_profile_codes_prep
				BEQ		net_bli_mastr_r	
				
				MOV		R0,#2 ; input R0: info for 0=missed events, 1=netlost/weak, 2=netblinker
				BL		_get_profile_codes_set_illu
				BL		_get_evaluated_netmode	
				CMP		R0,#1 ; 0=net idle
				BLE		net_bli_mastr_r
				
net_bli_what	STRB	R0,[R6,#0x13] ; TimedBlinker wait time for next blink call. if zero, blinker blinks not when illu is on
				CMP		R0,#0 ;idle value
				BEQ		net_bli_mastr_r
		
				BL		_get_net_online
				MOV		R1,R0 ; R1=net online (1=true)
				BL		_get_accu_icon ; R0=boot state (0=true)
				
				LDRB	R2,[R6,#0x17] ;  output: 0=off, 1=screen only, 2=kpl only, 3=both
				CMP		R2,#0 ; off?
				BEQ		net_bli_mastr_r	
				
				CMP		R0,#0 ; if bootin, go ; (vorher: R3)                 
				BEQ		net_bli_inner_r
				
				CMP		R1,#0 ; netlost, not booting: no
				BEQ		net_bli_mastr_r
				
net_bli_inner_r	BL		_illumination_toggler

				LDR		R2,_net_blinker
				B		net_bli_go

net_bli_mastr_r	BL		_set_illumination_state_to_law
				LDR		R2,_master

net_bli_go		LDRB	R1,[R6,#0x13] ; TimedBlinker wait time for next blink call. 
				BL		_call_after_timer
					
				POP		{PC}


; ========================================================================================	
; Blink Sequencer
; ========================================================================================
;DCB "___SEQ___"

; sequence_blinker 
; input: r0=sequence number
;
; function at start 

; -----------------------------------------------------------------
sequence_blinker_start
				PUSH	{LR}
				BL		_reset_illutoggler_flag

				MOV		R1,#0
				STRB	R1,[R6,#0xB] ; SeqBlinkerPosition - internally used
				
				LDRB	R1,[R6,#0x16] ; Illumination State by Law (what the firmware thinks about illumination on or off)
				CMP		R1,#0
				BEQ		sequence_blinker_start_str
				MOV		R1,#0xFF
sequence_blinker_start_str
				STRB	R1,[R6,#8] ; illutoggler value
				BL		sequence_blinker_loop
				
sequence_blinker_start_x
				POP	{PC}
				
; -----------------------------------------------------------------


sequence_blinker_loop
				PUSH	{LR}
				BL		_get_profile_codes_prep
				BEQ		sequence_blinker_loop_outer_return_master
				
				LDRB	R1,[R6,#0xC] ; SeqBlinker Sequence#
				MOV		R3,#8 ; length of sequence record
				MUL		R3,R1
				CMP		R1,#0
				BEQ		sequence_blinker_loop_select_netlost
				
				CMP		R1,#4
				BEQ		sequence_blinker_loop_select_special
				
sequence_blinker_loop_select_mevents
				MOV		R0,#0	; mevents			
				B		sequence_blinker_loop_select_x
				
sequence_blinker_loop_select_netlost
				MOV		R0,#1 ; netlost
				B		sequence_blinker_loop_select_x

sequence_blinker_loop_select_special
				MOV		R0,#3 ; special

sequence_blinker_loop_select_x
				BL		_get_profile_codes_set_illu
				BL		_illumination_toggler

				LDRB	R0,[R6,#0xB] ; SeqBlinkerPosition
				ADR		R2,sequence_blinker_data
				ADD		R3,R2
				
				CMP		R0,#5 ; max_sequence_elements ; sequence ended cause max number of elements reached
				BGE		sequence_blinker_loop_outer_return
				
				ADD		R2,R0,#2
				
				LDRB	R1,[R3,R2] ; R2=(R0+1)th element of sequence address R3
				CMP		R1,#0 ; element zero -> sequence finished
				BEQ		sequence_blinker_loop_outer_return
				
sequence_blinker_loop_inner_return
				ADD		R0,#1 ; increase element counter
				STRB	R0,[R6,#0xB] ; NumberBlinker Remainder/SeqBlinkerPosition
				LDR		R2,_sequence_blinker_loop
				BL		_call_after_timer 
				B		sequence_blinker_loop_x

sequence_blinker_loop_outer_return
				BL		sequence_blinker_decision
				CMP		R0,#1 ; situation changed
				BEQ		sequence_blinker_loop_outer_return_master
				
				LDR		R2,_sequence_blinker_start
				B		sequence_blinker_loop_outer_return_exe
				
sequence_blinker_loop_outer_return_master
				BL		_set_illumination_state_to_law
				LDR		R2,_master	

sequence_blinker_loop_outer_return_exe
				LDRH	R1,[R3]
				BL		_call_after_timer 
						
sequence_blinker_loop_x
				POP		{PC}

; -----------------------------------------------------------------
;DCB "__DECISION__"
sequence_blinker_decision		PUSH	{R1-R5,LR}

								LDRB	R1,[R6,#0x0C] ; R1=sequence# (to decide which event type causes the call of this func)
								
								CMP		R1,#4 ; seq 4 (special, far called sequence)
								BEQ		sequence_blinker_decision_y ; play only one time, but with all rights
								
								LDRB	R0,[R6,#0x17] ;  output: 0=off, 1=screen only, 2=kpl only, 3=both
								CMP		R0,#0 ; off?
								BEQ		sequence_blinker_decision_y
							
								CMP		R1,#0 ; seq 0 (net lost caused)
								BEQ		sequence_blinker_decision_0
								
								; else seq 1-3 (number of events 1-3 caused)
								
sequence_blinker_decision_1_3 	BL		_get_evaluated_netmode
								CMP		R0,#2 ; 0=net traffic idle, 1=net traffic weak but idle (only available if netmode2-method used, otherwise event ignored)
								BGE		sequence_blinker_decision_y
								
								BL		_get_blink_events_number
								STRB	R0,[R6,#0xC] ; SeqBlinker sequence number 
								CMP		R0,#0 ;  ####1
								BEQ		sequence_blinker_decision_y
								CMP		R0,#4
								BGE		sequence_blinker_decision_y
								B		sequence_blinker_decision_n

sequence_blinker_decision_0		BL		_get_blink_events_number 
								; CMP		R0,#0 ####1
								BNE		sequence_blinker_decision_y
								
								BL		_get_net_online
								CMP		R0,#0
								BEQ		sequence_blinker_decision_n
	
sequence_blinker_decision_y		MOV		R0,#1
								B		sequence_blinker_decision_x
								
sequence_blinker_decision_n		MOV		R0,#0
				
sequence_blinker_decision_x		POP		{R1-R5,PC} ; output: R0=0: no reason to leave. 1=situation changed, leave.

; ----------------------------------------------------------------------

stoptimer_netblinker			PUSH	{LR}
								BL		_get_mem
								BL		_set_illumination_state_to_law
								MOV		R1,#2
								BL		_store_illutoggler_flag	
								POP		{PC}
								
; ----------------------------------------------------------------------
	

_illumi16						DCD		illumi16
_master							DCD		master
_dynamic_blinker_loop			DCD		dynamic_blinker_loop
_net_blinker					DCD		net_blinker
_sequence_blinker_loop			DCD		sequence_blinker_loop
_sequence_blinker_start			DCD		sequence_blinker_start
_stoptimer_netblinker			DCD		stoptimer_netblinker

; ========================================================================================	
; auxiliary functions
; ========================================================================================	

; DCB "___CAT___"
_call_after_timer	PUSH	{LR}
					CMP		R1,#4
					BGE		_call_after_timer_x
					
					MOV		R1,#4
					
_call_after_timer_x	MOV		R0,R6
					BL		f077_CallAfterTimer
					POP		{PC}
; ----------------------------------------------------------------------	

_get_mem			LDR		R6,patch_ram
					BX		LR

; ----------------------------------------------------------------------	

_get_blink_events_number
					PUSH	{R1-R3,R7,LR}
					MOV		R0,#0 ; missed events info
					BL		_get_profile_codes
					BEQ		_get_blink_events_number_no
					
					BL		v12_RamMissedMes
					LDRB	R0,[R7]
					B		_get_blink_events_number_x

_get_blink_events_number_no
					MOV		R0,#0 ; events zero, blinker disengaged
_get_blink_events_number_x
					CMP		R0, #0
					POP		{R1-R3,R7,PC}
; ----------------------------------------------------------------------	


_set_illumination ; input: R2=brightness. [R6,#0x17]: 0=off, 1=screen only, 2=kpl only, 3=both
					PUSH	{R2,R4,LR}
					LDRB	R4,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generatet
										
					CMP		R4,#0 ; off
					BEQ		_set_illum_x1
					
					CMP		R4,#1 ; screen only
					BEQ		_set_illum_1
					
					MOV		R0,#1 ; keypadlight
					BL		__set_illumination
									
					CMP		R4,#2
					BNE		_set_illum_1
				
_set_illum_x1		POP		{R2,R4,PC}
				
_set_illum_1		POP		{R2,R4}
					MOV		R0,#0 ; screen illumination
					BL		__set_illumination
_set_illum_x		POP		{PC}


; ----------------------------------------------------------------------

 ;dcb "---###---"
__set_illumination
				PUSH	{R1,R4,R7,LR}
				MOV		R1,#1
				STRB	R1,[R6,#0x15] ;	SetIllumination-Is-Called-By-Blinker message (0=false)
				
				;MOV		R3,#0x08 ; delay/smoothness #conf#
				LDRB	R3,[R6,#0x10] ; copy of general blinker smoothness
				
				BL		f008_SetIllumination
				MOV		R1,#0
				STRB	R1,[R6,#0x15] ;	SetIllumination-Is-Called-By-Blinker message (0=false)

				POP		{R1,R4,R7,PC}

; ----------------------------------------------------------------------	

_get_illumination_state_by_law
				LDRB	R0,[R6,#0x16] ; Illumination State by Law (what the firmware thinks about illumination on or off)
				BX		LR

; ----------------------------------------------------------------------	

_set_illumination_state_to_law 
				PUSH	{R0-R7,LR}	
			 	BL		_get_illumination_state_by_law 
		   	    MOV		R7,R0
		   	    MOV		R2,R7
		   	    MOV		R0,#0 ; screen
		   	    BL		__set_illumination
		   	    MOV		R2,R7
		   	    MOV		R0,#1 ; kpl
		   	    BL		__set_illumination
		   	    POP		{R0-R7,PC}
		   	    
; ----------------------------------------------------------------------	

_reset_illutoggler_flag
				PUSH	{R1,LR}
				MOV		R1,#0 ; illu_toggler (0)=illu is allowed, (2)=illu forbidden, (1) onli if fw thinks that illumi is off
				BL		_get_mem
				BL		_store_illutoggler_flag
				POP		{R1,PC}
; ----------------------------------------------------------------------	

 ;dcb "__ILLTOGG__"
_illumination_toggler
				PUSH	{R0-R3,LR}
				BL		_get_mem
				
				LDRB	R0,[R6,#0x14] ;  if 1, blinker blinks only when fw thinks that illumination is on. else zero.
				CMP		R0,#0 
				BEQ		_illu_toggl_ok
				
				CMP		R0,#2
				BEQ		_illu_toggl_x
				
				
_illu_toggl_1	BL		_get_illumination_state_by_law
				CMP		R0,#0
				BEQ		_illu_toggl_ok
			
				BL		_get_accu_icon
				BNE		_illu_toggl_x
							
_illu_toggl_ok	LDR		R1,[R6,#0x18] ; profile_data_base_address = masterpatch_buffer + 2 + profile# * 8
				CMP		R1,#0 ; masterpatch not active
				BEQ		_illu_toggl_std
				
				LDRB	R2,[R1,#8] ; Blinker brightness by profile
				CMP		R2,#0
				BNE		_illu_toggl_ok1

_illu_toggl_std	MOV		R2,#65 ; standard fallback brightness
				
_illu_toggl_ok1	LDRB	R1,[R6,#8] ; Brightness-Toggler
				MOV		R3,#0xFF
				SUB		R3,R1
				STRB	R3,[R6,#8]
				AND		R2,R3
				BL		_set_illumination
				
_illu_toggl_x	POP		{R0-R3,PC}
		
; -----------------------------------------------------------
_get_net_online
					PUSH	{R1-R3,LR}
					MOV		R0,#1 
					BL		_get_profile_codes
					; input R0: info for 0=missed events, 1=netlost/weak, 2=netblinker								
					; returns: R0=illumination code(0=off,1=screen,2=kpl,3=both). R1=1: blinks only when fw thinks that illumination is off
					; returns if info is for netblinker R2=netblinker behaviour (0=diplomatic, 1=intelligence).

					BNE		_get_net_online_yes
					
_get_net_online_no	MOV		R0,#1 ; always online, blinker disengaged
					POP		{R1-R3,PC}

_get_net_online_yes	BL		__get_net_online
					POP		{R1-R3,PC}
; -----------------------------------------------------------


__get_net_online	LDR		R0,_ram_net_online
					LDRB	R0,[R0]
				
					;LDRB	R0,[R6,#0x19] ; for testing
					BX		LR
				
; -----------------------------------------------------------------------------

_get_accu_icon	LDR		R0,_ram_mainscreen_accu_icon_ 
				;LDR		R0,[R0] ; base address mainscreen state
				LDRH	R0,[R0]
				CMP		R0,#0
				BX		LR

; -----------------------------------------------------------------------------

; f081_GetNetMode	

; phone 13-0E-05-06. sms: 13-09-06-13
; 0,3,5,6,7,8,9,A  : 6=phoning, 9=sms. block supposed: activity
; D,E,F
; (11),12,13,14 ; 0x13=idle. block supposed being somehow idle
; 19, 1A,1B

				
		
; -----------------------------------------------------------------------------

; dcb "__NETMOD___"
_get_evaluated_netmode				PUSH	{R1-R3,LR}
									MOV		R0,#2 ; net traffic rights
 									BL		_get_profile_codes
									BEQ		_get_evaluated_netmode_x  ; netblinker disengaged
									
									BL		f081_GetNetMode
									CMP		R0,#0
									BEQ		_get_evaluated_netmode_idle
									
									CMP		R0,#0x0F ; idle low value ; 0x0F ; ##conf##  CC
									BLE		_get_evaluated_netmode_1
									
									CMP		R0,#0x14 ; idle hi value ; 0x14 ##conf## DD
									BLE		_get_evaluated_netmode_idle
								
_get_evaluated_netmode_1 	 		CMP		R0,#5
									BLE		_get_evaluated_netmode_2
									
									SUB		R0,#6
									LSL		R0,#2
									ADD		R0,#0xA
									B		_get_evaluated_netmode_x	

_get_evaluated_netmode_2			ADD		R0,#3
									CMP		R0,#6
									BGE		_get_evaluated_netmode_x	

									ADD		R0,#7
									B		_get_evaluated_netmode_x
				
_get_evaluated_netmode_idle			MOV		R0,#0
									
_get_evaluated_netmode_x			POP		{R1-R3,PC}

; -----------------------------------------------------------------------------
; DCB "__PCPREP__"
_get_profile_codes_prep				PUSH	{R0-R4,LR}						
																		
									BL		z00_FreeRAM
									LDR		R7,[R7]
									ADD		R7,#1
									BMI		_get_profile_codes_prep_mp
									; CMP		R7,#0
									; BNE		_get_profile_codes_prep_mp
									
_get_profile_codes_prep_boot		ADR		R7,profile_boot_fake ; pass thru boot dynamic blinker, fake magic address
									B		_get_profile_codes_prep_false_1

_get_profile_codes_prep_mp			LDR		R0,mp_id 
									BL		mp_Bufferizer
									BNE		_get_profile_codes_prep_true

_get_profile_codes_prep_false		MOV		R7,#0

_get_profile_codes_prep_false_1		MOV		R0,#0
									BL		_store_smoothness
									MOV		R0,R7
									B		_get_profile_codes_prep_x
									
_get_profile_codes_prep_true		LDRB	R0,[R0,#1] ; general blinker smoothness midlet parameter
									BL		_store_smoothness
									
									BL		f002_GetProfile
									LSL		R0,#3 ; *8 = lenght of profile data record in mp buffer
									ADD		R0,R6 ; first byte of profile data = mp buffer
									MOV		R7,R6
									
_get_profile_codes_prep_x			BL		_get_mem
									STR		R0,[R6,#0x18] ; 18-1b: profile codes address
									CMP		R7,#0
									POP		{R0-R4,PC} ; returns R7: masterpatchbuffer, stores in [R6,#0x18] masterpatchbuffer + profile_offset


; -----------------------------------------------------------------------------
_store_smoothness					PUSH	{R6,LR}
									BL		_get_mem
									STRB	R0,[R6,#0x10] ; copy of general blinker smoothness
									POP		{R6,PC}

; -----------------------------------------------------------------------------

			
_get_profile_codes				PUSH	{R3,R5,LR}
; input R0: info for 0=missed events, 1=netlost, 2=netblinker, 3=special blinker (pattern 4)
								
								LDR		R5,[R6,#0x18] ; current profile code address
								CMP		R5,#0 ; profile must not work!
								BNE		_get_profile_codes_2
								
								MOV		R0,#0
								MOV		R1,R0
								B		_get_profile_code_x

_get_profile_codes_2			CMP		R0,#2
								BEQ		_get_profile_code_netblinker
							
								CMP		R0,#3
								BEQ		_get_profile_code_special
								
								LDRB	R3,[R5,#2] ; current profile codes m_events & netlost
								CMP		R0,#1
								BEQ		_get_profile_code_netblinker1 ; for treatment netlost
 
_get_profile_code_meventsblink	MOV		R0,#48 ; illumination bits
								AND		R0,R3
								LSR		R0,#4 ; result in R0

								MOV		R1,#8 ; blinks only when fw thinks that illumination is off - bit
								AND		R1,R3 
								LSR		R1,#3 ; result in R1
								B		_get_profile_code_x	
								
_get_profile_code_special		MOV		R0,#2 ; output keypadlight
								MOV		R1,#0 ; always
								B		_get_profile_code_x	

_get_profile_code_netblinker	LDRB	R3,[R5,#3] ; current profile codes for netblinker

_get_profile_code_netblinker1	MOV		R0,#6 ; illumination bits
								AND		R0,R3
								LSR		R0,#1 ; result in R0
								MOV		R1,#1 ; blinks only when fw thinks that illumination is off - bit
								AND		R1,R3
								LDR		R2,[R5,#4] ; current profile codes for netblinker stoptime

; returns: if input 0-2: R0=illumination code(0=off,1=screen,2=kpl,3=both).
; returns: if input 0-2: R1=1: blinks only when fw thinks that illumination is off 
; returns: if 2: R2=netblinker stoptime
_get_profile_code_x				CMP		R0,#0
								POP		{R3,R5,PC}
; -----------------------------------------------------------------------------

_set_profile_illu				STRB	R0,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generated
								LDRB	R0,[R6,#0x14]
								CMP		R0,#2
								BEQ 	_set_profile_illu_x
								
_store_illutoggler_flag			STRB	R1,[R6,#0x14] ; if zero, blinker blinks not when illu is on, if 2, blinking not allowed

_set_profile_illu_x				BX		LR

; -----------------------------------------------------------------------------
_get_profile_codes_set_illu		PUSH	{LR}
								BL		_get_profile_codes
								BL		_set_profile_illu
								POP		{PC}
; -----------------------------------------------------------------------------

				ALIGN
sequence_blinker_data		
 				; word 6thtimer_Off,
 				; bytes 1stTimer_On, 2ndTimer_Off, 3rdTimer_On, 4thTimer_Off,5thTimer_On, placeholder
 				DCW		0x400
 				DCB 	10,12,10,12,13,    0x99 ;  ; seq 0 = net lost
				
				DCW		0x1C2
				DCB		0x44,0,0,0,0,     0x99 ; seq 1 =1 event
 				
 				DCW		0x220
 				DCB		0x20,0x1C,0x24,0,0,    0x99 ; seq 2 = 2 events
 				
 				DCW 	0x1E0
 				DCB		0x20,0x1C,0x20,0x1C,0x24,      0x99 ; seq 3 = 3 events
 				
 				DCW		0x1E0
 				DCB 	08,10,08,10,24,    0x99 ; seq 4 = far called, special
					
; -----------------------------------------------------------------

boot_illu_permit					EQU 32 ; 0x88 ; blink output at boot: 0=off,16=screen,32=kpl,48=both ##conf##
boot_illu_brightn					EQU 64
boot_illu_charging_screen_brighth	EQU 0 ; normally off

profile_boot_fake
				DCB		0,0
				DCB		boot_illu_permit, 0 ; missedevents+netlost-key, nettraffic key
				DCD		0 ; netstop timer off 
				DCB		boot_illu_brightn,boot_illu_charging_screen_brighth ; 5,0 ; blinker brighntess, keepscreenalive off 


; -----------------------------------------------------------------


; LTORG

; -----------------------------------------------------------------


 IF  FIRMWARE = 1 ; m65v50

; FunctionLibrary							DCD	0xA0FC0000	
patch_ram								DCD	0xA8000230 ; in this area in all firmwares are free spaces

; entrypoint: illumination + 0x34 (MOV R7, R0)
; illumination: FF4D2DE90160A0E180179FE508D04DE20010D1E502B0A0E300A0A0E3000051E30200E0030050A0E30240A0E10A00000A
;_ram_inbox 									DCD 0xA83FF444   ; m75v13: a841175c, sl65v50: A843F414
; second ram address in ";* Hourly event and sound alerts after missed_events and full_battery v11 *"

_ram_mainscreen_accu_icon_					DCD 0xA863A544 ; s65v58: A868C4E4, sl65v50: A863A3D0, m75v13
; (E) ram_mainscreen_accu_icon: (7047B0B5????????0068????0028)+0xA there you find an address loaded by LDR. add 4 to address.

_ram_net_online								DCD	0xA863D124  ; s65v58: A8690BF0, sl65v50: A863CFB0, m75v13: A84CFBB8
; A1634130 27 48 LDR     R0, =ram_Net_Online 
; (70B59999999900680028) + 2

; _get_net_access_						DCD	0xA132D75D ; s65v58: A136D5B4, sl65v50:A1339034
;(9999021C09780120914200D000207047999900787047)+0xF you find a LDR loading the address or you can start the function.

 ENDIF
 
 ; ------------------------------------------------------------------------

  IF  FIRMWARE = 2 ; sl65v50

FunctionLibrary							DCD	0xA0FC0000	
patch_ram								DCD	0xA8000230 ; in this area in all firmwares are free spaces


; entrypoint: illumination + 0x34 (MOV R7, R0)
; illumination: FF4D2DE90160A0E180179FE508D04DE20010D1E502B0A0E300A0A0E3000051E30200E0030050A0E30240A0E10A00000A

; firmware addresses

;_ram_inbox 									DCD 0xA83FF444
; second ram address in ";* Hourly event and sound alerts after missed_events and full_battery v11 *"

_ram_mainscreen_accu_icon_					DCD 0xA863A3D0
; (E) ram_mainscreen_accu_icon: (7047B0B5????????0068????0028)+0xA there you find an address loaded by LDR. add 4 to address.

_ram_net_online								DCD	0xA863CFB0
; A1634130 27 48 LDR     R0, =ram_Net_Online 
; (70B59999999900680028) + 2

 ENDIF
 
 ; ------------------------------------------------------------------------

  IF  FIRMWARE = 3 ; m75v13

FunctionLibrary							DCD	0xA0FC0000	
patch_ram								DCD	0xA8000230 ; in this area in all firmwares are free spaces


; entrypoint: illumination + 0x34 (MOV R7, R0)
; illumination: FF4D2DE90160A0E180179FE508D04DE20010D1E502B0A0E300A0A0E3000051E30200E0030050A0E30240A0E10A00000A

; firmware addresses
;_ram_inbox 									DCD 0xa841175c
; second ram address in ";* Hourly event and sound alerts after missed_events and full_battery v11 *"

_ram_mainscreen_accu_icon_					DCD 0xA84CB48C
; (E) ram_mainscreen_accu_icon: (7047B0B5????????0068????0028)+0xA there you find an address loaded by LDR. add 4 to address.

_ram_net_online								DCD	0xA84CFBB8
; A1634130 27 48 LDR     R0, =ram_Net_Online 
; (70B59999999900680028) + 2

; _get_net_access_						DCD	0xA132D75D ; s65v58: A136D5B4, sl65v50:A1339034
;(9999021C09780120914200D000207047999900787047)+0xF you find a LDR loading the address or you can start the function.

 ENDIF

; ------------------------------------------------------------------------

; profile codes0
; dcb A1,B1, ,A2,B2, A3,B3, A4,B4, A5,B5, A6,B6, A7,B7

; for each profile there are 2 bytes, a word
; define for each profile a word which is calculated like this:


; A -----

; missed events blinker
;  32 : keypadlight  
;  16 : screen 
;  8 : blinker blinks only when fw thinks that illumination is on. else zero
; if 32 amd 16 are unused, missed events blinker is completly disengaged

; net_lost blinker 
;  4 : keypadlight   
;  2 : screen 
;  1 : blinker blinks only when fw thinks that illumination is on. else zero

; if 4 amd 2 are unused, netlostblinker is completly disengaged

; add the numbers above as you like to get profile code A. (maximum: 32+16+8+4+2+1)

; B -----

; netblinker output
;   4 : keypadlight   
;   2 : screen 
;   1 : blinker blinks only when fw thinks that illumination is on. else zero1
;   0 : netblinker completly disengaged
  
; add the numbers above as you like to get profile code B. (maximum: 4+2+1)

; example: profile codes for one profile: 56,24 means:
; A = 61 = 32 + 16 + 8 + 4 + 1 : missed events blinker: 32=keypadlight, 16=screen. net_lost&net_instable*blinker: 4=keypadlight. 8 and 1 = [both]<-blinks only when fw thinks that illumination is off
; B = 14 = 8 + 4  = netblinker: 8=intelligence mode. 4=keypadlight output

			DCD 0,0,0
mp_data		DCD	0xB1C2D3E4
mp_id		DCD 0x0000CCCC, 0, 0
 
 END  
 
