; Blinker v2, (c) benj9, m65v50
; blink on events

; IlluminationByLaw & KeepScreenIllumAlive --> Umstellen Bootmetode auf aus, kurz, lang
; doppellicht conf 
; alles confbar machen 
; _get_net_access_, _get_illumination_data_table? funclibben
; 


				AREA Blinker, CODE, READONLY     
				
				EXPORT	illumi32

boot_blink_type					EQU	0x99  ; boot sfx: 0=no, 1=dynamic, 2=net ##conf##
mainscreen_always_on_profile	EQU 4  ; mainscreen always on profile ##conf##	
mainscreen_always_on_brightness	EQU 30 ; ##conf##


; simplified function: master_loop is running approx 1x/sec and checks for events.
; if events found, according blink engine is started. master_loop doest run meanwhile,
; last call of blink module restarts master_loop

; entry blinker_start starts dynamic_blink_module for boot effects, that starts after ending the master_loop.
		
	
; NOTE: cause the functions call each other by "CallAfterTimer", they cannot communicate by Registers, only by RAM
				
; free_ram usage:
; 0-7:	timer data 
; 8-9:	illumination toggler
; A:	DynamicBlinker polarity
; B:	NumberBlinker Start
; C:	Numberblinker Step
; D: 	MissedEventsResult (FF if not set)
; E: 	DynamicBlinker Parameter: lo value (time, 1sec=ca-225)
; F: 	DynamicBlinker Parameter: hi value (time, 1sec=ca-225)
; 10:	DynamicBlinker Parameter: step-divide-by
; 11:	DynamicBlinker Parameter: blink type
; 12:	Lock after running entryp first time
; 13:	NetBlinker wait time for next blink call. if zero, blinker blinks not when illu is on.
; 14:	Profile permit store 
; 15:	SetIllumination-Is-Called-By-Blinker message (0=false)
; 16:	Illumination State by Law (what the firmware thinks about illumination on or off)
; 17:	permit for _set_illumination which illumination output (0=off, 1=screen only, 2=kpl only, 3=both) is generatet
; 18:   Netblinker : 0=off, 1=phone+sms, 2=almost all
; -----------------------------------------------------------------------------

				DCB	"Blinker2  benj9"


; ========================================================================================	
; SetIllumination Patch
; ========================================================================================	

; Called by SetIllumination Entrypoint
				CODE32
				ENTRY

illumi32		STMFD	SP!,{R3,R6,LR} ; return is at: "illumi16_x  POP {R3,R6,PC}"
				LDR		R7, _illumi16
				BX		R7 ; switch to thumb
		
; -----------------------------------------------------------------------------

; R0 output					; R1 allowance	->R6
; R2 brightness	->R4		; R3 delay
; R4 = R2 brightness		; R5 used
; R6 = R1 allowance			; R7 addr	

				CODE16
	
illumi16		LDR		R6,free_ram
				LDRB	R3,[R6,#0x12] ; first time run?
				CMP		R3,#0 ; first time run?
				BNE		illumi16_1
							
illu16_first	MOV		R3,#0xFF
				STRB	R3,[R6,#0x12] ; first time run flag
				
				MOV		R3,#boot_blink_type ; boot sfx: 0=off, 1=dynamic, 2=netblinker ##conf## 
				CMP		R3,#0 ; no entry start
				BEQ		illumi16_1
				
				BL		master
				
				CMP		R3,#2 ; 2=netblinker -> finished
				BEQ		illumi16_1 

illu16_first_2	MOV		R3,#0x1F ; make the beginning a bit before fast climax. long: 0x20, short:0x10
				STRB	R3,[R6,#9] ; illumination toggle counter DynamicBlinker
				
				MOV		R3,#2 ; keypadlight at boot . ##conf##
				STRB	R3,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generatet
				BL		dynamic_blinker ; starts after being finished booting master :)
	

illumi16_1		CMP		R0,#0 ; illumination output device 0 = screen
				BNE		illumi16_x ; SetIllumination-Call is "output not screen"

				CMP		R1,#0 ; SetIllumination-Call is "no allowance"
				BEQ		illumi16_x
				
				; set ram byte with brightness content of FW calls, not of Blinker calls.
				BL		_get_mem_ptr
				LDRB	R3,[R6,#0x15] ; SetIllumination-Is-Called-By-Blinker message (set by Blinker-internal SetIllumination calls)
				CMP		R3,#0 
				BNE		illumi16_2 ; ;  called by Blinker
				STRB	R4,[R6,#0x16] ; Illumination State by Law (what the firmware thinks about illumination on or off)
				
illumi16_2		CMP		R4,#0 ; brightness. 0=off.
				BNE		illumi16_x ; SetIllumination-Call is "screen illumi on"
				
illumi16__KeepScreenIllumAlive		
				PUSH	{R0-R2} ;  GetProfile destroys them :/
				MOV		R7,#2 ; GetProfile
				BL		_funclib
				MOV		R3,R0
				POP		{R0-R2}
				
				CMP		R3,#mainscreen_always_on_profile
				BNE		illumi16_x

				MOV		R4,#mainscreen_always_on_brightness

illumi16_x		MOV		R7,R0 ; repatch

				;LDRB	R3,[R6,#0x12] ; first time run?
				;CMP		R3,#0 ; first time run?
				;BNE		illumi16_1
				
				POP		{R3,R6,PC} ; repatch & return of "illumi32  STMFD SP!,{R3,R6,LR}"			



; ========================================================================================	
; master loop
; ========================================================================================	
;dcb "_master_"
master			PUSH	{R0-R7,LR} ; PUSH	{LR}
				BL		_get_mem_ptr
				
				
				
				MOV     R7,#2 ; GetProfile
				BL		_funclib
				
				CMP		R0,#0
				BNE		xxxxx
				MOV		R2,#1 ; conservative   ; ##conf##
				B xxxx1

xxxxx			MOV		R2,#2 ; almost all net

xxxx1			STRB	R2,[R6,#0x18] ; for netblinker: 0=off, 1=phone+sms, 2=almost all
				
				
				ADR		R7,profiles
				LDRB	R2,[R7,R0] ; profile permit. 0=off. 1=blink events, netlost. 2=blink events, netlost, netblinker.
				STRB	R2,[R6,#0x14] ; 14:	Temporariliy profile permit store
				CMP		R2,#0
				BEQ		master_patrol
	
ma_precheck		LDRB	R0,[R6,#0xD] ; stored_number_missed_events
				CMP		R0,#0xFF
				BNE		ma_precheck1
				BL		_get_blink_events_number	
ma_precheck1	MOV		R1,#0xFF
				STRB	R1,[R6,#0xD] ; MissedEventsResult (FF if not set)
				
				MOV		R3,R0 ; R0=calculated_missed-events-result
				BL		_get_netmode_evaluation
				MOV		R1,R0 ; R1=net-access-traffic evaluated to timer-data
				
ma_precheck3	BL		_get_net_online
				MOV		R2,R0 ; R2=net online (1=true)
				
				BL		_get_accu_icon ; R0=boot state (0=true)
	
ma_check		CMP		R0,#0 ; booting				
				BEQ		ma_bli_net_traf

ma_boot_no		CMP		R3,#0 ; no events
				BEQ		ma_event_no

ma_event_y		CMP		R2,#1 ; netonline
				BNE		ma_bli_event	

ma_net_online_y	CMP		R1,#0 ; netaccess_idle
				BNE		ma_bli_net_traf
				B		ma_bli_event
				
ma_event_no		CMP		R2,#1 ; netonline
				BNE		ma_bli_net_lost
				
				CMP		R1,#0 ; netaccess_idle
				BEQ		master_patrol
				B		ma_bli_net_traf
				
; ----------------------------------------------
		
ma_bli_event	CMP		R3,#4 ; 1 & 2 & 3 events 
				BGE		ma_bli_event1
				MOV		R0,R3
				BL		number_blinker 
				B		master_x
				
ma_bli_event1	MOV		R1,#1
				STRB	R1,[R6,#0x11] ; blink type
				MOV		R1,#3 ; keypadlight and screen ##conf##
				STRB	R1,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generatet
				BL		dynamic_blinker 
				B		master_x				
								
ma_bli_net_traf	BL		net_blinker
				B		master_x
				
ma_bli_net_lost	BL		netlost_blinker
				B		master_x			
	
master_patrol	MOV		R1,#255 ; approx. 1.2 seconds
				LDR		R2,=master
				BL		_call_after_timer		
					
master_x		POP		{R0-R7,PC} ; POP		{PC}


; ========================================================================================	
; dynamic sweeping blinker module
; ========================================================================================	

; E: DynamicBlinker lo value (time, 1sec=ca-225)
; F: DynamicBlinker hi value (time, 1sec=ca-225)
; 10:DynamicBlinker step-divide-by
; 11:DynamicBlinker Parameter: blink type

dynamic_blinker ; input ram+0x11: blink type
				PUSH 	{R0-R7,LR} ; PUSH	{LR}
				BL		_get_mem_ptr
				
				MOV		R0,#0 
				STRB	R0,[R6,#0x13] ; if zero, blinker blinks not when illu is on
				
				LDRB	R0,[R6,#0x11] ; blink type
				
				CMP		R0,#0 
				BEQ		dyn_blinker_0


dyn_blinker_1	MOV		R0,#5
				MOV		R1,#0x48
				MOV		R2,#3
				B		dyn_blinker_exe

dyn_blinker_0	MOV		R0,#3
				MOV		R1,#0x60
				MOV		R2,#4
				
dyn_blinker_exe	STRB	R0,[R6,#0xE] ; lo value
				STRB	R1,[R6,#0xF] ; hi value
				STRB	R2,[R6,#0x10] ; lsr value
				
				BL		dynamic_blinker_loop

				POP		{R0-R7,PC} ; POP		{PC}

; -----------------------------------------------------------------

dynamic_blinker_loop
				PUSH	{R0-R7,LR}

				MOV		R5,#0 ; zero dynamic_loop_x flag

				BL		_illumination_toggler
 		
dyn_on			LDRB	R1,[R6,#9] ; gespeicherter nchster Zeitwert
				LDRB	R2,[R6,#0xE] ; low value
				CMP		R1,R2
				BGE		dyn_on1 ; wenn kleiner als 4, Richtung umpolen

dyn_pol_pos		MOV		R2,#1
 				B		dyn_pol_str

dyn_on1			LDRB	R2,[R6,#0xF] ; hi value
				CMP		R1,R2 
				BLE		dyn_on2 ; wenn grer als startvalue, Richtung umpolen
		
dyn_pol_neg		MOV		R2,#0
				MOV		R5,#1 ; set dynamix_loop_x flag
dyn_pol_str 	STRB	R2,[R6,#0xA] ; polarity speichern
		
		
dyn_on2			LDRB	R2,[R6,#0x10] ; LSR-Val
				MOV		R7,R1
				LSR		R7,R2  
				ADD		R7,#1
				LDRB	R2,[R6,#0xA] ; polaritaet
				CMP		R2,#0 
				BNE		dyn_on_pos
		
dyn_on_neg		SUB		R1,R7
				B		dyn_on3
		
dyn_on_pos		ADD		R1,R7

dyn_on3			STRB	R1,[R6,#9]	; store current timeval


dyn_start_what	CMP		R5,#1 ; loop finished?
				BEQ		dyn_master
				
dyn_inner_ret	LDR     R2,=dynamic_blinker_loop ; loop not finished, go on
				B		dyn_exec3	
				
dyn_master		BL		_get_blink_events_number
				CMP		R0,#0
				BNE		dyn_master_ret

dyn_law			BL		_set_illumination_state_to_law
			
dyn_master_ret	LDR     R2,=master
				B		dyn_exec3

; dyn_selfstarter	LDR     R2,=dynamic_blinker ; +1 ; restart myself directly while booting
		
dyn_exec3		BL		_call_after_timer
		
dynamic_loop_x	POP		{R0-R7,PC}	

			

; ========================================================================================	
; missed events numbers / netlost blinker module
; ========================================================================================	
; dcb "_num_bli_"
; entry for missed events 1-2

number_blinker	PUSH	{R0-R7,LR} ; input r0=number of missed events
				BL		_get_mem_ptr

				MOV		R3,#3 ; keypadlight and screen  ##conf##
				STRB	R3,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generatet

				CMP		R0,#1 ; 1 event
				BEQ		number_1
				
				CMP		R0,#2 ; 2 event
				BEQ		number_2
				
number_3		MOV		R0,#29
				MOV		R2,#145
				B		number_do

number_2		MOV		R0,#31
				MOV		R2,#93 ; 0x5D
				B		number_do
				
number_1		MOV		R0,#74 ; 0x4A
				MOV		R2,#100 ; 


number_do		MOV		R1,#0 
				STRB	R1,[R6,#0x13] ; if zero, blinker blinks not when illu is on
				
				MOV		R1,#60 ; brightness
				STRB	R1,[R6,#8] ; 8-9: illumination toggler

				STRB	R0,[R6,#0xC] ; Numberblinker Step
				STRB	R2,[R6,#0xB] ; NumberBlinker Remainder
				
				BL		number_blinker_loop
				POP		{R0-R7,PC}


; -----------------------------------------------------------------

; entry for netlost blinker

netlost_blinker	PUSH	{R0-R7,LR}
				BL		_get_mem_ptr
				MOV		R1,#2 ; keypadlight only ##conf##
				STRB	R1,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generatet

				MOV		R1,#0 
				STRB	R1,[R6,#0x13] ; if zero, blinker blinks not when illu is on
				
				MOV		R1,#0xA ; short duration
				STRB	R1,[R6,#0xB] ; NumberBlinker Remainder
				MOV		R1,#0xA ; short bleep
				STRB	R1,[R6,#0xC] ; Numberblinker Step

				MOV		R1,#60 ; brightness
				STRB	R1,[R6,#8] ; 8-9: illumination toggler
				
				BL		number_blinker_loop
				POP		{R0-R7,PC}

; -----------------------------------------------------------------

number_blinker_loop ; inner blinking module
				PUSH	{LR}
		
				BL		_illumination_toggler

				LDRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				LDRB	R1,[R6,#0xC] ; Numberblinker Step 
				SUB		R0,R1
				STRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				
				CMP		R0,#0
				BMI		number_blinker_return
				
				LDR		R2,=number_blinker_loop
				B		number_exec1

number_blinker_return
				BL		_get_blink_events_number
				CMP		R0,#0
				BNE		number_exec
				
				BL		_get_net_online
				CMP		R0,#0
				BEQ		number_exec
				
				BL		_set_illumination_state_to_law

number_exec		MOV		R1,#225 
				ADD		R1,#225 ; Dauer, 450/250 Sekunden
				LDR		R2,=master			
				
number_exec1	BL		_call_after_timer
				
				POP		{PC}
				
; ========================================================================================	
; net-blinker module
; ========================================================================================	
; dcb "__NETBLI___"
net_blinker		PUSH	{LR} 
				BL		_get_mem_ptr

				MOV		R0,#2 ; keypadlight ##conf##
				STRB	R0,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generatet

				BL		_get_netmode_evaluation	
				CMP		R0,#0 ; net idle
				BEQ		net_bli_mastr_r
				
net_bli_what	STRB	R0,[R6,#0x13] ; TimedBlinker wait time for next blink call. if zero, blinker blinks not when illu is on
				CMP		R0,#0 ;idle value
				BEQ		net_bli_mastr_r
				
				PUSH	{R0}
				BL		_get_net_online
				MOV		R1,R0 ; R1=net online (1=true)
				BL		_get_accu_icon ; R0=boot state (0=true)
				MOV		R3,R0 ; R3=booting (0=true)               
				POP		{R0}
				
				LDRB	R2,[R6,#0x14] ; profile permit
				CMP		R2,#2 ; 1=event+netlost blinker, 2=all blinker
				BNE		net_bli_mastr_r	
				
				CMP		R3,#0 ; if bootin, go                 
				BEQ		net_bli_inner_r
				
				CMP		R1,#0 ; netlost, not booting: no
				BEQ		net_bli_mastr_r
				
net_bli_inner_r	BL		_illumination_toggler
				LDR		R2,=net_blinker
				B		net_bli_go

net_bli_mastr_r	BL		_set_illumination_state_to_law
				LDR		R2,=master

net_bli_go		LDRB	R1,[R6,#0x13] ; TimedBlinker wait time for next blink call. if zero, blinker blinks not when illu is on.
				BL		_call_after_timer		
				POP		{PC}


; ========================================================================================	
; Blink Sequencer
; ========================================================================================

sequence_blinker
				;PUSH
				; B:	NumberBlinker Start
				; C:	Numberblinker Step
				
				
				
				;{R0-R7,PC}
				
				
				;POP
				
				
 

; ========================================================================================	
; auxiliary functions
; ========================================================================================	


_funclib			PUSH	{R6-R7,LR} ; input: R7  = func#
					LDR		R6,FunctionLibrary
					LSL		R7,#3
					ADD		R7,R6
					LDR		R7,[R7,#4]
					BLX		R7
					POP		{R6-R7,PC}
	
; ----------------------------------------------------------------------	
; DCB "___CAT___"
_call_after_timer	PUSH	{LR}
					CMP		R1,#5
					BGE		_call_after_timer_x
					MOV		R1,#5
_call_after_timer_x	MOV		R0,R6
					MOV     R7,#77 ; CallAfterTimer
					BL		_funclib
					POP		{PC}
; ----------------------------------------------------------------------	


_get_blink_events_number
					LDR		R0,_ram_inbox
					LDRB	R0,[R0]
					BX		LR

; ----------------------------------------------------------------------

_get_mem_ptr		LDR		R6,free_ram
					; LDR		R6,[R6]
					BX		LR

; ----------------------------------------------------------------------

_set_illumination ; input: R2=brightness. [R6,#0x17]: 0=off, 1=screen only, 2=kpl only, 3=both
					PUSH	{R2,R4,LR}
					LDRB	R4,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generatet
					MOV		R1,#1
					
					CMP		R4,#0 ; off
					BEQ		_set_illum_x1
					
					CMP		R4,#1 ; screen only
					BEQ		_set_illum_1
					
					MOV		R0,#1 ; keypadlight
					BL		__set_illumination
									
					CMP		R4,#2
					BNE		_set_illum_1
				
_set_illum_x1		POP		{R2,R4,PC}
				
_set_illum_1		POP		{R2,R4}
					MOV		R0,#0 ; screen illumination
					BL		__set_illumination
_set_illum_x		POP		{PC}


; ----------------------------------------------------------------------

 ;dcb "---###---"
__set_illumination
				PUSH	{R1,R4,R7,LR}
				MOV		R1,#1
				STRB	R1,[R6,#0x15] ;	SetIllumination-Is-Called-By-Blinker message (0=false)
				MOV		R3,#0x10 ; delay/smoothness ##conf##
				MOV		R7,#8 ; SetIllumination
				BL		_funclib
				MOV		R1,#0
				STRB	R1,[R6,#0x15] ;	SetIllumination-Is-Called-By-Blinker message (0=false)

				POP		{R1,R4,R7,PC}

; ----------------------------------------------------------------------	

_get_illumination_state_by_law
				PUSH	{LR}
				LDRB	R0,[R6,#0x16] ; Illumination State by Law (what the firmware thinks about illumination on or off)
				POP		{PC}


; ----------------------------------------------------------------------	

_set_illumination_state_to_law 
				PUSH	{R0-R7,LR}			
			 	BL		_get_illumination_state_by_law 
		   	    MOV		R7,R0
		   	    MOV		R2,R7
		   	    MOV		R0,#0 ; screen
		   	    BL		__set_illumination
		   	    MOV		R2,R7
		   	    MOV		R0,#1 ; kpl
		   	    BL		__set_illumination
		   	    POP		{R0-R7,PC}
		   	    
; ----------------------------------------------------------------------	

_illumination_toggler
				PUSH	{R0,LR}
				BL		_get_mem_ptr
				
				LDRB	R0,[R6,#0x13] ; TimedBlinker wait time for next blink call. if zero, blinker blinks not when illu is on, but yes, if booting.
				CMP		R0,#0 ; TimedBlinker not active?
				BNE		_illu_toggl_ok
				
_illu_toggl_1	BL		_get_illumination_state_by_law
				CMP		R0,#0
				BEQ		_illu_toggl_ok
			
				BL		_get_accu_icon
				CMP		R0,#0 ; booting?
				BNE		_illu_toggl_x
							
_illu_toggl_ok	LDRB	R2,[R6,#8] ; Brightness-Toggler, msste man boolsch machen, falls Profilwechsel/Brightnesswechsel
				MOV		R1,#60 ; brightness
				SUB		R0,R1,R2
				STRB	R0,[R6,#8]
				; MOV		R0,#0x01 ; output device
				BL		_set_illumination
_illu_toggl_x	POP		{R0,PC}
		
; -----------------------------------------------------------

_get_net_online	LDR		R0,_ram_net_online
				LDRB	R0,[R0]
				
				;LDRB	R0,[R6,#0x19] ; for testing
				BX		LR
				
; -----------------------------------------------------------------------------

_get_accu_icon	LDR		R0,_ram_mainscreen_accu_icon_ 
				;LDR		R0,[R0] ; base address mainscreen state
				LDRH	R0,[R0]
				BX		LR
				
; -----------------------------------------------------------------------------

_get_net_access_mode1	

; returns R0:
; phone 13-0E-05-06. sms: 13-09-06-13
; 0,3,5,6,7,8,9,A  : 6=phoning, 9=sms. block supposed: activity
; D,E,F
; (11),12,13,14 ; 0x13=idle. block supposed somehow idle
; 19, 1A,1B

				PUSH	{LR}
				;MOV		R7,#81 ; _get_net_access_
				; BL		_funclib
				LDR		R7,_get_net_access_
				BLX		R7
				POP		{PC}

; -----------------------------------------------------------------------------

_get_net_access_mode2
				LDR		R0,ram_netaccess_mode2
				LDRB	R0,[R0]
				BX		LR	
				
							
; -----------------------------------------------------------------------------

; dcb "__NETMOD___"
_get_netmode_evaluation
				PUSH	{R1,LR}
				
				LDRB	R0,[R6,#0x18] ; netblinker: 0=off, 1=phone+sms, 2=almost all
				CMP		R0,#0
				BEQ		_get_netmode_evaluation_idle
				CMP		R0,#1
				BEQ		_get_netmode_evaluation_1

_get_netmode_evaluation_2 ; sms: 4-0-1-0-2,  phone 0,1,2
				BL		_get_net_access_mode2
				CMP		R0,#0x1B ; idle
				BEQ		_get_netmode_evaluation_idle
				
				CMP		R0,#3 ; idle, but the net is not so stable/strong?
				BLE		_get_netmode_evaluation_2a
				MOV		R0,#48
				B		_get_netmode_evaluation_x
				
_get_netmode_evaluation_2a
				ADR		R1,_get_netmode_evaluation_data
				ADD		R0,R1
				LDRB	R0,[R0]		
				B		_get_netmode_evaluation_x
				
				ALIGN				
_get_netmode_evaluation_data
				DCB		7, 16,12,250
									
_get_netmode_evaluation_1			
				BL		_get_net_access_mode1
				
				CMP		R0,#0x0F ; idle low value
				BLE		_get_netmode_evaluation_1_1
				
				CMP		R0,#0x14 ; idle hi value
				BLE		_get_netmode_evaluation_idle
								
_get_netmode_evaluation_1_1 ; method with direct netaccess_mode byte
				CMP		R0,#5
				BLE		_get_netmode_evaluation_1_2
				SUB		R0,#6
				LSL		R0,#2
				ADD		R0,#0xA
				B		_get_netmode_evaluation_x	
_get_netmode_evaluation_1_2
				ADD		R0,#3
				CMP		R0,#6
				BGE		_get_netmode_evaluation_x	
				ADD		R0,#7
				B		_get_netmode_evaluation_x
				
_get_netmode_evaluation_idle
				MOV		R0,#0
				
_get_netmode_evaluation_x	
				POP		{R1,PC}


; -----------------------------------------------------------------------------	


 ALIGN
 
profiles		DCB		2,1,0,2,2,2,0,0xFF ; profiles 1-7:  0=off. 1=event+netlost-blinker. 2=event+netlost+netblinker

FunctionLibrary							DCD	0xA0FC0000	   	    
free_ram								DCD	0xA8000230 ; in this area in all firmwares are free spaces
_illumi16								DCD	illumi16

; -----------------------------------------------------------------------------

; firmware addresses

;Get_MainscreenNumberOfMissedEventTypes		DCD 0xA163A08F  ; s65v58: A169F14B. sl65v50:  A16486B3
;(00AB19780120022900D0002098BDF8B5)+0xF
 
;ram_Mainscreen_NumberOfMissedEventTypes	DCD 0xA867C860 ; s65v58: A86D0670 , sl65v50: A867633C
; A1634030 2E 48                       LDR     R0, =ramram_Mainscreen_NumberOfMissedEventTypes
; (0136A642EED39999006803) + 6, there you find the address loaded.

_ram_inbox 									DCD 0xA83FF444

_ram_mainscreen_accu_icon_					DCD 0xA863A544 ; s65v58: A868C4E4, sl65v50: A863A3D0
; A1633BF2 46 49 LDR     R1, =ram_mainscreen_states    + 4
; (7047B0B599999999006899990028)+0xA there you find an address loaded. add 4 to address.

; _get_illumination_data_table				DCD	0xA1226518 ; s65v58: A1241448  , sl65v50: A122DE48
; (00B0CAE571FFFFEA999999991EFF2FE1F04D) + 8. (internally done in Blinker: adds 0x94 to address returned by function)

_ram_net_online								DCD	0xA863D124  ; s65v58: A8690BF0, sl65v50: A863CFB0
; A1634130 27 48 LDR     R0, =ram_Net_Online
; (70B59999999900680028) + 2

_get_net_access_						DCD	0xA132D75D ; s65v58: A136D5B4, sl65v50:A1339034
;(9999021C09780120914200D000207047999900787047)+0x10 you find a LDR loading the address or you can start the function.

ram_netaccess_mode2						DCD 0xA8752560
; -----------------------------------------------------------------------------

		
 END  
 
