; blink on events
; x65 M65v50 (c) benj9 

		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for CX6C

TYPE	SETA	1 						

 IF  TYPE = 1


 ENDIF

		EXPORT	ram, _funclib, _set_illumination_state_to_law, master_entry, _get_number_missed_events, _get_net_online, blinker_start, _get_accu_icon
		IMPORT	dynamic_blinker
		IMPORT	number_blinker
		IMPORT	number_blinker_loop
		IMPORT	netlost_blinker
		
		CODE16
		
; ram usage:
; 0-7: timer data
; 8-9: illumination toggler, resides in DynamicBlinker
; A. DynamicBlinker polarity
; B: NumberBlinker Start
; C: Numberblinker Step
; D: MissedEventsResult (FF if not set)


blinker_start	PUSH 	{R0-R7,LR}
				BL		dynamic_blinker ; starts after being finished booting master_entry :)
				POP 	{R0-R7}
				
repatch			MOV     R7,#77 ; CallAfterTimer
				BL		_funclib
				POP		{PC}

; ----------------------------------------------------------------------	

		
master_entry	PUSH	{LR}
				LDR		R6,ram
				LDRB	R0,[R6,#0xD] ; stored_number_missed_events
				CMP		R0,#0xFF
				BNE		master_chk
				
				BL		_get_number_missed_events
				
master_chk		MOV		R1,#0xFF
				STRB	R1,[R6,#0xD]
				
				CMP		R0,#0 ; no missed event                --- 90 / 0B
				BNE		master_chk_ev
				
				BL		_get_net_online
				CMP		R0,#0
				BNE		master_patrol
				
master_netlost	BL		_get_accu_icon
				CMP		R0,#0 ; booting?
				BEQ		master_patrol
				BL		netlost_blinker
				B		master_x	
				
master_chk_ev	CMP		R0,#4
				BGE		master_dynamic
				
master_number	BL		number_blinker 
				B		master_x	
				
master_dynamic	BL		dynamic_blinker 
				B		master_x
	
master_patrol	MOV		R0,R6
				; MOV		R4,#0
				MOV		R1,#255 ; approx. 1.2 seconds
				LDR		R2,=master_entry
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib		
					
master_x		POP		{PC}
			
; ======================================================================
	
_funclib		PUSH	{R7,LR} ; input: R7  = func#
				BL		__funclib
				
 				BLX		R7		
				POP		{R7,PC}

__funclib		PUSH	{R5-R6,LR} ; input: R7  = func#
				LSL		R7,#3
				LDR		R6,FunctionLibrary
				ADD		R7,R6
				
				LDR		R5,[R7]
				CMP		R5,#0
				BMI		__funclib_err ; func lib entry not present
				
				ADD		R7,#1			
				BLX		R7
				B		__funclib_x
				
__funclib_err	MOV		SP,R4 ; release whole sub stack
				MOV		R0,#0
				MOV		R1,#0
				;LDR		R7,Shutdown_chunk
				;BLX		R7
				POP		{PC} ; escape patch immediatly
			
__funclib_x		POP		{R5-R6,PC}

; ----------------------------------------------------------------------	

_get_number_missed_events
				PUSH	{R1-R7,LR}

				MOV		R0,#0 ; otherwise crash
				LDR		R7,GetNumberOfNotCommittedMissedEvents
				BLX		R7
				LDR		R7,_Mainscreen_NumberOfMissedEvents
				LDR		R0,[R7]
				LDR		R6,ram

				LDR 	R0,[R6,#32]

				STRB	R0,[R6,#0xD]	
				POP		{R1-R7,PC}

; ----------------------------------------------------------------------	

_set_illumination
				PUSH	{R1,R7,LR}
				MOV		R1,#1
				MOV		R3,#0x28
				MOV		R7,#8 ; SetIllumination
				BL		_funclib
				POP		{R1,R7,PC}


; ----------------------------------------------------------------------	


_set_illumination_state_to_law
				PUSH	{R0-R7,LR}

			 	LDR		R0,_ram_illumination_data
				LDR		R0,[R0]
				ADD		R0,#0x94  ; +94: What OS thinks is state of Illumination On/Off
				LDRB	R0,[R0] 
		   	    
		   	    MOV		R7,R0
		   	    MOV		R2,R7
		   	    MOV		R0,#0 ; screen
		   	    BL		_set_illumination
		   	    MOV		R2,R7
		   	    MOV		R0,#1 ; kpl
		   	    BL		_set_illumination
		   	    POP		{R0-R7,PC}
		   	    
; ----------------------------------------------------------------------	

_get_net_online
				LDR		R0,_ram_net_online
				LDRB	R0,[R0]
				BX		LR
				
; -----------------------------------------------------------------------------

_get_accu_icon	LDR		R0,_ram_mainscreen_accu_icon_ 
				LDR		R0,[R0] ; base address mainscreen state
				LDRH	R0,[R0,#4]
				BX		LR
				
; ----------------------------------------------------------------------	

GetNumberOfNotCommittedMissedEvents	DCD 0xA163A08F
_Mainscreen_NumberOfMissedEvents	DCD 0xA867C860
_ram_mainscreen_accu_icon_			DCD 0xA1633D0C
_ram_illumination_data				DCD 0xA12265F8
_ram_net_online						DCD	0xA863D124
FunctionLibrary						DCD	0xA0FC0000	   	    
ram									DCD	0xA8240000 

 END
 
 
 
 
 
pattern			MOV		R1,#0x90 ; not #90!
				STRB	R1,[R6,#0xB] ; NumberBlinker Remainder
				MOV		R1,#0xB
				STRB	R1,[R6,#0xC] ; Numberblinker Step
				BL		number_blinker_loop