; Key Sequencer Test
; prototype
; m65v50 (c) benj9 

; entry m65v50
; 114C9D4: 041C251C B3F694FB ; -> A1000100
; repatch: ADD R4, R0, #0. ADD R5, R4, #0


		AREA patch, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for SL65v50

TYPE	SETA	1 						

 IF  TYPE = 1

free_ram			EQU	0xA8752F00

; _ram_keypress_buffer	EQU 0xA114CCF0

Malloc				EQU	0xA0820F98
Illumination		EQU	0xA0BC78B8
DrawImage			EQU 0xA16341BD
SwitchPhoneOff		EQU 0xA1240938
GetProfile			EQU	0xA08C9FE5
SetProfile			EQU	0xA08C9EB3
PlaySoundLoop		EQU	0xA0935CF8
DevM_NativeMenu		EQU	0xA08E714B
DevM_Sexit			EQU 0xA0903FE1
DevM_Configuration	EQU 0xA0904301
Usr_Setup			EQU	0xA08E1AF1
Usr_FlashExplorer 	EQU 0xA08E1A35
Usr_AlarmClock		EQU 0xA08E19DF
Usr_Messages		EQU 0xA08E19BD
Usr_Organizer       EQU 0xA08E19A9
Usr_Camera			EQU 0xA08E1A05
Usr_SMS_new			EQU 0xA08E19C9

; Usr_SoundRecorder	EQU 0xA08E219B
; Usr_StopWatch	 	EQU 0xA08E19F1
; Usr_MyMenu		EQU 0xA08E2131
; Usr_CountDown 	EQU 0xA08E19FB
; Usr_Downloads		EQU	0xA08E1A81
; Usr_Pictures		EQU 0xA08E1A8B
; Usr_DynamicLight 	EQU 0xA08E1BA3
; A08E1BB3             usr_Ringtones
; A08E1C7F             usr_ClockSetup_TimeDate
; A08E19E9             usr_Calc


 ENDIF
 
 
; free_ram: count_key_in_sequence[0], ..., count_key_in_sequence[n-1]
; count_key_in_sequence=0: not entered. =n: n keys accepted.

; -----------------------------------------------------------------------------

 CODE16
				B		start
				DCB		"KeySequencer1 (c)benj9",0
start			PUSH	{R1-R3,R6-R7,LR}
				MOV		R5,R0
				LDR		R3,=sequences
				SUB		R3,#1
				LDR		R4,=free_ram
				
				MOV		R7,#0 ; 1er Schritte

loop			LDRB	R1,[R4,R7] ; free_ram-buf for seq

				LSL		R0,R7,#4 ; *16
				ADD		R2,R3,R0 ; R2=rom byte 0 for seq


				LDR		R6,[R2] ; R6=ExecAddress
				MOV		R0,#0xFF
				AND		R6,R0
				CMP		R6,R0
				BEQ		exit
				
				ADD		R0,R2,R1
				ADD		R0,#8 ; 
				LDRB	R6,[R0] ; R0=rom seq byte
				
				CMP		R5,R6
				BNE     reset_sequence 
							
key_snapped		LDRB	R6,[R0,#1] ; sequence zu ende?
				CMP		R6,#0
				BNE		key_in_sequence
				
execute			PUSH	{R0-R3,R7}
				MOV		R7,R2		

				MOV		R0,#0x22
				MOV		R1,#2
				MOV		R2,#3
				LDR		R6,=PlaySoundLoop
				BLX		R6
				
				LDR		R6,[R7] ; R6=ExecAddress

				LDRB	R0,[R7,#4] ; R0 for exec_address
				LDRB	R1,[R7,#5] ; R1 for exec_address
				LDRB	R2,[R7,#6] ; R2 for exec_address
				LDRB	R3,[R7,#7] ; R3 for exec_address
				
				BLX		R6
			
			  	POP		{R0-R3,R7}
				B		reset_sequence
				
key_in_sequence	ADD		R1,#1
				B		loop_return
				
reset_sequence	MOV		R1,#0
				
loop_return		STRB	R1,[R4,R7] ; reset free_ram-buf for seq
				ADD		R7,#1
				B		loop
					
; -----------------------------------------------------------------------------	

			
exit			MOV		R0,R5 ; repatch
				MOV		R4,R5 ; repatch
				POP		{R1-R3,R6-R7,PC}
				
; -----------------------------------------------------------------------------

			ALIGN
				; DCD			0

; format: action(>=A0=address), R0(if address),8 bytes key sequence

 ; 0  1  2  3      4  5  6  7  8 9 A B C D  E  F
; Function Address R0 R1 R2 R3 KKKKKKKKKKKK KK KK
 
; AA  action number
; R0-R3 registers R0 - R3 as bytes
; KK  elements of key sequences
 
 ; Keys: 0-9=0x30-0x39. *=0x2A. #=0x23
 ; left softkey=0x01. right softkey=0x04. red button=0x0C. green button=0x0B.
 ; joystick: up=0x3B. down=0x3C. left=0x3D. right=0x3E. click=0x1A.
sequences

				DCD	SetProfile
				DCB 0,0,0,0 ; r0-r3  set profile 1
				DCB 0x2A,0x2A,0x31,0,0,0,0,0 ; **1
						
				DCD	SetProfile
				DCB 1,0,0,0 ; r0-r3  set profile 2
				DCB 0x2A,0x2A,0x32,0,0,0,0,0 ; **2
				
				DCD	SetProfile
				DCB 2,0,0,0 ; r0-r3  set profile 3
				DCB 0x2A,0x2A,0x33,0,0,0,0,0 ; **3
				
				DCD	SetProfile
				DCB 4,0,0,0 ; r0-r3  set profile 5
				DCB 0x2A,0x2A,0x35,0,0,0,0,0 ; **5
				
				DCD	SetProfile
				DCB 3,0,0,0 ; r0-r3  set profile 4
				DCB 0x2A,0x2A,0x34,0,0,0,0,0 ; **4
				
				DCD	SetProfile
				DCB 5,0,0,0 ; r0-r3  set profile 6
				DCB 0x2A,0x2A,0x36,0,0,0,0,0 ; **6
				
				DCD	SetProfile
				DCB 6,0,0,0 ; r0-r3  set profile 7
				DCB 0x2A,0x2A,0x37,0,0,0,0,0 ; **7
				
				DCD	SetProfile
				DCB 7,0,0,0 ; r0-r3  set profile 8
				DCB 0x2A,0x2A,0x30,0,0,0,0,0 ; **0
				
				DCD PlaySoundLoop
				DCB 0x3a,2,3,0 ; sfx. R0: sound: 3a. R1=2, R2=lenght, R3=0
				DCB 0x0B,0x31,0,0,0,0,0,0 ;  green 1
				
				DCD PlaySoundLoop
				DCB 0x5a,2,0x15,0 ; muuuh
				DCB 0x0B,0x32,0,0,0,0,0,0 ; green , 2
				
				DCD PlaySoundLoop
				DCB 0x5e,2,0xD,0 ; tadaa!
				DCB 0x0B,0x33,0,0,0,0,0,0 ; green , 3
				
				DCD PlaySoundLoop
				DCB 0x22,2,3,0 ; dialtone
				DCB 0x0B,0x34,0,0,0,0,0,0 ; green , 3
				
				DCD	SwitchPhoneOff
				DCD 0
				DCB 0x32,0x3B,0,0,0,0,0,0 ; 2, up
				
				DCD	DevM_NativeMenu
				DCD 0
				DCB 0x01,0x0B,0,0,0,0,0,0 ; left sk, green
				
				DCD	DevM_Sexit
				DCD 0
				DCB 0x23,0x23,0x30,0,0,0,0,0 ; ##0
				
				DCD	DevM_Configuration
				DCD 0
				DCB 0x23,0x23,0x39,0,0,0,0,0 ; ##9
				
				DCD	Usr_Setup
				DCD 0
				DCB 0x23,0x23,0x23,0x23,0,0,0,0 ; #####
				
				DCD	Usr_FlashExplorer 
				DCD 0
				DCB 0x31,0x31,0x31,0x31,0,0,0,0 ; 1111
				
				DCD	Usr_AlarmClock	
				DCD 0
				DCB 0x37,0x37,0x37,0x37,0,0,0,0 ; 7777
				
				DCD	Usr_Messages
				DCD 0
				DCB 0x34,0x34,0x34,0x34,0,0,0,0 ; 4444
			
				DCD	Usr_Organizer
				DCD 0
				DCB 0x38,0x38,0x38,0x38,0,0,0,0 ; 8888
				
				DCD	Usr_Camera	
				DCD 0
				DCB 0x35,0x35,0x35,0x35,0,0,0,0 ; 5555
				
				DCD Usr_SMS_new
				DCD 0
				DCB 0x32,0x32,0x32,0x32,0,0,0,0 ; 2222	
				
sequences_end	DCD 0xFF			


 END
