; Key Sequencer Test
; prototype
; m65v50 (c) benj9 

; entry m65v50
; 114C9D4: 041C251C B3F694FB ; -> A1000100
; repatch: ADD R4, R0, #0. ADD R5, R4, #0


		AREA benj9, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for SL65v50

TYPE	SETA	1 						

 IF  TYPE = 1

ram					EQU	0xA8752F00
malloc				EQU	0xA0820F98
Illumination		EQU	0xA0BC78B8
DrawImage			EQU 0xA16341BD
SwitchPhoneOff		EQU 0xA1240938
GetProfile			EQU	0xA08C9FE4+1
SetProfile			EQU	0xA08C9EB2+1
PlaySoundLoop		EQU	0xA0935CF8
; _ram_keypress_buffer	EQU 0xA114CCF0

 ENDIF


			CODE16

; ram: count_key_in_sequence[0], ..., count_key_in_sequence[n-1]
; count_key_in_sequence=0: not entered. =n: n keys accepted.

			
main			PUSH	{R1-R3,R6-R7,LR}
				MOV		R5,R0
				LDR		R3,=sequences
				SUB		R3,#1
				LDR		R4,=ram
				
				MOV		R7,#0 ; 1er Schritte

seq_loop		LDRB	R1,[R4,R7] ; ram-buf for seq

				LSL		R0,R7,#4 ; *16
				ADD		R2,R3,R0 ; R2=rom byte 0 for seq


				LDR		R6,[R2] ; R6=Action or Address
				MOV		R0,#0xFF
				AND		R6,R0
				CMP		R6,R0
				BEQ		exit
				
				ADD		R0,R2,R1
				ADD		R0,#8 ; 
				LDRB	R6,[R0] ; R0=rom seq byte
				
				CMP		R5,R6
				BNE     reset_key
				

				
key_snapped		LDRB	R6,[R0,#1] ; sequence zu ende?
				CMP		R6,#0
				BEQ		execute
				
				; sequence nicht zu ende, weiter in der sequence nchstes mal
				ADD		R1,#1
				STRB	R1,[R4,R7] ; reset ram-buf for seq	
				B		loop_more_seq
				
execute			LDR		R6,[R2] ; R6=Action or Address
				LDR		R0,=0xA0000000
				CMP		R6,R0
				BCS		exec_address				
				;exec_action
				
				CMP		R6,#1 
				BEQ		exec_action1
				
				CMP		R6,#2 
				BEQ		exec_action2
				
				CMP		R6,#9 
				BEQ		exec_action9
				
				 	
reset_key		
				MOV		R1,#0
				STRB	R1,[R4,R7] ; reset ram-buf for seq	
				B		loop_more_seq
			
loop_more_seq	ADD		R7,#1
				B		seq_loop
				
				
exit			MOV		R0,R5 ; repatch
				MOV		R4,R5 ; repatch
				POP		{R1-R3,R6-R7,PC}
				
exec_action1	LDR		R6,=SetProfile; SetProfile 
				B		exec_address
				
exec_action2	MOV		R1,#2 
				MOV		R2,#5
				LDR		R6,=PlaySoundLoop
				B		exec_address
				
exec_address	LDR		R0,[R2,#4] ; R0 for exec_address
				BLX		R6
				B		reset_key

exec_action9	SWI		2 ; software crash
 				B		reset_key

			

			ALIGN
; format: action(>=A0=address), R0(if address),8 bytes key sequence
sequences

			
			DCD	SetProfile ;  8
			DCD	7 ; set profile 8
			DCB 0x2A,0x2A,0x30,0,0,0,0,0 ; **0
			

			DCD	SwitchPhoneOff
			DCD 0
			DCB 0x39,0x39,0x36,0,0,0,0,0 ; 996
			
			DCD	1 ; action 1: SetProfile
			DCD	0 ; set profile 1
			DCB 0x2A,0x2A,0x31,0,0,0,0,0 ; **1

			

			
sequences_end	DCD 0xFF			


 END
 
 ; Keys:
 ; 0-9: 0x30-0x39
 ; *: 0x2A. #=0x23
 ; Softkey left: 1. SK right: 4
 ; red button: 0xC. green button: 0xB
 ; Joystick: up: 0x3B. dn: 0x3C. left: 0x3D. reight: 0x3E. Press: 0x1A
 
 
 

			DCD	1 ; action 1: SetProfile
			DCD	0 ; set profile 1
			DCB 0x2A,0x2A,0x31,0,0,0,0,0 ; **1
					
			DCD	1 
			DCD	1 ; set profile 2
			DCB 0x2A,0x2A,0x32,0,0,0,0,0 ; **2
			
			DCD	1
			DCD	2 ; set profile 3
			DCB 0x2A,0x2A,0x33,0,0,0,0,0 ; **3
			
			DCD	1
			DCD	3 ; set profile 4
			DCB 0x2A,0x2A,0x34,0,0,0,0,0 ; **4
			
			DCD	1
			DCD	4 ; set profile 5
			DCB 0x2A,0x2A,0x35,0,0,0,0,0 ; **5
			
			DCD	1
			DCD	5 ; set profile 6
			DCB 0x2A,0x2A,0x36,0,0,0,0,0 ; **6
			
			DCD	1 
			DCD	6 ; set profile 7
			DCB 0x2A,0x2A,0x37,0,0,0,0,0 ; **7
			
			DCD	SetProfile ;  8
			DCD	7 ; set profile 8
			DCB 0x2A,0x2A,0x30,0,0,0,0,0 ; **0
			
			DCD 2 ; action2: sound
			DCD 0xb
			DCB 0x01,0x31,0,0,0,0,0,0 ;  green 1
			
			DCD 2 ; action2: sound
			DCD 0xb
			DCB 0x01,0x32,0,0,0,0,0,0 ; green , 2
			
			DCD 2 ; action2: sound
			DCD 0xb
			DCB 0x01,0x33,0,0,0,0,0,0 ; green , 3
			
			DCD	SwitchPhoneOff
			DCD 0
			DCB 0x39,0x39,0x36,0,0,0,0,0 ; 996

			DCD	9 ; SWI 2
			DCD	0 ; 
			DCB 0x32,0x32,0x3C,0,0,0,0,0 ; 22,down
 