; blink on events
; x65 M65v50 (c) benj9 

		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for CX6C

TYPE	SETA	1 						

 IF  TYPE = 1


 ENDIF


; profil testen direkt , ram neu machen, blink-korrektur fr netlost, strings suchen, bauen, porten

		EXPORT	blinker_start

		
		CODE16

; simplified function: master_loop is running approx 1x/sec and checks for events.
; if events found, according blink engine is started. master_loop doest run meanwhile,
; last call of blink module restarts master_loop

; entry blinker_start starts dynamic_blink_module for boot effects, that starts after ending the master_loop.
		
				
; free_ram_dword_ usage:
; 0-7: timer data
; 8-9: illumination toggler, resides in DynamicBlinker
; A. DynamicBlinker polarity
; B: NumberBlinker Start
; C: Numberblinker Step
; D: MissedEventsResult (FF if not set)
; E: DynamicBlinker Parameter: lo value (time, 1sec=ca-225)
; F: DynamicBlinker Parameter: hi value (time, 1sec=ca-225)
; 10:DynamicBlinker Parameter: step-divide-by
; 11:DynamicBlinker Parameter: blink type
; 12:Lock after running entryp first time

; ========================================================================================	
; called from first entry point to start whole patch
; ========================================================================================	


blinker_start	PUSH 	{R0-R7,LR}

				LDR		R6,free_ram_dword_
				LDRB	R1,[R6,#0x12] ; first time run?
				CMP		R1,#0 ; first time run?
				BNE		blinker_x ; ram address already allocated, patch already started, dont do again

blinker_run		MOV		R1,#0xCC ; lock this entry, first time lock
				STRB	R1,[R6,#0x12] 
				
				 	
				
				;MOV		R0,#0x11 ; mem needed
				;MOV		R7,#20 ; Malloc - doesnt work at this early entryp
				;BL		_funclib
				
				; reset dest ram buffers to zero 
				MOV		R1,#0
				STR		R1,[R6,#8]
				STR		R1,[R6,#12]
				
				MOV		R1,#0 ; blink type 0=long, 1=short ; ### USER CONFIG ### 
				STRB	R1,[R6,#0x11]
				MOV		R2,#0x10
				MUL		R1,R2
				ADD		R1,#0x10
				; MOV		R1,#0x20 ; make the beginning a bit before fast climax. short: 0x20, long:0x10
				STRB	R1,[R6,#9] ; illumination toggle counter DynamicBlinker
				BL		dynamic_blinker ; starts after being finished booting master_entry :)
				; BL			master_entry

blinker_x		POP 	{R0-R7}
				
repatch			MOV     R7,#77 ; CallAfterTimer
				BL		_funclib
				POP		{PC}

; ========================================================================================	
; master loop
; ========================================================================================	
		
master_entry	PUSH	{LR}
			
				MOV     R7,#2 ; GetProfile
				BL		_funclib
				LDR 	R7, profile_key
				LSR		R7,R0
				MOV		R0,#1
				AND		R7,R0
				CMP		R7,#1
				BNE		master_patrol

				BL		_get_mem_ptr
				LDRB	R0,[R6,#0xD] ; stored_number_missed_events
				CMP		R0,#0xFF
				BNE		master_chk
				
				BL		_get_number_missed_events
				
master_chk		MOV		R1,#0xFF
				STRB	R1,[R6,#0xD] ; MissedEventsResult (FF if not set)
				
				CMP		R0,#0 ; missed events?
				BNE		master_chk_ev
				
				BL		_get_net_online
				CMP		R0,#0
				BNE		master_patrol
				
master_netlost	BL		_get_accu_icon
				CMP		R0,#0 ; booting?
				BEQ		master_patrol
				BL		netlost_blinker
				B		master_x	
				
master_chk_ev	CMP		R0,#2 ; 1 & 2 events 
				BLE		master_number
				
master_dynamic	MOV		R1,#1
				STRB	R1,[R6,#0x11] ; blink type
				BL		dynamic_blinker 
				B		master_x
				
master_number	BL		number_blinker 
				B		master_x	
	
master_patrol	MOV		R0,R6
				; MOV		R4,#0
				MOV		R1,#255 ; approx. 1.2 seconds
				LDR		R2,=master_entry
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib		
					
master_x		POP		{PC}

; ========================================================================================	
; dynamic sweeping blinker module
; ========================================================================================	

; E: DynamicBlinker lo value (time, 1sec=ca-225)
; F: DynamicBlinker hi value (time, 1sec=ca-225)
; 10:DynamicBlinker step-divide-by
; 11:DynamicBlinker Parameter: blink type

dynamic_blinker ; input ram+0x11: blink type
				PUSH	{LR}
				BL		_get_mem_ptr
				LDRB	R0,[R6,#0x11] ; blink type
	
				CMP		R0,#0 
				BEQ		dyn_blinker_0


dyn_blinker_1	MOV		R0,#5
				MOV		R1,#0x5C
				MOV		R2,#3
				B		dyn_blinker_exe

dyn_blinker_0	MOV		R0,#3
				MOV		R1,#0xB8
				MOV		R2,#5
				
dyn_blinker_exe	STRB	R0,[R6,#0xE] ; lo value
				STRB	R1,[R6,#0xF] ; hi value
				STRB	R2,[R6,#0x10] ; lsr value
				
				BL		dynamic_blinker_loop

				POP		{PC}


; -----------------------------------------------------------------
		
dynamic_blinker_loop
				PUSH	{R0-R7,LR}

				MOV		R5,#0 ; zero dynamix_loop_x flag

				BL		_illumination_toggler
 		
 			
dyn_on			LDRB	R1,[R6,#9] ; gespeicherter nchster Zeitwert
				LDRB	R2,[R6,#0xE] ; low value
				CMP		R1,R2
				BGE		dyn_on1 ; wenn kleiner als 4, Richtung umpolen

dyn_pol_pos		MOV		R2,#1
 				B		pol_str

dyn_on1			LDRB	R2,[R6,#0xF] ; hi value
				CMP		R1,R2 
				BLE		dyn_on2 ; wenn grer als startvalue, Richtung umpolen
		
dyn_pol_neg		MOV		R2,#0
				MOV		R5,#1 ; set dynamix_loop_x flag
pol_str 		STRB	R2,[R6,#0xA] ; polarity speichern
		
		
dyn_on2			LDRB	R2,[R6,#0x10] ; LSR-Val
				MOV		R7,R1
				LSR		R7,R2  
				ADD		R7,#1
				LDRB	R2,[R6,#0xA] ; polaritaet
				CMP		R2,#0 
				BNE		dyn_on_pos
		
dyn_on_neg		SUB		R1,R7
				B		dyn_on3
		
dyn_on_pos		ADD		R1,R7

dyn_on3			STRB	R1,[R6,#9]	; store current timeval


dyn_start_what	BL		_get_accu_icon
				CMP		R0,#0 ; booting?
				BNE		dyn_boot_no
				
dyn_boot_yes	CMP		R5,#1 ; loop finished?
				BEQ		dyn_law	

dyn_inner_ret	LDR     R2,=dynamic_blinker_loop ; loop not finished, go on
				NOP
				B		dyn_exec3
				
dyn_boot_no		LDRB	R3,[R6,#0x12] ; first time lock?
				CMP		R3,#0xCC ; dynamic called by boot entry?
				BNE		dyn_boot_no1
				
				MOV		R3,#0xFF
				STRB	R3,[R6,#0x12] ; lock forever
				B		dyn_law
							
dyn_boot_no1	CMP		R5,#1 ; loop finished?
				BNE		dyn_inner_ret	
				
dyn_master		BL		_get_number_missed_events
				CMP		R0,#0
				BNE		dyn_master_ret

dyn_law			BL		_set_illumination_state_to_law
			
dyn_master_ret	LDR     R2,=master_entry
				NOP
				B		dyn_exec3

dyn_selfstarter	LDR     R2,=dynamic_blinker ; +1 ; restart myself directly while booting
				NOP
		
dyn_exec3		MOV		R0,R6
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib
		
dynamic_loop_x	POP		{R0-R7,PC}	

			

; ========================================================================================	
; missed events numbers / netlost blinker module
; ========================================================================================	

; entry for missed events 1-3

number_blinker	PUSH	{R0-R7,LR} ; input r0=number of missed events

				CMP		R0,#1 ; 1 event
				BEQ		number_1
				
number_2		MOV		R0,#24
				B		number_do
				
number_1		MOV		R0,#72

number_do		BL		_get_mem_ptr
				MOV		R1,#60 ; brightness
				STRB	R1,[R6,#8] ; 8-9: illumination toggler

				STRB	R0,[R6,#0xC] ; Numberblinker Step
				MOV		R0,#72
				STRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				
				BL		number_blinker_loop
				POP		{R0-R7,PC}


; -----------------------------------------------------------------

; entry for netlost blinker
		
netlost_blinker	PUSH	{R0-R7,LR}
				BL		_get_mem_ptr
				MOV		R1,#0xA ; short duration
				STRB	R1,[R6,#0xB] ; NumberBlinker Remainder
				MOV		R1,#0xA ; short bleep
				STRB	R1,[R6,#0xC] ; Numberblinker Step

				MOV		R1,#60 ; brightness
				STRB	R1,[R6,#8] ; 8-9: illumination toggler
				
				BL		number_blinker_loop
				POP		{R0-R7,PC}

; -----------------------------------------------------------------
			
number_blinker_loop ; inner blinking module
				PUSH	{LR}
		
				BL		_illumination_toggler

				LDRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				LDRB	R1,[R6,#0xC] ; Numberblinker Step 
				SUB		R0,R1
				STRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				
				CMP		R0,#0
				BMI		number_blinker_return
				
				LDR		R2,=number_blinker_loop
				B		number_exec1

number_blinker_return
				BL		_get_number_missed_events
				CMP		R0,#0
				BNE		number_exec
				
				BL		_get_net_online
				CMP		R0,#0
				BEQ		number_exec
				
				BL		_set_illumination_state_to_law

number_exec		MOV		R1,#225 
				ADD		R1,#225 ; Dauer, 450/250 Sekunden
				LDR		R2,=master_entry			
				
number_exec1	MOV		R0,R6
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib
				
				POP		{PC}


; ========================================================================================	
; auxiliary functions
; ========================================================================================	

_funclib		PUSH	{R7,LR} ; input: R7  = func#
				BL		__funclib
				
 				BLX		R7		
				POP		{R7,PC}

__funclib		PUSH	{R5-R6,LR} ; input: R7  = func#
				LSL		R7,#3
				LDR		R6,FunctionLibrary
				ADD		R7,R6
				
				LDR		R5,[R7]
				CMP		R5,#0
				BMI		__funclib_err ; func lib entry not present
				
				ADD		R7,#1			
				BLX		R7
				B		__funclib_x
				
__funclib_err	MOV		SP,R4 ; release whole sub stack
				MOV		R0,#0
				MOV		R1,#0
				;LDR		R7,Shutdown_chunk
				;BLX		R7
				POP		{PC} ; escape patch immediatly
			
__funclib_x		POP		{R5-R6,PC}

; ----------------------------------------------------------------------	

_get_number_missed_events
				PUSH	{R1-R7,LR}

				MOV		R0,#0 ; otherwise crash
				LDR		R7,GetNumberOfNotCommittedMissedEvents
				BLX		R7
				LDR		R7,_Mainscreen_NumberOfMissedEvents
				LDR		R0,[R7]
				BL		_get_mem_ptr

				;LDR 	R0,[R6,#32]

				STRB	R0,[R6,#0xD]	
				POP		{R1-R7,PC}

; ----------------------------------------------------------------------

_get_mem_ptr	LDR		R6,free_ram_dword_
				; LDR		R6,[R6]
				BX		LR

; ----------------------------------------------------------------------

_set_illumination
				PUSH	{R1,R7,LR}
				MOV		R1,#1
				MOV		R3,#0x28
				MOV		R7,#8 ; SetIllumination
				BL		_funclib
				POP		{R1,R7,PC}

; ----------------------------------------------------------------------	

_get_illumination_state_by_law
				LDR		R0,_ram_illumination_data
				LDR		R0,[R0]
				ADD		R0,#0x94  ; +94: What OS thinks is state of Illumination On/Off
				LDRB	R0,[R0] 
				BX		LR


; ----------------------------------------------------------------------	


_set_illumination_state_to_law
				PUSH	{R0-R7,LR}			
			 	BL		_get_illumination_state_by_law 
		   	    MOV		R7,R0
		   	    MOV		R2,R7
		   	    MOV		R0,#0 ; screen
		   	    BL		_set_illumination
		   	    MOV		R2,R7
		   	    MOV		R0,#1 ; kpl
		   	    BL		_set_illumination
		   	    POP		{R0-R7,PC}
		   	    
; ----------------------------------------------------------------------	

_illumination_toggler
				PUSH	{LR}
				BL		_get_mem_ptr
						
				BL		_get_illumination_state_by_law
				CMP		R0,#0
				BEQ		_illu_togg_ok
			
				BL		_get_accu_icon
				CMP		R0,#0 ; booting?
				BNE		_illu_togg_x
							
_illu_togg_ok	LDRB	R2,[R6,#8] ; Brightness-Toggler, msste man boolsch machen, falls Profilwechsel/Brightnesswechsel
				MOV		R1,#60 ; brightness
				SUB		R0,R1,R2
				STRB	R0,[R6,#8]
				MOV		R0,#1 ; output device
				MOV		R1,#1
				MOV		R3,#0x28
				MOV		R7,#8 ; SetIllumination
				BL		_funclib
_illu_togg_x	POP		{PC}
		
; -----------------------------------------------------------


_get_net_online
				LDR		R0,_ram_net_online
				LDRB	R0,[R0]
				BX		LR
				
; -----------------------------------------------------------------------------

_get_accu_icon	LDR		R0,_ram_mainscreen_accu_icon_ 
				LDR		R0,[R0] ; base address mainscreen state
				LDRH	R0,[R0,#4]
				BX		LR

profile_key								DCD	47 ; 0101111
GetNumberOfNotCommittedMissedEvents		DCD 0xA163A08F
_Mainscreen_NumberOfMissedEvents		DCD 0xA867C860
_ram_mainscreen_accu_icon_				DCD 0xA1633D0C
_ram_illumination_data					DCD 0xA12265F8
_ram_net_online							DCD	0xA863D124
FunctionLibrary							DCD	0xA0FC0000	   	    
free_ram_dword_							DCD	0xA8000230

; choose one of: 0=patch off, 1=patch on, 2=patch on only when illu should be off
; and add with one of those: 64=kurze boot-effects, 128=lange booteffects
profiles	

 END
 
 
 
 
 
pattern			MOV		R1,#0x90 ; not #90!
				STRB	R1,[R6,#0xB] ; NumberBlinker Remainder
				MOV		R1,#0xB
				STRB	R1,[R6,#0xC] ; Numberblinker Step
				BL		number_blinker_loop