; Iconbar Addition 3.2 masterpatch
; x65 M65v50 (c) benj9


number_of_plugin_icon_engines	EQU	2

						AREA ARMex, CODE, READONLY  

						EXPORT	iconbar_start				
						IMPORT	mp_Bufferizer
						IMPORT	v01_RamLS
						IMPORT	v02_RamNetCH
						IMPORT	f064_GetVibraStatus
						IMPORT	f002_GetProfile
						IMPORT	f039_AddIconToIconbar
						IMPORT	f081_GetNetMode
						IMPORT	f035_DrawImg
						IMPORT	f037_DrawCanvas
						IMPORT	f022_sPrintf
						IMPORT	f017_OpenReadCloseFile
						IMPORT	f058_mfree_high
						IMPORT	f033_GetImgHeight
						IMPORT	f034_GetImgWidth
						IMPORT	f105_LockSched
						IMPORT	f106_UnLockSched
						IMPORT	v14_RamNetOnline
						IMPORT	f092_GetCPUClock
						IMPORT	f093_GetCPULoad
						IMPORT	f004_dwMODdw



max_plugin_ptc			EQU	4 ; maximum possible ptc name of plugin (e.g. 4 -> "00001C04.ptc")
stack_diff				EQU 4*4 + 2*4 ; main + sub PUSHs
					
; midlet ram data of 00001c00.ptc, built-in-ram, offsets of icons / xy position in midlet ram

builtinAnimaCounter 	EQU 01 ; temp. animation counter
builtinPermits 			EQU 02 ; permit bits for all standard icons
builtinMiniGpsTmpFlag 	EQU 03 ; temp. mini-gps flag
builtinAnimaProfiles	EQU 04 ; byte profile store
builtinChargeIco1 		EQU 08
builtinVibraIco0 		EQU 16
builtinProfileIco1st 	EQU 24
builtinNetmodeIcoSrchLo EQU 28
builtinNetmodeIcoSrchHi EQU 36
builtinNetmodeIcoPhone 	EQU 32
builtinNetmodeIcoSMS 	EQU 40
builtinNetmodeSemiIdle 	EQU 44
builtinNetmodeIdle 		EQU 48
builtinNetmodeXY 		EQU 52
builtinAnimaXY 			EQU 56
builtinAnimaIco1st 		EQU 60
builtinMiniGpsBuffer 	EQU 68 ; temp. buffer pointer for open
builtinMiniGpsBuffer2	EQU 72 ; temp. buffer 8 bytes
builtinMiniGpsXY 		EQU 80
builtinMiniGpsString 	EQU 82
builtinCpuLoadXY		EQU 114
builtinCpuLoad1st		EQU 116


; midlet ram data of 00001c0x.ptc, plugin-in-ram, offsets

pluginFocusLoadType		EQU 01
pluginXY				EQU	02
pluginFocusAddr			EQU	08 ; dword
pluginFocusUseAsPtr		EQU	04
pluginFocusOffset		EQU	05
pluginConditionDir		EQU	06
pluginValuePermit		EQU	07
pluginValueFirst		EQU 12 ; 8 x dword
pluginValueIconFirst	EQU 44 ; 8 x dword

		
						CODE16
						
						DCB		"IconbAdd33,benj9"
					
; ========================================================================================
	
						ENTRY
						
iconbar_start			PUSH	{R3, R4, R6, LR}

						
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
						
iconbar_builtin			BL		f105_LockSched
						LDR		R0,_id
						BL		mp_Bufferizer
						BEQ		iconbar_plugin
						
						MOV		R4, #0
						
iconbar_builtin_loop	BL		builtin_icons
						ADD		R4, #1
						CMP		R4, #6 ; number of standard engines - 1
						BLE		iconbar_builtin_loop
						
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		
iconbar_plugin			LDR		R3,_id
						MOV		R4, #0

iconbar_plugin_loop		ADD		R4, #1
						CMP		R4, #max_plugin_ptc
						BGT		iconbar_x
						
						ADD		R0, R3, R4
						PUSH	{R3, R4}
						BL		mp_Bufferizer
						POP		{R3, R4}
						BEQ		iconbar_plugin_loop
						
						BL		plugin_icons
						
						B 		iconbar_plugin_loop
						
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
					
iconbar_x				BL		f106_UnLockSched
						LDR		R7, repatch_1 ; repatch
						BLX		R7
						LDR		R7, repatch_2 ; repatch
						BLX		R7
						POP		{R3, R4, R6, R7}
						ADD		R7, #4
						CMP		R0, #0 ; repatch
						BX		R7

					
; ========================================================================================	

builtin_icons			PUSH	{R4, LR} ; ; input: R4= module bit number {2.? cb engage}
						LDRB	R1, [R6, #builtinPermits] ; {2.? cb engage}
						LSR		R1, R4
						MOV		R2, #1
						AND		R1, R2
						BEQ		__exit0
						
						LSL		R4, #1
						ADD		PC, R4
						
__exit0					POP		{R4, PC}

						B		builtin_profiles
						B		builtin_charging
						B		builtin_vibra
						B		builtin_netmode
						B		builtin_animation
						B		builtin_cpuload
						B		builtin_minigps
						
; -----------------------------------------------------------------------------------	

builtin_charging		BL		v01_RamLS

						LDRB	R0, [R7] ; 0: no charging. 1+2: charging. 3: full
						CMP		R0 ,#0
						BEQ		__exit0
						
						SUB		R0, #1
						LSR		R0, #1
						LSL		R0, #2
						ADD		R0, #builtinChargeIco1 ; {4 i iconCharge}{8 i iconFull}
						
						B		builtin_vibra_x

; -----------------------------------------------------------------------------------	
					
builtin_vibra			BL		f064_GetVibraStatus
							
						LSL		R0, #2
						ADD		R0, #builtinVibraIco0 ; offset of icons in midlet ram {12 i iconNoVibra } {16 i iconVibra} 
						
builtin_vibra_x			MOV		R4, #0 ; no xy position
						B		__geticon

; -----------------------------------------------------------------------------------	
					
builtin_profiles		BL		f002_GetProfile
						
						LDR		R1, [R6, #builtinProfileIco1st] ; {20 i iconFirst}
						ADD		R1, R0
						
						B		__iconbar
						
; -----------------------------------------------------------------------------------

builtin_netmode			BL		f081_GetNetMode
						MOV		R1, #0
						ADR		R2, __builtin_netmode_modes
						ADR		R3, __builtin_netmode_icons
							
builtin_netmode_loop	LDRB	R4, [R2, R1]
						CMP		R0, R4
						BLE		builtin_netmode_snap
						
						ADD		R1, #1
						CMP		R1, #8 ; number of __builtin_netmode_modes data bytes
						BLT		builtin_netmode_loop
																	
builtin_netmode_snap	LDRB	R0, [R3, R1] ; offset to icon in midlet ram
						MOV		R4, #builtinNetmodeXY  ; offset of xy-pos choice in midlet ram
						B		__geticon

; -----------------------------------------------------------------------------------		

builtin_animation		BL		f002_GetProfile
						LDRB	R1, [R6, #builtinAnimaProfiles]
						LSR		R1, R0
						MOV		R0, #1
						AND		R1, R0
						BEQ		__exit
						
						LDRB	R3, [R6, #builtinAnimaCounter] 
						LDR		R0, [R6, #builtinAnimaIco1st] ; {56 i `first icon` v=31}
						LDR		R2, [R6, #builtinAnimaIco1st + 4] ; {60 i `last icon` v=36}
						ADD		R1, R0, R3
						CMP		R1, R2
						BLE		builtin_animation_le
						
						MOV		R1, R0
						MOV		R3, #0
						
builtin_animation_le	ADD		R3, #1
										
builtin_animation_sto	STRB	R3, [R6, #builtinAnimaCounter] ; hidden animation counter
						MOV		R4, #builtinAnimaXY ; num xy position
						B		__draw	
									
; -----------------------------------------------------------------------------------

builtin_cpuload			BL		f093_GetCPULoad
						MOV		R1, R0
						BEQ		builtin_cpuload_1
						
						SUB		R1,#1

builtin_cpuload_1		MOV		R0, #10
						BL		f004_dwMODdw

						
						LDR		R1, [R6, #builtinCpuLoad1st]
						ADD		R1, R0
						
						MOV		R4, #builtinCpuLoadXY ; num xy position
						B		__draw	
						
; -----------------------------------------------------------------------------------

builtin_minigps			BL		v14_RamNetOnline
						LDRB	R7, [R7]
						CMP		R7, #0
						BEQ		__exit
						
builtin_minigps_run		SUB		SP, #0x30
						MOV		R2, #0xFF
						STRB	R2, [R6, #builtinMiniGpsTmpFlag] ; hidden temp minigps flag
						
						BL		v02_RamNetCH
						LDRH	R3, [R7, #2] ; CID
builtin_minigps_1		LDRH	R2, [R7, #4] ; LAC
						
						STR		R2, [SP]
						ADD		R0, SP, #4
						MOV		R1, R6
						ADD		R1, #builtinMiniGpsString ; {-- s miniGPS maxlen=31 value=`0:\\Misc\\gps\\%i\\%i-%i.tmo`}
						BL		f022_sPrintf
						
						ADD		R0, SP, #4
						MOV		R1, R6
						ADD		R1, #builtinMiniGpsBuffer ; string buffer ptr
						BL		f017_OpenReadCloseFile
						BMI		builtin_minigps_2nd
						
						LDR		R0, [R6, #builtinMiniGpsBuffer] ; string buffer ptr
						
						LDRH	R1, [R0] ; string len
						CMP		R1, #0
						BEQ		builtin_minigps_2nd
						
						ADD		R0, #2 ; string starts ptr +2
						SUB		R1, #1
						LSL		R1, #1 ; cause of unicode double byte format "bb 00"
						MOV		R2, #0
						
builtin_minigps_lp1		CMP		R2, R1
						BGT		builtin_minigps_2nd
						
						LDRB	R3, [R0, R2]
						ADD		R2, #2 ; 2er steps cause unicode 2 bytes format
						CMP		R3, #0xA ; line feed
						BNE		builtin_minigps_lp1

						LDRB	R3, [R0, R2]
						CMP		R3, #0xA ; line feed
						BNE		builtin_minigps_2nd
						
						MOV		R4, R6
						ADD		R4, #builtinMiniGpsBuffer2  ; 8 bytes for icon number as chars
						MOV		R7, R4
						ADD		R2, #2	
						
						MOV		R3, R2 
						ADD		R3, #14 ; max 8 chars (8-1)*2
						CMP		R3, R1
						BGE		builtin_minigps_lp2
						
						MOV		R1, R3 ; correct lenght

builtin_minigps_lp2		LDRB	R3, [R0, R2] ; load the char numbers
						STRB	R3, [R7] ; store them in buffer
						ADD		R7, #1
						ADD		R2, #2
						CMP		R2, R1
						BLE		builtin_minigps_lp2

						MOV		R0, #1 ; power
						MOV		R3, #0 ; sum = icon
						MOV		R2, #10 ; power factor
						
builtin_minigps_ch2int	SUB		R7, #1
						LDRB	R1, [R7]
						SUB		R1, #0x30 ; ascii to machine
						MUL		R1, R0 ; power up
						ADD		R3, R1
						MUL		R0, R2
						CMP		R7, R4
						BGT		builtin_minigps_ch2int
			
builtin_minigps_final	LDR		R0, [R6, #builtinMiniGpsBuffer] ; string buffer ptr
						BL		f058_mfree_high
						ADD		SP, #0x30
						MOV		R1, R3 ; icon
builtin_minigps_final1	MOV		R4, #builtinMiniGpsXY ; {?? xy `position (off=iconbar)`}
						
						B		__draw
						
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

										
builtin_minigps_2nd		LDRB	R3, [R6, #builtinMiniGpsTmpFlag] ; hidden temp minigps flag
						CMP		R3, #0xFF
						BEQ		builtin_minigps_2nd_1
						
						LDR		R0, [R6, #builtinMiniGpsBuffer] ; string buffer ptr
						BL		f058_mfree_high
						ADD		SP, #0x30
						B		__exit

builtin_minigps_2nd_1	MOV		R3, #0
						STRB	R3, [R6, #builtinMiniGpsTmpFlag] ; hidden temp minigps flag
						BL		v02_RamNetCH
						B		builtin_minigps_1
						
; -----------------------------------------------------------------------------------
					
__geticon				LDR		R1, [R6, R0] ; get icon
						CMP		R1, #0 ; ignore if zero
						BEQ		__exit				

__draw					; input: R4=icon/xy-midlet-position ; 
						CMP		R4, #0 ; no xy-pos choice
						BEQ		__iconbar
						
						LDRB	R2, [R6, R4]; {?? xy `position (off=iconbar)`}
						ADD		R4, #1
						LDRB	R3, [R6, R4]; {??+1 xy `position (off=iconbar)`}
						
						CMP		R2, #0xFF
						BNE		__static
						
						CMP		R3, #0xFF
						BNE		__static
						
__iconbar				ADD		R2, SP, #0x18 + stack_diff ; MainscreenIcon context
						MOV		R0, R5 ; MainscreenIcon context
						BL		f039_AddIconToIconbar	
						
__exit					POP		{R4, PC}
												
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

__static				SUB		SP, #12
						STR		R1, [SP, #8] ; save icon
						
						MOV		R0, R1
						BL		f033_GetImgHeight
						LDRB	R3, [R6, R4]; {??+1 xy `position (off=iconbar)`}
						ADD		R3, R0 ; ypos + height

						MOV		R0, #1						
						STR		R0, [SP, #4] ; canvas: standard value
						SUB		R3, #1
						STR     R3, [SP] ; canvas: y-bottom
						
						LDR		R0, [SP, #8] ; icon
						BL		f034_GetImgWidth
						SUB		R4, #1
						LDRB	R3, [R6, R4]; {?? xy `position (off=iconbar)`}				
						ADD		R3,  R0 ; xpos + width
						SUB		R3, #1 ; canvas: x-right
						
						MOV		R1, R2 ; canvas: x-left
						ADD		R4, #1
						LDRB	R2, [R6, R4]; canvas: y-left
						
						LDR     R0, [SP, #0x14 + stack_diff + 12 ] ; mainscreen context: 0x14.
						BL		f037_DrawCanvas	
						
						LDRB	R1, [R6, R4]; drawimg: y-left
						SUB		R4, #1
						LDRB	R0, [R6, R4] ; drawimg: x-left
						LDR		R2, [SP, #8] ; icon
						BL		f035_DrawImg
						
						ADD		SP, #12
						B		__exit
													
						
; ========================================================================================	

plugin_icons			PUSH	{R4, LR}
				
						LSL		R4, #2

						LDR		R7, [R6, #pluginFocusAddr] 
						CMP		R7, #0
						BPL		__exit
						
						LDRB	R0, [R6, #pluginFocusUseAsPtr]
						CMP		R0, #0
						BEQ		plugin_icons_load
						
						LDR		R7, [R7]
						CMP		R7, #0
						BPL		__exit

						LDRB	R0, [R6, #pluginFocusOffset]	
						ADD		R7, R0
						
plugin_icons_load		LDRB	R1, [R6, #pluginFocusLoadType]
						CMP		R1, #1
						BLT		plugin_icons_load_b
						BEQ		plugin_icons_load_h
						
plugin_icons_load_d		LDR		R7, [R7]
						B		plugin_icons_preloop
						
plugin_icons_load_h		LDRH	R7, [R7]
						B		plugin_icons_preloop
						
plugin_icons_load_b		LDRB	R7, [R7]

plugin_icons_preloop	LDRB	R0, [R6, #pluginValuePermit]
						MOV		R4, #0

plugin_icons_loop		CMP		R4, #7 * 4
						BEQ		plugin_icons_else
						
						MOV		R1, #1
						AND		R1, R0
						BEQ		plugin_icons_loop_x
						
						LDRB	R1, [R6, #pluginConditionDir]
						BL		_plugin_value
						BEQ		plugin_icons_snapped 

plugin_icons_loop_x		LSR		R0, #1
						ADD		R4, #4
						B		plugin_icons_loop


plugin_icons_else		MOV		R1, #1
						AND		R1, R0
						BEQ		__exit
						
						MOV		R1,#0 ; condition direction. 0=eq, 1=le, 2=ge
						BL		_plugin_value
						BEQ		__exit ; NOT this value
						

plugin_icons_snapped	MOV		R0, #pluginValueIconFirst ; R3 + pluginValueIconFirst: first icon
						ADD		R0, R4
						MOV		R4, #pluginXY
						B		__geticon

; -----------------------------------------------------------------------------------	

_plugin_value			; input R1:  condition direction. 0=eq, 1=le, 2=ge
						
						MOV		R2, #pluginValueFirst ; first  value
						ADD		R2, R4 
						LDR		R2, [R6, R2] 
						CMP		R1, #1 ; input R1:  condition direction. 0=eq, 1=le, 2=ge
						BEQ		_plugin_value_le
						BGT		_plugin_value_ge

_plugin_value_equal		CMP		R7, R2 ; focus byte snapped?
						BX		LR
						
_plugin_value_le		CMP		R7, R2 ; focus byte snapped?
						BLE		_plugin_value_true
						B		_plugin_value_false
						
_plugin_value_ge		CMP		R7, R2 ; focus byte snapped?
						BGE		_plugin_value_true

_plugin_value_false		MOV		R2, #0
						B		_plugin_value_test

_plugin_value_true		MOV		R2, #1				

_plugin_value_test		CMP		R2,#1
						BX		LR ; outputs condition bits
											
; ========================================================================================						

						ALIGN

						; '<=' : SearchLow, Phone, SearchHi, SMS, SearchHi, SemiIdle, Idle
__builtin_netmode_modes	DCB		5, 6, 8, 9, 0xf, 0x12, 0x13, 0xff
						; according icons in midlet (builtin) ram:
__builtin_netmode_icons	DCB		builtinNetmodeIcoSrchLo, builtinNetmodeIcoPhone
						DCB		builtinNetmodeIcoSrchHi, builtinNetmodeIcoSMS
						DCB 	builtinNetmodeIcoSrchHi, builtinNetmodeSemiIdle
						DCB		builtinNetmodeIdle, builtinNetmodeIcoSrchHi

; ========================================================================================				
	
repatch_1				DCD 0xA164FDF8 
repatch_2				DCD 0xA165033C ; CheckHomezoneStatus1

						DCD	0,0,0xB1C2D3E4
_id						DCD	0x00001c00, 0, 0

       				
        END  
       