import javax.microedition.lcdui.*;

public class ColorSelector extends Canvas implements Runnable {

	static Font mfont = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_BOLD, Font.SIZE_SMALL);
	static int w, h;

	static String[] NAMES = { "R", "G", "B", "A" };
	static int[] COLORS = { 0xff2020, 0x00ff00, 0x4848ff, 0xa0a0a0 };

	Displayable DS;
	Graphics G;
	Widget CW;
	int val;
	int cpos;

	int dy;
	int timer;
	boolean exit;

	public ColorSelector(Patch p, Widget cw) {

		super();
		DS = Master.D.getCurrent();
		CW = cw;
		w = getWidth();
		h = getHeight();
		val = cw.value;
		cpos = 0;

		exit = false;
		(new Thread(this)).start();
		Master.D.setCurrent(this);

	}

	protected void paint(Graphics g) {

		g.setColor(0xffffff);
		g.fillRect(0, 0, w, h);
		g.setFont(mfont);

		int cl = (val & (int)0xff00ff00);
		cl |= ((val & 0xff) << 16);
		cl |= ((val & 0xff0000) >> 16);
		g.setColor(0);
		g.setStrokeStyle(g.SOLID);
		g.drawRect(w-18, 2, 15, 15);
		g.setColor(cl);
		g.fillRect(w-16, 4, 12, 12);
		String s = Integer.toHexString((cl << 8) | (cl >>> 24)).toUpperCase();
		while (s.length() < 8) s = "0".concat(s);
		g.setColor(0x800000);
		g.drawString(s, 2, 2, g.TOP|g.LEFT);

		for (int i=0; i<4; i++) {
			int cv = (val >> (i * 8)) & 0xff;
			int px = (i+1)*(w/5);
			int py = h - 20;
			int ph = h - 52;
			int ps = (ph*cv)/255;
			g.setColor(0);
			g.setStrokeStyle(g.SOLID);
			g.fillRect(px-2, py-ph, 5, ph);
			g.drawString(NAMES[i], px, py+2, g.TOP|g.HCENTER);
			g.setColor(COLORS[i]);
			g.fillRect(px-2, py-ps, 5, ps);
			if (cpos == i) {
				g.setColor(0);
				g.setStrokeStyle(g.DOTTED);
				g.drawRect(px-7, py-ph-5, 15, 5+ph+15);
			}
		}

	}

	protected void keyPressed(int key) {

		switch (key) {

			case -59:
			case '2':
				timer = 7;
				dy = 1;
				movePoint();
				break;

			case -60:
			case '8':
				timer = 7;
				dy = -1;
				movePoint();
				break;

			case -61:
			case '4':
				cpos -= 1; if (cpos < 0) cpos = 3;
				repaint();
				break;

			case -62:
			case '6':
				cpos += 1; if (cpos > 3) cpos = 0;
				repaint();
				break;

			case -26:
			case -4:
			case '5':
				CW.value = val;
				exit = true;
				Master.D.setCurrent(DS);
				break;

			case -12:
			case '0':
				exit = true;
				Master.D.setCurrent(DS);
				break;

		}

	}

	protected void keyReleased(int key) {

		dy = 0;

	}

	public void run() {

		while (! exit) {

			try { Thread.sleep(35); } catch (Exception e) { }
			if (--timer > 0) continue;
			movePoint();
			movePoint();

		}

	}

	private void movePoint() {

		if (dy == 0) return;
		int cv = (val >> (cpos * 8)) & 0xff;
		cv = (cv + dy) & 0xff;
		val = (val & ~(0xff << (cpos * 8))) | (cv << (cpos * 8));
		repaint();

	}

}
