import java.io.UnsupportedEncodingException;

public class Ptc {

	public static char[] HEXCHARS = (new String("0123456789abcdef")).toCharArray();

	public int id;
	public byte[] buffer;
	public boolean initialized;

	protected Ptc(int xid, byte[] xbuffer, boolean initz) {

		id = xid;
		buffer = xbuffer;
		initialized = initz;

	}

	public static boolean isEnabled(int id) {

		try {
			String fname = ptcname(id);
			if (! AFile.exists(fname)) return false;
			AFile F = AFile.open(fname);
			byte[] b = new byte[1];
			F.read(b, 0, 1);
			F.close();
			return ((b[0] & 0x80) != 0);
		}
		catch (Exception e) {
			return false;
		}

	}

	public static Ptc read(int id, int ram) {

		byte[] buff = null;
		boolean initz = false;
		if (ram == 0) ram = 1;

		try {

			String fname = ptcname(id);
			if (! AFile.exists(fname)) {
				initz = false;
			} else {
				AFile F = AFile.open(fname);
				int len = F.length();
				if (len == 0) {
					initz = false;
				} else {
					if (len < ram) len = ram;
					buff = new byte[len];
					F.read(buff, 0, len);
					initz = true;
				}
				F.close();
			}

		}
		catch (Exception e) { }

		if (buff == null) buff = new byte[ram];
		Ptc ptc = new Ptc(id, buff, initz);
		return ptc;

	}

	public void save() {

		try {
			String fname = ptcname(id);
			AFile F = AFile.open(fname);
			F.write(buffer, 0, buffer.length);
			F.close();
			initialized = true;
		}
		catch (Exception e) {
			Master.D.setCurrent(new Msg(e, Master.D.getCurrent()));
		}

	}

	public int getInt(Tag t) {

		int i = t.offset;
		expand(i+4);
		if (! initialized) {
			return (t.index == -1) ? t.getInt("value") : t.getInt("value", t.index);
		}
		int r = buffer[i] & 0xff;
		r |= (buffer[i+1] & 0xff) << 8;
		r |= (buffer[i+2] & 0xff) << 16;
		r |= (buffer[i+3] & 0xff) << 24;

		return r;

	}

	public void setInt(Tag t, long val) throws Exception {

		int i = t.offset;
		expand(i+4);
		long[] ai = t.getRange();
		long n = val;
		if (n < ai[0] || n > ai[1]) {
			throw new Exception(Msg.BETWEEN + "\n" + ai[0] + " " + Msg.AND + " " + ai[1]);
		}
		buffer[i] = (byte)(n & 0xff);
		buffer[i+1] = (byte)((n >> 8) & 0xff);
		buffer[i+2] = (byte)((n >> 16) & 0xff);
		buffer[i+3] = (byte)((n >> 24) & 0xff);

	}

	public short getShort(Tag t) {

		int r;
		int i = t.offset;
		expand(i+2);
		if (! initialized) {
			r = (t.index == -1) ? t.getInt("value") : t.getInt("value", t.index);
		} else {
			r = (buffer[i] & 0xff);
			r |= (buffer[i+1] & 0xff) << 8;
		}

		return (short)r;

	}

	public void setShort(Tag t, long val) throws Exception {

		int i = t.offset;
		expand(i+2);
		long[] ai = t.getRange();
		long n = val;
		if (n < ai[0] || n > ai[1]) {
			throw new Exception(Msg.BETWEEN + "\n" + ai[0] + " " + Msg.AND + " " + ai[1]);
		}
		buffer[i] = (byte)(n & 0xff);
		buffer[i+1] = (byte)((n >> 8) & 0xff);

	}

	public int getBits(Tag t) {

		int i = t.offset;
		expand(i+1);
		if (! initialized) {
			return (t.index == -1) ? t.getInt("value") : t.getInt("value", t.index);
		}

		return (buffer[i] >> t.bitshift) & t.bitmask;

	}

	public void setBits(Tag t, int val) throws Exception {

		int i = t.offset;
		expand(i+1);
		long[] ai = t.getRange();
		if (ai[1] > 255) ai[1] = 255;
		long n = (long)val;
		if (n < ai[0] || n > ai[1]) {
			throw new Exception(Msg.BETWEEN + "\n" + ai[0] + " " + Msg.AND + " " + ai[1]);
		}
		buffer[i] &= ~(t.bitmask << t.bitshift);
		buffer[i] |= (byte)((n & t.bitmask) << t.bitshift);

	}

	public int[] getXY(Tag t) {

		int i = t.offset;
		expand(i+2);
		int[] r = new int[2];
		if (! initialized) {
			r[0] = t.getInt("x");
			r[1] = t.getInt("y");
			return r;
		}

		r[0] = (buffer[i] & 0xff);
		r[1] = (buffer[i+1] & 0xff);
		return r;

	}

	public void setXY(Tag t, int[] val) throws Exception {

		int i = t.offset;
		expand(i+2);
		buffer[i] = (byte)val[0];
		buffer[i+1] = (byte)val[1];

	}

	public int[] getXY2(Tag t) {

		int i = t.offset;
		expand(i+4);
		int[] r = new int[2];
		if (! initialized) {
			r[0] = t.getInt("x");
			r[1] = t.getInt("y");
			return r;
		}

		r[0] = (buffer[i] & 0xff);
		r[0] |= (buffer[i+1] & 0xff) << 8;
		r[1] = (buffer[i+2] & 0xff);
		r[1] |= (buffer[i+3] & 0xff) << 8;
		return r;

	}

	public void setXY2(Tag t, int[] val) throws Exception {

		int i = t.offset;
		expand(i+4);
		buffer[i] = (byte)(val[0] & 0xff);
		buffer[i+1] = (byte)((val[0] >> 8) & 0xff);
		buffer[i+2] = (byte)(val[1] & 0xff);
		buffer[i+3] = (byte)((val[1] >> 8) & 0xff);

	}

	public String getString(Tag t) {

		int i = t.offset;
		int maxl = t.maxlen;
		if (maxl == 0) maxl = 15;
		expand(i+maxl+1);
		if (! initialized) {
			String s = t.getString("value");
			return (s == null) ? "" : s;
		}
		int ii = i;
		while (ii-i < maxl && buffer[ii] != 0) ii++;

		try {
			return new String(buffer, i, ii-i, "utf-8");
		} catch (UnsupportedEncodingException e) {
			return new String(buffer, i, ii-i);
		}

	}

	public void setString(Tag t, String val) throws Exception {

		int i = t.offset;
		int maxl = t.maxlen;
		if (maxl == 0) maxl = 15;
		expand(i+maxl+1);
		for (int j=0; j<=maxl; j++) buffer[i+j] = 0;
		byte[] b = val.getBytes("utf-8");
		if (val.length() > maxl) {
			throw new Exception(Msg.TOOLONG);
		}
		if (b.length > maxl) {
			throw new Exception(Msg.UTOOLONG);
		}
		System.arraycopy(b, 0, buffer, i, b.length);

	}

	public String getUstring(Tag t) {

		int i = t.offset;
		int maxl = t.maxlen;
		if (maxl == 0) maxl = 15;
		expand(i+maxl*2+2);
		if (! initialized) {
			String s = t.getString("value");
			return (s == null) ? "" : s;
		}

		char[] cc = new char[maxl];
		int l;
		for (l=0; l<maxl; l++) {
			char c = (char)((buffer[i+l*2] & 0xff) | ((buffer[i+l*2+1] & 0xff) << 8));
			if (c == 0) break;
			cc[l] = c;
		}

		return new String(cc, 0, l);

	}

	public void setUstring(Tag t, String val) throws Exception {

		int i = t.offset;
		int maxl = t.maxlen;
		if (maxl == 0) maxl = 15;
		expand(i+maxl*2+2);
		for (int j=0; j<=maxl*2; j++) buffer[i+j] = 0;
		char[] cc = val.toCharArray();
		for (int j=0; j<cc.length && j<maxl; j++) {
			buffer[i+j*2] = (byte)(cc[j] & 0xff);
			buffer[i+j*2+1] = (byte)((cc[j] >> 8) & 0xff);
		}
	}

	public String getHex(Tag t) {

		int i = t.offset;
		int maxl = t.maxlen / 2;
		if (maxl == 0) maxl = 1;
		expand(i+maxl);
		if (! initialized) {
			String s = t.getString("value");
			try {
				if (s == null) throw new Exception();
				parsehex(s);
				return s;
			}
			catch (Exception e) {
				return "00";
			}
		}
		return byte2hex(buffer, i, maxl);

	}

	public void setHex(Tag t, String s) throws Exception {

		int i = t.offset;
		int maxl = t.maxlen / 2;
		if (maxl == 0) maxl = 1;
		expand(i+maxl);
		for (int j=0; j<maxl; j++) buffer[i+j] = 0;
		byte[] hb = parsehex(s);
		if (hb != null && hb.length > 0) {
			System.arraycopy(hb, 0, buffer, i, hb.length);
		}

	}

	public String getAddr(Tag t) {

		int i = t.offset;
		expand(i+4);
		if (! initialized) {
			String s = t.getString("value");
			try {
				if (s == null) throw new Exception();
				if (s == "NULL") return s;
				parsehex(s);
				return s;
			}
			catch (Exception e) {
				return "NULL";
			}
		}
		byte[] tb = new byte[4];
		tb[0] = buffer[i+3];
		tb[1] = buffer[i+2];
		tb[2] = buffer[i+1];
		tb[3] = buffer[i];
		String r = byte2hex(tb, 0, 4);
		if (r.equals("00000000")) r = "NULL";
		return r;

	}

	public void setAddr(Tag t, String s) throws Exception {

		int i = t.offset;
		expand(i+4);
		for (int j=0; j<4; j++) buffer[i+j] = 0;
		if (s.length() == 0) return;
		if (s.equals("0") || s.equals("00000000") || s.toUpperCase().equals("NULL")) return;
		byte[] hb = parsehex(s);
		int a = (hb[0] & 0xff);
		if (a < 0xa0 || a > 0xa8 || (a > 0xa3 && a < 0xa8))
			throw new Exception(Msg.ANOTVALID);
		if (hb != null && hb.length > 0) {
			buffer[i] = hb[3];
			buffer[i+1] = hb[2];
			buffer[i+2] = hb[1];
			buffer[i+3] = hb[0];
		}

	}

	public void setData(int offset, byte[] data, int len) throws Exception {

		expand(offset+len);
		System.arraycopy(data, 0, buffer, offset, len);

	}

	public static String ptcname(int id) {

		String s = Integer.toHexString(id);
		while (s.length() < 8) s = "0" + s;
		return Master.PATCHDIR + "\\" + s + ".ptc";

	}

	private byte[] parsehex(String s) throws Exception {

		if (s.length() == 0) return new byte[0];
		char[] cc = s.toUpperCase().toCharArray();
		if ((cc.length & 1) != 0) {
			throw new Exception(Msg.ODDHEX);
		}
		byte[] bb = new byte[cc.length / 2];

		for (int i=0; i<cc.length; i+=2) {
			char c1 = (char)(cc[i] - 0x30); if (c1 > 9) c1 -= 7;
			char c2 = (char)(cc[i+1] - 0x30); if (c2 > 9) c2 -= 7;
			if (c1 < 0 || c2 < 0 || c1 > 15 || c2 > 15) {
				throw new Exception(Msg.WRONGHEX);
			}
			bb[i/2] = (byte)((c1 << 4) | c2);
		}

		return bb;

	}

	private String byte2hex(byte[] bb, int pos, int len) {

		char[] cc = new char[len*2];

		for (int i=0; i<len; i++) {
			cc[i*2] = HEXCHARS[(bb[pos+i] >> 4) & 0xf];
			cc[i*2+1] = HEXCHARS[bb[pos+i] & 0xf];
		}

		return new String(cc);

	}

	private void expand(int l) {

		if (buffer.length < l) {

			byte[] oldbuffer = buffer;
			buffer = new byte[l];
			System.arraycopy(oldbuffer, 0, buffer, 0, oldbuffer.length);

		}

	}

}
