import javax.microedition.lcdui.*;
import java.io.*;

public class Msg extends Form implements CommandListener {

	public static final int MAXMSG = 64;

	public static String ON_OFF;
	public static String OK;
	public static String CANCEL;
	public static String ABOUT;
	public static String EXIT;
	public static String INFO;
	public static String OPEN;
	public static String SELECT;
	public static String VARIANTS;
	public static String CLRCONF;
	public static String CLRALL;
	public static String CANTOPEN;
	public static String CANTOPEN2;
	public static String ERREAD;
	public static String ERREAD2;
	public static String PROGNAME;
	public static String TITLE;
	public static String NAME;
	public static String VERSION;
	public static String CLRCFGFOR;
	public static String CLRALLCFGS;
	public static String NONE;
	public static String UNKOPT;
	public static String INVINT;
	public static String INVTIME;
	public static String BETWEEN;
	public static String AND;
	public static String TOOLONG;
	public static String UTOOLONG;
	public static String ANOTVALID;
	public static String ODDHEX;
	public static String WRONGHEX;
	public static String THISDIR;
	public static String PLAY;
	public static String VIEW;
	public static String STOP;
	public static String BACK;
	public static String CHOOSEDIR;
	public static String CHOOSEFILE;
	public static String PLAYING;
	public static String PROFILES;
	public static String NORMAL;
	public static String QUIET;
	public static String NOISY;
	public static String CARKIT;
	public static String HEADSET;
	public static String PROFILE6;
	public static String PROFILE7;

	Displayable ND;

	private static boolean loadLang(String lang) {

		try {
			InputStream is = lang.getClass().getResourceAsStream("/messages/" + lang + ".txt");
			byte[] b = new byte[16384];
			int len = is.read(b, 0, b.length);
			String S = new String(b, 0, len, "utf-8");
			b = null;
			is.close();
			is = null;

			int p = 0;
			String[] ss = new String[MAXMSG];
			for (int i=0; i<MAXMSG; i++) {
				int pp = S.indexOf('\n', p);
				if (pp != -1) {
					ss[i] = S.substring(p, pp).trim();
					p = pp + 1;
				} else {
					ss[i] = S.substring(p).trim();
					break;
				}
			}

			int n = 0;

			ON_OFF = ss[n++];
			OK = ss[n++];
			CANCEL = ss[n++];
			ABOUT = ss[n++];
			EXIT = ss[n++];
			INFO = ss[n++];
			OPEN = ss[n++];
			SELECT = ss[n++];
			VARIANTS = ss[n++];
			CLRCONF = ss[n++];
			CLRALL = ss[n++];
			CANTOPEN = ss[n++];
			CANTOPEN2 = ss[n++];
			ERREAD = ss[n++];
			ERREAD2 = ss[n++];
			PROGNAME = ss[n++];
			TITLE = ss[n++];
			NAME = ss[n++];
			VERSION = ss[n++];
			CLRCFGFOR = ss[n++];
			CLRALLCFGS = ss[n++];
			NONE = ss[n++];
			UNKOPT = ss[n++];
			INVINT = ss[n++];
			INVTIME = ss[n++];
			BETWEEN = ss[n++];
			AND = ss[n++];
			TOOLONG = ss[n++];
			UTOOLONG = ss[n++];
			ANOTVALID = ss[n++];
			ODDHEX = ss[n++];
			WRONGHEX = ss[n++];
			THISDIR = ss[n++];
			PLAY = ss[n++];
			VIEW = ss[n++];
			STOP = ss[n++];
			BACK = ss[n++];
			CHOOSEDIR = ss[n++];
			CHOOSEFILE = ss[n++];
			PLAYING = ss[n++];
			PROFILES = ss[n++];
			NORMAL = ss[n++];
			QUIET = ss[n++];
			NOISY = ss[n++];
			CARKIT = ss[n++];
			HEADSET = ss[n++];
			PROFILE6 = ss[n++];
			PROFILE7 = ss[n++];
			
			return true;
			
		}
		catch (Exception e) {
			return false;
		}
		
	}
	
	static {
	
		String lang = System.getProperty("microedition.locale");
		if (! loadLang(lang)) {
			loadLang("en");
		}
		
	}
	
	public Msg(String s, Displayable d) {
	
		super("Message");
		
		this.append(s);
		this.addCommand(new Command((d == null) ? "Exit" : "OK", Command.BACK, 0));
		this.setCommandListener(this);
		
		ND = d;
		
	}
	
	public Msg(Exception e, Displayable d) {
	
		super("Exception");
		
		String s = e.getMessage();
		if (s == null || s.length() == 0) s = e.toString();
		
		this.append(s);
		this.addCommand(new Command((d == null) ? "Exit" : "OK", Command.BACK, 0));
		this.setCommandListener(this);

		ND = d;

	}

	public void commandAction(Command c, Displayable d) {

		if (ND != null) {
			Master.D.setCurrent(ND);
		} else {
			Master.quit();
		}

	}

}



