import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

public class Master extends MIDlet implements CommandListener, Runnable {

	public static final String ABOUT = Msg.PROGNAME + "\n(c) Chaos\nV0.96beta";
	public static final String PATCHDIR = "0:\\Misc\\Patches\\ptc";
	public static final String CONFIGNAME = "configs.txt";

	public static Master M;
	public static Display D;
	public static List GL;

	public static Command CMD_ENABLE = new Command(Msg.ON_OFF, Command.OK, 1);
	public static Command CMD_INFO = new Command(Msg.INFO, Command.HELP, 2);
	public static Command CMD_CLEAR = new Command(Msg.CLRCONF, Command.CANCEL, 3);
	public static Command CMD_CLEARALL = new Command(Msg.CLRALL, Command.CANCEL, 4);
	public static Command CMD_CANCEL = new Command(Msg.CANCEL, Command.BACK, 0);
	public static Command CMD_ABOUT = new Command(Msg.ABOUT, Command.HELP, 5);
	public static Command CMD_EXIT = new Command(Msg.EXIT, Command.BACK, 6);

	public static Image imgEN, imgDIS;

	public Patch[] P;
	public int npatches;

	public static char[] charset = new char[256];
	public static int timeout = 0;

	public Master()
	{
		M = this;
		D = Display.getDisplay(this);

		for (int i=0; i<0xc0; i++) charset[i] = (char)i;
		for (int i=0xc0; i<0x100; i++) charset[i] = (char)(i+0x350);		
	}

	public void startApp()
	{
		try {

			imgEN = Image.createImage("/images/enabled.png");
			imgDIS = Image.createImage("/images/disabled.png");

			String config = loadConfig();        
			preparse(config);
			config = null;
			System.gc();

			(new Thread(this)).start();

		}
		catch (Exception e) {

			D.setCurrent(new Msg(e, null));

		}

	}

	public void pauseApp()
	{
	}

	public void destroyApp(boolean flag)
	{
	}

	public static void quit()
	{
		System.getProperty("MPJCCONF");
		M.notifyDestroyed();
	}


	private String loadConfig() throws Exception {

		String fname = PATCHDIR + "\\" + CONFIGNAME;
		AFile F = null;
		if (AFile.exists(fname)) {
			F = AFile.open(fname);
		}
		if (F == null) throw new Exception(Msg.CANTOPEN + " " + CONFIGNAME + ". " + Msg.CANTOPEN2);

		int len;
		byte[] data = new byte[256];
		char[] cdata = new char[256];
		String res = "";
		while ((len = F.read(data, 0, 256)) > 0) {

			int j=0;
			for (int i=0; i<len; i++) {
				if (data[i] != 0x0d) cdata[j++] = charset[data[i] & 0xff];
			}
			res += new String(cdata, 0, j);

		}
		if (res.length() < 5) {
			throw new Exception(Msg.ERREAD + " " + CONFIGNAME + ". " + Msg.ERREAD2);
		}
		F.close();

		return res;

	}

	private void preparse(String cfg) throws Exception {

		P = new Patch[256];
		npatches = 0;

		GL = new List(Msg.TITLE, List.IMPLICIT);
		GL.addCommand(CMD_ENABLE);
		GL.addCommand(CMD_INFO);
		GL.addCommand(CMD_CLEAR);
		GL.addCommand(CMD_CLEARALL);
		GL.addCommand(CMD_ABOUT);
		GL.addCommand(CMD_EXIT);
		GL.setCommandListener(this);

		int len = cfg.length();
		int pos = 0;

		while (pos < len) {

			Tag t = Tag.next(cfg, pos);
			if (t == null) break;
			pos = t.end;

			if (t.tag.equals("patch") || t.tag.equals("p")) {

				t.parse();

				String patchname = t.name;
				if (patchname == null) continue;

				String ver = t.getString("version");
				if (ver == null) ver = t.getString("ver");
				if (ver == null) ver = "0";

				String cpy = t.getString("copyright");
				if (cpy == null) cpy = t.getString("cp");

				int ram = t.getInt("memory");
				if (ram == 0) ram = t.getInt("mem");

				String pf = t.getString("profiles");
				if (pf == null) pf = t.getString("pf");
				if (pf == null) pf="y";
				pf = pf.toLowerCase();

				Patch p = new Patch(patchname, ver, cpy, ram, pf.equals("y"), cfg, t.end+1);
				p.id = -1;
				try {
					p.id = (int)Long.parseLong(t.getString("id"), 16);
				}
				catch (Exception e) { }

				p.enabled = Ptc.isEnabled(p.id);

				int i;
				for (i=0; i<npatches; i++) {
					if (patchname.compareTo(P[i].name) < 0) break;
				}
				if (i < npatches) System.arraycopy(P, i, P, i+1, npatches-i);
				P[i] = p;
				npatches++;

			}

		}

		for (int i=0; i<npatches; i++) {

			Patch p = P[i];
			p.index = GL.append(p.name, p.enabled ? imgEN : imgDIS);

		}

		if (npatches == 0) {
			throw new Exception(Msg.ERREAD2);
		}

		D.setCurrent(GL);

	}

	private void clearConfig(int id) {


		try {
			if (id == 0) {
				String[] ss = AFile.list(PATCHDIR);
				for (int j=0; j<ss.length; j++) {
					if (ss[j].toLowerCase().endsWith(".ptc")) {
						try { AFile.delete(PATCHDIR + "\\" + ss[j]); } catch (Exception e) { }
					}
				}
			} else {
				try { AFile.delete(Ptc.ptcname(id)); } catch (Exception e) { }
			}

			String config = loadConfig();
			preparse(config);

		}
		catch (Exception ee) { }

	}


	public void commandAction(Command c, Displayable d) {

		timeout = 0;

		try {

			int i = GL.getSelectedIndex();
			String text = GL.getString(i);
			Patch p = null;
			for  (int j=0; j<npatches; j++) {
				if (P[j].index == i) {
					p = P[j];
					break;
				}
			}
			if (p == null) return;
			String cfg = p.body;

			switch (c.getCommandType()) {

				case Command.SCREEN:

					Form f = p.buildMenu();
					D.setCurrent(f);
					break;

				case Command.OK:

					p.buildMenu();
					p.buildPtc();
					Ptc ptc = p.getPtc();
					if (p.enabled) {
						p.setEnabled(false);
						GL.set(i, text, imgDIS);
					} else {
						p.setEnabled(true);
						GL.set(i, text, imgEN);
					}
					ptc.save();
					p.cleanup();
					break;

				case Command.CANCEL:

					if (d == GL) {
						String s = (c == CMD_CLEAR) ? Msg.CLRCFGFOR + " " + p.name + "?" : Msg.CLRALLCFGS;
						Alert A = new Alert("Clear config", s, null, null);
						A.addCommand(c);
						A.addCommand(CMD_CANCEL);
						A.setCommandListener(this);
						D.setCurrent(A);
					} else {
						clearConfig((c == CMD_CLEAR) ? p.id : 0);
					}
					break;

				case Command.HELP:

					if (c == CMD_ABOUT) {
						D.setCurrent(new Msg(ABOUT, GL));
						break;
					}

					String s = "";
					int j = 0;
					while (j < cfg.length()) {
						Tag t = Tag.next(cfg, j);
						if (t == null) break;
						if (t.tag.equals("patch")) break;
						if (t.tag.equals("info")) {
							t.parse();
							s = t.name;
							if (s == null) s = "";
							break;
						}
						j = t.end;
					}
					p.info = s;
					D.setCurrent(new Msg(p.getInfo(), GL));
					break;

				case Command.BACK:

					if (d == GL) {
						Master.quit();
					} else {
						D.setCurrent(GL);
					}
					break;

			}
		}
		catch (Exception e) {

			D.setCurrent(new Msg(e, GL));

		}

	}

	public void run() {

		while (++timeout < 300) {
			try { Thread.sleep(1000); } catch (Exception e) { }
		}
		quit();

	}

}
