/* ==========================================================================
   : def_code.c
   : Turbo C 2.0
   ᠭ: ⥪  ⮬᪮ । ஢ ⥪
             (ALT, WIN, KOI). 㭪 m_def_code -  ,  ⥪
              , 㭪 f_def_code -  ⥪  䠩.
   ᠭ ⬠: http://ivr.webzone.ru/articles/defcod_2/
   (c)  騭, ᪢, 2004.
 ========================================================================= */

#include <stdio.h>

/*  ६ */

static int len_;
static unsigned char *p_;
static FILE *f_;

/*  ⠭ */

static unsigned char table_2s[128]={0xFF,0xFF,0xFF,0xC7,0xFE,0xBE,0xF7,0xFB,
 0xFD,0xBF,0xF7,0xF9,0xFC,0xBE,0xF1,0x80,0xFF,0xFF,0xF7,0xBB,0xFF,0xFF,0xFF,
 0xCF,0xDE,0xBF,0xD1,0x08,0xFF,0xBF,0xF1,0xBF,0xFF,0xFF,0xFF,0xC7,0x1D,0x3F,
 0x7F,0x81,0xA7,0xB6,0xF2,0x82,0xFF,0xFF,0x75,0xDB,0xFC,0xBF,0xD7,0x9D,0xFF,
 0xAE,0xFB,0xDF,0xFF,0xFF,0xFF,0xC7,0x84,0xB7,0xF3,0x9F,0xFF,0xFF,0xFF,0xDB,
 0xFF,0xBF,0xFF,0xFF,0xFD,0xBF,0xFF,0xFF,0xFF,0xFF,0xE7,0xC7,0x84,0x9E,0xF0,
 0x12,0xBC,0xBF,0xF0,0x84,0xA4,0xBA,0x10,0x10,0xA4,0xBE,0xB8,0x88,0xAC,0xBF,
 0xF7,0x0A,0x84,0x86,0x90,0x08,0x04,0x00,0x00,0x03,0x7F,0xFD,0xF7,0xC1,0x7D,
 0xAE,0x6F,0xCB,0x15,0x3D,0xFC,0x00,0x7F,0x7D,0xE7,0xC2,0x7F,0xFD,0xF7,0xC3};

/* =========================================================================
   ᯮ⥫쭠 㭪 alt2num.
   室: a -  ᪮ 㪢  ஢ ALT.
   室: 浪  ⮩ 㪢 (0-31).
 ========================================================================= */

static int alt2num (int a)
{
 if (a>=0xE0) a-=0x30;
 return (a&31);
}

/* =========================================================================
   ᯮ⥫쭠 㭪 koi2num.
   室: a -  ᪮ 㪢  ஢ KOI.
   室: 浪  ⮩ 㪢 (0-31).
 ========================================================================= */

static int koi2num (int a)
{
 static unsigned char t[32]={30,0,1,22,4,5,20,3,21,8,9,10,11,12,13,14,15,31,
  16,17,18,19,6,2,28,27,7,24,29,25,23,26};

 return (t[a&31]);
}

/* =========================================================================
   ᯮ⥫쭠 㭪 work_2s - ࠡ⪠ 㪢 ⠭.
   室:  1 - 浪  ࢮ 㪢 (0-31),
          c2 - 浪  ன 㪢 (0-31),
          check -   ஢, 砫  ⠭ ࠭
                  (1 - , 0 - ),
          buf -  ᨢ  ଠ樥  祭 ⠭.
   室: 0 - 㪠 ⠭ 㦥 砫 ࠭,
          1 - ⠭  砫 ࠭   ⨬,
          2 - ⠭  砫 ࠭   ⨬.
 ========================================================================= */

static int work_2s (int c1, int c2, int check, unsigned char buf[128])
{
 int i=(c1<<2)+(c2>>3); /*    ᨢ. */
 int mask=0x80>>(c2&7); /* ᪠, ᮮ⢥    . */

 /* ᫨ check=1, ஢塞: ᫨ ᮮ⢥騩  ᨢ buf ࠢ 0,
    , 㪠 ⠭ 㦥 砫 ࠭.  室 
    㭪樨,  0. ᫨  ⠭  砫,  砥, 
     ⨫ (塞 ᮮ⢥騩  ᨢ buf). */

 if (check==1)
 {
  if ((buf[i]&mask)==0) return (0);
  buf[i]&=~mask;
 }

 /* ஢塞, ⨬ ⠭  . */

 if ((table_2s[i]&mask)!=0) return (1); /* ⨬. */
 return (2);                            /* ⨬. */
}

/* =========================================================================
   ᯮ⥫쭠 㭪 def_code - । ஢ ⥪. 㭪樨
   m_def_code  f_def_code -  ன  ⮩ 㭪樥.
   室:  get_char - 㪠⥫  㭪,   뢠  祭
                     । ᨬ ⥪. 㭪   
                      ᨬ, ,  ⨦  ⥪, -1.
          n - ⢮ ࠧ ⠭ ᪨ 㪢 (1-255), ண
              筮  । ஢.
   室: 0 - ⥪  ஢ ALT, 1 - WIN, 2 - KOI.
 ========================================================================= */

static int def_code (int (*get_char)(), int n)
{
 /*  ᨢ buf_1 ࠭ ଠ  ⮬,  ⠭ ᪨ 㪢
    㦥 砫  ਠ ALT,   ᨢ buf_2 -  ਠ WIN. */

 unsigned char buf_1 [128];
 unsigned char buf_2 [128];

 int bad_1=0;
 int bad_2=0;
 int bad_3=0;
 int all_1=0;
 int all_3=0;  /* all_2=all_3 */

 int c1; int c2=0; /*  ⥪饣 ࠡ뢠 ⠭. */
 int i;

 /* 樠 buf_1  buf_2. */

 for (i=0;i<128;i++) buf_1[i]=0xFF;
 for (i=0;i<128;i++) buf_2[i]=0xFF;

 /*  横 - ࠡ⪠ ⠭     ਠ⮢. 
    믮,    ⥪   -  ਠ⮢ 
     n ⠭. */

 while (((c1=c2,c2=(*get_char)())!=-1)&&(all_1<n)&&(all_3<n))
 {
  /* ਠ ALT. 砫 ஢塞,   ᨬ ⥪饣 ⠭
      ᪨ 㪢  ஢ ALT. */

  if ((((c1>=0x80)&&(c1<0xB0))||((c1>=0xE0)&&(c1<0xF0)))&&
      (((c2>=0x80)&&(c2<0xB0))||((c2>=0xE0)&&(c2<0xF0))))
  {
   switch (work_2s(alt2num(c1),alt2num(c2),1,buf_1)) /* ࠡ⠫. */
   {
    case 2: bad_1++;
    case 1: all_1++;
   }
  }
  /* ਠ WIN  KOI. 砫 ஢塞,   ᨬ ⥪饣
     ⠭  ᪨ 㪢   ஢ (  ஢
       ᪨ 㪢 ᮢ). */

  if ((c1&c2)>=0xC0) /* ⭮ ᫮ (c1>=0xC0)&&(c2>=0xC0). */
  {
   switch (work_2s(c1&31,c2&31,1,buf_2)) /* ࠡ⠫. */
   {
    case 0: continue; /* ᫨ ⠭ 㪢 㦥 砫  ਠ WIN,
                           㦥 砫   ਠ KOI, ⠪ 
                         ய᪠ ࠡ ਠ KOI  室
                          ᫥饩 樨  横. */
    case 2: bad_2++;
   }

  /* ᫨ ⠭ 㪢   砫  ਠ WIN,   
      砫   ਠ KOI, ⮬ ᯥ樠쭮 ஢  
      - , 㭪 work_2s 뢠  ࠬ஬ check, ࠢ 0. */

   switch (work_2s(koi2num(c1),koi2num(c2),0,NULL)) /* ࠡ⠫. */
   {
    case 2: bad_3++;
    case 1: all_3++;
   }
  }
 }

 /*  ᮡ࠭. , ᫨  -  ਠ⮢ ⨬
    ⠭   1/32  饣  ᫠,  ⠥,    
    뫮. */

 if (bad_1<=(all_1>>5)) bad_1=0;
 if (bad_2<=(all_3>>5)) bad_2=0;
 if (bad_3<=(all_3>>5)) bad_3=0;

 /* 砥 १. */

 {
  unsigned int a=((255-bad_1)<<8)+all_1;
  unsigned int b=((255-bad_2)<<8)+all_3;
  unsigned int c=((255-bad_3)<<8)+all_3;

  if ((a>=b)&&(a>=c)) return (0);
  if (b>=c) return (1); else return (2);
 }
}

/* =========================================================================
   ᯮ⥫쭠 㭪 m_get_char 뢠  㭪樨 def_code, 
    맢  m_def_code.
   室: । ᨬ ⥪  -1, ᫨ ⥪ 稫.
 ========================================================================= */

static int m_get_char()
{
 if (len_==0) return (-1);
 len_--;
 return (*(p_++));
}

/* =========================================================================
   㭪 m_def_code - । ஢ ⥪, 室饣  .
   室:  p -  ⥪,
          len -  ⥪,
          n - ⢮ ࠧ ⠭ ᪨ 㪢 (1-255), ண
              筮  । ஢.
   室: 0 - ⥪  ஢ ALT, 1 - WIN, 2 - KOI.
 ========================================================================= */

int m_def_code (unsigned char *p, int len, int n)
{
 /* ᢠ 祭  ६ len_  p_,  
    㯭  㭪樨 m_get_char. */
 len_=len;
 p_=p;
 /* 砥 १. */
 return (def_code(&m_get_char,n));
}

/* =========================================================================
   ᯮ⥫쭠 㭪 f_get_char 뢠  㭪樨 def_code, 
    맢  f_def_code.
   室: । ᨬ ⥪  -1, ᫨ ⥪ 稫.
 ========================================================================= */

static int f_get_char()
{
 int a=fgetc(f_);
 if (a==EOF) return (-1);
 return (a);
}

/* =========================================================================
   㭪 f_def_code - । ஢ ⥪, 室饣  䠩.
   室:  f - 㪠⥫  , 易  䠩 (㪠⥫ ⥪饩
              樨  䠩  㪠뢠  砫 䠩),
          n - ⢮ ࠧ ⠭ ᪨ 㪢 (1-255), ண
              筮  । ஢.
   室: 0 - ⥪  ஢ ALT, 1 - WIN, 2 - KOI.
 ========================================================================= */

int f_def_code (FILE *f, int n)
{
 /* ᢠ 祭 쭮 ६ f_,  㤥 㯭
     㭪樨 f_get_char. */
 f_=f;
 /* 砥 १. */
 return (def_code(&f_get_char,n));
}
