#include "..\inc\swilib.h"
#include <stdbool.h>
#include "..\inc\playsound.h"

#define NO_SOUND 0x80000000
#define NEED_BEEP 0;

int main(WSHDR **ptr) {//ptr[0]=descr, ptr[1]=place
 char place[21];// ""  20 
 IPC_REQ *ipc_multisim;

 ws_2str(ptr[1], place, sizeof(place)-1);
 if (place[0]!='.')//    ...
  return NO_SOUND;//...     

 GBS_SendMessage(MMI_CEPID, KEY_DOWN, RIGHT_SOFT);//   -,        ". ."

 ipc_multisim=(IPC_REQ*)((char*)GetBuffer(0x4401)+4);//ipc_multisim ->  RAM   ,  
 if ((int)ipc_multisim==4)// ?
  return NO_SOUND;//,    

 bool needShutdown=false, needTime=false, needExec=false;
 unsigned profile=0, sim=0xFF, vibra=0, alert=0xFF, tmp, a;
 char *p=place+1;

 while (*p) {
  switch ((*p)|0x20) {
  case 'a':
   if (!(*(++p)))// ?..
    goto l_perform_actions;//... 
   tmp=*p;
   if (tmp>'9')
    tmp=(tmp&0xDF)-7;
   tmp-='0';
   if (!(*(++p)))// ?..
    goto l_perform_actions;//... 
   if (tmp<=15)
    a=tmp<<4;
   else
    continue;
   tmp=*p;
   if (tmp>'9')
    tmp=(tmp&0xDF)-7;
   tmp-='0';
   if (tmp<=15)
    alert=a|tmp;
   break;
  case 'z':
   needShutdown=true;
   break;
  case 't':
   needTime=true;
   break;
  case 'v':
   if (!(*(++p)))// ?..
    goto l_perform_actions;//... 
   tmp=*p;
   if (tmp>'9')
    tmp=(tmp&0xDF)-7;
   tmp-='0';
   if (tmp<=15)//  -  (15 - 1 )
    vibra=tmp;
   break;
  case 'p':
   if (!(*(++p)))// ?..
    goto l_perform_actions;//... 
   tmp=*p-'0';
   if (tmp>0 && tmp<=8)
    profile=tmp;
   break;
  case 's':
   if (!(*(++p)))// ?..
    goto l_perform_actions;//... 
   tmp=*p;
   if (tmp>'9')
    tmp=(tmp&0xDF)-7;
   tmp-='0';
   if (tmp<=10)//  - 
    sim=tmp;
   break;
  case 'x':
   needExec=true; p++;
   goto l_perform_actions;//   -  
  }
  p++;
 }

l_perform_actions:

 if (profile!=0)
  SetProfile(profile-1);

 unsigned ret;
 if (IsCalling()) {
  ret=NEED_BEEP;//   
 }
 else {//    . !
  ret=NO_SOUND;

  SetIllumination(0, 1, 0, 50);//  
  SetIllumination(1, 1, 0, 50);//  

  if (alert<0xFF)
   PlaySound(VOLUME_ORGANISER, MMI_CEPID, 0, alert, 0);

  if (vibra>0)
   PlaySoundLoop(0x2F, 1, vibra);

  if (needTime)
   SpellTime();
 }

 if (sim!=0xFF) {
  ipc_multisim->name_to="MultiSim";
  ipc_multisim->name_from="AppEx";
  ipc_multisim->data=(void*)sim;
  GBS_SendMessage(MMI_CEPID, MSG_IPC, 1, ipc_multisim);
 }

 if (needExec) {
  if (*p!='*') {//x0:\... -    ""
   if (*p) {
    int len=strlen(p)+1;
    WSHDR *ws=AllocWS(len<<1);
    str_2ws(ws, p, len);
    ExecuteFile(ws, NULL, NULL);
    FreeWS(ws);
   }
  }
  else {//x* -    ""
   ExecuteFile(ptr[0], NULL, NULL);
  }
 }

 if (needShutdown)
  SwitchPhoneOff();

 return ret;
}
