#include "..\inc\swilib.h"

#define TMR_SECOND 216

extern void kill_data(void *p, void (*func_p)(void *));
extern void srand(unsigned int);
extern int rand(void);
#define iNumOfColors 5 //  
#define iNumOfRows 9//  (9   )


int m_iNumOfRows;     //    
int m_iNumOfColors;   //  
int m_iNumOfPoints;   // 
int m_iNumOfBalls;    //   
int cur_x=0;
int cur_y=0;

int m_iBallSize; //   (0  1)
int x0, y0; //   

GBSTMR tmr;

int m_field[iNumOfRows][iNumOfRows];  //,   
// m_field   .   ,   ,    1  7 -    (      ).

    
    
#pragma inline
void patch_header(HEADER_DESC* head)
{
  head->rc.x=0;
  head->rc.y=YDISP;
  head->rc.x2=ScreenW()-1;
  head->rc.y2=HeaderH()+YDISP;
}

#pragma inline
void patch_rect(RECT* rc)
{
  rc->x=0;
  rc->y=YDISP;
  rc->x2=ScreenW()-1;
  rc->y2=ScreenH()-1;
}

typedef struct
{
  CSM_RAM csm;
  int gui_id;
}MAIN_CSM;

typedef struct
{
  GUI gui;
  WSHDR *ws1;
}MAIN_GUI;



void ElfKiller(void)
{
  extern void *ELF_BEGIN;
  kill_data(&ELF_BEGIN,(void (*)(void *))mfree_adr());
}

void SetField(int x, int y, int iColor);


void OnTimer(void) 
{
  // TODO: Add your message handler code here and/or call default
  m_iBallSize=!m_iBallSize;
  REDRAW();
  GBS_StartTimerProc(&tmr,TMR_SECOND/2,OnTimer);
}

void Delete5InLine(int x1, int y1, int x2, int y2)
{
  // 5 ,   
  //  (x1, y1)   (x2, y2).
  int i;
  //  
  if(y1==y2){
    for(i=x1;i<=x2;i++){
      SetField(i,y1,0);
    }
  }
  
  //  
  if(x1==x2){
    for(i=y1;i<=y2;i++){
      SetField(x1,i,0);
    }
  }
  
  //   - - -
  if((x1<x2) && (y1<y2)){
    for(i=x1;i<=x2;i++){
      SetField(i,y1-x1+i,0);
    }
  }
  
  //   - - -
  if((x1>x2) && (y1<y2)){
    for(i=y1;i<=y2;i++){
      SetField(x1+y1-i,i,0);
    }
  }
}
        
int CalcPoints(int iNumDeletedBalls)
{
  int iRes;
  if(iNumDeletedBalls<5){
    return 0;
  }
  else{
    iRes = 2* iNumDeletedBalls*iNumDeletedBalls-20*iNumDeletedBalls+60;
  }
  return iRes;
}

int Is5InLine(int x, int y, int bAddPoints){
  //,   5    
  //int x1=x, y1=y;//  ,   ..
  int i;//   (x, y)
  int bSeeFuther;//  
  
  //  , ,   
  int iO=0, iW=0, iN=0, iS=0;
  //  -, -, -  
  int iNO=0, iNW=0, iSO=0, iSW=0;
  int bRes =0;// 
  
  // 
  bSeeFuther=1;
  i=1;
  while((x+i<iNumOfRows) && bSeeFuther){//   
    bSeeFuther=0;
    if(m_field[x+i][y]==m_field[x][y]){//      (x,y)
      iO++;//   
      bSeeFuther=1;
    }
    i++;
  };
  
  // 
  bSeeFuther=1;
  i=1;
  while((x-i>=0) && bSeeFuther){//   
    bSeeFuther=0;
    if(m_field[x-i][y]==m_field[x][y]){//      (x,y)
      iW++;//   
      bSeeFuther=1;
    }
    i++;
  };
  
  // 
  bSeeFuther=1;
  i=1;
  while((y+i<iNumOfRows) && bSeeFuther){//   
    bSeeFuther=1;
    if(m_field[x][y+i]==m_field[x][y]){//      (x,y)
      iS++;//   
      bSeeFuther=1;
    }
    i++;
  }
  
  // 
  bSeeFuther=1;
  i=1;
  while((y-i>=0) && bSeeFuther){//   
    bSeeFuther=0;
    if(m_field[x][y-i]==m_field[x][y]){//      (x,y)
      iN++;//   
      bSeeFuther=1;
    }
    i++;
  }

    ///////////// /////////////
  
  // -
  bSeeFuther=1;
  i=1;
  //    
  while((x+i<iNumOfRows) && (y+i<iNumOfRows) && bSeeFuther){
    bSeeFuther=0;
    if(m_field[x+i][y+i]==m_field[x][y]){//      (x,y)
      iSO++;//    
      bSeeFuther=1;
    }
    i++;
  };
    
  // -
  bSeeFuther=1;
  i=1;
  while((x-i>=0) && (y-i>=0) && bSeeFuther){//    
    bSeeFuther=0;
    if(m_field[x-i][y-i]==m_field[x][y]){//      (x,y)
      iNW++;//    
      bSeeFuther=1;
    }
    i++;
  };
  
  // -
  bSeeFuther=1;
  i=1;
  while((x+i<iNumOfRows) && (y-i>=0) && bSeeFuther){//    
    bSeeFuther=0;
    if(m_field[x+i][y-i]==m_field[x][y]){//      (x,y)
      iNO++;//   
      bSeeFuther=1;
    }
    i++;
  };
  
  // -
  bSeeFuther=1;
  i=1;
  while((x-i>=0) && (y+i<iNumOfRows) && bSeeFuther){//    
    bSeeFuther=0;
    if(m_field[x-i][y+i]==m_field[x][y]){//      (x,y)
      iSW++;//   
      bSeeFuther=1;
    }
    i++;
  };
  
  //,     
  int iWasNumOfBalls = m_iNumOfBalls;
  if(iS+iN+1>=5){// 5  
    ShowMSG(1,(int)"5    ");
    Delete5InLine(x,y-iN,x,y+iS); 
    bRes=1;
    //return true;
  }
  
  if(iO+iW+1>=5){// 5  
    ShowMSG(1,(int)"5    ");
    Delete5InLine(x-iW,y,x+iO,y);
    bRes=1;
    //return true;
  }

    
  // 5     - -
  if(iNW+iSO+1>=5){
    ShowMSG(1,(int)"5     - -");
    Delete5InLine(x-iNW,y-iNW,x+iSO,y+iSO);
    bRes=1;
    //return true;
  }
  
  // 5     - -
  if(iSW+iNO+1>=5){
    ShowMSG(1,(int)"5     - -");
    Delete5InLine(x+iNO,y-iSW,x-iNO,y+iSW);
    bRes=1;
    //return true;
  }
  
  if(bAddPoints){
    //( )
    m_iNumOfPoints+=CalcPoints(iWasNumOfBalls-m_iNumOfBalls);
  }
  return bRes;// 5  
}



int IsPath(int xFrom, int yFrom, int xTo, int yTo)
{
  int iField[iNumOfRows][iNumOfRows];
  for(int j=0;j<iNumOfRows;j++){
    for(int i=0;i<iNumOfRows;i++){
      iField[i][j]=m_field[i][j];
    }
  }
  
  int iMaxPathLength=iNumOfRows*iNumOfRows+1;
  iField[xFrom][yFrom]=-1;// 
  iField[xTo][yTo]=iMaxPathLength;// 
  
  int iNextSearch=-1;
  int bContSearch = 1;
  while(bContSearch){
    bContSearch=0;
    for(int j=0;j<iNumOfRows;j++){
      for(int i=0;i<iNumOfRows;i++){
        //    .
        if(iField[i][j]==iNextSearch){
          //   
          //  
          int bIsLeft=(i==0)?1:0;
          //  
          int bIsRight=(i==(iNumOfRows-1))?1:0;
          //  
          int bIsTop=(j==0)?1:0;
          //  
          int bIsButtom=(j==(iNumOfRows-1))?1:0;
          
          if(!bIsLeft){
            //   .
            if(iField[i-1][j]==iMaxPathLength){
              return 1;
            }
            if(iField[i-1][j]==0){//   
              iField[i-1][j]=iNextSearch-1;
              bContSearch = 1;
            }
          }
          
          if(!bIsRight){
            //   
            if(iField[i+1][j]==iMaxPathLength){
              return 1;
            }
            //   
            if(iField[i+1][j]==0){
              iField[i+1][j]=iNextSearch-1;
              bContSearch = 1;
            }
          }
          
          if(!bIsTop){
            //   .
            if(iField[i][j-1]==iMaxPathLength){
              return 1;
            }
            //   
            if(iField[i][j-1]==0){
              iField[i][j-1]=iNextSearch-1;
              bContSearch = 1;
            }
          }
          
          if(!bIsButtom){
            //   
            if(iField[i][j+1]==iMaxPathLength){
              return 1;
            }
            //   
            if(iField[i][j+1]==0){
              iField[i][j+1]=iNextSearch-1;
              bContSearch = 1;
            }
          }
        }
      }
    }
    iNextSearch--;
  };
  return 0;
}


void MoveBall(int xFrom, int yFrom, int xTo, int yTo){
  //    
  int iTmp;
  iTmp = m_field[xTo][yTo];
  SetField(xTo, yTo, m_field[xFrom][yFrom]);
  SetField(xFrom, yFrom, iTmp);
}

void SetField(int x, int y, int iColor)
{
  //   iColor
  m_field[x][y]=iColor;
  if (iColor>0 && iColor<8) m_iNumOfBalls++;  //     
  else m_iNumOfBalls--;  //     
  //SetModifiedFlag();//   
}
// m_iNumOfBalls      1,    ,     (iColor  )    (iColor  ).


int Throw3Balls(int iNum)
{
  int x, y;//,    
  int iColor; // 
  if(iNum!=0)
  {
    for(int i=0;i<iNum;i++)
    {
      //  
      do
      {
        x=rand()%m_iNumOfRows;
        y=rand()%m_iNumOfRows;
      }
      while(m_field[x][y]!=0);
      // 
      iColor=rand()%m_iNumOfColors+1;
      SetField(x,y,iColor); //   
      Is5InLine(x, y, 0);
    }
    return (1);
  }
  else
  {
    ShowMSG(1,(int)" !");
    return (0);
  }
}
// ==============================================================================================

#define MIN(a,b) a<b?a:b
void OnRedraw(MAIN_GUI *data)
{ 
  unsigned int scr_w=ScreenW();
  unsigned int scr_h=ScreenH();
  unsigned int color;
  int x_off;
  int y_off;
  int xy_size=(MIN(scr_w,scr_h))/m_iNumOfRows;
  x_off=((MIN(scr_w,scr_h))-xy_size*m_iNumOfRows)>>1;
  y_off=(scr_h-MIN(scr_w,scr_h))>20?20:scr_h-MIN(scr_w,scr_h);
  DrawRoundedFrame(0,YDISP,scr_w-1,scr_h-1,0,0,0,
		   GetPaletteAdrByColorIndex(0),
		   GetPaletteAdrByColorIndex(20));
  wsprintf(data->ws1,"%d balls, %d points", m_iNumOfBalls, m_iNumOfPoints);
  DrawString(data->ws1,3,3,scr_w-3,3+GetFontYSIZE(SMALL_FONT),SMALL_FONT,0,GetPaletteAdrByColorIndex(0),GetPaletteAdrByColorIndex(23));

  for (int x=0; x<=m_iNumOfRows; x++)
  {
    DrawLine(x_off+x*xy_size,y_off,x_off+x*xy_size,y_off+m_iNumOfRows*xy_size,1,GetPaletteAdrByColorIndex(0));
  }
  for (int y=0; y<=m_iNumOfRows; y++)
  {
    DrawLine(x_off,y_off+y*xy_size,x_off+m_iNumOfRows*xy_size,y_off+y*xy_size,1,GetPaletteAdrByColorIndex(0));
  }
  
  //    
  DrawRectangle(xy_size*cur_x+x_off,xy_size*cur_y+y_off,xy_size*cur_x+xy_size+x_off,xy_size*cur_y+xy_size+y_off,
                0,GetPaletteAdrByColorIndex(0),GetPaletteAdrByColorIndex(23));
  
  for(int j=0; j<m_iNumOfRows; j++)
  {
    for(int i=0; i<m_iNumOfRows; i++)
    {
      switch(m_field[i][j])
      {
      case 1:
        color=1;
        break;
          
      case 2:
        color=3;
        break;
        
      case 3:
        color=14;
        break;
        
      case 4:
        color=4;
        break;
        
      case 5:
        color=2;
        break;
        
      case 6:
        color=8;
        break;
        
      case 7:
        color=7;
        break;
        
      default:
        color=23;
        break;
      }
      if (m_iBallSize==1 && i==x0 && j==y0)
      {
        drawArc(xy_size*i+x_off+3,xy_size*j+y_off+3,xy_size*i+xy_size+x_off-3,xy_size*j+xy_size+y_off-3,360,360,
                0,GetPaletteAdrByColorIndex(23),GetPaletteAdrByColorIndex(color));        
      }
      else
      {
        drawArc(xy_size*i+x_off,xy_size*j+y_off,xy_size*i+xy_size+x_off,xy_size*j+xy_size+y_off,360,360,
                0,GetPaletteAdrByColorIndex(23),GetPaletteAdrByColorIndex(color));
      }
    
    
      
    }
  }

}


void OnCreate(MAIN_GUI *data, void *(*malloc_adr)(int))
{
  TTime tt;
  int n;
  data->ws1=AllocWS(256);

  m_iNumOfColors=7;//  (7 )
  m_iNumOfRows=9;
  GetDateTime(0, &tt);
  n=tt.param+tt.min*60+tt.hour*3600;
  srand(n%32000); //   
  
  Throw3Balls(5);//   .
  data->gui.state=1;
}

void OnClose(MAIN_GUI *data, void (*mfree_adr)(void *))
{
  FreeWS(data->ws1);
  data->gui.state=0;
}

void OnFocus(MAIN_GUI *data, void *(*malloc_adr)(int), void (*mfree_adr)(void *))
{
  DisableIDLETMR();
  data->gui.state=2;
}

void OnUnfocus(MAIN_GUI *data, void (*mfree_adr)(void *))
{
  if (data->gui.state!=2) return;
  data->gui.state=1;
}

void OnJClickUp(MAIN_GUI *data) 
{
  // TODO: Add your message handler code here and/or call default
  int x=cur_x;  //  
  int y=cur_y;  //  
  static int bMove;   //    

  if(m_field[x][y]!=0){//..    
     bMove=1;
     x0=x;//  
     y0=y;
     OnTimer();
  }
  else{//. .    
    if(bMove)
    {//  
      if(IsPath(x0, y0, x, y))
      {       //  ,    
                                      //. . ,    
        GBS_DelTimer(&tmr);
        MoveBall(x0, y0, x, y);
        bMove=0;
        //    
        if(!Is5InLine(x,y,1))
        {   //  ,
          //. . ,  ( )      
          //true- 
          //,    
          //  
          if(m_iNumOfRows*m_iNumOfRows-m_iNumOfBalls>=3){
            Throw3Balls(3);
          }
          else{
            Throw3Balls(m_iNumOfRows*m_iNumOfRows-m_iNumOfBalls);
          }
          //,      
          // ,   
          if(m_iNumOfRows*m_iNumOfRows==m_iNumOfBalls){
            
          }
        }
      }
    }
  }
    
    //    - 
    
}
int OnKey(MAIN_GUI *data, GUI_MSG *msg)
{

  DirectRedrawGUI();
  if (msg->gbsmsg->msg==KEY_DOWN || msg->gbsmsg->msg==LONG_PRESS)
  {
    switch(msg->gbsmsg->submess)
    {
    case '2':
    case UP_BUTTON:
      cur_y=cur_y-1<0?m_iNumOfRows-1:cur_y-1;
      break;
      
    case '4':
    case LEFT_BUTTON:
      cur_x=cur_x-1<0?m_iNumOfRows-1:cur_x-1;
      break;
      
    case '6':
    case RIGHT_BUTTON:
      cur_x=(cur_x+1)>=m_iNumOfRows?0:cur_x+1;
      break;
      
    case '8':
    case DOWN_BUTTON:
      cur_y=(cur_y+1)>=m_iNumOfRows?0:cur_y+1;
      break;
    }
    REDRAW();
  }
    
  if (msg->gbsmsg->msg==KEY_DOWN)
  {
    switch(msg->gbsmsg->submess)
    {
    case ENTER_BUTTON:
      OnJClickUp(data);
      REDRAW();
      return (-1);
    }
  }
  
  if (msg->gbsmsg->msg==KEY_DOWN)
  {
    switch(msg->gbsmsg->submess)
    {
    case LEFT_SOFT:
      break;

    case RIGHT_SOFT:
      return(1); 
      
    case GREEN_BUTTON:

      // TODO: add reinitialization code here
      // (SDI documents will reuse this document)
      m_iNumOfBalls=0; //    
      m_iNumOfPoints=0;//  ( )
      
      
      for(int j=0;j<m_iNumOfRows;j++){
        for(int i=0;i<m_iNumOfRows;i++){
          m_field[i][j]=0; //  
        }
      }
      Throw3Balls(5);
      break;
    }
  }
  
  return(-1);
}


int method8(void){return(0);}

int method9(void){return(0);}

const void * const gui_methods[11]={
  (void *)OnRedraw,	//Redraw
  (void *)OnCreate,	//Create
  (void *)OnClose,	//Close
  (void *)OnFocus,	//Focus
  (void *)OnUnfocus,	//Unfocus
  (void *)OnKey,	//OnKey
  0,
  (void *)kill_data, //method7,	//Destroy
  (void *)method8,
  (void *)method9,
  0
};

const RECT Canvas={0,0,0,0};

int maincsm_onmessage(CSM_RAM *data, GBS_MSG *msg)
{
  MAIN_CSM *csm=(MAIN_CSM*)data;
  if (msg->msg==MSG_GUI_DESTROYED)
  {
    if ((int)msg->data0==csm->gui_id)
    {
      csm->csm.state=-3;
    }
  }
  return(1);
}


void maincsm_oncreate(CSM_RAM *data)
{
  MAIN_GUI *main_gui=malloc(sizeof(MAIN_GUI));
  MAIN_CSM*csm=(MAIN_CSM*)data;
  zeromem(main_gui,sizeof(MAIN_GUI));
  patch_rect((void *)(&Canvas));
  main_gui->gui.canvas=(void *)(&Canvas);
  main_gui->gui.flag30=2;
  main_gui->gui.methods=(void *)gui_methods;
  main_gui->gui.item_ll.data_mfree=(void (*)(void *))mfree_adr();
  csm->csm.state=0;
  csm->csm.unk1=0;
  csm->gui_id=CreateGUI(main_gui);
}

void maincsm_onclose(CSM_RAM *csm)
{
  GBS_DelTimer(&tmr);
  SUBPROC((void *)ElfKiller);
}

unsigned short maincsm_name_body[140];
const int minus11=-11;
const struct
{
  CSM_DESC maincsm;
  WSHDR maincsm_name;
}MAINCSM =
{
  {
  maincsm_onmessage,
  maincsm_oncreate,
#ifdef NEWSGOLD
  0,
  0,
  0,
  0,
#endif
  maincsm_onclose,
  sizeof(MAIN_CSM),
  1,
  &minus11
  },
  {
    maincsm_name_body,
    NAMECSM_MAGIC1,
    NAMECSM_MAGIC2,
    0x0,
    139
  }
};

void UpdateCSMname(void)
{
  wsprintf((WSHDR *)(&MAINCSM.maincsm_name),"Lines");
}

int main(char *exename, char *fname)
{
  MAIN_CSM main_csm;
  LockSched();
  UpdateCSMname();
  CreateCSM(&MAINCSM.maincsm,&main_csm,0);
  UnlockSched();
  return (0);
}
