/*
 *  This Loader Module is written by Yury Haron
 *
 */

/*
        L O A D E R  for Java-classFile
*/

#include "../idaldr.h"
#include "../../module/java/classfil.hpp"
//--------------------------------------------------------------------------
//
//      check input file format. if recognized, then return 1
//      and fill 'fileformatname'.
//      otherwise return 0
//
int accept_file(linput_t *li, char fileformatname[MAX_FILE_FORMAT_NAME], int n)
{
  ulong  magic;
  ushort min_ver, maj_ver;

  if(n ||
     lread4bytes(li, &magic, 1) || magic != MAGICNUMBER ||
     lread2bytes(li, &min_ver, 1) || lread2bytes(li, &maj_ver, 1) ||
     maj_ver < CURRENT_MAJOR_VERSION || maj_ver > (CURRENT_MAJOR_VERSION+1))
          				                             return(0);

  qstrncpy(fileformatname, "JavaVM Class File", MAX_FILE_FORMAT_NAME);
  return(f_LOADER);
}

//--------------------------------------------------------------------------
//
//      load file into the database.
//
void load_file(linput_t *li, ushort neflag, const char * /*fileformatname*/)
{
  if(ph.id != PLFM_JAVA )
    set_processor_type("java", SETPROC_ALL|SETPROC_FATAL);
  if(ph.notify(ph.loader, li, (bool)(neflag & NEF_MAN)))
                    error("Internal error in loader<->module link");
}

//----------------------------------------------------------------------
bool idaapi init_loader_options(linput_t*)
{
  set_processor_type("java", SETPROC_ALL|SETPROC_FATAL);
  return true;
}

//----------------------------------------------------------------------
//
//      LOADER DESCRIPTION BLOCK
//
//----------------------------------------------------------------------
loader_t LDSC =
{
  IDP_INTERFACE_VERSION,
  0,                            // loader flags
//
//      check input file format. if recognized, then return 1
//      and fill 'fileformatname'.
//      otherwise return 0
//
  accept_file,
//
//      load file into the database.
//
  load_file,
//
//	create output file from the database.
//	this function may be absent.
//
  NULL,
//      take care of a moved segment (fix up relocations, for example)
  NULL,
//      initialize user configurable options based on the input file.
  init_loader_options,
};
