
# Create configuration files

!include "allmake.mak"

!ifndef	MAKE_ALL
all:	env
!endif

env:    w32vs.cfg w64vs.cfg

w32vs.cfg:     makeenv_vc.mak allmake.mak __vs.cfg
        $(CP) __vs.cfg $@
#       All warnings on
        @echo /W2       >>$@
w64vs.cfg:     makeenv_vc.mak allmake.mak __vs.cfg
        $(CP) __vs.cfg $@
#       All warnings on
        @echo /Wall     >>$@
#       warning C4018: '>=' : signed/unsigned mismatch
        @echo /wd4018   >>$@
#       warning C4061: enumerator 'xxx' in switch of enum 'yyy' is not explicitly handled by a case label
        @echo /wd4061   >>$@
#       warning C4127: conditional expression is constant
        @echo /wd4127   >>$@
#       warning C4146: unary minus operator applied to unsigned type, result still unsigned
        @echo /wd4146   >>$@
#       warning C4200: nonstandard extension used: zero-sized array in struct/union
        @echo /wd4200   >>$@
#       warning C4201: nonstandard extension used : nameless struct/union
        @echo /wd4201   >>$@
#       warning C4245: 'xxx' : conversion from 'a' to 'b', signed/unsigned mismatch
        @echo /wd4245   >>$@
#       warning C4310: cast truncates constant value
        @echo /wd4310   >>$@
#       warning C4389: '!=' : signed/unsigned mismatch
        @echo /wd4389   >>$@
#       warning C4512: 'xxx' : assignment operator could not be generated
        @echo /wd4512   >>$@
#       warning C4514: 'xxx' : unreferenced inline function has been removed
        @echo /wd4514   >>$@
#       warning C4611: interaction between '_setjmp' and C++ object destruction is non-portable
        @echo /wd4611   >>$@
#       warning C4619: pragma warning : there is no warning number 'xxx'
        @echo /wd4619   >>$@
#       warning C4625: 'xxx' : copy constructor could not be generated because a base class copy constructor is inaccessible
        @echo /wd4625   >>$@
#       warning C4626: 'xxx' : assignment operator could not be generated because a base class assignment operator is inaccessible
        @echo /wd4626   >>$@
#       warning C4640: 'p' : construction of local static object is not thread-safe
        @echo /wd4640   >>$@
#       warning C4668: 'xxx' is not defined as a preprocessor macro, replacing with '0' for '#if/#elif'
        @echo /wd4668   >>$@
#       warning C4710: 'xxx' : function not inlined
        @echo /wd4710   >>$@
#       warning C4800: 'BOOL' : forcing value to bool 'true' or 'false' (performance warning)
        @echo /wd4800   >>$@
#       warning C4820: 'xxx' : 'x' bytes padding added after member 'xxx'
        @echo /wd4820   >>$@
#       warning C4917: 'xxx' : a GUID can only be associated with a class, interface or namespace
        @echo /wd4917   >>$@
#       warning C4996: 'xxx' was declared deprecated
        @echo /wd4996   >>$@
#
        echo /D__AMD64__ >>$@

__vs.cfg:     makeenv_vc.mak allmake.mak
        $(CP) &&|
#this file is generated by make, don't edit
/I$(IDA)include
/nologo
#       Optimize code for Windows application
/GA
#       Merge duplicate strings
/GF
#       Exception handling
/EHa
#       Enable RTTI
/GR
#       No standard stack frame
/Oy
/DMAXSTR=1024
/DNO_TV_STREAMS
/D__NT__
| $@
