//--------------------------------------------------------------------------
#define EXCEPTION_BCC_FATAL  0xEEFFACE
#define EXCEPTION_BCC_NORMAL 0xEEDFAE6

static ssize_t find_signature(const uchar *sign, size_t signlen, const uchar *buf, size_t bufsize)
{
  const uchar c = sign[0];
  const uchar *end = buf + bufsize - signlen;
  for ( const uchar *ptr=buf; ptr <= end; ptr++ )
  {
    if ( *ptr != c ) continue;
    if ( memcmp(sign, ptr, signlen) == 0 )
      return ptr-buf;
  }
  return -1;
}

//--------------------------------------------------------------------------
static ssize_t find_bcc_sign(const uchar *buf, size_t bufsize)
{
  static const uchar bcc_sign[] = "fb:C++HOOK";
  ssize_t bcc_hook_off = find_signature(bcc_sign, sizeof(bcc_sign)-1, buf, bufsize);
  if ( bcc_hook_off == -1 )
    return -1;
  bcc_hook_off += sizeof(bcc_sign) - 1 + 2;
  return bcc_hook_off;
}

//--------------------------------------------------------------------------
static void fix_exception_table(ea_t begin_ea)
{
#if 0
  // fix up the exceptions table according to the program type
  // for borland programs we don't intercept exceptions while for others we do
  uchar buf[4096];
  if ( rpc_get_many_bytes(begin_ea, buf, sizeof(buf))
    && find_bcc_sign(buf, sizeof(buf)) != -1 )
  {
    for ( int i=0; i < qnumber(exceptions)-NUM_ALWAYS; i++ )
    {
      exceptions[i].break_on = false;
      exceptions[i].handle   = false;
    }
  }
#endif
}

