
static const uchar bpt_code = 0xCC;  // breakpoint instruction opcode

// Hardware breakpoints

static ea_t hwbpt_ea[MAX_BPT];
static ulong dr6;
static ulong dr7;

//--------------------------------------------------------------------------
// returns -1 if something is wrong
static int find_hwbpt_slot(ea_t ea)
{
  for ( int i=0; i < MAX_BPT; i++ )
  {
    if ( hwbpt_ea[i] == ea ) // another breakpoint is here
      return -1;
    if ( hwbpt_ea[i] == BADADDR ) // empty slot found
      return i;
  }
  return -1;
}

//--------------------------------------------------------------------------
int idaapi remote_is_ok_bpt(bpttype_t type, ea_t ea, int /* len */)
{
  if ( type == BPT_SOFT )
    return true;
  return find_hwbpt_slot(ea) == -1 ? BPT_TOO_MANY : BPT_OK;
}

//--------------------------------------------------------------------------
static void cleanup_hwbpts(void)
{
  for ( int i=0; i < MAX_BPT; i++ )
    hwbpt_ea[i] = BADADDR;
  dr6 = 0;
  dr7 = 0x100;          // exact local breakpoints
}

