#
#       Common part of make files for IDA.
#
#       Please set IDA and BCDIR variables!
#

#       All makesfiles are prepared to be used by BCC MAKE.EXE

#--------------------------- Main IDA directory   --------------------------
!ifndef IDA
IDA=c:\tmp\4\sdk\          # with the trailing backslash!
!endif

!ifdef __AMD64__
__EA64__=1
!endif

!include $(IDA)defaults.mk

############################################################################
TV=ui\txt\tv\           # TurboVision subdirectory

.PHONY: all All goal Goal total Total objdir test runtest $(ADDITIONAL_GOALS)

######################### set debug switches
!ifdef DEBUG
CCDEBUG=-v
CCOPT=-O-
!else
CCOPT=-O2
!endif

!ifdef __EA64__
SUFF64=64
ADRSIZE=64
ADRSWITCH=-D__EA64__
!else
ADRSIZE=32
!endif

# include,help and other directories are common for all platforms and compilers:
I =$(IDA)include\       # include directory
R =$(IDA)bin\		# main result directory result
HO=$(R)                 # help file is stored in the bin directory
HI=$(RS)		# _ida.hlp placed in main tool directory
C =$(R)cfg\		# cfg files stored path
RI=$(R)idc\		# idc files stored path
HS=.hls                 #       help source
HH=.hhp                 #       help headers

#############################################################################
!if $d(__MSDOS__)					# Borland C++ DOS 16
__IDA_MSDOS__=1
__DOS16__=1
IMPLIB	=$(BC31)bin\implib.exe				# implib executable name
ASM	=$(BC31)bin\tasm.exe				# assembler
!ifdef LDR_TRANSLATION
CC	=$(BCDIR)bin\bcc.exe				# C++ compiler
!else
CC	=$(BC31)bin\bcc.exe			        # C++ compiler
!endif
CFLAGS	=+$(IDA)dosbor.cfg $(_CFLAGS) $(CCDEBUG)	# default compiler flags
AFLAGS	=/t/ml/z/m5$(_AFLAGS)				# default assembler flags
OUTSW	=-e						# outfile name switch for one-line linker
OUTDLL	=/Twd						# output is DLL switch
LINKER	=$(BC31)bin\tlink /m $(_LDFLAGS)		# indirect file linker
CCL	=$(RS)ld _b _l$(CC) $(CFLAGS) $(_LDFLAGS)	# one-line linker
LINKSYS_EXE=      					# target link system for executable
LINKSYS	=						# target link system
C_STARTUP=$(BC31)lib\c0l				# indirect linker: C startup file
C_LIB	=$(BC31)lib\cl					# indirect linker: default C library
OVRON	=-Yo						# 16bit: following files overlayed
OVROFF	=-Yo-						# 16bit: following files not overlayed
L	=$(IDA)lib\					# libraries directory
TL	=$(IDA)$(TV)lib\       		        	# TVision libraries directory
F	=						# object files directory
B	=.exe						# exe file extension
BS	=.exe						# host utility extension
MAP	=.map						# map file extension
T	=.ar						# library flag file extension
IDP	=.idp						# IDP extension
LDR     =.ldd                                           # LDR extension
PLUGIN  =.pl1                                           # PLUGIN extension
DLLEXT  =$(B)
LINKOPTS_EXE=/ye+/yx+/c
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE)
O	=.obj						# object file extension
A	=.lib						# library file extension
API	=.api						# API definition file extension
DEF	=.def						# DEF file extension
IDPSTUB	=$(L)idpstub$(O)				# STUB file for IDPs
LDRSTUB =$(L)idpstub$(O) $(L)dlldata$(O)                # STUB file for LDRs
IDPSLIB =						# system libraries for IDPs
AR	=$(RS)ar$(BS) _a _e$(T) "_l$(BC31)bin\tlib /C/0/E" ruv	# librarian
APISW   =-sdos16
#############################################################################
!elif $d(__AMD64__)                                     # Visual Studio 8 for AMD64
IMPLIB  =implib_xxx                                     # implib executable name
ASM     =asm_xxx                                        # assembler
BCDIR   =c:\progra~1\micros~1\vc\			#
CC      =$(BCDIR)bin\cl                                 # C++ compiler
!ifdef DEBUG
#CCDEBUG=/Zi  -- linker complains about bad lib in my case
CCDEBUG=
CCOPT=/Od
!else
CCOPT=/O2
!endif
CFLAGS  =@$(IDA)w$(ADRSIZE)vs.cfg $(ADRSWITCH) $(CCDEBUG) $(CCOPT) $(_CFLAGS) $(_CLOPT) # default compiler flags
AFLAGS  =xxx /D__FLAT__ /t/ml/m5$(_AFLAGS)              # default assembler flags
OUTSW   =/Fe                                            # outfile name switch for one-line linker
!ifdef BASE
LDFLAGS =/BASE:$(BASE) $(_LDFLAGS)
!else
LDFLAGS =$(_LDFLAGS)
!endif
ULINK_COMPAT_OPT = -O- -P- -o- -Gh -Gh- -F -N           # -N for pulgins\debugger
!ifdef LINK_ULINK
_LINKER =$(ULINK) $(ULINK_COMPAT_OPT) $(_CLOPT)         # _COMPAT_OPT used in UI\TXT
!else
_LINKER =$(BCDIR)bin\link                               # indirect file linker
!endif
LINKER  = $(_LINKER) $(LDFLAGS) $(CCDEBUG)              # default link command
CCL     =$(RS)ld _v _l$(CC) $(CFLAGS) $(_LDFLAGS)       # one-line linker
LINKSYS_EXE=                                            # target link system for executable
LINKSYS =                                               # target link system
C_STARTUP=                                              # indirect linker: C startup file
C_IMP   =kernel32                                       # import library
C_LIB   =$(C_IMP) libcmt                                # indirect linker: default C library
OVRON   =                                               # 16bit: following files overlayed
OVROFF  =                                               # 16bit: following files not overlayed
L       =$(IDA)libvc.x$(ADRSIZE)\                       # libraries directory
TL      =$(IDA)$(TV)libvc.x64\                          # TVision libraries directory
F       =vc.x$(ADRSIZE)\                                # object files directory
B       =x64.exe                                        # exe file extension
BS      =.exe                                           # host utility extension
MAP     =.mpv                                           # map file extension
T       =.ax$(ADRSIZE)                                  # library flag file extension
IDP     =.x$(ADRSIZE)                                   # IDP extension
DLLEXT  =64.dll
IDP     =64.x$(ADRSIZE)                                 # IDP extension
LDR     =64.x$(ADRSIZE)                                 # LDR extension
PLUGIN  =.x$(ADRSIZE)                                   # PLUGIN extension
LINKOPTS_EXE=/LIBPATH:$(BCDIR)lib
LINKOPTS=$(LINKOPTS_EXE)
O       =.obj                                           # object file extension
A       =.lib                                           # library file extension
API     =.api                                           # API definition file extension
DEF     =.df2                                           # DEF file extension
!if  !$d(NORTL)
IDPSTUB =		                                # STUB file for IDPs
LDRSTUB =                                               # STUB file for LDRs
IDPSLIB =$(C_LIB)                                       # system libraries for IDPs
!else
IDPSTUB =$(L)modstart                                   # STUB file for IDPs
LDRSTUB =$(L)modstart                                   # STUB file for LDRs
IDPSLIB =$(C_IMP)                                       # system libraries for IDPs
!endif
AR      =$(RS)ar$(BS) _e$(T) _v _llib ruv	        # librarian
APISW   =-swin -i$(RS)ida.imp -n
# force C mode for .c files
!if $d(DONT_FORCE_CPP)
FORCEC=/TC
!endif
#############################################################################
!elif $d(__VC__)                                        # Visual Studio 6 for x86
IMPLIB  =implib_xxx                                     # implib executable name
ASM     =asm_xxx                                        # assembler
BCDIR   =c:\progra~1\miaf9d~1\vc98\			#
CC      =$(BCDIR)bin\cl                                 # C++ compiler
!ifdef DEBUG
CCDEBUG=/Zi
CCOPT=/Od
!else
CCOPT=/O2
!endif
CFLAGS  =/nologo @$(IDA)w$(ADRSIZE)vs.cfg $(ADRSWITCH) $(CCDEBUG) $(CCOPT) $(_CFLAGS) $(_CLOPT) # default compiler flags
AFLAGS  =xxx /D__FLAT__ /t/ml/m5$(_AFLAGS)              # default assembler flags
OUTSW   =/Fe                                            # outfile name switch for one-line linker
!ifdef BASE
LDFLAGS =/BASE:$(BASE) $(_LDFLAGS)
!else
LDFLAGS =$(_LDFLAGS)
!endif
ULINK_COMPAT_OPT = -O- -P- -o- -Gh -Gh- -F -N           # -N for pulgins\debugger
!ifdef LINK_ULINK
_LINKER =$(ULINK) $(ULINK_COMPAT_OPT) $(_CLOPT)         # _COMPAT_OPT used in UI\TXT
!else
_LINKER =$(BCDIR)bin\link                               # indirect file linker
!endif
LINKER  = $(_LINKER) $(LDFLAGS) $(CCDEBUG)              # default link command
CCL     =$(RS)ld _v _l$(CC) $(CFLAGS) $(_LDFLAGS)       # one-line linker
LINKSYS_EXE=                                            # target link system for executable
LINKSYS =                                               # target link system
C_STARTUP=xxx                                           # indirect linker: C startup file
C_IMP   =kernel32                                       # import library
C_LIB   =$(C_IMP) libcmt                                # indirect linker: default C library
OVRON   =                                               # 16bit: following files overlayed
OVROFF  =                                               # 16bit: following files not overlayed
L       =$(IDA)libvc.x$(ADRSIZE)\                       # libraries directory
TL      =$(IDA)$(TV)libvc.x64\                          # TVision libraries directory
F       =vc.w$(ADRSIZE)\                                # object files directory
B       =v32.exe                                        # exe file extension
BS      =.exe                                           # host utility extension
MAP     =.mpv                                           # map file extension
T       =.ax$(ADRSIZE)                                  # library flag file extension
IDP     =.x$(ADRSIZE)                                   # IDP extension
DLLEXT  =32.dll
IDP     =32.v$(ADRSIZE)                                 # IDP extension
LDR     =32.v$(ADRSIZE)                                 # LDR extension
PLUGIN  =.x$(ADRSIZE)                                   # PLUGIN extension
LINKOPTS_EXE= $(_LNK_EXE_MAP) /LIBPATH:$(BCDIR)lib
LINKOPTS=$(LINKOPTS_EXE)
O       =.obj                                           # object file extension
A       =.lib                                           # library file extension
API     =.api                                           # API definition file extension
DEF     =.df2                                           # DEF file extension
!if  !$d(NORTL)
IDPSTUB =$(BCDIR)lib\c0d32                              # STUB file for IDPs
LDRSTUB =$(BCDIR)lib\c0d32                              # STUB file for LDRs
IDPSLIB =$(C_LIB)                                       # system libraries for IDPs
!else
IDPSTUB =$(L)modstart                                   # STUB file for IDPs
LDRSTUB =$(L)modstart                                   # STUB file for LDRs
IDPSLIB =$(C_IMP)                                       # system libraries for IDPs
!endif
AR      =$(RS)ar$(BS) _e$(T) _v _llib ruv	        # librarian
APISW   =-swin -i$(RS)ida.imp -n
# force C mode for .c files
!if $d(DONT_FORCE_CPP)
FORCEC=/TC
!endif
#############################################################################
!elif $d(__NT__)                                        # Borland C++ for NT (WIN32)
IMPLIB  =$(BCDIR)bin\implib                             # implib executable name
ASM     =$(BC5_COM)bin\tasm32                           # assembler
CC      =$(BCDIR)bin\bcc32                              # C++ compiler
!ifdef __IDP__
CC_ALIGN= -ps                                           # Standard calling convention
!else
CC_ALIGN= -pr                                           # Register calling convention
!endif
!ifdef __PRECOMPILE__
CC_PRECOMPILE= -H
!endif
CFLAGS  =+$(IDA)w$(ADRSIZE)bor.cfg $(ADRSWITCH) $(CC_PRECOMPILE) $(CC_ALIGN) $(CCDEBUG) $(CCOPT) $(_CFLAGS) $(_CLOPT) # default compiler flags
AFLAGS  =/D__FLAT__ /t/ml/m5$(_AFLAGS)                  # default assembler flags
OUTSW   =-n -e                                          # outfile name switch for one-line linker
OUTDLL  =/Tpd                                           # output is DLL switch
!ifdef BASE
NT_BSW  =-b=$(BASE)
!endif
LDFLAGS =$(NT_BSW) $(_LDFLAGS)
ULINK_COMPAT_OPT = -O- -P- -o- -Gh -Gh- -F -N           # -N for pulgins\debugger
!ifdef LINK_ULINK
_LINKER =$(ULINK) $(ULINK_COMPAT_OPT) $(_CLOPT)         # _COMPAT_OPT used in UI\TXT
!else
_LINKER =$(BCDIR)bin\ilink32 -Gn                        # indirect file linker
!endif
LINKER  = $(_LINKER) $(LDFLAGS) $(CCDEBUG)              # default link command
CCL     =$(RS)ld _b _l$(CC) $(CFLAGS) $(_LDFLAGS)       # one-line linker
LINKSYS_EXE=                                            # target link system for executable
LINKSYS =                                               # target link system
C_STARTUP=c0x32                                         # indirect linker: C startup file
C_IMP   =import32                                       # import library
C_LIB   =$(C_IMP) cw32mt                                # indirect linker: default C library
OVRON   =                                               # 16bit: following files overlayed
OVROFF  =                                               # 16bit: following files not overlayed
L       =$(IDA)libbor.w$(ADRSIZE)\                      # libraries directory
TL      =$(IDA)$(TV)libbor.w32\                         # TVision libraries directory
F       =bor.w$(ADRSIZE)\                               # object files directory
!ifdef __EA64__
B       =64.exe                                         # exe file extension
!else
B       =.exe                                           # exe file extension
!endif
BS      =.exe                                           # host utility extension
MAP     =.mpb                                           # map file extension
T       =.a$(ADRSIZE)                                   # library flag file extension
IDP     =.w$(ADRSIZE)                                   # IDP extension
!ifdef __EA64__
DLLEXT  =64.wll
IDP     =64.w$(ADRSIZE)                                 # IDP extension
LDR     =64.l$(ADRSIZE)                                 # LDR extension
PLUGIN  =.p$(ADRSIZE)                                   # PLUGIN extension
!else
DLLEXT  =.wll
LDR     =.ldw
PLUGIN  =.plw
!endif
ORDINALS= #-o                                           # import functions by ordinals
# -c case sensitive
# -C clear state before linking
# -s detailed map of segments
# -m detailed map of publics
# -r verbose
LINKOPTS_EXE= $(_LNK_EXE_MAP) -c -C $(ORDINALS) $(CCDEBUG) -L$(BCDIR)lib
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE)
O       =.obj                                           # object file extension
A       =.lib                                           # library file extension
API     =.api                                           # API definition file extension
DEF     =.df2                                           # DEF file extension
!if  !$d(NORTL)
IDPSTUB =$(BCDIR)lib\c0d32                              # STUB file for IDPs
LDRSTUB =$(BCDIR)lib\c0d32                              # STUB file for LDRs
IDPSLIB =$(C_LIB)                                       # system libraries for IDPs
!else
IDPSTUB =$(L)modstart                                   # STUB file for IDPs
LDRSTUB =$(L)modstart                                   # STUB file for LDRs
IDPSLIB =$(C_IMP)                                       # system libraries for IDPs
!endif
AR      =$(RS)ar$(BS) _a _e$(T) "_l$(BC5_COM)BIN\TLIB.EXE /C/E/P64" ruv   # librarian
APISW   =-swin -i$(RS)ida.imp -n
# force C mode for .c files
!if $d(DONT_FORCE_CPP)
FORCEC=-P-
!endif
#############################################################################
!else
!error          Unknown compiler/platform
!endif
#############################################################################

!if 0           # this is for makedep
F=
!endif

HC=$(RS)ihc$(BS)                                # Help Compiler

IDALIB=$(L)ida$(A)
DUMB=$(L)dumb$(O)
HLIB=$(HI)_ida.hlp

########################################################################
!if   $d(__MSDOS__)
_MAKEFLAGS=-D__MSDOS__ -U__NT__
!elif $d(__NT__)
_MAKEFLAGS=-U__MSDOS__ -D__NT__
!else
_MAKEFLAGS=-U__MSDOS__ -U__NT__
!endif

!ifdef _MAKEOPTS
MAKEFLAGS=$(MAKEFLAGS) $(_MAKEFLAGS)
!else
MAKEFLAGS=$(_MAKEFLAGS)
!endif

!ifdef __EA64__
MAKEFLAGS=$(MAKEFLAGS) -D__EA64__
!endif

### for 'if exist DIRECTORY'
!IF "$(OS)" == "Windows_NT"
CHKDIR=
!ELSE
CHKDIR=/nul
!ENDIF

########################################################################
!ifndef CONLY
CONLY=-c
!endif

!ifdef __VC__
.cpp$(O):
        $(CC) $(CFLAGS) $(CONLY) /Fo$(F)${<:.cpp=.obj} $?
.c$(O):
        $(CC) $(CFLAGS) $(CONLY) $(FORCEC) /Fo$(F)${<:.c=.obj} $?
!else
.cpp$(O):
        $(CC) $(CFLAGS) $(CONLY) {$< }
.c$(O):
        $(CC) $(CFLAGS) $(CONLY) $(FORCEC) {$< }
.asm$(O):
        $(ASM) $(AFLAGS) $*,$(F)$*
!endif


.hls.hhp:
        $(HC) -t $(HLIB) -i$@ $?
$(API)$(DEF):
        $(R)api2df$(B) $(APISW) $? $@
$(DEF)$(A):
        $(IMPLIB) $@ temp.def >nul
########################################################################
