/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.midletui;

import j2meunit.framework.AssertionFailedError;
import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestFailure;
import j2meunit.framework.TestListener;
import j2meunit.framework.TestResult;
import j2meunit.framework.TestSuite;
import j2meunit.util.StringUtil;
import j2meunit.util.Version;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class TestRunner
extends MIDlet
implements TestListener {
    protected static TestRunner theInstance = null;
    protected Gauge aProgressBar;
    protected List aResultsList;
    protected PrintStream aWriter = System.out;
    protected StringItem aErrorInfo;
    protected StringItem aFailureInfo;
    protected TestResult aResult;
    protected boolean bScreenOutput = true;
    protected boolean bTextOutput = true;
    protected int nCount;

    public TestRunner() {
        if (theInstance != null) {
            throw new RuntimeException("Only one MIDlet instance allowed!");
        }
        theInstance = this;
    }

    public static TestRunner getInstance() {
        return theInstance;
    }

    public void setOutputMode(boolean bScreen, boolean bText) {
        this.bScreenOutput = bScreen;
        this.bTextOutput = bText;
    }

    public void setWriter(PrintStream aStream) {
        this.aWriter = aStream;
    }

    public PrintStream getWriter() {
        return this.aWriter;
    }

    public synchronized void addError(Test test, Throwable t) {
        System.out.print("E");
    }

    public synchronized void addFailure(Test test, AssertionFailedError e) {
        System.out.print("F");
    }

    public void addToResultsList(String sText) {
        if (this.bScreenOutput) {
            this.getResultsList().append(sText, null);
        }
        if (this.bTextOutput) {
            this.aWriter.println(sText);
        }
    }

    public void addToResultsList(Throwable t) {
        if (this.bScreenOutput) {
            String sMsg = t.getMessage() != null ? t.getMessage() : t.getClass().getName();
            this.getResultsList().append(sMsg, null);
        }
        if (this.bTextOutput) {
            t.printStackTrace();
        }
    }

    public void endTest(Test test) {
        if (this.aProgressBar != null) {
            this.aProgressBar.setValue(this.aProgressBar.getValue() + 1);
            this.aFailureInfo.setText(Integer.toString(this.aResult.failureCount()));
            this.aErrorInfo.setText(Integer.toString(this.aResult.errorCount()));
        }
    }

    public void endTestStep(Test test) {
        if (this.aProgressBar != null) {
            this.aProgressBar.setValue(this.aProgressBar.getValue() + 1);
        }
    }

    public synchronized void print(TestResult result) {
        this.printHeader(result);
        this.printErrors(result);
        this.printFailures(result);
        this.printFooter();
    }

    public void printErrors(TestResult result) {
        if (result.errorCount() != 0) {
            if (result.errorCount() == 1) {
                this.addToResultsList("There was " + result.errorCount() + " error:");
            } else {
                this.addToResultsList("There were " + result.errorCount() + " errors:");
            }
            int i = 1;
            Enumeration e = result.errors();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.addToResultsList(String.valueOf(i) + ") " + failure.failedTest());
                if (failure.thrownException() != null) {
                    this.addToResultsList(failure.thrownException());
                }
                ++i;
            }
        }
    }

    public void printFailures(TestResult result) {
        if (result.failureCount() != 0) {
            if (result.failureCount() == 1) {
                this.addToResultsList("There was " + result.failureCount() + " failure:");
            } else {
                this.addToResultsList("There were " + result.failureCount() + " failures:");
            }
            int i = 1;
            Enumeration e = result.failures();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.addToResultsList(String.valueOf(i) + ") " + failure.failedTest());
                if (failure.thrownException() != null) {
                    this.addToResultsList(failure.thrownException());
                }
                ++i;
            }
        }
    }

    public void printFooter() {
        this.addToResultsList("J2ME Unit " + Version.id());
        this.addToResultsList("Original Version by RoleModel Software, Inc.");
        this.addToResultsList("Original JUnit by Kent Beck and Erich Gamma");
    }

    public void printHeader(TestResult result) {
        if (result.wasSuccessful()) {
            this.addToResultsList("OK");
            this.addToResultsList(" (" + result.runCount() + " tests)");
        } else {
            this.addToResultsList("FAILURES");
            this.addToResultsList("Test Results:");
            this.addToResultsList("Run: " + result.runCount());
            this.addToResultsList("Failures: " + result.failureCount());
            this.addToResultsList("Errors: " + result.errorCount());
        }
    }

    public void showResult() {
        if (this.bScreenOutput) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.getResultsList());
        }
    }

    public synchronized void startTest(Test test) {
        System.out.print(".");
    }

    protected List getResultsList() {
        if (this.aResultsList == null) {
            this.aResultsList = new List("J2ME Unit", 3);
        }
        return this.aResultsList;
    }

    protected Test createTestSuite(String[] rTestCaseClasses) {
        if (rTestCaseClasses.length < 1) {
            System.out.println("Usage: TestRunner testCaseName1 [... testCaseNameN]");
            System.exit(-1);
        }
        TestSuite aSuite = new TestSuite();
        int i = 0;
        while (i < rTestCaseClasses.length) {
            try {
                String sClass = rTestCaseClasses[i];
                TestCase aCase = (TestCase)Class.forName(sClass).newInstance();
                aSuite.addTest(aCase.suite());
            }
            catch (Exception e) {
                System.out.println("Access to TestCase " + rTestCaseClasses[i] + " failed: " + e.getMessage() + " - " + e.getClass().getName());
            }
            ++i;
        }
        return aSuite;
    }

    protected void destroyApp(boolean bUnconditional) {
    }

    protected void doRun(Test suite) {
        this.aResult = new TestResult();
        this.aResult.addListener(this);
        long startTime = System.currentTimeMillis();
        suite.run(this.aResult);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        this.addToResultsList("Time: " + StringUtil.elapsedTimeAsString(runTime));
        this.print(this.aResult);
    }

    protected void pauseApp() {
    }

    protected void start(String[] rTestCaseClasses) {
        final Test aTestSuite = this.createTestSuite(rTestCaseClasses);
        Display rDisplay = Display.getDisplay((MIDlet)this);
        Form aForm = new Form("TestRunner");
        this.nCount = aTestSuite.countTestSteps();
        this.aProgressBar = new Gauge(null, false, this.nCount, 0);
        this.aFailureInfo = new StringItem("Failures:", "0");
        this.aErrorInfo = new StringItem("Errors:", "0");
        aForm.append("Testing...");
        aForm.append((Item)this.aProgressBar);
        aForm.append((Item)this.aFailureInfo);
        aForm.append((Item)this.aErrorInfo);
        rDisplay.setCurrent((Displayable)aForm);
        new Thread(){

            public void run() {
                try {
                    TestRunner.this.doRun(aTestSuite);
                    TestRunner.this.showResult();
                }
                catch (Exception e) {
                    System.out.println("Exception while running test: " + e);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    protected void startApp() throws MIDletStateChangeException {
        try {
            String sTestClasses = this.getAppProperty("J2MEUnitTestClasses");
            System.out.println("Testing: " + sTestClasses);
            this.start(new String[]{sTestClasses});
        }
        catch (Exception e) {
            System.out.println("Exception while setting up tests: " + e);
            e.printStackTrace();
        }
    }
}

