/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.Application;
import com.siemens.mp.app.MessageBox;
import com.siemens.mp.app.UIException;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;
import com.siemens.mp.app.calculatorconverter.CalculatorCore;
import com.siemens.mp.app.calculatorconverter.CalculatorData;
import com.siemens.mp.app.calculatorconverter.InputLine;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class CalculatorUI
extends Canvas
implements Runnable,
CommandListener {
    private static final String CYRILLIC = "CYRILLIC";
    private static final String ARABIC = "ARABIC";
    private static final int BUTTON_COUNT = 15;
    private static final String BUTTON_PREFIX = "I_Calculator_";
    private static final String BUTTON_SELECTED_POSTFIX = "_Selected";
    private static final int BUTTONS_PER_LINE = 5;
    private static final int BUTTON_BACKGROUND_COLOR = 15771417;
    private static final int INPUT_BACKGROUND_COLOR = 14211819;
    private static final int HISTORY_BACKGROUND_COLOR = 7570646;
    private static final int BUTTON_SPACING = 2;
    private static final int INPUT_LINE_RIGHT_BORDER_SPAING = 8;
    private static final int INPUT_LINE_TOP_SPACING = 1;
    private static final int OPERATOR_POS_X = 3;
    private static final int ANIMATION_INTERVALL = 250;
    private static final int IST_NORMAL = 0;
    private static final int IST_SELECTED = 1;
    private static final int HISTORY_SIZE = 2;
    private static final int KEY_PROCESSED = -99999;
    private static final String[] sButtonNames = new String[]{"Square_Root", "Reciprocal", "Multiplication", "Percent", "Memory_Store", "Square", "Sign_Minus", "Equality", "Sign_Plus", "Memory_Plus", "Scientific", "DecimalPoint", "Division", "Sign_Change", "Memory_Recall"};
    private static final int BTN_SQRT = 0;
    private static final int BTN_RECIPROCAL = 1;
    private static final int BTN_MULTIPLICATION = 2;
    private static final int BTN_PERCENT = 3;
    private static final int BTN_MEM_SAVE = 4;
    private static final int BTN_SQR = 5;
    private static final int BTN_MINUS = 6;
    private static final int BTN_EQUAL = 7;
    private static final int BTN_PLUS = 8;
    private static final int BTN_MEM_ADD = 9;
    private static final int BTN_EXP = 10;
    private static final int BTN_DOT = 11;
    private static final int BTN_DIVIDE = 12;
    private static final int BTN_CHANGE_SIGN = 13;
    private static final int BTN_MEM_RECALL = 14;
    private static final int CMD_CLEAR_LAST_DIGIT = 0;
    private static final int CMD_LSK_EXIT = 1;
    private static final int CMD_AC = 2;
    private static final int CMD_CONVERT = 3;
    private static final int CMD_CLEAR_ALL = 4;
    private static final int CMD_MEM_SAVE = 5;
    private static final int CMD_MEM_RECALL = 6;
    private static final int CMD_MEM_CLEAR = 7;
    private static final int CMD_BASIC_MODE = 8;
    private static final int CMD_EXTENDED_MODE = 9;
    private static final int CMD_EXIT = 10;
    private static final int CMD_CENTER_CLICK = 11;
    private static final int CMD_LSK_BACK = 12;
    private static final int BTN_SUBSTRACT = 6;
    private static final int BTN_ADD = 8;
    private static final int BTN_ADD_EXPONENT = 10;
    private static final int BTN_ADD_DECIMAL_POINT = 11;
    public static final int OP_NONE = -1;
    public static final int OP_SQRT = 0;
    public static final int OP_RECIPROCAL = 1;
    public static final int OP_MULTIPLICATION = 2;
    public static final int OP_PERCENT = 3;
    public static final int OP_MEM_SAVE = 4;
    public static final int OP_SQR = 5;
    public static final int OP_SUBSTRACT = 6;
    public static final int OP_EQUAL = 7;
    public static final int OP_ADD = 8;
    public static final int OP_MEM_ADD = 9;
    public static final int OP_ADD_EXPONENT = 10;
    public static final int OP_ADD_DECIMAL_POINT = 11;
    public static final int OP_DIVIDE = 12;
    public static final int OP_CHANGE_SIGN = 13;
    public static final int OP_MEM_RECALL = 14;
    public static final int OP_MEM_CLEAR = 15;
    public static final int OP_CLEAR_ALL = 16;
    public static final int OP_DELETE_CHAR = 17;
    public static final int OP_CLEAR_INPUT = 18;
    public static final int IS_ENTER_NUMBER = 0;
    public static final int IS_ENTER_OPERATOR = 1;
    public static final int IS_SHOW_RESULT = 2;
    public static final int TYPE_ADD_NUMBER = 0;
    public static final int TYPE_BASIC_OPERATION = 1;
    public static final int TYPE_ADVANCED_OPERATION = 2;
    public static final int TYPE_INPUTLINE_HANDLING = 3;
    public static final int TYPE_MEMORY_RELATED = 4;
    private static final Command[] sCommands = new Command[]{new Command(Application.getLocalizedText(5), 2, 1), new Command(Application.getLocalizedText(133), 2, 1), new Command(Application.getLocalizedText(6), 2, 1), new Command(Application.getLocalizedText(7), 4, 3), new Command(Application.getLocalizedText(8), 4, 4), new Command(Application.getLocalizedText(9), 4, 5), new Command(Application.getLocalizedText(10), 4, 6), new Command(Application.getLocalizedText(11), 4, 7), new Command(Application.getLocalizedText(12), 4, 8), new Command(Application.getLocalizedText(13), 4, 9), new Command(Application.getLocalizedText(133), 4, 10), new Command(Application.getLocalizedText(14), 4, 2), new Command(Application.getLocalizedText(134), 2, 1)};
    private CalculatorCore mCore;
    private Image[][] mButtons;
    private int mFocusedButton;
    private int mLastKeyDown = -99999;
    private Image mMemoryValidIndicator;
    private Font mMemoryFont;
    private Font mHistoryFont;
    private Font mInputLineFont;
    private int mButtonX;
    private int mButtonY;
    private int mButtonSX;
    private int mButtonSY;
    private int mHistoryHeight;
    private int mInputLineY;
    private int mInputLineHeight;
    private InputLine mInputLine;
    private long mStartTime;
    private int mLSKCommandId;
    private Command mSelectCommand;
    private int[] mOperatorHistory;
    private double[] mNumberHistory;
    private int[] mHistoryPos;
    private Image mIcon;
    private boolean showCursor;
    private int running;
    private String keyboardLayout = System.getProperty("com.siemens.KeyboardLayout");

    public CalculatorUI(CalculatorCore pCore) {
        int histSpace;
        CalcConvApp app = CalcConvApp.getInstance();
        this.setFullScreenMode(false);
        this.mCore = pCore;
        this.setTitle(app.getAppTitle());
        this.mIcon = Application.getBitmap(0);
        this.mButtons = new Image[2][15];
        int id = 1;
        int i = 0;
        while (i < 15) {
            this.mButtons[0][i] = Application.getBitmap(id++);
            this.mButtons[1][i] = Application.getBitmap(id++);
            ++i;
        }
        int lskId = CalcConvApp.getInstance().mCurrentState == CalcConvApp.getInstance().getInitialState() ? 1 : 12;
        this.addCommand(sCommands[lskId]);
        this.mLSKCommandId = lskId;
        if (app.checkEnabDisabConv()) {
            this.addCommand(sCommands[3]);
        }
        this.addCommand(sCommands[4]);
        this.addCommand(sCommands[5]);
        this.addCommand(sCommands[6]);
        this.addCommand(sCommands[7]);
        this.addCommand(sCommands[11]);
        this.mMemoryValidIndicator = Application.getBitmap(31);
        this.mFocusedButton = 7;
        this.mInputLine = new InputLine();
        this.mStartTime = System.currentTimeMillis();
        if (app.isSmallDisplay()) {
            this.mMemoryFont = Font.getFont((int)64, (int)1, (int)8);
            this.mHistoryFont = Font.getFont((int)64, (int)1, (int)8);
            this.mInputLineFont = Font.getFont((int)32, (int)1, (int)8);
        } else {
            this.mMemoryFont = Font.getFont((int)64, (int)1, (int)0);
            this.mHistoryFont = Font.getFont((int)64, (int)1, (int)0);
            this.mInputLineFont = Font.getFont((int)32, (int)1, (int)0);
        }
        this.mButtonSX = this.mButtons[0][0].getWidth() + 2;
        this.mButtonSY = this.mButtons[0][0].getHeight() + 2;
        this.mButtonX = (this.getWidth() - 5 * this.mButtonSX - 2) / 2;
        this.mButtonY = this.getHeight() - 3 * this.mButtonSY;
        this.mInputLineHeight = this.mInputLineFont.getHeight() + 2;
        this.mHistoryHeight = this.mInputLineY = this.mButtonY - 2 - this.mInputLineHeight;
        int hpos = histSpace = (this.mHistoryHeight - 2 * this.mHistoryFont.getHeight()) / 3;
        histSpace += this.mHistoryFont.getHeight();
        this.mHistoryPos = new int[2];
        int i2 = 1;
        while (i2 >= 0) {
            this.mHistoryPos[i2] = hpos;
            hpos += histSpace;
            --i2;
        }
        this.mOperatorHistory = new int[2];
        this.mNumberHistory = new double[2];
        this.clearHistory();
        this.setCommandListener(this);
        try {
            app.getPersistenceManager().waitForReadComplete(this.mCore.getDataObject(), -1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.mCore.getDataObject().isExtendedModeEnabled()) {
            this.addCommand(sCommands[8]);
        } else {
            this.addCommand(sCommands[9]);
        }
    }

    public void showNotify() {
        ++this.running;
        new Thread(this).start();
    }

    public void hideNotify() {
        ++this.running;
    }

    public void shutdown() {
        ++this.running;
    }

    private int findCommand(Command pCommand) {
        int i = 0;
        while (i < sCommands.length) {
            if (pCommand == sCommands[i]) {
                return i;
            }
            ++i;
        }
        return pCommand == this.mSelectCommand ? 11 : -1;
    }

    void setExtendedMode() {
        CalculatorData data = this.mCore.getDataObject();
        if (!data.isExtendedModeEnabled()) {
            this.removeCommand(sCommands[9]);
            this.addCommand(sCommands[8]);
            data.setExtendedModeEnabled(true);
        }
    }

    public void commandAction(Command pCommand, Displayable pDisplayable) {
        CalcConvApp app = CalcConvApp.getInstance();
        CalculatorData data = this.mCore.getDataObject();
        if (pDisplayable instanceof MessageBox) {
            return;
        }
        int cmdId = this.findCommand(pCommand);
        switch (cmdId) {
            case 1: 
            case 10: 
            case 12: {
                app.back();
                break;
            }
            case 0: {
                this.mCore.performOperation(3, 17, this.mInputLine);
                break;
            }
            case 2: 
            case 4: {
                this.clearHistory();
                this.mCore.performOperation(3, 16, this.mInputLine);
                break;
            }
            case 3: {
                if (this.mInputLine.isValidNumber() || this.mInputLine.isEmpty()) {
                    if (!this.mInputLine.isEmpty()) {
                        app.setTransferValue(this.mInputLine.toDouble());
                    } else {
                        app.setTransferValue(0.0);
                    }
                }
                app.enterState(2);
                return;
            }
            case 5: {
                this.mCore.performOperation(4, 4, this.mInputLine);
                break;
            }
            case 6: {
                this.mCore.performOperation(4, 14, this.mInputLine);
                break;
            }
            case 7: {
                this.mCore.performOperation(4, 15, this.mInputLine);
                break;
            }
            case 8: {
                if (!data.isExtendedModeEnabled()) break;
                this.removeCommand(sCommands[8]);
                this.addCommand(sCommands[9]);
                int column = this.mFocusedButton % 5;
                if (column == 0 || column == 4) {
                    this.mFocusedButton = 7;
                }
                data.setExtendedModeEnabled(false);
                break;
            }
            case 9: {
                this.setExtendedMode();
                break;
            }
            case 11: {
                this.keyPressed(this.getKeyCode(8));
                this.keyReleased(this.getKeyCode(8));
            }
        }
        this.updateCommands();
        this.repaint();
    }

    protected void paint(Graphics g) {
        CalcConvApp app = CalcConvApp.getInstance();
        if (app != null) {
            int y;
            int x;
            int i;
            CalculatorData data = this.mCore.getDataObject();
            g.setColor(7570646);
            g.fillRect(0, 0, this.getWidth(), this.mHistoryHeight);
            g.setColor(14211819);
            g.fillRect(0, this.mInputLineY, this.getWidth(), this.mInputLineHeight);
            if (g.getClipY() + g.getClipHeight() >= this.mButtonY - 2) {
                g.setColor(15771417);
                g.fillRect(0, this.mButtonY - 2, this.getWidth(), this.mButtonSY * 3 + 2);
                i = 0;
                while (i < 15) {
                    int column = i % 5;
                    int row = i / 5;
                    x = column * this.mButtonSX + this.mButtonX;
                    y = row * this.mButtonSY + this.mButtonY;
                    if (column > 0 && column < 4 || data.isExtendedModeEnabled()) {
                        int type;
                        int n = type = i == this.mFocusedButton ? 1 : 0;
                        if (this.mButtons[type][i] != null) {
                            g.drawImage(this.mButtons[type][i], x, y, 20);
                        }
                    }
                    ++i;
                }
                if (!Double.isNaN(app.getShared().getMemoryValue())) {
                    g.drawImage(this.mMemoryValidIndicator, this.getWidth() - 2, this.mButtonY, 24);
                }
            }
            g.setFont(this.mInputLineFont);
            g.setColor(0);
            g.drawString(this.mInputLine.toString(), this.getWidth() - 8, this.mInputLineY + 1, 24);
            String opChar = this.mCore.getInputState() == 2 ? "=" : this.mCore.getOperatorChar(this.mCore.getPendingOperator());
            g.drawString(opChar, 3, this.mInputLineY + 1, 20);
            if (this.showCursor) {
                x = this.getWidth() - 8 + 2;
                y = this.mInputLineY + 1;
                g.drawLine(x, y, x, y + this.mInputLineFont.getHeight() - 1);
            }
            g.setFont(this.mHistoryFont);
            i = 0;
            while (i < 2) {
                double num = this.mNumberHistory[i];
                int op = this.mOperatorHistory[i];
                if (op != -1) {
                    opChar = this.mCore.getOperatorChar(op);
                    g.drawString(opChar, 3, this.mHistoryPos[i], 20);
                }
                if (!Double.isNaN(num)) {
                    try {
                        g.drawString(CalcConvApp.getFormattedValue(num), this.getWidth() - 8, this.mHistoryPos[i], 24);
                    }
                    catch (UIException uIException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public void updateOptions() {
        this.updateCommands();
        this.setCommandListener(this);
    }

    public void keyPressed(int pKeyCode) {
        if (pKeyCode == -8) {
            this.mCore.performOperation(3, 17, this.mInputLine);
        }
        this.mLastKeyDown = pKeyCode;
    }

    public void keyReleased(int pKeyCode) {
        if (CalcConvApp.getInstance().mCurrentState != 1) {
            return;
        }
        try {
            if (pKeyCode == this.mLastKeyDown) {
                this.handleKey(pKeyCode, false);
                this.mLastKeyDown = -99999;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyRepeated(int pKeyCode) {
        if (pKeyCode == -8) {
            this.clearHistory();
            this.mCore.performOperation(3, 16, this.mInputLine);
        }
        if (CalcConvApp.getInstance().mCurrentState != 1) {
            return;
        }
        try {
            if (pKeyCode == this.mLastKeyDown || pKeyCode == -1) {
                this.handleKey(pKeyCode, true);
                this.mLastKeyDown = -99999;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateCommands() {
        if (CalcConvApp.isCalcCalledFromConv()) {
            CalcConvApp.setCalledFromConverter(false);
            this.addLSKCommand(12);
        } else if (this.mInputLine.isEmpty() || this.mInputLine.toString().equals("0") && this.mCore.getOverwrite()) {
            this.handleEmptyInputline();
        } else {
            this.handleNotEmptyInputline();
        }
    }

    private void handleEmptyInputline() {
        if (this.mLSKCommandId != 1) {
            int lskId = CalcConvApp.getInstance().mCurrentState == CalcConvApp.getInstance().getInitialState() ? 1 : 12;
            this.addLSKCommand(lskId);
        }
    }

    private void handleNotEmptyInputline() {
        if ((this.mCore.getInputState() != 0 || this.mCore.getInputState() == 0 && this.mCore.getOverwrite()) && this.mLSKCommandId != 2) {
            this.updateCommandWhenInputlineNotEmpty(2);
        }
    }

    private void addLSKCommand(int cmdId) {
        this.addCommand(sCommands[cmdId]);
        if (cmdId != this.mLSKCommandId) {
            this.removeCommand(sCommands[this.mLSKCommandId]);
        }
        this.mLSKCommandId = cmdId;
        this.removeCommand(sCommands[10]);
    }

    private void updateCommandWhenInputlineNotEmpty(int cmdId) {
        this.addCommand(sCommands[cmdId]);
        this.addCommand(sCommands[10]);
        this.removeCommand(sCommands[this.mLSKCommandId]);
        this.mLSKCommandId = cmdId;
    }

    private void keyOp(int group, int type, int focus) {
        if (type == 7 && this.mCore.getInputState() == 2) {
            return;
        }
        this.mCore.performOperation(group, type, this.mInputLine);
        if (focus != -1) {
            this.mFocusedButton = focus;
        }
        this.updateCommands();
        this.repaint();
    }

    private void handleKey(int pKeyCode, boolean pIsLongPress) {
        CalculatorData data = this.mCore.getDataObject();
        int column = this.mFocusedButton % 5;
        int row = this.mFocusedButton / 5;
        if (!pIsLongPress) {
            if (pKeyCode >= 48 && pKeyCode <= 57) {
                this.keyOp(0, pKeyCode, -1);
                return;
            }
            if (pKeyCode == 35) {
                this.keyOp(1, 7, 7);
                return;
            }
            if (pKeyCode == 42) {
                this.keyOp(1, 2, 2);
                return;
            }
        }
        switch (pKeyCode) {
            case -999: {
                this.keyOp(3, 18, -1);
                return;
            }
            case 49: {
                this.keyOp(2, 1, 1);
                return;
            }
            case -86: 
            case -78: 
            case 50: {
                this.keyOp(1, 2, 2);
                return;
            }
            case -84: 
            case 51: {
                this.keyOp(2, 3, 3);
                return;
            }
            case -90: {
                if (!CYRILLIC.equals(this.keyboardLayout)) {
                    this.keyOp(3, 17, -1);
                    return;
                }
            }
            case -74: 
            case -65: 
            case 52: {
                this.keyOp(1, 6, 6);
                return;
            }
            case -100: 
            case -79: 
            case 53: {
                this.keyOp(1, 7, 7);
                return;
            }
            case -75: 
            case 48: 
            case 54: {
                this.keyOp(1, 8, 8);
                return;
            }
            case 55: {
                this.keyOp(3, 11, 11);
                return;
            }
            case -72: 
            case 56: {
                this.keyOp(1, 12, 12);
                return;
            }
            case 35: 
            case 57: {
                this.keyOp(2, 13, 13);
                return;
            }
            case 42: {
                this.keyOp(3, 11, 11);
                return;
            }
            case -93: {
                if (ARABIC.equals(this.keyboardLayout) || CYRILLIC.equals(this.keyboardLayout)) {
                    this.keyOp(3, 17, -1);
                    return;
                }
            }
            case -95: 
            case -92: {
                this.keyOp(3, 11, 11);
                return;
            }
            case -68: {
                this.setExtendedMode();
                this.mCore.checkInputState(this.mInputLine);
                this.keyOp(3, 10, 10);
                return;
            }
            case -82: {
                this.setExtendedMode();
                this.keyOp(2, 0, 0);
                return;
            }
            case -87: {
                this.setExtendedMode();
                this.keyOp(2, 5, 5);
                return;
            }
        }
        switch (this.getGameAction(pKeyCode)) {
            case 1: {
                this.mFocusedButton -= 5;
                if (this.mFocusedButton < 0) {
                    this.mFocusedButton += 15;
                }
                this.repaint();
                break;
            }
            case 6: {
                this.mFocusedButton += 5;
                if (this.mFocusedButton >= 15) {
                    this.mFocusedButton -= 15;
                }
                this.repaint();
                break;
            }
            case 2: {
                column = data.isExtendedModeEnabled() ? (column == 0 ? 4 : column - 1) : (column == 1 ? 3 : column - 1);
                this.mFocusedButton = row * 5 + column;
                this.repaint();
                break;
            }
            case 5: {
                column = data.isExtendedModeEnabled() ? (column == 4 ? 0 : column + 1) : (column == 3 ? 1 : column + 1);
                this.mFocusedButton = row * 5 + column;
                this.repaint();
                break;
            }
            case 8: {
                if (column != 0 && column != 4) {
                    this.handleKey(49 + column - 1 + row * 3, true);
                    break;
                }
                switch (this.mFocusedButton) {
                    case 0: {
                        this.mCore.performOperation(2, 0, this.mInputLine);
                        break;
                    }
                    case 5: {
                        this.mCore.performOperation(2, 5, this.mInputLine);
                        break;
                    }
                    case 10: {
                        this.mCore.checkInputState(this.mInputLine);
                        this.mCore.performOperation(3, 10, this.mInputLine);
                        this.updateCommands();
                        break;
                    }
                    case 9: {
                        this.mCore.performOperation(4, 9, this.mInputLine);
                        break;
                    }
                    case 4: {
                        this.mCore.performOperation(4, 4, this.mInputLine);
                        break;
                    }
                    case 14: {
                        this.mCore.performOperation(4, 14, this.mInputLine);
                    }
                }
                this.updateCommands();
                this.repaint();
            }
        }
    }

    public void setInputLine(double pNumber) {
        this.mInputLine.setNumber(pNumber);
    }

    public InputLine getInputLine() {
        return this.mInputLine;
    }

    public void addToHistory(double pNumber, int pOperator) {
        int i = this.mNumberHistory.length - 1;
        while (i > 0) {
            this.mNumberHistory[i] = this.mNumberHistory[i - 1];
            this.mOperatorHistory[i] = this.mOperatorHistory[i - 1];
            --i;
        }
        this.mNumberHistory[0] = pNumber;
        this.mOperatorHistory[0] = pOperator;
    }

    public void clearHistory() {
        if (this.mNumberHistory != null) {
            int i = 0;
            while (i < this.mNumberHistory.length) {
                this.mNumberHistory[i] = Double.NaN;
                this.mOperatorHistory[i] = -1;
                ++i;
            }
        }
    }

    public void run() {
        int runId = this.running;
        CalcConvApp app = CalcConvApp.getInstance();
        while (runId == this.running) {
            try {
                Thread.sleep(250L);
                this.showCursor = !this.showCursor;
                this.repaint(0, this.mInputLineY, this.getWidth(), this.mInputLineHeight);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

