/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.pim;

import com.sun.kvem.midp.pim.PIMHandler;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.pim.FieldEmptyException;

public class RepeatRule {
    private Hashtable fields = new Hashtable();
    private Vector exceptions = new Vector();
    public static final int FREQUENCY = 0;
    public static final int DAY_IN_MONTH = 1;
    public static final int DAY_IN_WEEK = 2;
    public static final int DAY_IN_YEAR = 4;
    public static final int MONTH_IN_YEAR = 8;
    public static final int WEEK_IN_MONTH = 16;
    public static final int COUNT = 32;
    public static final int END = 64;
    public static final int INTERVAL = 128;
    public static final int DAILY = 16;
    public static final int WEEKLY = 17;
    public static final int MONTHLY = 18;
    public static final int YEARLY = 19;
    public static final int FIRST = 1;
    public static final int SECOND = 2;
    public static final int THIRD = 4;
    public static final int FOURTH = 8;
    public static final int FIFTH = 16;
    public static final int LAST = 32;
    public static final int SECONDLAST = 64;
    public static final int THIRDLAST = 128;
    public static final int FOURTHLAST = 256;
    public static final int FIFTHLAST = 512;
    public static final int SATURDAY = 1024;
    public static final int FRIDAY = 2048;
    public static final int THURSDAY = 4096;
    public static final int WEDNESDAY = 8192;
    public static final int TUESDAY = 16384;
    public static final int MONDAY = 32768;
    public static final int SUNDAY = 65536;
    public static final int JANUARY = 131072;
    public static final int FEBRUARY = 262144;
    public static final int MARCH = 524288;
    public static final int APRIL = 0x100000;
    public static final int MAY = 0x200000;
    public static final int JUNE = 0x400000;
    public static final int JULY = 0x800000;
    public static final int AUGUST = 0x1000000;
    public static final int SEPTEMBER = 0x2000000;
    public static final int OCTOBER = 0x4000000;
    public static final int NOVEMBER = 0x8000000;
    public static final int DECEMBER = 0x10000000;
    private static final int[] MONTHS = new int[]{131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000};
    private static final long DAY_INCREMENT = 86400000L;
    private static final long DAY_IN_WEEK_MASK = 130048L;
    private static final long WEEK_IN_MONTH_MASK = 1023L;
    private static final long MONTH_IN_YEAR_MASK = 536739840L;
    private static final int[] DAYS = new int[]{65536, 32768, 16384, 8192, 4096, 2048};
    private static final long DAY_LENGTH = 86400000L;
    private static final Object NO_DEFAULT = "";

    public Enumeration dates(long startDate, long subsetBeginning, long subsetEnding) {
        if (subsetBeginning > subsetEnding) {
            throw new IllegalArgumentException("Bad range: " + subsetBeginning + "(" + PIMHandler.getInstance().composeDateTime(subsetBeginning) + ") to " + subsetEnding + "(" + PIMHandler.getInstance().composeDateTime(subsetEnding));
        }
        Calendar calendar = Calendar.getInstance();
        Date dateObj = new Date(startDate);
        calendar.setTime(dateObj);
        Vector dates = new Vector();
        long date = startDate;
        Integer frequency = (Integer)this.getField(0, null);
        int interval = (Integer)this.getField(128, new Integer(1));
        int count = (Integer)this.getField(32, new Integer(Integer.MAX_VALUE));
        long end = (Long)this.getField(64, new Long(Long.MAX_VALUE));
        Integer dayInWeek = (Integer)this.getField(2, null);
        Integer dayInMonth = (Integer)this.getField(1, null);
        Integer dayInYear = (Integer)this.getField(4, null);
        Integer weekInMonth = (Integer)this.getField(16, null);
        Integer monthInYear = (Integer)this.getField(8, null);
        if (dayInMonth == null && weekInMonth == null) {
            dayInMonth = new Integer(calendar.get(5));
        }
        if (dayInWeek == null) {
            switch (calendar.get(7)) {
                case 1: {
                    dayInWeek = new Integer(65536);
                    break;
                }
                case 2: {
                    dayInWeek = new Integer(32768);
                    break;
                }
                case 3: {
                    dayInWeek = new Integer(16384);
                    break;
                }
                case 4: {
                    dayInWeek = new Integer(8192);
                    break;
                }
                case 5: {
                    dayInWeek = new Integer(4096);
                    break;
                }
                case 6: {
                    dayInWeek = new Integer(2048);
                    break;
                }
                case 7: {
                    dayInWeek = new Integer(1024);
                }
            }
        }
        long rangeStart = Math.max(subsetBeginning, startDate);
        long rangeEnd = Math.min(subsetEnding, end);
        block15: for (int i = 0; date <= subsetEnding && date <= end && i < count; ++i) {
            if (frequency == null) {
                this.storeDate(dates, startDate, rangeStart, rangeEnd);
                break;
            }
            switch (frequency) {
                case 16: {
                    this.storeDate(dates, date, rangeStart, rangeEnd);
                    dateObj.setTime(date += 86400000L * (long)interval);
                    calendar.setTime(dateObj);
                    continue block15;
                }
                case 17: {
                    if (dayInWeek == null) {
                        this.storeDate(dates, date, rangeStart, rangeEnd);
                    } else {
                        dateObj.setTime(date -= 86400000L * (long)(calendar.get(7) - 1));
                        calendar.setTime(dateObj);
                        this.storeDays(dates, date, rangeStart, rangeEnd, dayInWeek);
                    }
                    dateObj.setTime(date += 604800000L);
                    calendar.setTime(dateObj);
                    continue block15;
                }
                case 18: {
                    this.storeDaysByMonth(dates, date, rangeStart, rangeEnd, dayInWeek, dayInMonth, weekInMonth);
                    int currentMonth = calendar.get(2);
                    if (currentMonth == 11) {
                        int currentYear = calendar.get(1);
                        calendar.set(1, currentYear + 1);
                        calendar.set(2, 0);
                    } else {
                        calendar.set(2, currentMonth + 1);
                    }
                    dateObj = calendar.getTime();
                    date = dateObj.getTime();
                    continue block15;
                }
                case 19: {
                    if (monthInYear == null && dayInYear == null) {
                        this.storeDate(dates, date, rangeStart, rangeEnd);
                    } else {
                        calendar.set(2, 0);
                        dateObj = calendar.getTime();
                        date = dateObj.getTime();
                        if (monthInYear != null) {
                            int months = monthInYear;
                            for (int m = 0; m < MONTHS.length; ++m) {
                                if ((months & MONTHS[m]) == 0) continue;
                                calendar.set(2, m);
                                this.storeDaysByMonth(dates, calendar.getTime().getTime(), rangeStart, rangeEnd, dayInWeek, dayInMonth, weekInMonth);
                            }
                        } else {
                            calendar.set(5, 1);
                            dateObj = calendar.getTime();
                            date = dateObj.getTime();
                            this.storeDate(dates, date + (long)(dayInYear - 1) * 86400000L, rangeStart, rangeEnd);
                        }
                    }
                    calendar.set(1, calendar.get(1) + 1);
                    dateObj = calendar.getTime();
                    date = dateObj.getTime();
                    continue block15;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized value for frequency: " + frequency);
                }
            }
        }
        return dates.elements();
    }

    private void storeDate(Vector dates, long date, long rangeStart, long rangeEnd) {
        Date dateObj;
        if (date >= rangeStart && date <= rangeEnd && !this.exceptions.contains(dateObj = new Date(date))) {
            dates.addElement(new Date(date));
        }
    }

    private void storeDays(Vector dates, long date, long rangeStart, long rangeEnd, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(date));
        int dayShift = cal.get(7) - 1;
        date -= (long)dayShift * 86400000L;
        long dateNextWeek = (long)dayShift + 604800000L;
        for (int i = 0; i < DAYS.length; ++i) {
            if ((days & DAYS[i]) == 0) continue;
            long targetDate = dayShift > i ? dateNextWeek : date;
            this.storeDate(dates, targetDate + 86400000L * (long)i, rangeStart, rangeEnd);
        }
    }

    private void storeDaysByMonth(Vector dates, long date, long rangeStart, long rangeEnd, Integer dayInWeek, Integer dayInMonth, Integer weekInMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(date));
        date -= 86400000L * (long)(calendar.get(5) - 1);
        if (dayInMonth != null) {
            this.storeDate(dates, date + 86400000L * (long)(dayInMonth - 1), rangeStart, rangeEnd);
        } else if (weekInMonth != null) {
            long monthRangeStart = Math.max(rangeStart, date);
            long monthEnd = date + 2678400000L;
            calendar.setTime(new Date(monthEnd));
            while (calendar.get(5) > 1) {
                calendar.setTime(new Date(monthEnd -= 86400000L));
            }
            long monthRangeEnd = Math.min(rangeEnd, monthEnd -= 86400000L);
            int weeks = weekInMonth;
            if ((weeks & 1) != 0) {
                this.storeDays(dates, date, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 2) != 0) {
                this.storeDays(dates, date + 604800000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 4) != 0) {
                this.storeDays(dates, date + 1209600000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 8) != 0) {
                this.storeDays(dates, date + 1814400000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 0x10) != 0) {
                this.storeDays(dates, date + 2419200000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 0x20) != 0) {
                this.storeDays(dates, monthEnd - 518400000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 0x20) != 0) {
                this.storeDays(dates, monthEnd - 518400000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 0x40) != 0) {
                this.storeDays(dates, monthEnd - 1123200000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 0x80) != 0) {
                this.storeDays(dates, monthEnd - 1728000000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 0x100) != 0) {
                this.storeDays(dates, monthEnd - 2332800000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
            if ((weeks & 0x200) != 0) {
                this.storeDays(dates, monthEnd - 2937600000L, monthRangeStart, monthRangeEnd, dayInWeek);
            }
        }
    }

    public void addExceptDate(long date) {
        this.exceptions.addElement(new Date(date));
    }

    public void removeExceptDate(long date) {
        this.exceptions.removeElement(new Date(date));
    }

    public Enumeration getExceptDates() {
        Vector<Date> results = new Vector<Date>();
        Enumeration e = this.exceptions.elements();
        while (e.hasMoreElements()) {
            Date date = (Date)e.nextElement();
            results.addElement(new Date(date.getTime()));
        }
        return results.elements();
    }

    public int getInt(int field) {
        this.validateDataType(field, 3);
        return (Integer)this.getField(field, NO_DEFAULT);
    }

    private Object getField(int field, Object defaultValue) {
        Integer fieldKey = new Integer(field);
        Object fieldValue = this.fields.get(fieldKey);
        if (fieldValue == null) {
            if (defaultValue == NO_DEFAULT) {
                throw new FieldEmptyException();
            }
            return defaultValue;
        }
        return fieldValue;
    }

    public void setInt(int field, int value) {
        boolean isValid;
        this.validateDataType(field, 3);
        block0 : switch (field) {
            case 32: {
                isValid = value >= 1;
                break;
            }
            case 1: {
                isValid = value >= 1 && value <= 31;
                break;
            }
            case 2: {
                isValid = ((long)value & 0xFFFFFFFFFFFE03FFL) == 0L;
                break;
            }
            case 0: {
                switch (value) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        isValid = true;
                        break block0;
                    }
                }
                isValid = false;
                break;
            }
            case 128: {
                isValid = value >= 1;
                break;
            }
            case 8: {
                isValid = ((long)value & 0xFFFFFFFFE001FFFFL) == 0L;
                break;
            }
            case 16: {
                isValid = ((long)value & 0xFFFFFFFFFFFFFC00L) == 0L;
                break;
            }
            case 4: {
                isValid = value >= 1 && value <= 366;
                break;
            }
            default: {
                isValid = false;
            }
        }
        if (!isValid) {
            throw new IllegalArgumentException("Field value is invalid");
        }
        Integer fieldKey = new Integer(field);
        this.fields.put(fieldKey, new Integer(value));
    }

    public long getDate(int field) {
        this.validateDataType(field, 2);
        return (Long)this.getField(field, NO_DEFAULT);
    }

    public void setDate(int field, long value) {
        this.validateDataType(field, 2);
        Integer fieldKey = new Integer(field);
        this.fields.put(fieldKey, new Long(value));
    }

    public int[] getFields() {
        int[] result = new int[this.fields.size()];
        int i = 0;
        Enumeration e = this.fields.keys();
        while (e.hasMoreElements()) {
            Integer fieldKey = (Integer)e.nextElement();
            result[i++] = fieldKey;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RepeatRule)) {
            return false;
        }
        RepeatRule rule = (RepeatRule)obj;
        Calendar cal = Calendar.getInstance();
        int[] ruleFields = rule.getFields();
        block4: for (int i = 0; i < ruleFields.length; ++i) {
            int field = ruleFields[i];
            Object value = this.fields.get(new Integer(field));
            if (value == null) {
                return false;
            }
            switch (this.getDataType(field)) {
                case 3: {
                    int iValue = (Integer)value;
                    if (rule.getInt(field) == iValue) continue block4;
                    return false;
                }
                case 2: {
                    long thisDate = (Long)value;
                    long ruleDate = rule.getDate(field);
                    if (thisDate == ruleDate) {
                        return true;
                    }
                    if (Math.abs(thisDate - ruleDate) >= 86400000L) {
                        return false;
                    }
                    cal.setTime(new Date(thisDate));
                    int day = cal.get(5);
                    cal.setTime(new Date(ruleDate));
                    if (day == cal.get(5)) continue block4;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        Enumeration e = this.fields.keys();
        while (e.hasMoreElements()) {
            Integer fieldKey = (Integer)e.nextElement();
            int field = fieldKey;
            boolean match = false;
            for (int i = 0; i < ruleFields.length && !match; ++i) {
                if (ruleFields[i] != field) continue;
                match = true;
            }
            if (match) continue;
            return false;
        }
        int[] exceptionDates = new int[this.exceptions.size()];
        for (int i = 0; i < exceptionDates.length; ++i) {
            Date date = (Date)this.exceptions.elementAt(i);
            cal.setTime(date);
            exceptionDates[i] = cal.get(5) + 100 * cal.get(2) + 10000 * cal.get(1);
        }
        boolean[] matchedExceptionDates = new boolean[exceptionDates.length];
        Enumeration e2 = rule.getExceptDates();
        while (e2.hasMoreElements()) {
            Date date = (Date)e2.nextElement();
            cal.setTime(date);
            int day = cal.get(5) + 100 * cal.get(2) + 10000 * cal.get(1);
            boolean match = false;
            for (int i = 0; i < exceptionDates.length && !match; ++i) {
                if (exceptionDates[i] != day) continue;
                match = true;
                matchedExceptionDates[i] = true;
            }
            if (match) continue;
            return false;
        }
        for (int i = 0; i < matchedExceptionDates.length; ++i) {
            if (matchedExceptionDates[i]) continue;
            boolean duplicate = false;
            for (int j = 0; j < i && !duplicate; ++j) {
                duplicate = exceptionDates[j] == exceptionDates[i];
            }
            if (duplicate) continue;
            return false;
        }
        return true;
    }

    private void validateDataType(int field, int dataType) {
        int correctDataType = this.getDataType(field);
        if (dataType != correctDataType) {
            throw new IllegalArgumentException("Invalid field type");
        }
    }

    private int getDataType(int field) {
        switch (field) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 128: {
                return 3;
            }
            case 64: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unrecognized field: " + field);
    }
}

