/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io.file;

import com.sun.midp.io.j2me.file.RootCache;
import com.sun.midp.lcdui.SystemEventDispatcher;
import com.sun.midp.lcdui.SystemEventHandler;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.microedition.io.file.FileSystemEventHandler;
import javax.microedition.io.file.FileSystemListener;

public class FileSystemRegistry {
    private static Vector fileSystemListeners;
    private static RootCache rootCache;

    FileSystemRegistry() {
    }

    public static boolean addFileSystemListener(FileSystemListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        FileSystemRegistry.checkReadPermission();
        FileSystemRegistry.getRootCache().getRoots();
        fileSystemListeners.addElement(listener);
        return true;
    }

    public static boolean removeFileSystemListener(FileSystemListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return fileSystemListeners.removeElement(listener);
    }

    public static Enumeration listRoots() {
        FileSystemRegistry.checkReadPermission();
        return new Enumeration(){
            String[] roots = FileSystemRegistry.access$000().getRoots();
            int index = 0;

            public boolean hasMoreElements() {
                return this.index < this.roots.length;
            }

            public Object nextElement() {
                try {
                    return this.roots[this.index++];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    static synchronized void addRoot(String root) {
        RootCache cache = FileSystemRegistry.getRootCache();
        if (!cache.isRoot(root)) {
            cache.addRoot(root);
            FileSystemRegistry.notifyListeners(0, root);
        }
    }

    static synchronized void removeRoot(String root) {
        FileSystemRegistry.getRootCache().removeRoot(root);
        FileSystemRegistry.notifyListeners(1, root);
    }

    private static void notifyListeners(int event, String root) {
        for (int i = 0; i < fileSystemListeners.size(); ++i) {
            try {
                ((FileSystemListener)fileSystemListeners.elementAt(i)).rootChanged(event, root);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static void checkReadPermission() {
        MIDletSuite suite = Scheduler.getScheduler().getMIDletSuite();
        try {
            suite.checkForPermission(31, null);
        }
        catch (InterruptedException ie) {
            throw new SecurityException("Interrupted while trying to ask the user permission");
        }
    }

    private static synchronized RootCache getRootCache() {
        if (rootCache == null) {
            rootCache = RootCache.getInstance((FileSystemRegistry)new FileSystemRegistry());
        }
        return rootCache;
    }

    static /* synthetic */ RootCache access$000() {
        return FileSystemRegistry.getRootCache();
    }

    static {
        SystemEventDispatcher.addHandler((SystemEventHandler)new FileSystemEventHandler());
        fileSystemListeners = new Vector(2);
    }
}

