/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.UIException;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;
import com.siemens.mp.app.calculatorconverter.CalculatorCore;
import com.siemens.mp.app.calculatorconverter.Category;
import com.siemens.mp.app.calculatorconverter.InputLine;
import com.siemens.mp.app.calculatorconverter.Unit;
import com.siemens.mp.app.calculatorconverter.UnitConverterCore;
import com.siemens.mp.app.calculatorconverter.UnitConverterData;
import com.siemens.mp.app.calculatorconverter.UnitConverterUI;
import com.siemens.mp.app.j2meunit.framework.TestCase;
import j2meunit.framework.Test;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;

public class UnitNumberTest
extends TestCase {
    private CalculatorCore calculatorCore = new CalculatorCore();

    public UnitNumberTest(String testName, TestMethod testMethod) {
        super(testName, testMethod);
    }

    public UnitNumberTest() {
    }

    public Test suite() {
        TestSuite aSuite = new TestSuite();
        aSuite.addTest(new UnitNumberTest("performBasicOperationsTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitNumberTest)tc).performBasicOperationsTest();
            }
        }));
        aSuite.addTest(new UnitNumberTest("performAdvancedOperationsTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitNumberTest)tc).performAdvancedOperationsTest();
            }
        }));
        aSuite.addTest(new UnitNumberTest("convertTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitNumberTest)tc).convertTest();
            }
        }));
        aSuite.addTest(new UnitNumberTest("digitPrecisionTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitNumberTest)tc).digitPrecisionTest();
            }
        }));
        aSuite.addTest(new UnitNumberTest("tooBigNumberTest", new TestMethod(){

            public void run(j2meunit.framework.TestCase tc) {
                ((UnitNumberTest)tc).tooBigNumberTest();
            }
        }));
        return aSuite;
    }

    public final void performBasicOperationsTest() {
        this.writeLogTestCase("TC_[Wolf5.Calculator.002]_001", "performBasicOperationsTest");
        this.writeLogExecTestCase("TC_[Wolf5.Calculator.002]_001_01");
        InputLine line = new InputLine();
        this.writeLogInput("5");
        this.writeLogInput("9");
        this.writeLogExpected("14");
        this.calculatorCore.performOperation(0, 53, line);
        this.calculatorCore.performOperation(1, 8, line);
        this.calculatorCore.performOperation(0, 57, line);
        this.calculatorCore.performOperation(1, 7, line);
        this.writeLogCurrent((long)line.toDouble());
        this.assertEquals(14L, (long)line.toDouble());
        this.writeLogExecTestCase("TC_[Wolf5.Calculator.002]_001_02");
        line = new InputLine();
        this.writeLogInput("15");
        this.writeLogInput("5");
        this.writeLogExpected("10");
        this.calculatorCore.performOperation(0, 49, line);
        this.calculatorCore.performOperation(0, 53, line);
        this.calculatorCore.performOperation(1, 6, line);
        this.calculatorCore.performOperation(0, 53, line);
        this.calculatorCore.performOperation(1, 7, line);
        this.writeLogCurrent((long)line.toDouble());
        this.assertEquals(10L, (long)line.toDouble());
        this.writeLogExecTestCase("TC_[Wolf5.Calculator.002]_001_03");
        line = new InputLine();
        this.writeLogInput("10");
        this.writeLogInput("2");
        this.writeLogExpected("20");
        this.calculatorCore.performOperation(0, 49, line);
        this.calculatorCore.performOperation(0, 48, line);
        this.calculatorCore.performOperation(1, 2, line);
        this.calculatorCore.performOperation(0, 50, line);
        this.calculatorCore.performOperation(1, 7, line);
        this.writeLogCurrent((long)line.toDouble());
        this.assertEquals(20L, (long)line.toDouble());
        this.writeLogExecTestCase("TC_[Wolf5.Calculator.002]_001_04");
        line = new InputLine();
        this.writeLogInput("20");
        this.writeLogInput("4");
        this.writeLogExpected("5");
        this.calculatorCore.performOperation(0, 50, line);
        this.calculatorCore.performOperation(0, 48, line);
        this.calculatorCore.performOperation(1, 12, line);
        this.calculatorCore.performOperation(0, 52, line);
        this.calculatorCore.performOperation(1, 7, line);
        this.writeLogCurrent((long)line.toDouble());
        this.assertEquals(5L, (long)line.toDouble());
        this.writeLogResultPass();
    }

    public final void performAdvancedOperationsTest() {
        this.writeLogTestCase("TC_[Wolf5.Calculator.002]_002", "performAdvancedOperationsTest");
        this.writeLogExecTestCase("TC_[Wolf5.Calculator.002]_002_01");
        InputLine line = new InputLine();
        this.writeLogInput("20");
        this.writeLogInput("10");
        this.writeLogExpected("22");
        this.calculatorCore.performOperation(0, 50, line);
        this.calculatorCore.performOperation(0, 48, line);
        this.calculatorCore.performOperation(1, 8, line);
        this.calculatorCore.performOperation(0, 49, line);
        this.calculatorCore.performOperation(0, 48, line);
        this.calculatorCore.performOperation(2, 3, line);
        this.calculatorCore.performOperation(1, 7, line);
        this.writeLogCurrent((long)line.toDouble());
        this.assertEquals(22L, (long)line.toDouble());
        this.writeLogExecTestCase("TC_[Wolf5.Calculator.002]_002_02");
        line = new InputLine();
        this.writeLogInput("20");
        this.writeLogExpected("400");
        this.calculatorCore.performOperation(0, 50, line);
        this.calculatorCore.performOperation(0, 48, line);
        this.calculatorCore.performOperation(2, 5, line);
        this.calculatorCore.performOperation(1, 7, line);
        this.writeLogCurrent((long)line.toDouble());
        this.assertEquals(400L, (long)line.toDouble());
        this.writeLogExecTestCase("TC_[Wolf5.Calculator.002]_002_03");
        line = new InputLine();
        this.writeLogInput("100");
        this.writeLogExpected("10");
        this.calculatorCore.performOperation(0, 49, line);
        this.calculatorCore.performOperation(0, 48, line);
        this.calculatorCore.performOperation(0, 48, line);
        this.calculatorCore.performOperation(2, 0, line);
        this.calculatorCore.performOperation(1, 7, line);
        this.writeLogCurrent((long)line.toDouble());
        this.assertEquals(10L, (long)line.toDouble());
        this.writeLogResultPass();
    }

    public final void convertTest() {
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.001]_003", "convertTest");
        try {
            UnitConverterCore converterCore = new UnitConverterCore();
            UnitConverterData data = converterCore.getDataObject();
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_01");
            this.writeLogInput("0");
            this.writeLogExpected("Length");
            data.setSelectedCategoryIndex(0);
            Category category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Length", category.getName());
            Unit unit1 = category.getUnit(0);
            Unit unit2 = category.getUnit(1);
            double operand = 1000.0;
            this.writeLogInput("1000");
            this.writeLogInput("Millimetres");
            this.writeLogInput("Centimetres");
            this.writeLogExpected("100");
            double result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent((long)result);
            this.assertEquals(100L, (long)result);
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_02");
            this.writeLogInput("1");
            this.writeLogExpected("Temperature");
            data.setSelectedCategoryIndex(1);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Temperature", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 20.0;
            this.writeLogInput("20");
            this.writeLogInput("Celsius");
            this.writeLogInput("Fahrenheit");
            this.writeLogExpected("68");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent((long)result);
            this.assertEquals(68L, (long)result);
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_03");
            this.writeLogInput("3");
            this.writeLogExpected("Energy");
            data.setSelectedCategoryIndex(3);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Energy", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 20000.0;
            this.writeLogInput("20000");
            this.writeLogInput("Calories");
            this.writeLogInput("Kilocalories");
            this.writeLogExpected("20");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent((long)result);
            this.assertEquals(20L, (long)result);
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_04");
            this.writeLogInput("4");
            this.writeLogExpected("Velocity");
            data.setSelectedCategoryIndex(4);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Velocity", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 90.0;
            this.writeLogInput("90");
            this.writeLogInput("KilometresPerH");
            this.writeLogInput("MilesPerH");
            this.writeLogExpected("55.923408");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent(result);
            this.assertEquals(new Double(55.923408), new Double(result));
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_05");
            this.writeLogInput("5");
            this.writeLogExpected("Mass");
            data.setSelectedCategoryIndex(5);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Mass", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 2500.0;
            this.writeLogInput("2500");
            this.writeLogInput("Milligrams");
            this.writeLogInput("Grains");
            this.writeLogExpected("38.580896");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent(result);
            this.assertEquals(new Double(38.580896), new Double(result));
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_06");
            this.writeLogInput("6");
            this.writeLogExpected("Area");
            data.setSelectedCategoryIndex(6);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Area", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 3600.0;
            this.writeLogInput("3600");
            this.writeLogInput("SquareMm");
            this.writeLogInput("SquareCm");
            this.writeLogExpected("36");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent(result);
            this.assertEquals(36L, (long)result);
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_07");
            this.writeLogInput("7");
            this.writeLogExpected("Volume_MEASURE");
            data.setSelectedCategoryIndex(7);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Volume_MEASURE", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 7000.0;
            this.writeLogInput("7000");
            this.writeLogInput("Millilitres");
            this.writeLogInput("Centilitres");
            this.writeLogExpected("700");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent((long)result);
            this.assertEquals(700L, (long)result);
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_08");
            this.writeLogInput("8");
            this.writeLogExpected("Power");
            data.setSelectedCategoryIndex(8);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Power", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 800.0;
            this.writeLogInput("800");
            this.writeLogInput("Horsepower");
            this.writeLogInput("Kilowatts");
            this.writeLogExpected("588.3990400001574");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent(result);
            this.assertEquals(new Double(588.3990400001574), new Double(result));
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_09");
            this.writeLogInput("9");
            this.writeLogExpected("Time");
            data.setSelectedCategoryIndex(9);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Time", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 20.0;
            this.writeLogInput("20");
            this.writeLogInput("Seconds");
            this.writeLogInput("Minutes");
            this.writeLogExpected("0.3333333333333333");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent(result);
            this.assertEquals(new Double(0.3333333333333333), new Double(result));
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.001]_003_10");
            this.writeLogInput("10");
            this.writeLogExpected("Pressure");
            data.setSelectedCategoryIndex(10);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Pressure", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 3000.0;
            this.writeLogInput("3000");
            this.writeLogInput("Bars");
            this.writeLogInput("Atmospheres");
            this.writeLogExpected("2960.7698001480385");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent(result);
            this.assertEquals(new Double(2960.7698001480385), new Double(result));
            this.writeLogResultPass();
        }
        catch (Exception uie) {
            this.writeLogResultFail();
            this.fail(uie.getMessage());
        }
    }

    public final void digitPrecisionTest() {
        double operand;
        Unit unit2;
        Unit unit1;
        Category category;
        UnitConverterCore converterCore = new UnitConverterCore();
        UnitConverterData data = converterCore.getDataObject();
        double result = 0.0;
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.010]_001", "digitPrecisionTest");
        try {
            this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.010]_001_01");
            this.writeLogInput("8");
            this.writeLogExpected("Power");
            data.setSelectedCategoryIndex(8);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Power", category.getName());
            unit1 = category.getUnit(1);
            unit2 = category.getUnit(2);
            operand = 1000000.0;
            this.writeLogInput("1000000");
            this.writeLogInput("Kilowatts");
            this.writeLogInput("Watts");
            this.writeLogExpected("1000000000");
            result = UnitConverterUI.convert(operand, unit1, unit2);
            this.writeLogCurrent((long)result);
            this.assertEquals(1000000000L, (long)result);
        }
        catch (Exception uie) {
            this.fail(uie.getMessage());
        }
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.010]_002_01");
        try {
            this.writeLogInput("3");
            this.writeLogExpected("Energy");
            data.setSelectedCategoryIndex(3);
            category = data.getSelectedCategory();
            this.writeLogCurrent(category.getName());
            this.assertEquals("Energy", category.getName());
            unit1 = category.getUnit(0);
            unit2 = category.getUnit(1);
            operand = 1.0E7;
            this.writeLogInput("10000000");
            this.writeLogInput("Kilocalories");
            this.writeLogInput("Calories");
            this.writeLogExpected("1.0000000000000002E10");
            result = UnitConverterUI.convert(operand, unit2, unit1);
            this.writeLogCurrent(result);
            this.assertEquals(new Double(1.0000000000000002E10), new Double(result));
            String resultDisplayedOnScreen = CalcConvApp.getFormattedValue(result);
            this.writeLogExpected("1e10");
            this.writeLogCurrent(resultDisplayedOnScreen);
            this.assertEquals("1e10", resultDisplayedOnScreen);
            this.writeLogResultPass();
        }
        catch (Exception uie) {
            this.fail(uie.getMessage());
        }
    }

    public final void tooBigNumberTest() {
        this.writeLogTestCase("TC_[Wolf5.UnitConverter.011]_001", "tooBigNumberTest");
        this.writeLogExecTestCase("TC_[Wolf5.UnitConverter.011]_001_01");
        try {
            this.writeLogInput("10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
            this.writeLogExpected("com.siemens.mp.app.UIException");
            double n = Double.parseDouble("10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
            System.out.println(CalcConvApp.getFormattedValue(n));
            this.fail("Should raise an UIException, because the number is too big");
        }
        catch (UIException uie) {
            this.writeLogCurrent(uie.getClass().getName());
            this.writeLogResultPass();
        }
    }
}

