/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.UIException;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;
import com.siemens.mp.app.calculatorconverter.Category;
import com.siemens.mp.app.calculatorconverter.UnitConverterUI;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;

public class UnitConverterTextField_
extends CustomItem
implements Runnable {
    public static final int EXPONENTIAL = 1;
    public static final int ANY = 2;
    private String entry = "";
    private int width;
    private Form container;
    private boolean isClear = false;
    double value;
    Category cat;
    UnitConverterUI ui;
    protected boolean horz;
    protected boolean vert;
    protected static final int UPPER = 0;
    protected static final int IN = 1;
    protected static final int LOWER = 2;
    protected int location = 0;
    private Thread th;
    boolean editable = false;
    private String reference = "";
    private boolean mustPaintCursor = false;
    private boolean blinkCursor = false;
    private TimerTask task;
    private Timer t;

    public UnitConverterTextField_(String label) {
        super(label);
    }

    public UnitConverterTextField_(Displayable object, String string, int i, int type) {
        this(string);
        this.container = (Form)object;
        this.setPreferredSize(240, 30);
        int interactionMode = this.getInteractionModes();
        this.horz = (interactionMode & 1) != 0;
        this.vert = (interactionMode & 2) != 0;
    }

    protected final int getMinContentWidth() {
        return 240;
    }

    protected final int getMinContentHeight() {
        return 32;
    }

    protected final int getPrefContentWidth(int arg0) {
        return this.getMinimumWidth();
    }

    protected final int getPrefContentHeight(int arg0) {
        return this.getMinimumHeight();
    }

    protected final void keyPressed(int keyCode) {
        if (keyCode == -8) {
            this.clearLastDigit();
            this.modifyState();
        }
        if (this.entry.length() <= 14 || keyCode == 35) {
            String input = "";
            if (keyCode >= 48 && keyCode <= 57) {
                input = String.valueOf((char)keyCode);
            } else if (keyCode == 42) {
                input = this.entry.indexOf("e") == -1 && this.entry.indexOf(".") == -1 ? String.valueOf('.') : "";
            } else if (keyCode == 35) {
                if (this.entry.length() != 0) {
                    this.value = -Double.parseDouble(this.entry);
                    try {
                        this.entry = CalcConvApp.getFormattedValue(this.value);
                    }
                    catch (UIException uie) {
                        this.entry = "-0.0";
                    }
                } else {
                    return;
                }
            }
            this.entry = String.valueOf(this.entry) + input;
        }
        if (this.entry.equals("")) {
            this.setString("");
            this.value = Double.NaN;
        } else if (this.entry.startsWith("0") && !this.entry.equals("0") && !this.entry.startsWith("0.")) {
            this.setString(this.entry.substring(1));
            this.value = Double.parseDouble(this.entry);
        } else {
            this.value = Double.parseDouble(this.entry);
        }
        this.modifyState();
        if (this.isClear) {
            this.isClear = false;
        }
    }

    protected void keyRepeated(int keyCode) {
        this.entry = "";
    }

    public final void modifyState() {
        this.repaint();
        this.notifyStateChanged();
    }

    public final void clearLastDigit() {
        int length = this.entry.length();
        if (length > 0) {
            this.entry = this.entry.substring(0, length - 1);
        }
        if (this.entry.length() == 0) {
            this.isClear = true;
        }
    }

    protected void paint(Graphics g, int arg1, int arg2) {
        g.setColor(255, 255, 255);
        g.setColor(7570646);
        g.setFont(Font.getFont((int)64, (int)1, (int)0));
        g.drawString(this.entry, 3, 6, 20);
        g.setColor(0, 0, 0);
        this.width = g.getFont().stringWidth(this.entry);
        if (this.mustPaintCursor) {
            if (this.blinkCursor) {
                g.drawLine(this.width + 4, 10, this.width + 4, 25);
            }
            this.blinkCursor = !this.blinkCursor;
        }
    }

    public final void setString(String s) {
        this.entry = s;
        if (this.container.isShown()) {
            this.repaint();
        }
    }

    public final String getString() {
        return this.entry;
    }

    protected void traverseOut() {
        super.traverseOut();
        this.setEditable(false);
        this.mustPaintCursor = false;
    }

    protected boolean traverse(int arg0, int arg1, int arg2, int[] arg3) {
        this.mustPaintCursor = true;
        this.blinkCursor = true;
        this.setEditable(true);
        if (this.horz && this.vert) {
            switch (arg0) {
                case 6: {
                    if (this.location == 0) {
                        this.location = 1;
                        break;
                    }
                    if (this.getReference().equals(this.toString())) {
                        this.location = 1;
                        return true;
                    }
                    this.location = 2;
                    return false;
                }
                case 1: {
                    if (this.location == 2) {
                        this.location = 1;
                        break;
                    }
                    this.location = 0;
                    return false;
                }
                case 2: {
                    return true;
                }
                case 5: {
                    return true;
                }
            }
        } else if (this.horz || this.vert) {
            switch (arg0) {
                case 1: 
                case 2: {
                    if (this.location == 2) {
                        this.location = 1;
                        break;
                    }
                    this.location = 0;
                    return false;
                }
                case 5: 
                case 6: {
                    if (this.location == 0) {
                        this.location = 1;
                        break;
                    }
                    this.location = 2;
                    return false;
                }
            }
        }
        return true;
    }

    public void run() {
        while (this.editable) {
            try {
                this.repaint(this.width + 4, 3, this.width + 4, this.getPreferredHeight() - 3);
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setEditable(boolean newState) {
        this.mustPaintCursor = newState;
        if (newState && !this.editable) {
            this.editable = newState;
            new Thread(this).start();
        }
        this.editable = newState;
    }

    protected void setReference() {
        this.reference = this.toString();
    }

    public String getReference() {
        return this.reference;
    }
}

