/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.calculatorconverter.Category;
import com.siemens.mp.app.calculatorconverter.InputLine;
import com.siemens.mp.app.calculatorconverter.UnitConverterUI;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;

public class UnitConverterTextField
extends CustomItem
implements Runnable {
    public static final int EXPONENTIAL = 1;
    public static final int ANY = 2;
    private String entry = "";
    private int width;
    private Form container;
    private boolean isClear = false;
    double value;
    Category cat;
    UnitConverterUI ui;
    protected boolean horz;
    protected boolean vert;
    protected static final int UPPER = 0;
    protected static final int IN = 1;
    protected static final int LOWER = 2;
    protected int location = 0;
    private Thread th;
    boolean editable = false;
    private String reference = "";
    private InputLine mInputLine;
    private int tamanho = 0;
    private boolean isInChoice = false;
    private boolean mustPaintCursor = false;
    private boolean blinkCursor = false;
    private TimerTask task;
    private Timer t;
    private boolean left = false;
    private boolean right = false;
    private boolean isFirst = false;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    long transactionTime = 0L;
    long oldTime = 0L;
    boolean mExpSign = false;
    int positioncurrent = 0;
    private boolean last = false;
    private String insering = "";
    private String lastCaracter = "";
    private int lastPosition = 0;
    private Graphics graph;

    public UnitConverterTextField(String label) {
        super(label);
    }

    public UnitConverterTextField(Displayable object, String string, int i, int type) {
        this(string);
        this.container = (Form)object;
        this.setPreferredSize(240, 30);
        int interactionMode = this.getInteractionModes();
        this.horz = (interactionMode & 1) != 0;
        this.vert = (interactionMode & 2) != 0;
        this.right = false;
        this.left = false;
        this.isFirst = true;
    }

    public UnitConverterTextField(Displayable object, String string, int i, int type, UnitConverterUI ui) {
        this(string);
        this.container = (Form)object;
        this.setPreferredSize(240, 30);
        int interactionMode = this.getInteractionModes();
        this.horz = (interactionMode & 1) != 0;
        this.vert = (interactionMode & 2) != 0;
        this.ui = ui;
        this.right = false;
        this.left = false;
        this.isFirst = true;
    }

    protected final int getMinContentWidth() {
        return 240;
    }

    protected final int getMinContentHeight() {
        return 32;
    }

    protected final int getPrefContentWidth(int arg0) {
        return this.getMinimumWidth();
    }

    protected final int getPrefContentHeight(int arg0) {
        return this.getMinimumHeight();
    }

    protected final void keyPressed(int keyCode) {
        if (keyCode == -8) {
            this.clearLastDigit();
            this.modifyState();
        }
        if (this.entry.length() <= 14 || keyCode == 35) {
            String input = "";
            if (keyCode >= 48 && keyCode <= 57) {
                input = String.valueOf((char)keyCode);
                System.out.println("1. input :" + input);
            } else if (keyCode == 42) {
                if (this.entry.indexOf("e") == -1 && this.entry.indexOf(".") == -1) {
                    input = String.valueOf('.');
                    this.oldTime = System.currentTimeMillis();
                } else {
                    this.transactionTime = System.currentTimeMillis();
                    input = "";
                    if (this.entry.length() > 0 && !this.entry.equals(".")) {
                        if (this.entry.indexOf("e") != -1) {
                            if (this.transactionTime - this.oldTime <= 500L) {
                                this.entry.indexOf(".");
                                this.oldTime = System.currentTimeMillis();
                            } else {
                                String strpos;
                                input = "";
                                if (this.positioncurrent < this.entry.indexOf("e") && (strpos = this.entry.substring(0, this.entry.indexOf("e"))).indexOf(".") == -1) {
                                    this.entry = String.valueOf(this.entry.substring(0, this.positioncurrent)) + "." + this.entry.substring(this.positioncurrent);
                                    ++this.positioncurrent;
                                    this.width += 9;
                                }
                                this.oldTime = System.currentTimeMillis();
                            }
                        } else if (this.entry.indexOf(".") != -1) {
                            if (this.transactionTime - this.oldTime <= 500L) {
                                this.entry = this.entry.replace('.', 'e');
                                this.width += 7;
                                this.oldTime = System.currentTimeMillis();
                            } else {
                                input = "e";
                                this.oldTime = System.currentTimeMillis();
                            }
                        }
                    }
                }
            } else if (keyCode == 35) {
                if (this.entry.length() != 0 && !this.entry.equals(".")) {
                    int pos = 0;
                    if (this.entry.indexOf("e") != -1) {
                        pos = this.entry.indexOf("e");
                    }
                    input = "-";
                } else {
                    return;
                }
            }
            System.out.println("2. input :" + input);
            this.entry = this.insert(input);
        }
        if (this.entry.equals("")) {
            this.setString("");
            this.value = Double.NaN;
        } else if (this.entry.startsWith("0") && !this.entry.equals("0") && !this.entry.startsWith("0.")) {
            if (!(this.entry.endsWith("e") || this.entry.endsWith("-") || this.entry.startsWith("0") && this.entry.indexOf("e") != -1)) {
                this.width -= 15;
                this.setString(this.entry.substring(1));
                this.value = Double.parseDouble(this.entry);
            }
        } else if (!(this.entry.endsWith("e") || this.entry.endsWith("-") || this.entry.equals("."))) {
            this.value = Double.parseDouble(this.entry);
        }
        this.modifyState();
        if (this.isClear) {
            this.isClear = false;
        }
    }

    protected void keyRepeated(int keyCode) {
        this.entry = "";
    }

    public final void modifyState() {
        this.repaint();
        this.notifyStateChanged();
    }

    public final void clearLastDigit() {
        boolean pos = false;
        String text = "";
        this.right = false;
        this.left = false;
        int length = this.entry.length();
        if (length > 0) {
            if (this.positioncurrent > 0) {
                if (this.positioncurrent == this.entry.length()) {
                    this.width = this.entry.charAt(length - 1) == '.' || this.entry.charAt(length - 1) == '-' ? (this.width -= 8) : (this.width -= 15);
                    this.entry = this.entry.substring(0, length - 1);
                } else {
                    this.width = this.entry.charAt(this.positioncurrent - 1) == '.' || this.entry.charAt(this.positioncurrent - 1) == '-' ? (this.width -= 10) : (this.width -= 15);
                    length = this.positioncurrent - 1;
                    this.entry = String.valueOf(this.entry.substring(0, length)) + this.entry.substring(this.positioncurrent);
                }
                --this.positioncurrent;
            } else if (this.positioncurrent == 0) {
                this.entry = this.entry.substring(this.positioncurrent + 1);
                this.width = 0;
            }
        }
        if (this.entry.length() == 0) {
            this.isClear = true;
            this.width = 0;
            this.positioncurrent = 0;
        }
    }

    protected void paint(Graphics g, int arg1, int arg2) {
        g.setColor(255, 255, 255);
        g.setColor(7570646);
        System.out.println("entry" + this.entry);
        System.out.println("poition" + this.positioncurrent);
        if (this.graph == null) {
            this.graph = g;
        }
        g.setFont(Font.getFont((int)64, (int)1, (int)0));
        g.drawString(this.entry, 3, 6, 20);
        g.setColor(0, 0, 0);
        if (this.isFirst) {
            this.width = g.getFont().stringWidth(this.entry);
        }
        if (this.mustPaintCursor) {
            if (this.blinkCursor) {
                if (this.left) {
                    --this.positioncurrent;
                    if (this.positioncurrent >= 0) {
                        if (this.entry.startsWith("-")) {
                            this.width = this.entry.charAt(this.positioncurrent) == '.' || this.entry.charAt(this.positioncurrent) == '-' ? (this.width -= 8) : (this.width -= 15);
                        } else {
                            this.width = this.entry.charAt(this.positioncurrent) == '.' || this.entry.charAt(this.positioncurrent) == '-' ? (this.width -= 8) : (this.width -= 15);
                            this.x1 = this.width;
                            this.y1 = 7;
                            this.x2 = this.width;
                            this.y2 = this.getPreferredHeight() - 3;
                        }
                    } else {
                        this.positioncurrent = 0;
                    }
                    if (this.width < 0) {
                        this.width = 0;
                    }
                    this.left = false;
                } else {
                    if (this.right) {
                        if (this.width <= 225 && !this.last) {
                            String s = "" + this.entry.charAt(this.positioncurrent);
                            if (!this.last) {
                                if (this.entry.startsWith("-") && s.equals("-")) {
                                    this.width += 8;
                                } else if (this.positioncurrent > this.entry.length()) {
                                    this.width = this.entry.charAt(this.positioncurrent) == '.' || this.entry.charAt(this.positioncurrent) == '-' ? (this.width += 8) : (this.width += 15);
                                } else {
                                    this.last = true;
                                    this.width = this.entry.charAt(this.positioncurrent) == '.' || this.entry.charAt(this.positioncurrent) == '-' ? (this.width += 8) : (this.entry.charAt(this.positioncurrent) == '.' || this.entry.charAt(this.positioncurrent) == '-' ? (this.width += 8) : (this.width += 15));
                                }
                            }
                            this.x1 = this.width;
                            this.x2 = this.width;
                            ++this.positioncurrent;
                        } else if (!this.last) {
                            this.width = 225;
                        }
                        this.right = false;
                    } else if (this.isFirst) {
                        this.width += 2;
                        this.x2 = this.x1 = this.width;
                        this.isFirst = false;
                    } else {
                        this.x1 = this.width;
                        this.x2 = this.width;
                    }
                    this.y1 = 7;
                    this.y2 = this.getPreferredHeight() - 3;
                }
                g.drawLine(this.x1, this.y1, this.x2, this.y2);
            }
            this.blinkCursor = !this.blinkCursor;
        }
    }

    public final void setString(String s) {
        this.entry = s;
        this.positioncurrent = this.entry.length();
        if (this.container.isShown()) {
            this.repaint();
        }
    }

    public void initialize() {
        this.positioncurrent = this.entry.length();
        this.right = false;
        this.left = false;
        this.isFirst = true;
    }

    public final String getString() {
        return this.entry;
    }

    protected void traverseOut() {
        this.setEditable(false);
        this.mustPaintCursor = false;
        this.positioncurrent = this.entry.length();
        this.right = false;
        this.left = false;
        this.isFirst = true;
    }

    protected boolean traverse(int arg0, int arg1, int arg2, int[] arg3) {
        this.mustPaintCursor = true;
        this.blinkCursor = true;
        this.setEditable(true);
        if (this.horz && this.vert) {
            switch (arg0) {
                case 6: {
                    if (this.location == 0) {
                        this.location = 1;
                        break;
                    }
                    this.location = 2;
                    if (this.isInChoice) {
                        this.isInChoice = false;
                        return true;
                    }
                    this.right = false;
                    this.left = false;
                    this.isFirst = true;
                    return false;
                }
                case 1: {
                    if (this.location == 2) {
                        this.location = 1;
                        break;
                    }
                    if (this.isInChoice) {
                        this.location = 1;
                        return true;
                    }
                    this.location = 0;
                    this.right = false;
                    this.left = false;
                    this.isFirst = true;
                    return false;
                }
                case 2: {
                    this.left = true;
                    if (this.positioncurrent < 0) {
                        this.positioncurrent = 0;
                    }
                    if (this.entry.length() == 0) {
                        this.width = 0;
                        this.left = false;
                    }
                    this.repaint();
                    return true;
                }
                case 5: {
                    this.right = true;
                    this.last = false;
                    if (this.positioncurrent == this.entry.length()) {
                        this.right = false;
                        this.last = true;
                    }
                    this.repaint();
                    return true;
                }
            }
        } else if (this.horz || this.vert) {
            switch (arg0) {
                case 1: 
                case 2: {
                    if (this.location == 2) {
                        this.location = 1;
                        break;
                    }
                    this.location = 0;
                    this.right = false;
                    this.left = false;
                    this.isFirst = true;
                    return false;
                }
                case 5: 
                case 6: {
                    if (this.location == 0) {
                        this.location = 1;
                        break;
                    }
                    this.location = 2;
                    this.right = false;
                    this.left = false;
                    this.isFirst = true;
                    return false;
                }
            }
        }
        return true;
    }

    public void run() {
        while (this.editable) {
            try {
                this.repaint();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setEditable(boolean newState) {
        this.mustPaintCursor = newState;
        if (newState && !this.editable) {
            this.editable = newState;
            new Thread(this).start();
        }
        this.editable = newState;
    }

    protected void setReference() {
        this.reference = this.toString();
    }

    public String getReference() {
        return this.reference;
    }

    private String insert(String str) {
        String strRet = "";
        this.insering = str;
        boolean tam = false;
        if (this.validate(str, this.positioncurrent)) {
            if (this.entry.length() > 0 && !str.equals("")) {
                if (str.equals("-")) {
                    if (this.entry.indexOf("e") < this.positioncurrent) {
                        String strexp = this.entry.substring(this.entry.indexOf("e") + 1);
                        if (strexp.indexOf("-") != -1) {
                            strexp = strexp.substring(1);
                            strRet = String.valueOf(this.entry.substring(0, this.entry.indexOf("e") + 1)) + strexp;
                            this.width -= 9;
                            --this.positioncurrent;
                        } else {
                            strRet = String.valueOf(this.entry.substring(0, this.entry.indexOf("e") + 1)) + str + strexp;
                            this.width += 9;
                            ++this.positioncurrent;
                        }
                    } else {
                        String first = "" + this.entry.charAt(0);
                        if (first.equals("-")) {
                            this.width -= 9;
                            --this.positioncurrent;
                            strRet = this.entry.substring(1);
                        } else {
                            this.width += 9;
                            ++this.positioncurrent;
                            strRet = String.valueOf(str) + this.entry;
                        }
                    }
                } else {
                    strRet = String.valueOf(this.entry.substring(0, this.positioncurrent)) + str + this.entry.substring(this.positioncurrent);
                    this.width = str.equals(".") ? (this.width += 10) : (this.width += 15);
                    ++this.positioncurrent;
                }
            } else {
                strRet = String.valueOf(this.entry) + str;
                if (!str.equals("")) {
                    ++this.positioncurrent;
                    this.width = str.equals(".") ? (this.width += 10) : (this.width += 15);
                }
            }
        } else {
            strRet = this.entry;
        }
        this.right = false;
        this.left = false;
        this.isFirst = false;
        return strRet;
    }

    private int getSizeChar(String text, Graphics g, int widthValue, int dir) {
        int maxWidth = this.width;
        if (text.indexOf(".") != -1 || text.indexOf("e") != -1) {
            widthValue = 15;
        }
        if (widthValue >= maxWidth) {
            widthValue = maxWidth;
        }
        int y = 0;
        int aux = Math.abs(widthValue / 15);
        if (aux >= text.length()) {
            aux = text.length() - 1;
        } else if (dir == 0) {
            y = aux - 1;
        } else {
            y = aux + 1;
            if (y >= text.length()) {
                y = text.length() - 1;
            }
        }
        char[] s = text.toCharArray();
        int b = 0;
        b = g.getFont().stringWidth("" + s[y]);
        return b;
    }

    private boolean aftherdot() {
        int aux;
        boolean ret = false;
        int d = this.entry.indexOf(".");
        if (d != -1 && (aux = Math.abs(this.width / 15)) > d) {
            ret = true;
        }
        return ret;
    }

    public boolean isInChoice() {
        return this.isInChoice;
    }

    public void setInChoice(boolean isInChoice) {
        this.isInChoice = isInChoice;
    }

    private boolean validate(String s, int position) {
        boolean isvalidate = false;
        if (this.entry == null) {
            return false;
        }
        if (position == 0 && s.equals("0") && this.entry.length() > 0) {
            return isvalidate;
        }
        isvalidate = true;
        return isvalidate;
    }
}

