/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.PersistableObject;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;
import com.siemens.mp.app.calculatorconverter.Category;
import com.siemens.mp.app.calculatorconverter.NameList;
import com.siemens.mp.app.calculatorconverter.Unit;
import java.util.Vector;

class UnitConverterData
extends PersistableObject
implements NameList {
    private static final String UNITCONVERTER_DATA_VERSION = "V1.1";
    private Vector mCategories;
    private int selectedCategoryIndex;

    public UnitConverterData() {
        this.initCategories();
    }

    public String getNameListEntry(int index) {
        return this.getCategory(index).getDisplayName();
    }

    public final int getNameListSize() {
        return this.size();
    }

    private void initCategories() {
        this.selectedCategoryIndex = 0;
        this.mCategories = new Vector();
        Category cat = this.addNewCategory("Length", 1, false);
        int idDisplayName = 15;
        cat.addUnit("Millimetres", 1000000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Centimetres", 100000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Inches", 39370.0787402, 0.0, false, ++idDisplayName);
        cat.addUnit("Feet", 3280.839895, 0.0, false, ++idDisplayName);
        cat.addUnit("Yards", 1093.6132983, 0.0, false, ++idDisplayName);
        cat.addUnit("Metres", 1000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Kilometres", 1.0, 0.0, true, ++idDisplayName);
        cat.addUnit("Miles", 0.6213712, 0.0, false, ++idDisplayName);
        cat.addUnit("NauticalMiles", 0.5399568, 0.0, false, ++idDisplayName);
        cat.addUnit("LightYear", 1.0570234105227022E-13, 0.0, false, ++idDisplayName);
        cat.setFirstUnitByName("Metres");
        cat.setSecondUnitByName("Feet");
        idDisplayName = 26;
        cat = this.addNewCategory("Temperature", 20, false);
        cat.addUnit("Celsius", 1.0, 0.0, true, ++idDisplayName);
        cat.addUnit("Fahrenheit", 1.8, 32.0, false, ++idDisplayName);
        cat.addUnit("Kelvin", 1.0, 273.15, false, ++idDisplayName);
        cat.setFirstUnitByName("Celsius");
        cat.setSecondUnitByName("Fahrenheit");
        cat = this.addNewCategory("Currency", 100, true);
        idDisplayName = 31;
        cat = this.addNewCategory("Energy", 10, false);
        cat.addUnit("Calories", 238.9029576, 0.0, false, ++idDisplayName);
        cat.addUnit("Kilocalories", 0.2389029576, 0.0, false, ++idDisplayName);
        cat.addUnit("Joules", 1000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Kilojoules", 1.0, 0.0, true, ++idDisplayName);
        cat.addUnit("Wattsecond", 1000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Watthour", 0.2777777777777778, 0.0, false, ++idDisplayName);
        cat.addUnit("Kilowatthour", 2.777777777777778E-4, 0.0, false, ++idDisplayName);
        cat.addUnit("Electronvolts", 6.241457005723416E21, 0.0, false, ++idDisplayName);
        cat.setFirstUnitByName("Kilocalories");
        cat.setSecondUnitByName("Kilojoules");
        idDisplayName = 40;
        cat = this.addNewCategory("Velocity", 50, false);
        cat.addUnit("KilometresPerH", 1.0, 0.0, true, ++idDisplayName);
        cat.addUnit("MilesPerH", 0.6213712, 0.0, false, ++idDisplayName);
        cat.addUnit("MetresPerSec", 0.2777777777777778, 0.0, false, ++idDisplayName);
        cat.addUnit("MilesPerSec", 1.72603109E-4, 0.0, false, ++idDisplayName);
        cat.addUnit("Knots", 0.5399568, 0.0, false, ++idDisplayName);
        cat.addUnit("Mach", 8.162972105491721E-4, 0.0, false, ++idDisplayName);
        cat.setFirstUnitByName("KilometresPerH");
        cat.setSecondUnitByName("MilesPerH");
        idDisplayName = 47;
        cat = this.addNewCategory("Mass", 1, false);
        cat.addUnit("Milligrams", 1000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Grains", 15.4323584, 0.0, false, ++idDisplayName);
        cat.addUnit("Grams", 1.0, 0.0, true, ++idDisplayName);
        cat.addUnit("Ounces", 0.035274, 0.0, false, ++idDisplayName);
        cat.addUnit("Pounds", 0.0022046, 0.0, false, ++idDisplayName);
        cat.addUnit("Kilograms", 0.001, 0.0, false, ++idDisplayName);
        cat.addUnit("MetricTons", 1.0E-6, 0.0, false, ++idDisplayName);
        cat.setFirstUnitByName("Kilograms");
        cat.setSecondUnitByName("Pounds");
        idDisplayName = 55;
        cat = this.addNewCategory("Area", 1, false);
        cat.addUnit("SquareMm", 1000000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("SquareCm", 10000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("SquareInches", 1550.0031, 0.0, false, ++idDisplayName);
        cat.addUnit("SquareFeet", 10.7639104, 0.0, false, ++idDisplayName);
        cat.addUnit("SquareYards", 1.19599, 0.0, false, ++idDisplayName);
        cat.addUnit("SquareMetres", 1.0, 0.0, true, ++idDisplayName);
        cat.addUnit("SquareKm", 1.0E-6, 0.0, false, ++idDisplayName);
        cat.addUnit("SquareMiles", 3.8610215854244587E-7, 0.0, false, ++idDisplayName);
        cat.addUnit("Acres", 2.471053814671653E-4, 0.0, false, ++idDisplayName);
        cat.addUnit("Ares", 0.01, 0.0, false, ++idDisplayName);
        cat.addUnit("Hectares", 1.0E-4, 0.0, false, ++idDisplayName);
        cat.setFirstUnitByName("SquareMetres");
        cat.setSecondUnitByName("SquareFeet");
        idDisplayName = 67;
        cat = this.addNewCategory("Volume_MEASURE", 1, false);
        cat.addUnit("Millilitres", 1000000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Centilitres", 100000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Litres", 1000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("CubicMm", 1.0E9, 0.0, false, ++idDisplayName);
        cat.addUnit("CubicCm", 1000000.0, 0.0, false, ++idDisplayName);
        cat.addUnit("CubicInches", 61023.74409473228, 0.0, false, ++idDisplayName);
        cat.addUnit("CubicFeet", 35.31466672148859, 0.0, false, ++idDisplayName);
        cat.addUnit("CubicMetres", 1.0, 0.0, true, ++idDisplayName);
        cat.addUnit("GallonsUS", 264.1720523581484, 0.0, false, ++idDisplayName);
        cat.addUnit("GallonsUK", 219.96959146614708, 0.0, false, ++idDisplayName);
        cat.addUnit("PintsUK", 1759.7567317291766, 0.0, false, ++idDisplayName);
        cat.addUnit("LiquidOzUS", 33814.022701842994, 0.0, false, ++idDisplayName);
        cat.addUnit("LiquidOzUK", 35195.13463458353, 0.0, false, ++idDisplayName);
        cat.addUnit("DryPints", 1816.1828599622704, 0.0, false, ++idDisplayName);
        cat.addUnit("LiquidPintsUS", 2113.376418865187, 0.0, false, ++idDisplayName);
        cat.addUnit("Barrels", 6.289810770432105, 0.0, false, ++idDisplayName);
        cat.setFirstUnitByName("Litres");
        cat.setSecondUnitByName("GallonsUS");
        idDisplayName = 84;
        cat = this.addNewCategory("Power", 1, false);
        cat.addUnit("Horsepower", 0.001359621524875, 0.0, false, ++idDisplayName);
        cat.addUnit("Kilowatts", 0.001, 0.0, false, ++idDisplayName);
        cat.addUnit("Watts", 1.0, 0.0, true, ++idDisplayName);
        cat.addUnit("Milliwatts", 1000.0, 0.0, false, ++idDisplayName);
        cat.setFirstUnitByName("Horsepower");
        cat.setSecondUnitByName("Kilowatts");
        idDisplayName = 89;
        cat = this.addNewCategory("Time", 1, false);
        cat.addUnit("Seconds", 86400.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Minutes", 1440.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Hours", 24.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Days", 1.0, 0.0, true, ++idDisplayName);
        cat.addUnit("Weeks", 0.14285714285714285, 0.0, false, ++idDisplayName);
        cat.addUnit("Years", 0.0027378507871321013, 0.0, false, ++idDisplayName);
        cat.setFirstUnitByName("Days");
        cat.setSecondUnitByName("Minutes");
        idDisplayName = 96;
        cat = this.addNewCategory("Pressure", 1, false);
        cat.addUnit("Bars", 1.01325, 0.0, false, ++idDisplayName);
        cat.addUnit("Atmospheres", 1.0, 0.0, false, ++idDisplayName);
        cat.addUnit("Pascals", 101325.0, 0.0, true, ++idDisplayName);
        cat.addUnit("Torr", 760.0021, 0.0, false, ++idDisplayName);
        cat.addUnit("PoundsPerSqInch", 14.695949, 0.0, false, ++idDisplayName);
        cat.setFirstUnitByName("Bars");
        cat.setSecondUnitByName("Atmospheres");
    }

    private Category addNewCategory(String pName, int pLastValue, boolean pIsChangeBaseAllowed) {
        if (this.mCategories == null) {
            this.mCategories = new Vector();
        }
        Category cat = new Category(pName, pLastValue, pIsChangeBaseAllowed);
        this.mCategories.addElement(cat);
        return cat;
    }

    public String getStoreName() {
        return "Converter_Data";
    }

    public void parseStoreData(String data) {
        if (data == null) {
            return;
        }
        if (data.length() < 10) {
            return;
        }
        int len = Integer.parseInt(data.substring(0, 5));
        if (len != (data = data.substring(5)).length()) {
            return;
        }
        String[] dataLines = CalcConvApp.splitString(data, "\n");
        int lineNo = 0;
        if (!dataLines[lineNo++].equals(UNITCONVERTER_DATA_VERSION)) {
            return;
        }
        try {
            String s;
            Category cat = (Category)this.mCategories.elementAt(2);
            while (!(s = dataLines[lineNo++]).equals("")) {
                cat.addUnit(s, false);
            }
            int i = 0;
            while (i < this.mCategories.size()) {
                cat = (Category)this.mCategories.elementAt(i);
                String s2 = dataLines[lineNo++];
                String[] tokens = CalcConvApp.splitString(s2, ",");
                cat.setFirstUnit(Integer.parseInt(tokens[0]));
                cat.setSecondUnit(Integer.parseInt(tokens[1]));
                cat.setLastValue(Double.parseDouble(tokens[2]));
                ++i;
            }
            this.selectedCategoryIndex = Integer.parseInt(dataLines[++lineNo]);
            if (this.getCategory(this.selectedCategoryIndex).size() == 0) {
                this.selectedCategoryIndex = 0;
            }
        }
        catch (Throwable e) {
            this.initCategories();
        }
    }

    public String getStoreData() {
        StringBuffer sb = new StringBuffer();
        sb.append(UNITCONVERTER_DATA_VERSION).append("\n");
        Category cat = this.getCategoryByName("Currency");
        int i = 0;
        while (i < cat.size()) {
            Unit u = cat.getUnit(i);
            sb.append(u.getName()).append(",");
            sb.append(u.getFactor()).append(",");
            sb.append(u.getOffset()).append(",");
            sb.append(u.isBaseUnit()).append("\n");
            ++i;
        }
        sb.append("\n");
        i = 0;
        while (i < this.mCategories.size()) {
            cat = (Category)this.mCategories.elementAt(i);
            sb.append(cat.getFirstIndex()).append(",");
            sb.append(cat.getSecondIndex()).append(",");
            sb.append(Double.toString(cat.getLastValue())).append("\n");
            ++i;
        }
        sb.append("\n");
        sb.append(this.selectedCategoryIndex);
        int len = sb.length();
        String ls = Integer.toString(len);
        while (ls.length() < 5) {
            ls = "0" + ls;
        }
        return String.valueOf(ls) + sb.toString();
    }

    public Category getCategoryByName(String pName) {
        if (this.mCategories != null && this.mCategories.size() > 0) {
            int i = 0;
            while (i < this.mCategories.size()) {
                Category cat = (Category)this.mCategories.elementAt(i);
                if (cat.getName().equals(pName)) {
                    return cat;
                }
                ++i;
            }
        }
        return null;
    }

    public int getSelectedCategoryIndex() {
        return this.selectedCategoryIndex;
    }

    public Category getSelectedCategory() {
        return this.getCategory(this.selectedCategoryIndex);
    }

    public void setSelectedCategoryIndex(int pIndex) {
        this.selectedCategoryIndex = pIndex;
    }

    public Category getCategory(int pIndex) {
        if (pIndex < 0 || pIndex >= this.mCategories.size()) {
            return null;
        }
        return (Category)this.mCategories.elementAt(pIndex);
    }

    public int size() {
        return this.mCategories.size();
    }
}

