/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.Application;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;

public class Unit {
    private String mName;
    private String mDisplayName;
    private boolean mIsBaseUnit;
    private int mCategoryIndex;
    private int mIndex;
    private int mResDisplayName;
    private double factor;
    private double offset;

    public Unit(String pName, double pFactor, double pOffset, boolean pIsBase, boolean pLocalizeName, int pResDisplayName) {
        this.mName = pName;
        this.mDisplayName = !pLocalizeName ? this.mName : Application.getLocalizedText(pResDisplayName);
        this.factor = pFactor;
        this.offset = pOffset;
        this.mIsBaseUnit = pIsBase;
        this.mResDisplayName = pResDisplayName;
    }

    public Unit(String pSerialData, boolean pLocalizeName) {
        String[] data = CalcConvApp.splitString(pSerialData, ",");
        if (data.length != 4) {
            throw new IllegalArgumentException();
        }
        this.mName = data[0];
        this.mDisplayName = !pLocalizeName ? this.mName : null;
        this.factor = Double.parseDouble(data[1]);
        this.offset = Double.parseDouble(data[2]);
        this.mIsBaseUnit = data[3].equals("true");
    }

    public final int getIndex() {
        return this.mIndex;
    }

    public final String getName() {
        return this.mName;
    }

    public final String getDisplayName() {
        if (this.mDisplayName == null) {
            this.mDisplayName = Application.getLocalizedText(this.mResDisplayName);
        }
        return this.mDisplayName;
    }

    public final void setName(String pNewName) {
        this.mName = pNewName;
        this.mDisplayName = pNewName;
    }

    public final void setFactor(double factor) {
        this.factor = factor;
    }

    public final double getFactor() {
        return this.factor;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final boolean isBaseUnit() {
        return this.mIsBaseUnit;
    }

    public final void setIsBaseUnit(boolean pValue) {
        this.mIsBaseUnit = pValue;
    }

    public final void setIndex(int pIndex) {
        this.mIndex = pIndex;
    }
}

