/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.UIException;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;

public class InputLine {
    private String mLine;
    private boolean mHasDot;
    private int mExpPos;
    private int mExpSignChars;
    private double cache;

    public InputLine() {
        this.clear();
    }

    public final double toDouble() {
        return !Double.isNaN(this.cache) ? this.cache : Double.parseDouble(this.mLine);
    }

    public final String toString() {
        return this.mLine;
    }

    public final boolean isEmpty() {
        return this.mLine.equals("");
    }

    public final boolean isValidNumber() {
        if (this.isEmpty()) {
            return false;
        }
        try {
            if (this.mLine.charAt(this.mLine.length() - 1) == 'e') {
                this.mLine = String.valueOf(this.mLine) + "0";
            }
            new Double(Double.parseDouble(this.mLine));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final void changeSign(boolean pForceLeading) {
        this.cache = Double.NaN;
        if (this.isEmpty() || this.mLine.equals("0") || this.mLine.equals("0.")) {
            return;
        }
        if (!pForceLeading && this.mExpPos >= 0) {
            if (this.mExpPos < this.mLine.length() - 1 && this.mLine.charAt(this.mExpPos + 1) == '-') {
                this.mLine = String.valueOf(this.mLine.substring(0, this.mExpPos)) + "e" + this.mLine.substring(this.mExpPos + 2);
                this.mExpSignChars = 0;
            } else {
                this.mLine = String.valueOf(this.mLine.substring(0, this.mExpPos)) + "e-" + this.mLine.substring(this.mExpPos + 1);
                this.mExpSignChars = 1;
            }
        } else {
            this.mLine = this.mLine.charAt(0) == '-' ? this.mLine.substring(1) : "-" + this.mLine;
        }
    }

    public final void addChar(char pChar) {
        this.cache = Double.NaN;
        if ((pChar < '0' || pChar > '9') && pChar != '.' && pChar != 'e') {
            return;
        }
        if (pChar == '.') {
            if (this.mExpPos >= 0 || this.mHasDot) {
                return;
            }
            if (this.mLine.length() == 0) {
                this.mLine = "0";
            }
            int maxLength = 10;
            if (this.mExpPos < 0 && this.mLine.length() >= (maxLength += this.mLine.startsWith("-") ? 1 : 0)) {
                return;
            }
            this.mLine = String.valueOf(this.mLine) + pChar;
            this.mHasDot = true;
        } else if (pChar == 'e') {
            if (this.mExpPos >= 0) {
                return;
            }
            if (this.isEmpty()) {
                this.mLine = "1.0";
                this.mHasDot = true;
            }
            if (this.mLine.charAt(this.mLine.length() - 1) == '.') {
                this.mLine = String.valueOf(this.mLine) + "0";
            }
            this.mLine = String.valueOf(this.mLine) + "e";
            this.mExpPos = this.mLine.length() - 1;
            this.mExpSignChars = 0;
        } else {
            if (pChar == '0') {
                if (this.mLine.equals("0")) {
                    return;
                }
                if (this.mExpPos >= 0 && this.mLine.length() == this.mExpPos + 1 + this.mExpSignChars) {
                    return;
                }
            }
            if (this.mExpPos >= 0 && this.mLine.length() >= this.mExpPos + 3 + this.mExpSignChars) {
                return;
            }
            if (this.mLine.equals("0")) {
                this.mLine = "" + pChar;
            } else {
                int maxLength = 10;
                maxLength += this.mHasDot ? 1 : 0;
                if (this.mExpPos < 0 && this.mLine.length() >= (maxLength += this.mLine.startsWith("-") ? 1 : 0)) {
                    return;
                }
                this.mLine = String.valueOf(this.mLine) + pChar;
            }
        }
    }

    public final void deleteChar() {
        this.cache = Double.NaN;
        if (this.isEmpty()) {
            return;
        }
        int lastCharPos = this.mLine.length() - 1;
        char lastChar = this.mLine.charAt(lastCharPos);
        if (this.mExpPos >= 0 && lastChar == '-') {
            this.mLine = this.mLine.substring(0, this.mLine.length() - 2);
            this.mExpSignChars = 0;
            this.mExpPos = -1;
            return;
        }
        if (this.mExpPos >= 0 && lastChar == 'e') {
            this.mLine = this.mLine.substring(0, lastCharPos);
            this.mExpPos = -1;
            this.mExpSignChars = 0;
            return;
        }
        if (lastChar == '.') {
            this.mHasDot = false;
        }
        this.mLine = this.mLine.substring(0, lastCharPos);
        if (this.mExpPos >= 0 && --lastCharPos > this.mExpPos && this.mLine.charAt(lastCharPos) == '-') {
            this.mLine = this.mLine.substring(0, lastCharPos);
            this.mExpSignChars = 0;
        }
        if (this.mLine.equals("-")) {
            this.mLine = "";
        }
    }

    public final void clear() {
        this.cache = Double.NaN;
        this.mLine = "";
        this.mHasDot = false;
        this.mExpPos = -1;
        this.mExpSignChars = 0;
    }

    public final void setText(String pTextLine) {
        this.cache = Double.NaN;
        if (pTextLine == null || pTextLine.equals("")) {
            this.clear();
            return;
        }
        if (Double.valueOf(pTextLine).isNaN()) {
            throw new NumberFormatException();
        }
        this.mLine = pTextLine;
        this.mHasDot = pTextLine.indexOf(46) >= 0;
        this.mExpPos = pTextLine.indexOf(101);
    }

    public final void setNumber(double pNumber) {
        if (!Double.isNaN(pNumber)) {
            try {
                this.setText(CalcConvApp.getFormattedValue(pNumber));
                this.cache = pNumber;
            }
            catch (UIException exc) {}
        } else {
            this.clear();
        }
    }
}

