/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.Application;
import com.siemens.mp.app.UIException;
import com.siemens.mp.app.calculatorconverter.NameList;
import com.siemens.mp.app.calculatorconverter.Unit;
import java.util.Vector;

public class Category
implements NameList {
    private String mName;
    private String mDisplayName;
    private Vector mUnits;
    private int mBaseIdx;
    private boolean mChangeBaseAllowed;
    private double mLastValue;
    private int mFirstUnit;
    private int mSecondUnit;

    public Category(String pName, int pLastValue, boolean pChangeBaseAllowed) {
        this.mName = pName;
        this.mDisplayName = Application.getLocalizedText(Category.getIdDisplayName(pName));
        this.mUnits = new Vector();
        this.deleteAll();
        this.mLastValue = pLastValue;
        this.mChangeBaseAllowed = pChangeBaseAllowed;
    }

    private static int getIdDisplayName(String pName) {
        if (pName.equals("Length")) {
            return 15;
        }
        if (pName.equals("Temperature")) {
            return 26;
        }
        if (pName.equals("Currency")) {
            return 30;
        }
        if (pName.equals("Energy")) {
            return 31;
        }
        if (pName.equals("Velocity")) {
            return 40;
        }
        if (pName.equals("Mass")) {
            return 47;
        }
        if (pName.equals("Area")) {
            return 55;
        }
        if (pName.equals("Volume_MEASURE")) {
            return 67;
        }
        if (pName.equals("Power")) {
            return 84;
        }
        if (pName.equals("Time")) {
            return 89;
        }
        if (pName.equals("Pressure")) {
            return 96;
        }
        throw new IllegalArgumentException("Unknown Category for init: " + pName);
    }

    public final String getNameListEntry(int index) {
        Unit temp = this.getUnit(index);
        return this.getUnit(index).getDisplayName();
    }

    public final int getNameListSize() {
        return this.size();
    }

    public final int addUnit(String pName, double pFactor, double pOffset, boolean pIsBase, int pResDisplayName) {
        Unit u = new Unit(pName, pFactor, pOffset, pIsBase, true, pResDisplayName);
        return this.checkAndAddUnit(u);
    }

    private int checkAndAddUnit(Unit pUnit) {
        if (pUnit.isBaseUnit()) {
            if (this.mBaseIdx == -1) {
                this.mBaseIdx = this.mUnits.size();
            } else {
                throw new IllegalArgumentException("Category " + this.mName + " has allready a BaseUnit. Trying to add: " + pUnit.getName());
            }
        }
        this.mUnits.addElement(pUnit);
        return this.mUnits.size();
    }

    public final int addUnit(String pSerialData, boolean pLocalizeName) {
        Unit u = new Unit(pSerialData, pLocalizeName);
        return this.checkAndAddUnit(u);
    }

    public final void deleteUnit(Unit pUnit) {
        this.deleteUnit(this.mUnits.indexOf(pUnit));
    }

    public final void deleteUnit(int pIndex) {
        if (this.getUnit(pIndex).isBaseUnit() && this.mUnits.size() > 1) {
            throw new IllegalArgumentException("Can't delete BaseUnit in Category");
        }
        this.mUnits.removeElementAt(pIndex);
        if (this.mBaseIdx >= pIndex) {
            --this.mBaseIdx;
        }
        if (this.mFirstUnit >= pIndex) {
            --this.mFirstUnit;
        }
        if (this.mSecondUnit >= pIndex) {
            --this.mSecondUnit;
        }
        if (this.mFirstUnit < 0) {
            this.mFirstUnit = 0;
        }
        if (this.mSecondUnit < 0) {
            this.mSecondUnit = 0;
        }
        if (this.mBaseIdx < 0) {
            this.mBaseIdx = 0;
        }
        int i = 0;
        while (i < this.mUnits.size()) {
            this.getUnit(i).setIndex(i);
            ++i;
        }
    }

    public final void deleteAll() {
        this.mUnits.removeAllElements();
        this.mBaseIdx = -1;
        this.mFirstUnit = -1;
        this.mSecondUnit = -1;
    }

    public final void changeBaseUnit(int pNewIndex) throws UIException {
        if (this.mChangeBaseAllowed) {
            if (pNewIndex == this.mBaseIdx) {
                return;
            }
            Unit newBase = this.getUnit(pNewIndex);
            double factor = newBase.getFactor();
            if (Double.isInfinite(factor)) {
                throw new UIException(127);
            }
            int i = 0;
            while (i < this.size()) {
                Unit u = this.getUnit(i);
                u.setIsBaseUnit(i == pNewIndex);
                u.setFactor(u.getFactor() / factor);
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Changing the BaseUnit is not allowed in this Category");
        }
        this.mBaseIdx = pNewIndex;
    }

    public final int getUnitIndexFromName(String pName) {
        int i = 0;
        while (i < this.mUnits.size()) {
            Unit u = this.getUnit(i);
            if (u.getName().equals(pName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final Unit getUnit(int pIndex) {
        if (pIndex < 0 || pIndex >= this.mUnits.size()) {
            return this.mUnits.size() != 0 ? (Unit)this.mUnits.elementAt(0) : null;
        }
        return (Unit)this.mUnits.elementAt(pIndex);
    }

    public final String getName() {
        return this.mName;
    }

    public final String getDisplayName() {
        return this.mDisplayName;
    }

    public final void setChangeBaseAllowed(boolean pAllowed) {
        this.mChangeBaseAllowed = pAllowed;
    }

    public final boolean getChangeBaseAllowed() {
        return this.mChangeBaseAllowed;
    }

    public final void setLastValue(double pValue) {
        this.mLastValue = pValue;
    }

    public final double getLastValue() {
        return this.mLastValue;
    }

    public final void setFirstUnitByName(String pName) {
        this.setFirstUnit(this.getUnitIndexFromName(pName));
    }

    public final void setFirstUnit(int pIndex) {
        this.mFirstUnit = pIndex;
    }

    public final void setSecondUnitByName(String pName) {
        this.setSecondUnit(this.getUnitIndexFromName(pName));
    }

    public final void setSecondUnit(int pIndex) {
        this.mSecondUnit = pIndex;
    }

    public final void setUnit(int pUnitNumber, int pUnitIndex) {
        if (pUnitNumber == 1) {
            this.setFirstUnit(pUnitIndex);
        }
        if (pUnitNumber == 2) {
            this.setSecondUnit(pUnitIndex);
        }
    }

    public final Unit getFirstUnit() {
        this.mFirstUnit = this.mFirstUnit >= this.mUnits.size() ? this.mUnits.size() - 1 : this.mFirstUnit;
        return this.getUnit(this.mFirstUnit);
    }

    public final Unit getSecondUnit() {
        this.mSecondUnit = this.mSecondUnit >= this.mUnits.size() ? this.mUnits.size() - 1 : this.mSecondUnit;
        return this.getUnit(this.mSecondUnit);
    }

    public final int getFirstIndex() {
        this.mFirstUnit = this.mFirstUnit >= this.mUnits.size() ? this.mUnits.size() - 1 : this.mFirstUnit;
        return this.mFirstUnit;
    }

    public final int getSecondIndex() {
        this.mSecondUnit = this.mSecondUnit >= this.mUnits.size() ? this.mUnits.size() - 1 : this.mSecondUnit;
        return this.mSecondUnit;
    }

    public final int size() {
        return this.mUnits.size();
    }

    public final Unit getBaseUnit() {
        return this.getUnit(this.mBaseIdx);
    }
}

