/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.UIException;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;
import com.siemens.mp.app.calculatorconverter.CalculatorData;
import com.siemens.mp.app.calculatorconverter.CalculatorUI;
import com.siemens.mp.app.calculatorconverter.InputLine;
import com.siemens.mp.app.calculatorconverter.SharedData;
import javax.microedition.lcdui.Displayable;

class CalculatorCore {
    private CalculatorUI mUserInterface;
    private CalculatorData mCalculatorData;
    private int mInputState;
    private boolean mOverwriteOnNumberInput;
    private int mPendingOperator;
    private double[] mOperandStack = new double[2];
    private int mStackPointer;
    private boolean isBothZerosOperands = false;

    public CalculatorCore() {
        this.mCalculatorData = new CalculatorData();
        this.loadData();
        this.mUserInterface = new CalculatorUI(this);
        this.performOperation(3, 16, this.mUserInterface.getInputLine());
    }

    public CalculatorUI getUI() {
        return this.mUserInterface;
    }

    public CalculatorData getDataObject() {
        return this.mCalculatorData;
    }

    public void activate() {
        CalcConvApp app = CalcConvApp.getInstance();
        try {
            app.getPersistenceManager().waitForReadComplete(this.mCalculatorData, -1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mUserInterface.updateOptions();
        this.mUserInterface.repaint();
        app.setDisplayable((Displayable)this.mUserInterface);
    }

    private double executePendingOperation() throws UIException {
        double op2 = this.popOperand();
        double op1 = this.popOperand();
        try {
            double result;
            op1 = CalculatorCore.getFormattedOperand(op1);
            op2 = CalculatorCore.getFormattedOperand(op2);
            this.isBothZerosOperands = false;
            switch (this.mPendingOperator) {
                case 8: {
                    result = op1 + op2;
                    break;
                }
                case 2: {
                    result = op1 * op2;
                    break;
                }
                case 6: {
                    result = op1 - op2;
                    break;
                }
                case 12: {
                    this.isBothZerosOperands = this.checkBothOperands(op1, op2);
                    result = op1 / op2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected operator found: " + this.mPendingOperator);
                }
            }
            this.validate(result);
            this.mPendingOperator = -1;
            this.pushOperand(result);
            return result;
        }
        catch (UIException uie) {
            this.mUserInterface.clearHistory();
            this.pushOperand(op1);
            this.mUserInterface.addToHistory(op1, -1);
            throw uie;
        }
    }

    private boolean checkBothOperands(double op1, double op2) {
        boolean flag = false;
        if (op1 == op2 && op1 == 0.0) {
            flag = true;
        }
        return flag;
    }

    public static double getFormattedOperand(double value) throws UIException {
        double result = value;
        if (result != Double.NaN) {
            double format = result;
            String soperand = CalcConvApp.getFormattedValue(format);
            result = Double.parseDouble(soperand);
        }
        return result;
    }

    void validate(double value) throws UIException {
        if (Double.isNaN(value)) {
            if (this.isBothZerosOperands) {
                throw new UIException(127);
            }
            throw new UIException(130);
        }
        if (Double.isInfinite(value)) {
            throw new UIException(127);
        }
        CalcConvApp.getFormattedValue(value);
    }

    private void pushOperand(double pOperand) {
        if (this.mStackPointer >= 2) {
            throw new IndexOutOfBoundsException("Operator stack overflow");
        }
        this.mOperandStack[this.mStackPointer++] = pOperand;
    }

    private double popOperand() {
        if (this.mStackPointer > 0) {
            int i = 0;
            while (i < this.mOperandStack.length) {
                ++i;
            }
            return this.mOperandStack[--this.mStackPointer];
        }
        throw new IndexOutOfBoundsException("Operator stack underflow");
    }

    private double peekOperand() {
        if (this.mStackPointer > 0) {
            return this.mOperandStack[this.mStackPointer - 1];
        }
        return Double.NaN;
    }

    private void enterStartNumberState() {
        if (this.mInputState == 2) {
            this.mUserInterface.clearHistory();
        }
        this.mInputState = 0;
        this.mOverwriteOnNumberInput = true;
    }

    public final void performOperation(int pOperationGroup, int pOperationCode, InputLine pInputLine) {
        CalcConvApp app = CalcConvApp.getInstance();
        SharedData shared = app.getShared();
        CalculatorData data = this.mCalculatorData;
        try {
            switch (pOperationGroup) {
                case 0: {
                    this.performAddNumberOperation(pOperationCode, pInputLine);
                    break;
                }
                case 1: {
                    this.performBasicOperation(pOperationCode, pInputLine);
                    break;
                }
                case 3: {
                    this.performInputLineHandlingOperation(pOperationCode, pInputLine);
                    break;
                }
                case 2: {
                    this.performAdvancedOperation(pOperationCode, pInputLine);
                    break;
                }
                case 4: {
                    this.performMemoryRelatedOperation(shared, pOperationCode, pInputLine);
                }
            }
            if (this.mPendingOperator == 7) {
                this.mPendingOperator = -1;
            }
        }
        catch (UIException ex) {
            if (ex.getTextResId() == 127) {
                pInputLine.clear();
                this.mOverwriteOnNumberInput = true;
                if (this.mInputState != 2) {
                    this.mInputState = 0;
                }
            } else {
                this.mInputState = 0;
            }
            app.showAlert(ex, (Displayable)this.mUserInterface);
        }
    }

    private void performAddNumberOperation(int number, InputLine inputLine) {
        this.checkInputState(inputLine);
        if (this.mOverwriteOnNumberInput) {
            inputLine.clear();
        }
        inputLine.addChar((char)number);
        this.mOverwriteOnNumberInput = false;
        this.mInputState = 0;
    }

    private void performMemoryRelatedOperation(SharedData shared, int operationCode, InputLine inputLine) {
        switch (operationCode) {
            case 15: {
                shared.clearMemoryValue();
                break;
            }
            case 9: {
                if (!inputLine.isValidNumber()) break;
                if (!Double.isNaN(shared.getMemoryValue())) {
                    shared.setMemoryValue(shared.getMemoryValue() + inputLine.toDouble());
                } else {
                    shared.setMemoryValue(inputLine.toDouble());
                }
                if (this.mInputState != 0) break;
                this.mOverwriteOnNumberInput = true;
                break;
            }
            case 14: {
                if (!Double.isNaN(shared.getMemoryValue())) {
                    inputLine.setNumber(shared.getMemoryValue());
                } else {
                    inputLine.setNumber(0.0);
                }
                this.enterStartNumberState();
                break;
            }
            case 4: {
                if (!inputLine.isValidNumber()) break;
                shared.setMemoryValue(inputLine.toDouble());
                if (this.mInputState != 0) break;
                this.mOverwriteOnNumberInput = true;
            }
        }
    }

    private void performBasicOperation(int pOperationCode, InputLine inputLine) throws UIException {
        if (this.mInputState == 1 && !inputLine.isEmpty()) {
            this.mInputState = 0;
        }
        switch (this.mInputState) {
            case 1: {
                if (this.mStackPointer <= 0 || pOperationCode == 7) break;
                this.mPendingOperator = pOperationCode;
                break;
            }
            case 0: {
                if (!inputLine.isValidNumber()) break;
                double input = inputLine.toDouble();
                this.pushOperand(input);
                this.mUserInterface.addToHistory(input, this.mPendingOperator);
                if (this.mPendingOperator != -1) {
                    double result = this.executePendingOperation();
                    if (pOperationCode == 7) {
                        inputLine.setNumber(result);
                        this.mInputState = 2;
                        pOperationCode = -1;
                        this.popOperand();
                    } else {
                        this.mUserInterface.clearHistory();
                        this.mUserInterface.addToHistory(result, -1);
                        this.mInputState = 1;
                        inputLine.clear();
                    }
                } else if (pOperationCode != 7) {
                    this.mInputState = 1;
                    inputLine.clear();
                } else {
                    this.mInputState = 2;
                    this.mUserInterface.clearHistory();
                    this.mUserInterface.addToHistory(inputLine.toDouble(), -1);
                    inputLine.setNumber(inputLine.toDouble());
                    this.popOperand();
                }
                this.mPendingOperator = pOperationCode;
                break;
            }
            case 2: {
                if (!inputLine.isValidNumber()) break;
                double input = inputLine.toDouble();
                if (pOperationCode == 7) {
                    this.mInputState = 2;
                    this.mPendingOperator = -1;
                    this.mUserInterface.clearHistory();
                    this.mUserInterface.addToHistory(inputLine.toDouble(), -1);
                    inputLine.setNumber(inputLine.toDouble());
                    break;
                }
                if (this.mStackPointer == 0) {
                    this.pushOperand(input);
                }
                this.mUserInterface.clearHistory();
                this.mUserInterface.addToHistory(input, -1);
                this.mPendingOperator = pOperationCode;
                this.mInputState = 1;
                inputLine.clear();
            }
        }
    }

    private void performAdvancedOperation(int operationCode, InputLine inputLine) throws UIException {
        switch (operationCode) {
            case 1: {
                if (!inputLine.isValidNumber()) break;
                double result = 1.0 / inputLine.toDouble();
                this.validate(result);
                inputLine.setNumber(result);
                this.enterStartNumberState();
                break;
            }
            case 0: {
                if (!inputLine.isValidNumber()) break;
                double result = Math.sqrt(inputLine.toDouble());
                this.validate(result);
                inputLine.setNumber(result);
                this.enterStartNumberState();
                break;
            }
            case 5: {
                if (!inputLine.isValidNumber()) break;
                double result = inputLine.toDouble() * inputLine.toDouble();
                this.validate(result);
                inputLine.setNumber(result);
                this.enterStartNumberState();
                break;
            }
            case 3: {
                if (!inputLine.isValidNumber()) break;
                double op1 = this.peekOperand();
                double op2 = inputLine.toDouble();
                if (Double.isNaN(op1)) {
                    op1 = 1.0;
                }
                if (Double.isNaN(op2)) {
                    throw new UIException(130);
                }
                double result = op1 * op2 / 100.0;
                this.validate(result);
                inputLine.setNumber(result);
                this.enterStartNumberState();
                break;
            }
            case 13: {
                if (inputLine.isEmpty()) break;
                inputLine.changeSign(this.mInputState != 0);
                if (this.mInputState != 2) break;
                this.mUserInterface.clearHistory();
                this.mInputState = 1;
            }
        }
    }

    private void performInputLineHandlingOperation(int operationCode, InputLine inputLine) {
        switch (operationCode) {
            case 16: {
                this.mInputState = 0;
                this.mPendingOperator = -1;
                this.mStackPointer = 0;
                this.mOverwriteOnNumberInput = true;
                this.mUserInterface.clearHistory();
                inputLine.clear();
                inputLine.setText("0");
                break;
            }
            case 17: {
                if (inputLine.isEmpty()) break;
                this.checkInputState(inputLine);
                if (this.mOverwriteOnNumberInput) {
                    inputLine.clear();
                }
                inputLine.deleteChar();
                this.mInputState = 0;
                this.mOverwriteOnNumberInput = false;
                if (!inputLine.isEmpty() || this.mPendingOperator == -1) break;
                this.mInputState = 1;
                break;
            }
            case 18: {
                if (inputLine.isEmpty()) break;
                this.checkInputState(inputLine);
                inputLine.clear();
                this.mInputState = this.mPendingOperator != -1 ? 1 : 0;
                this.mOverwriteOnNumberInput = false;
                break;
            }
            case 11: {
                this.checkInputState(inputLine);
                if (this.mOverwriteOnNumberInput) {
                    inputLine.clear();
                }
                inputLine.addChar('.');
                this.mOverwriteOnNumberInput = false;
                this.mInputState = 0;
                break;
            }
            case 10: {
                this.checkInputState(inputLine);
                if (this.mOverwriteOnNumberInput) {
                    inputLine.clear();
                }
                inputLine.addChar('e');
                this.mOverwriteOnNumberInput = false;
                this.mInputState = 0;
            }
        }
    }

    public void checkInputState(InputLine pInputLine) {
        if (this.mInputState == 2) {
            this.performOperation(3, 16, pInputLine);
        }
        this.mInputState = 0;
    }

    protected void loadData() {
        CalcConvApp.getInstance().getPersistenceManager().addToReadQueue(this.mCalculatorData);
    }

    public void saveData() {
        CalcConvApp.getInstance().getPersistenceManager().addToWriteQueue(this.mCalculatorData);
    }

    public int getInputState() {
        return this.mInputState;
    }

    public boolean getOverwrite() {
        return this.mOverwriteOnNumberInput;
    }

    public int getPendingOperator() {
        return this.mPendingOperator;
    }

    public String getOperatorChar(int pOperator) {
        String opChar;
        switch (pOperator) {
            case 8: {
                opChar = "+";
                break;
            }
            case 6: {
                opChar = "-";
                break;
            }
            case 2: {
                opChar = "*";
                break;
            }
            case 12: {
                opChar = "/";
                break;
            }
            case 7: {
                opChar = "=";
                break;
            }
            default: {
                opChar = "";
            }
        }
        return opChar;
    }
}

