/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app;

import com.siemens.mp.app.PersistableObject;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class PersistenceManager
implements Runnable {
    public static final int WAIT_UNTIL_DONE = -1;
    private static final int IDLE_WAIT_TIME = 250;
    private static final int ACTIVE_WAIT_TIME = 500;
    private Thread mWorker;
    private Vector mReadQueue = new Vector();
    private Vector mWriteQueue = new Vector();
    private boolean mDied = false;

    public PersistenceManager() {
        this.mWorker = new Thread(this);
        this.mWorker.start();
    }

    private void waitComplete(Vector pQueue, PersistableObject pObj, int pTimeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long stopTime = startTime + (long)pTimeout;
        while (pObj != null && pQueue.indexOf(pObj) >= 0 || pObj == null && !pQueue.isEmpty()) {
            Thread.currentThread();
            Thread.yield();
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (pTimeout <= 0 || System.currentTimeMillis() <= stopTime) continue;
            throw new InterruptedException();
        }
    }

    private RecordStore open(String name) throws RecordStoreException {
        String[] tryShared = null;
        if (name.equals("Shared_Data")) {
            tryShared = new String[]{"Calculator", "UnitConverter"};
        } else if (name.equals("WorldClockData")) {
            tryShared = new String[]{"WorldClockInit", "WorldClock", "WorldClockNITZ"};
        }
        if (tryShared != null) {
            int i = 0;
            while (i < tryShared.length) {
                try {
                    return RecordStore.openRecordStore((String)name, (String)"SIEMENS AG", (String)tryShared[i]);
                }
                catch (RecordStoreException recordStoreException) {
                    ++i;
                }
            }
            return RecordStore.openRecordStore((String)name, (boolean)true, (int)1, (boolean)true);
        }
        return RecordStore.openRecordStore((String)name, (boolean)true);
    }

    private byte[] read(String pRecordStore) throws IOException {
        byte[] arrayValue = null;
        try {
            RecordStore recordStore = this.open(pRecordStore);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordStore.getNumRecords() >= 1) {
                arrayValue = recordEnumeration.nextRecord();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception e) {
            throw new IOException("read('" + pRecordStore + "')");
        }
        return arrayValue;
    }

    private void write(String pRecordStore, String pNewData) throws IOException {
        if (pNewData == null) {
            this.delete(pRecordStore);
            return;
        }
        byte[] newArray = pNewData.getBytes("UTF-8");
        try {
            RecordStore recordStore = this.open(pRecordStore);
            if (recordStore.getNumRecords() == 0) {
                int recordId = recordStore.getNextRecordID();
                recordStore.addRecord(newArray, 0, newArray.length);
            } else {
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
                int recordId = recordEnumeration.nextRecordId();
                recordStore.setRecord(recordId, newArray, 0, newArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception e) {
            throw new IOException("write('" + pRecordStore + "')");
        }
    }

    private void delete(String pRecordStore) throws IOException {
        try {
            RecordStore.deleteRecordStore((String)pRecordStore);
        }
        catch (Exception e) {
            throw new IOException("delete('" + pRecordStore + "')");
        }
    }

    public final synchronized void addToReadQueue(PersistableObject pObj) {
        if (!this.isInReadQueue(pObj) && !this.isInWriteQueue(pObj)) {
            pObj.setManager(this);
            this.mReadQueue.addElement(pObj);
        }
    }

    public final synchronized void addToWriteQueue(PersistableObject pObj) {
        if (!this.isInWriteQueue(pObj) && !this.isInReadQueue(pObj)) {
            pObj.setManager(this);
            this.mWriteQueue.addElement(pObj);
        }
    }

    public final synchronized boolean isInReadQueue(PersistableObject pObj) {
        return this.mReadQueue.indexOf(pObj) >= 0;
    }

    public final synchronized boolean isInWriteQueue(PersistableObject pObj) {
        return this.mWriteQueue.indexOf(pObj) >= 0;
    }

    public final int pendingReads() {
        return this.mReadQueue.size();
    }

    public final int pendingWrites() {
        return this.mWriteQueue.size();
    }

    public final void waitForReadComplete(PersistableObject pObj, int pTimeout) throws InterruptedException {
        this.waitComplete(this.mReadQueue, pObj, pTimeout);
    }

    public final void waitForWriteComplete(int pTimeout) throws InterruptedException {
        this.waitComplete(this.mWriteQueue, null, pTimeout);
    }

    public final void waitForWriteComplete(PersistableObject pObj, int pTimeout) throws InterruptedException {
        this.waitComplete(this.mWriteQueue, pObj, pTimeout);
    }

    public final void shutdown() {
        this.mWorker = null;
    }

    public final boolean hasDied() {
        return this.mDied;
    }

    public final void run() {
        while (this.mWorker != null || !this.mWriteQueue.isEmpty() || !this.mReadQueue.isEmpty()) {
            try {
                Vector vector;
                String data;
                String storeName;
                PersistableObject obj;
                if (!this.mReadQueue.isEmpty() && this.mWorker != null) {
                    obj = (PersistableObject)this.mReadQueue.firstElement();
                    storeName = obj.getStoreName();
                    obj.setState(1);
                    try {
                        byte[] bytes = this.read(storeName);
                        data = bytes == null ? null : new String(bytes, "UTF-8");
                        PersistableObject persistableObject = obj;
                        synchronized (persistableObject) {
                            try {
                                obj.parseStoreData(data);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (obj.getState() == 1) {
                        obj.setState(3);
                    }
                    vector = this.mReadQueue;
                    synchronized (vector) {
                        obj.setManager(null);
                        this.mReadQueue.removeElementAt(0);
                    }
                }
                if (!this.mWriteQueue.isEmpty()) {
                    obj = (PersistableObject)this.mWriteQueue.firstElement();
                    storeName = obj.getStoreName();
                    try {
                        data = null;
                        try {
                            data = obj.getStoreData();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        obj.setState(2);
                        this.write(storeName, data);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (obj.getState() == 2) {
                        obj.setState(3);
                    }
                    vector = this.mWriteQueue;
                    synchronized (vector) {
                        obj.setManager(null);
                        this.mWriteQueue.removeElementAt(0);
                    }
                }
                if (this.mWriteQueue.size() + this.mReadQueue.size() != 0 || this.mWorker == null) continue;
                Thread.sleep(250L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.mDied = true;
    }
}

