/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app;

import com.siemens.mp.app.HelpForm;
import com.siemens.mp.app.MessageBox;
import com.siemens.mp.app.PersistenceManager;
import com.siemens.mp.app.UIException;
import com.siemens.mp.global.MemoryMonitor;
import com.siemens.mp.global.ResourceManager;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;

public abstract class Application
extends MIDlet {
    private static ResourceManager managerTexts = ResourceManager.getManager("texts");
    public static final boolean MEM_MONITOR = false;
    public static final boolean DEBUG = false;
    private static final int SMALL_DISPLAY_LIMIT = 140;
    public static final Command BACK_COMMAND = new Command(Application.getLocalizedText(134), 2, 1);
    protected static Application sThis;
    private static boolean sInitialized;
    private boolean mPaused;
    private MIDlet mOwner = this;
    protected Display mDisplay = Display.getDisplay((MIDlet)this);
    private int mDisplayWidth;
    private int mDisplayHeight;
    protected PersistenceManager mPersManager;
    private Displayable mLastVisibleDisplayable;
    private Displayable mLastNextDisplayable;
    private boolean mIsSmallDisplay;
    private MemoryMonitor monitor;
    private static ResourceManager managerPictures;

    static {
        sInitialized = false;
        managerPictures = ResourceManager.getManager("pictures");
    }

    protected Application() {
        sThis = this;
        Form f = new Form(null);
        this.mDisplayWidth = f.getWidth();
        this.mDisplayHeight = f.getHeight();
        this.mPaused = true;
        this.mLastVisibleDisplayable = null;
        this.mLastNextDisplayable = null;
        this.mPersManager = new PersistenceManager();
        this.mIsSmallDisplay = this.mDisplayHeight < 140;
        this.checkEnabDisabConv();
    }

    protected abstract int getAppTitleResId();

    protected abstract void initializeApp();

    protected abstract void finalizeApp();

    protected abstract void suspendApp();

    protected abstract void resumeApp();

    public final String getAppTitle() {
        return Application.getLocalizedText(this.getAppTitleResId());
    }

    public final void startApp() {
        if (!sInitialized) {
            this.initializeApp();
            sInitialized = true;
        }
        if (this.mPaused) {
            this.restoreDisplay();
            this.resumeApp();
        }
        this.mPaused = false;
    }

    public final void pauseApp() {
        this.mPaused = true;
        this.suspendApp();
    }

    public final void destroyApp(boolean unconditional) {
        if (this.mPaused) {
            this.resumeApp();
        }
        this.mDisplay.setCurrent(null);
        this.finalizeApp();
        this.mPersManager.shutdown();
        try {
            this.mPersManager.waitForWriteComplete(5000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        sThis = null;
        sInitialized = false;
    }

    public final void quitApp() {
        this.destroyApp(true);
        this.mOwner.notifyDestroyed();
        this.mOwner = null;
    }

    public final void setDisplayable(Displayable pDisplayable) {
        this.mLastNextDisplayable = null;
        this.mLastVisibleDisplayable = pDisplayable;
        if (this.mDisplay.getCurrent() != pDisplayable) {
            this.mDisplay.setCurrent(pDisplayable);
        }
    }

    public final void focusItem(Item pItem) {
        this.mDisplay.setCurrentItem(pItem);
        this.mLastVisibleDisplayable = this.mDisplay.getCurrent();
        this.mLastNextDisplayable = null;
    }

    public final int getWidth() {
        return this.mDisplayWidth;
    }

    public final int getHeight() {
        return this.mDisplayHeight;
    }

    public final boolean isSmallDisplay() {
        return this.mIsSmallDisplay;
    }

    public Display getDisplay() {
        return this.mDisplay;
    }

    private void restoreDisplay() {
        if (this.mLastVisibleDisplayable != null) {
            if (this.mLastVisibleDisplayable instanceof MessageBox) {
                ((MessageBox)this.mLastVisibleDisplayable).show();
                return;
            }
            if (this.mLastVisibleDisplayable instanceof Alert) {
                this.mDisplay.setCurrent((Alert)this.mLastVisibleDisplayable, this.mLastNextDisplayable);
                return;
            }
        }
        this.setDisplayable(this.mLastVisibleDisplayable);
    }

    public final void showAlert(Alert pAlert, Displayable pNextDisplayable) {
        this.mLastVisibleDisplayable = pAlert;
        this.mLastNextDisplayable = pNextDisplayable;
        this.mDisplay.setCurrent(pAlert, pNextDisplayable);
    }

    public final void showAlert(int pTitleResId, int pTextResId, int pImageResId, AlertType pType, Displayable pNextDisplayable) {
        this.showMessageBox(-1, pTitleResId, pTextResId, pType, -1, 117, null, pNextDisplayable);
    }

    public final void showAlert(UIException pException, Displayable pNextDisplayable) {
        this.showAlert(pException.getTitleResId(), pException.getTextResId(), pException.getBitmapResId(), pException.getType(), pNextDisplayable);
    }

    public final void showMessageBoxPlain(int pBoxId, String pTitle, String pBodyText, AlertType pType, String pLeftButton, String pRightButton, CommandListener pListener, Displayable pNextDisplayable) {
        MessageBox box = new MessageBox();
        box.setBoxId(pBoxId);
        box.setTitle(pTitle);
        box.setBodyText(pBodyText);
        box.setType(pType);
        box.setListener(pListener);
        box.setNextDisplayable(pNextDisplayable);
        box.setButtonText(0, pLeftButton);
        box.setButtonText(1, pRightButton);
        box.show();
    }

    public final void showMessageBoxPlainYesNo(int pBoxId, String pTitle, String pBodyText, CommandListener pListener, Displayable pNextDisplayable) {
        MessageBox box = new MessageBox();
        box.setBoxId(pBoxId);
        box.setTitle(pTitle);
        box.setBodyText(pBodyText);
        box.setType(AlertType.CONFIRMATION);
        box.setListener(pListener);
        box.setNextDisplayable(pNextDisplayable);
        box.setButtonTextResId(0, 125);
        box.setButtonTextResId(1, 126);
        box.show();
    }

    public final void showMessageBox(int pBoxId, int pTitle, int pBodyText, AlertType pType, int pLeftButton, int pRightButton, CommandListener pListener, Displayable pNextDisplayable) {
        MessageBox box = new MessageBox();
        box.setBoxId(pBoxId);
        box.setTitleResId(pTitle);
        box.setBodyTextResId(pBodyText);
        box.setType(pType);
        box.setListener(pListener);
        box.setNextDisplayable(pNextDisplayable);
        box.setButtonTextResId(0, pLeftButton);
        box.setButtonTextResId(1, pRightButton);
        box.show();
    }

    public final void showMessageBoxYesNo(int pBoxId, int pTitle, int pBodyText, CommandListener pListener, Displayable pNextDisplayable) {
        MessageBox box = new MessageBox();
        box.setBoxId(pBoxId);
        box.setTitleResId(pTitle);
        box.setBodyTextResId(pBodyText);
        box.setType(AlertType.CONFIRMATION);
        box.setListener(pListener);
        box.setNextDisplayable(pNextDisplayable);
        box.setButtonTextResId(0, 125);
        box.setButtonTextResId(1, 126);
        box.show();
    }

    public final PersistenceManager getPersistenceManager() {
        return this.mPersManager;
    }

    public static Image getBitmap(int bitmapMnemo) {
        try {
            return managerPictures.getImage(bitmapMnemo);
        }
        catch (Exception e1) {
            Image tmpImage = Image.createImage((int)16, (int)16);
            Graphics g = tmpImage.getGraphics();
            g.setColor(127, 127, 127);
            g.fillRect(0, 0, 16, 16);
            g.setColor(255, 0, 0);
            g.drawLine(0, 0, 15, 15);
            g.drawLine(0, 15, 15, 0);
            return tmpImage;
        }
    }

    public static String getLocalizedText(int textMnemo) {
        return managerTexts.getString(textMnemo);
    }

    public static void openHelpResource(int resID) {
        Displayable current = null;
        if (sThis != null) {
            current = Application.sThis.mDisplay.getCurrent();
        }
        HelpForm helpForm = new HelpForm(Application.getLocalizedText(resID), null, current);
        helpForm.show();
    }

    public boolean checkEnabDisabConv() {
        return this.getAppProperty("keyConv").equals("true");
    }
}

