/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.Application;
import com.siemens.mp.app.MessageBox;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;
import com.siemens.mp.app.calculatorconverter.Category;
import com.siemens.mp.app.calculatorconverter.Unit;
import com.siemens.mp.app.calculatorconverter.UnitConverterCore;
import com.siemens.mp.app.calculatorconverter.UnitConverterData;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class AddOrEditCurrency
extends Form
implements CommandListener,
ItemCommandListener {
    private StringItem mTextResult;
    private TextField mCurrencyName;
    private TextField mRate;
    private Command mCommandSave;
    private Command mCommandCalculator;
    private Command mCommandHelp;
    private Command mCommandExit;
    private Command mLSKCommandClear;
    private UnitConverterCore mCore;
    private Unit mUnitToEdit;
    private int mUnitIndex;
    private CalcConvApp mApp;
    private static final int MAX_CURRENCY_ENTRIES = 25;

    AddOrEditCurrency(UnitConverterCore pCore, Unit pUnitToEdit, int pUnitIndex) {
        super(CalcConvApp.getInstance().getAppTitle());
        TextField focusItem;
        this.mCore = pCore;
        this.mUnitToEdit = pUnitToEdit;
        this.mUnitIndex = pUnitIndex;
        this.mApp = CalcConvApp.getInstance();
        UnitConverterData data = this.mCore.getDataObject();
        this.mLSKCommandClear = new Command(Application.getLocalizedText(5), 2, 1);
        this.mCommandSave = new Command(Application.getLocalizedText(0), 4, 1);
        this.mCommandCalculator = new Command(Application.getLocalizedText(104), 4, 2);
        this.mCommandHelp = new Command(Application.getLocalizedText(1), 4, 3);
        this.mCommandExit = new Command(Application.getLocalizedText(133), 4, 4);
        this.mTextResult = new StringItem(null, "= 1 " + data.getSelectedCategory().getBaseUnit().getDisplayName());
        this.mTextResult.setLayout(512);
        this.mCurrencyName = new TextField(Application.getLocalizedText(2), "", 10, 0);
        this.mCurrencyName.setLayout(512);
        this.mCurrencyName.addCommand(this.mLSKCommandClear);
        this.mCurrencyName.setItemCommandListener((ItemCommandListener)this);
        this.mRate = new TextField(Application.getLocalizedText(3), "", 25, 5);
        this.mRate.setLayout(512);
        this.mRate.addCommand(this.mLSKCommandClear);
        this.mRate.setItemCommandListener((ItemCommandListener)this);
        if (this.mUnitToEdit != null) {
            this.mCurrencyName.setString(this.mUnitToEdit.getDisplayName());
            try {
                this.mRate.setString(CalcConvApp.getFormattedValue(this.mUnitToEdit.getFactor()));
            }
            catch (Exception e) {
                this.mRate.setString("-0.0");
            }
            focusItem = this.mRate;
        } else {
            focusItem = this.mCurrencyName;
        }
        this.append((Item)this.mCurrencyName);
        this.append((Item)this.mRate);
        this.append((Item)this.mTextResult);
        this.addCommand(this.mCommandSave);
        this.addCommand(this.mCommandCalculator);
        this.addCommand(this.mCommandHelp);
        this.addCommand(this.mCommandExit);
        this.setCommandListener(this);
        CalcConvApp.getInstance().getDisplay().setCurrentItem((Item)focusItem);
    }

    public final void commandAction(Command pCommand, Displayable pDisplayable) {
        int newUnitPos = -1;
        CalcConvApp app = CalcConvApp.getInstance();
        UnitConverterData data = this.mCore.getDataObject();
        if (pDisplayable instanceof MessageBox) {
            return;
        }
        if (pCommand == this.mCommandHelp) {
            Application.openHelpResource(113);
            return;
        }
        if (pCommand == this.mCommandSave) {
            if (this.saveAllowed()) {
                Category cat = data.getSelectedCategory();
                if (this.mUnitToEdit != null) {
                    this.mUnitToEdit.setName(this.mCurrencyName.getString());
                    this.mUnitToEdit.setFactor(Double.parseDouble(this.mRate.getString()));
                } else {
                    newUnitPos = cat.addUnit(String.valueOf(this.mCurrencyName.getString()) + "," + this.mRate.getString() + ",0,false", false);
                }
                if (this.mUnitIndex > 0 && this.mUnitToEdit == null && newUnitPos >= 0) {
                    cat.setUnit(this.mUnitIndex, newUnitPos);
                }
                this.mApp.getPersistenceManager().addToWriteQueue(this.mCore.getDataObject());
                app.enterState(2);
            }
        } else if (pCommand == this.mCommandCalculator) {
            app.enterState(1);
        } else if (pCommand == this.mCommandExit) {
            app.enterState(2);
        }
    }

    private boolean saveAllowed() {
        UnitConverterData data = this.mCore.getDataObject();
        Category cat = data.getSelectedCategory();
        String rate = this.mRate.getString();
        String name = this.mCurrencyName.getString().replace(',', '.');
        if (rate == null || rate.equals("") || Double.isNaN(Double.parseDouble(rate)) || name == null || name.equals("")) {
            this.mApp.showMessageBox(0, -1, 119, AlertType.ERROR, -1, 117, this, (Displayable)this);
            return false;
        }
        if (this.mUnitToEdit != null && this.mUnitToEdit.getDisplayName().equals(name)) {
            return true;
        }
        if (cat.size() == 25) {
            this.mApp.showMessageBox(0, -1, 120, AlertType.ERROR, -1, 117, this, (Displayable)this);
            return false;
        }
        if (cat.getUnitIndexFromName(name) >= 0) {
            this.mApp.showMessageBox(0, -1, 121, AlertType.ERROR, -1, 117, this, (Displayable)this);
            return false;
        }
        return true;
    }

    public final void commandAction(Command command, Item item) {
        if (item instanceof TextField) {
            TextField field = (TextField)item;
            if (command == this.mLSKCommandClear && field.getCaretPosition() != 0) {
                try {
                    field.delete(field.getCaretPosition() - 1, 1);
                }
                catch (Exception e) {
                    field.setString("");
                }
            }
        }
    }
}

